import globals.Globals

REACTION_FURNACE = recipemap('reaction_furnace')
FBR = recipemap('fixed_bed_reactor')
REFORMER = recipemap('catalytic_reformer_recipes')
PHASE_SEPARATOR = recipemap('phase_separator')

// Isomerization
    FBR.recipeBuilder()
        .notConsumable(ore('catalystBedChloridedAlumina'))
        .fluidInputs(fluid('light_naphtha') * 1000)
        .fluidInputs(fluid('hydrogen') * 200)
        .fluidOutputs(fluid('raw_isomerate') * 1000)
        .fluidOutputs(fluid('hydrogen') * 160)
        .circuitMeta(1)
        .duration(800)
        .EUt(Globals.voltAmps[2])
        .buildAndRegister()

    FBR.recipeBuilder()
        .notConsumable(ore('catalystBedSulfatedMetalOxide'))
        .fluidInputs(fluid('light_naphtha') * 1000)
        .fluidInputs(fluid('hydrogen') * 200)
        .fluidOutputs(fluid('raw_isomerate') * 1000)
        .fluidOutputs(fluid('hydrogen') * 160)
        .circuitMeta(1)
        .duration(200)
        .EUt(Globals.voltAmps[2])
        .buildAndRegister()

    FBR.recipeBuilder()
        .notConsumable(ore('catalystBedChloridedAlumina'))
        .fluidInputs(fluid('light_naphtha') * 4000)
        .fluidInputs(fluid('isohexane_rich_stream') * 8000)
        .fluidInputs(fluid('hydrogen') * 800)
        .fluidOutputs(fluid('raw_isomerate') * 12000)
        .fluidOutputs(fluid('hydrogen') * 640)
        .circuitMeta(2)
        .duration(800)
        .EUt(Globals.voltAmps[2])
        .buildAndRegister()

    FBR.recipeBuilder()
        .notConsumable(ore('catalystBedSulfatedMetalOxide'))
        .fluidInputs(fluid('light_naphtha') * 4000)
        .fluidInputs(fluid('isohexane_rich_stream') * 8000)
        .fluidInputs(fluid('hydrogen') * 800)
        .fluidOutputs(fluid('raw_isomerate') * 12000)
        .fluidOutputs(fluid('hydrogen') * 640)
        .circuitMeta(2)
        .duration(200)
        .EUt(Globals.voltAmps[2])
        .buildAndRegister()

    DT.recipeBuilder()
        .fluidInputs(fluid('raw_isomerate') * 12000)
        .fluidOutputs(fluid('isomerate') * 4000)
        .fluidOutputs(fluid('isohexane_rich_stream') * 8000)
        .duration(200)
        .EUt(Globals.voltAmps[2])
        .buildAndRegister()

// Alkylation
    CSTR.recipeBuilder()
        .fluidInputs(fluid('hydrofluoric_acid') * 50)
        .fluidInputs(fluid('isobutane') * 1000)
        .fluidInputs(fluid('catalytic_olefin_rich_mixture') * 100)
        .fluidOutputs(fluid('acidic_alkylate_mixture') * 1150)
        .duration(10)
        .EUt(Globals.voltAmps[2])
        .buildAndRegister()

    PHASE_SEPARATOR.recipeBuilder()
        .fluidInputs(fluid('acidic_alkylate_mixture') * 1150)
        .fluidOutputs(fluid('hydrofluoric_acid') * 45)
        .fluidOutputs(fluid('alkylate_mixture') * 1105)
        .duration(5)
        .buildAndRegister()

    DT.recipeBuilder()
        .fluidInputs(fluid('alkylate_mixture') * 11050)
        .fluidOutputs(fluid('alkylate') * 1000)
        .fluidOutputs(fluid('butane') * 900)
        .fluidOutputs(fluid('crude_isobutane') * 9150)
        .duration(100)
        .EUt(Globals.voltAmps[2])
        .buildAndRegister()

    DT.recipeBuilder()
        .fluidInputs(fluid('crude_isobutane') * 9150)
        .fluidOutputs(fluid('isobutane') * 9000)
        .fluidOutputs(fluid('hydrofluoric_acid') * 50)
        .fluidOutputs(fluid('propane') * 100)
        .duration(100)
        .EUt(Globals.voltAmps[2])
        .buildAndRegister()

// Polymerization
    FBR.recipeBuilder()
        .notConsumable(ore('catalystBedSolidPhosphoricAcid'))
        .fluidInputs(fluid('catalytic_olefin_rich_mixture') * 1000)
        .fluidOutputs(fluid('raw_gasoline_polymerate') * 500)
        .duration(200)
        .EUt(Globals.voltAmps[2])
        .buildAndRegister()

    PHASE_SEPARATOR.recipeBuilder()
        .fluidInputs(fluid('raw_gasoline_polymerate') * 500)
        .fluidOutputs(fluid('polymerate') * 250)
        .fluidOutputs(fluid('fuel_gas') * 250)
        .duration(50)
        .buildAndRegister()

// Reforming
    REFORMER.recipeBuilder()
        .fluidInputs(fluid('heavy_naphtha') * 1000)
        .fluidInputs(fluid('hydrogen') * 5000)
        .notConsumable(ore('catalystBedSupportedPlatinum'))
        .fluidOutputs(fluid('naphtha_reformate') * 9000)
        .duration(25)
        .EUt(Globals.voltAmps[3])
        .buildAndRegister()

    PHASE_SEPARATOR.recipeBuilder()
        .fluidInputs(fluid('naphtha_reformate') * 7200)
        .fluidOutputs(fluid('reforming_liquids') * 800)
        .fluidOutputs(fluid('hydrogen') * 6400)
        .duration(20)
        .buildAndRegister()

    DT.recipeBuilder()
        .fluidInputs(fluid('reforming_liquids') * 1000)
        .fluidOutputs(fluid('reformate') * 600)
        .fluidOutputs(fluid('fuel_gas') * 200)
        .duration(400)
        .EUt(Globals.voltAmps[1])
        .buildAndRegister()