import globals.Globals

import static gregtech.api.unification.material.Materials.*;
import gregtech.api.unification.material.MarkerMaterials;
import static gregtech.api.unification.ore.OrePrefix.dye;

DRYER = recipemap('dryer')
BCR = recipemap('bubble_column_reactor')
ELECTROLYTIC_CELL = recipemap('electrolytic_cell')
FLUID_SOLIDIFIER = recipemap('fluid_solidifier')
MIXER = recipemap('mixer')
DISTILLERY = recipemap('distillery')
VACUUM_DT = recipemap('vacuum_distillation')
TUBE_FURNACE = recipemap('tube_furnace')
SIFTER = recipemap('sifter')
BR = recipemap('batch_reactor')
VACUUM_FREEZER = recipemap('vacuum_freezer')
PHASE_SEPARATOR = recipemap('phase_separator')
SINGLE_COLUMN_CRYOGENIC_DISTILLATION_PLANT = recipemap('single_column_cryogenic_distillation')

//Molten Salt Method


ELECTROLYTIC_CELL.recipeBuilder()
    .inputs(metaitem("graphite_electrode"))
    .notConsumable(metaitem('stickMolybdenum'))
    .notConsumable(metaitem('crucible.graphite'))
    .fluidInputs(fluid('lithium_chloride') * 576)
    .fluidInputs(fluid('moist_argon') * 1000)
    .fluidOutputs(fluid('impure_lithium_carbonate') * 1008)
    .fluidOutputs(fluid('acidic_argon_hydrogen_mixture') * 2000)
    .duration(600)
    .EUt(Globals.voltAmps[4])
    .buildAndRegister()

FLUID_SOLIDIFIER.recipeBuilder()
    .notConsumable(metaitem('shape.mold.ball'))
    .fluidInputs(fluid('impure_lithium_carbonate') * 144)
    .outputs(metaitem('dustImpureLithiumCarbonate'))
    .duration(80)
    .EUt(16)
    .buildAndRegister()

MIXER.recipeBuilder()
    .inputs(ore('dustImpureLithiumCarbonate') * 7)
    .fluidInputs(fluid('distilled_water') * 1000)
    .fluidOutputs(fluid('impure_lithium_carbonate_solution') * 1000)
    .duration(80)
    .EUt(Globals.voltAmps[2])
    .buildAndRegister()

SIFTER.recipeBuilder()
    .fluidInputs(fluid('impure_lithium_carbonate_solution') * 10000)
    .outputs(metaitem('dustWashedGraphene') * 10)
    .fluidOutputs(fluid('lithium_carbonate_solution') * 10000)
    .duration(160)
    .EUt(Globals.voltAmps[2])
    .buildAndRegister()

VACUUM_DT.recipeBuilder()
    .inputs(ore('dustWashedGraphene'))
    .outputs(metaitem('dustDistilledGraphene'))
    .duration(20)
    .EUt(Globals.voltAmps[3])
    .buildAndRegister()

DRYER.recipeBuilder()
    .inputs(ore('dustDistilledGraphene'))
    .outputs(metaitem('dustDriedGraphene'))
    .duration(400)
    .EUt(Globals.voltAmps[2])
    .buildAndRegister()

TUBE_FURNACE.recipeBuilder()
    .inputs(ore('dustDriedGraphene'))
    .fluidInputs(fluid('nitrogen') * 500)
    .outputs(metaitem('dustGraphene'))
    .duration(200)
    .EUt(Globals.voltAmps[3])
    .buildAndRegister()

TUBE_FURNACE.recipeBuilder()
    .inputs(ore('dustDriedGraphene'))
    .fluidInputs(fluid('argon') * 50)
    .outputs(metaitem('dustGraphene'))
    .duration(100)
    .EUt(Globals.voltAmps[3])
    .buildAndRegister()

DISTILLERY.recipeBuilder()
    .fluidInputs(fluid('lithium_carbonate_solution') * 1000)
    .outputs(metaitem('gregtechfoodoption:lithium_carbonate_dust') * 6)
    .fluidOutputs(fluid('water') * 1000)
    .duration(200)
    .EUt(Globals.voltAmps[1])
    .buildAndRegister()

//Argon preparation and recycling

BCR.recipeBuilder()
    .fluidInputs(fluid('argon') * 50)
    .fluidInputs(fluid('water') * 50)
    .fluidOutputs(fluid('moist_argon') * 100)
    .duration(2)
    .EUt(16)
    .buildAndRegister()

BR.recipeBuilder()
    .fluidInputs(fluid('acidic_argon_hydrogen_mixture') * 1000)
    .fluidInputs(fluid('ammonia') * 2000)
    .outputs(metaitem('dustAmmoniumChloride') * 6)
    .fluidOutputs(fluid('ammoniacal_argon_hydrogen_mixture') * 2000)
    .duration(100)
    .EUt(Globals.voltAmps[2])
    .buildAndRegister()

VACUUM_FREEZER.recipeBuilder()
    .fluidInputs(fluid('ammoniacal_argon_hydrogen_mixture') * 1000)
    .fluidOutputs(fluid('cold_ammoniacal_argon_hydrogen_mixture') * 875)
    .duration(200)
    .EUt(60)
    .buildAndRegister()

PHASE_SEPARATOR.recipeBuilder()
    .fluidInputs(fluid('cold_ammoniacal_argon_hydrogen_mixture') * 875)
    .fluidOutputs(fluid('cold_ammonia') * 500)
    .fluidOutputs(fluid('cold_argon_hydrogen_mixture') * 320)
    .duration(20)
    .buildAndRegister()

VACUUM_FREEZER.recipeBuilder()
    .fluidInputs(fluid('cold_argon_hydrogen_mixture') * 1280)
    .fluidOutputs(fluid('partially_liquefied_argon_hydrogen_mixture') * 1000)
    .duration(200)
    .EUt(Globals.voltAmps[3])
    .buildAndRegister();

SINGLE_COLUMN_CRYOGENIC_DISTILLATION_PLANT.recipeBuilder()
    .fluidInputs(fluid('partially_liquefied_argon_hydrogen_mixture') * 16000)
    .fluidOutputs(fluid('liquid_argon') * 125)
    .fluidOutputs(fluid('hydrogen') * 16000)
    .duration(40)
    .EUt(Globals.voltAmps[3])
    .buildAndRegister()
