import globals.Globals

FBR = recipemap('fixed_bed_reactor')
DISTILLATION_TOWER = recipemap('distillation_tower')
FERMENTER = recipemap('vat_fermentation');
MIXER = recipemap('mixer')
ROASTER = recipemap('roaster')
LCR = recipemap('large_chemical_reactor')
BR = recipemap('batch_reactor')
DRYER = recipemap('dryer')
DISTILLERY = recipemap('distillery')
BCR = recipemap('bubble_column_reactor')

// Formic acid

BR.recipeBuilder()
    .inputs(ore('dustAnyPuritySodium'))
    .fluidInputs(fluid('methanol') * 1000)
    .outputs(metaitem('dustSodiumMethoxide') * 6)
    .fluidOutputs(fluid('hydrogen') * 1000)
    .duration(80)
    .EUt(30)
    .buildAndRegister()

BCR.recipeBuilder()
    .inputs(ore('dustSodiumMethoxide'))
    .fluidInputs(fluid('polyethylene_glycol') * 50)
    .fluidInputs(fluid('methanol') * 1000)
    .fluidInputs(fluid('carbon_monoxide') * 1000)
    .fluidOutputs(fluid('methyl_formate_solution') * 1000)
    .duration(80)
    .EUt(30)
    .buildAndRegister()

CSTR.recipeBuilder()
    .notConsumable(ore('springCupronickel'))
    .fluidInputs(fluid('methyl_formate_solution') * 300)
    .fluidInputs(fluid('sulfuric_acid') * 50)
    .fluidOutputs(fluid('neutralized_methyl_formate_solution') * 300)
    .duration(4)
    .EUt(30)
    .buildAndRegister()

CSTR.recipeBuilder()
    .fluidInputs(fluid('water') * 150)
    .fluidInputs(fluid('neutralized_methyl_formate_solution') * 50)
    .fluidInputs(fluid('sulfuric_acid') * 50)
    .fluidOutputs(fluid('hydrolyzed_methyl_formate_solution') * 200)
    .duration(4)
    .EUt(30)
    .buildAndRegister()

DISTILLATION_TOWER.recipeBuilder()
    .fluidInputs(fluid('hydrolyzed_methyl_formate_solution') * 4000)
    .chancedOutput(metaitem('dustSodiumSulfate'), 5250, 0)
    .fluidOutputs(fluid('sulfuric_acid') * 1000)
    .fluidOutputs(fluid('polyethylene_glycol') * 50)
    .fluidOutputs(fluid('formic_acid_water_azeotrope') * 1000)
    .fluidOutputs(fluid('water') * 2600)
    .fluidOutputs(fluid('methanol') * 600)
    .duration(80)
    .EUt(30)
    .buildAndRegister()

VACUUM_DT.recipeBuilder()
    .fluidInputs(fluid('formic_acid_water_azeotrope') * 1000)
    .fluidOutputs(fluid('formic_acid') * 600)
    .fluidOutputs(fluid('water') * 400)
    .duration(80)
    .EUt(30)
    .buildAndRegister()

// Acetic acid (biological)

FERMENTER.recipeBuilder()
    .fluidInputs(fluid('ethanol') * 8000)
    .fluidInputs(fluid('oxygen') * 4000)
    .fluidOutputs(fluid('vinegar') * 16000)
    .duration(2400)
    .EUt(16)
    .buildAndRegister()

FERMENTER.recipeBuilder()
    .fluidInputs(fluid('ethanol') * 8000)
    .fluidInputs(fluid('air') * 12000)
    .fluidOutputs(fluid('vinegar') * 16000)
    .duration(2400)
    .EUt(16)
    .buildAndRegister()

FERMENTER.recipeBuilder()
    .fluidInputs(fluid('impure_ethanol') * 16000)
    .fluidInputs(fluid('oxygen') * 4000)
    .fluidOutputs(fluid('vinegar') * 16000)
    .duration(2400)
    .EUt(16)
    .buildAndRegister()

FERMENTER.recipeBuilder()
    .fluidInputs(fluid('impure_ethanol') * 16000)
    .fluidInputs(fluid('air') * 12000)
    .fluidOutputs(fluid('vinegar') * 16000)
    .duration(2400)
    .EUt(16)
    .buildAndRegister()

DISTILLATION_TOWER.recipeBuilder()
    .fluidInputs(fluid('vinegar') * 2000)
    .outputs(metaitem('dustWood'))
    .fluidOutputs(fluid('acetic_acid') * 400)
    .fluidOutputs(fluid('water') * 1600)
    .duration(200)
    .EUt(30)
    .buildAndRegister()

DISTILLATION_TOWER.recipeBuilder()
    .fluidInputs(fluid('gtfo_apple_cider') * 2000)
    .fluidOutputs(fluid('acetic_acid') * 400)
    .fluidOutputs(fluid('water') * 1600)
    .duration(200)
    .EUt(30)
    .buildAndRegister()

// Acetic acid (chemical)

FBR.recipeBuilder()
    .fluidInputs(fluid('ethylene') * 100)
    .fluidInputs(fluid('oxygen') * 100)
    .notConsumable(ore('catalystBedPlatinum'))
    .fluidOutputs(fluid('gtfo_acetaldehyde') * 100)
    .duration(10)
    .EUt(30)
    .buildAndRegister()

FBR.recipeBuilder()
    .fluidInputs(fluid('gtfo_acetaldehyde') * 100)
    .fluidInputs(fluid('oxygen') * 100)
    .notConsumable(ore('catalystBedCobalt'))
    .fluidOutputs(fluid('acetic_acid') * 100)
    .duration(10)
    .EUt(30)
    .buildAndRegister()

// Cativa Process

LCR.recipeBuilder()
    .fluidInputs(fluid('methanol') * 1000)
    .fluidInputs(fluid('carbon_monoxide') * 1000)
    .fluidOutputs(fluid('acetic_acid') * 1000)
    .notConsumable(ore('dustCativaCatalyst'))
    .duration(20)
    .EUt(Globals.voltAmps[1])
    .buildAndRegister()

BR.recipeBuilder()
    .inputs(ore('dustHexachloroiridicAcid') * 9)
    .fluidInputs(fluid('potassium_iodide_solution') * 4000)
    .outputs(metaitem('dustIridiumIodide') * 5)
    .fluidOutputs(fluid('potassium_chloride_solution') * 4000)
    .fluidOutputs(fluid('hydrogen_chloride') * 2000)
    .duration(100)
    .EUt(Globals.voltAmps[1])
    .buildAndRegister()

BR.recipeBuilder()
    .fluidInputs(fluid('phosphorus_trichloride') * 1000)
    .fluidInputs(fluid('chlorobenzene') * 3000)
    .inputs(ore('dustAnyPuritySodium') * 6)
    .outputs(metaitem('dustTriphenylphosphine'))
    .outputs(metaitem('dustSalt') * 12)
    .duration(100)
    .EUt(Globals.voltAmps[1])
    .buildAndRegister()

ROASTER.recipeBuilder()
    .inputs(ore('dustTriphenylphosphine'))
    .fluidInputs(fluid('chlorine') * 2000)
    .outputs(metaitem('dustTriphenylphosphineDichloride'))
    .duration(100)
    .EUt(Globals.voltAmps[1])
    .buildAndRegister()

LCR.recipeBuilder()
    .inputs(ore('dustTriphenylphosphineDichloride') * 2)
    .inputs(ore('dustTriphenylphosphine'))
    .fluidInputs(fluid('hydroxylamine') * 1000)
    .fluidInputs(fluid('hydrogen_chloride') * 1000)
    .outputs(metaitem('dustBistriphenylphosphineiminiumChloride'))
    .outputs(metaitem('dustTriphenylphosphineOxide'))
    .fluidOutputs(fluid('hydrogen_chloride') * 4000)
    .duration(100)
    .EUt(Globals.voltAmps[1])
    .buildAndRegister()

BR.recipeBuilder()
    .inputs(ore('dustIridiumIodide') * 5)
    .fluidInputs(fluid('dimethylformamide') * 1000)
    .fluidInputs(fluid('carbon_monoxide') * 1000)
    .fluidOutputs(fluid('cativa_catalyst_preparation') * 1000)
    .duration(100)
    .EUt(Globals.voltAmps[1])
    .buildAndRegister()

MIXER.recipeBuilder()
    .fluidInputs(fluid('cativa_catalyst_preparation') * 500)
    .inputs(ore('dustBistriphenylphosphineiminiumChloride'))
    .fluidOutputs(fluid('cativa_catalyst_solution') * 500)
    .duration(100)
    .EUt(Globals.voltAmps[1])
    .buildAndRegister()

DRYER.recipeBuilder()
    .fluidInputs(fluid('cativa_catalyst_solution') * 1000)
    .outputs(metaitem('dustCativaCatalyst') * 10)
    .duration(100)
    .EUt(Globals.voltAmps[1])
    .buildAndRegister()

MIXER.recipeBuilder()
    .inputs(ore('dustPotassiumIodide') * 2)
    .fluidInputs(fluid('water') * 1000)
    .fluidOutputs(fluid('potassium_iodide_solution') * 1000)
    .duration(100)
    .EUt(Globals.voltAmps[1])
    .buildAndRegister()