import globals.Globals

FBR = recipemap('fixed_bed_reactor')
DISTILLERY = recipemap('distillery')
REACTION_FURNACE = recipemap('reaction_furnace')
MIXER = recipemap('mixer')
DISTILLATION_TOWER = recipemap('distillation_tower')
SIEVE_DT = recipemap('sieve_distillation')

// Methanol

ROASTER.recipeBuilder()
    .inputs(ore('dustCopperCarbonate') * 10)
    .inputs(ore('dustZincCarbonate') * 5)
    .inputs(ore('dustChromiumTrioxide') * 4)
    .outputs(metaitem('dustCopperZincChromiumOxide'))
    .duration(40)
    .EUt(40)
    .buildAndRegister()

FBR.recipeBuilder()
    .fluidInputs(fluid('hydrogen_rich_syngas') * 4800)
    .fluidInputs(fluid('carbon_monoxide') * 500)
    .notConsumable(metaitem('catalystBedCopperZincChromiumOxide'))
    .fluidOutputs(fluid('methanol') * 1000)
    .duration(4)
    .EUt(40)
    .buildAndRegister()

FBR.recipeBuilder()
    .fluidInputs(fluid('carbon_monoxide') * 1000)
    .fluidInputs(fluid('hot_hp_hydrogen') * 4000)
    .notConsumable(metaitem('catalystBedCopperZincChromiumOxide'))
    .fluidOutputs(fluid('methanol') * 1000)
    .duration(4)
    .EUt(40)
    .buildAndRegister()

FBR.recipeBuilder()
    .fluidInputs(fluid('monoxide_rich_syngas') * 5000)
    .notConsumable(metaitem('catalystBedCopperZincChromiumOxide'))
    .fluidOutputs(fluid('methanol') * 1000)
    .duration(4)
    .EUt(40)
    .buildAndRegister()

FBR.recipeBuilder()
    .fluidInputs(fluid('carbon_dioxide') * 1000)
    .fluidInputs(fluid('hot_hp_hydrogen') * 6000)
    .notConsumable(metaitem('catalystBedCopperZincChromiumOxide'))
    .fluidOutputs(fluid('methanol') * 1000)
    .fluidOutputs(fluid('dense_steam') * 1000)
    .duration(8)
    .EUt(40)
    .buildAndRegister()

// Ethanol

DISTILLATION_TOWER.recipeBuilder()
    .fluidInputs(fluid('impure_ethanol') * 2000)
    .outputs(metaitem('dustWood'))
    .fluidOutputs(fluid('fusel_oil') * 20)
    .fluidOutputs(fluid('water') * 1280)
    .fluidOutputs(fluid('ethanol_water_azeotrope') * 700)
    .duration(50)
    .EUt(30)
    .buildAndRegister()

MIXER.recipeBuilder()
    .fluidInputs(fluid('ethanol_water_azeotrope') * 700)
    .fluidInputs(fluid('toluene') * 10)
    .fluidOutputs(fluid('entrained_ethanol_water_azeotrope') * 710)
    .duration(50)
    .EUt(30)
    .buildAndRegister()

DISTILLATION_TOWER.recipeBuilder()
    .fluidInputs(fluid('entrained_ethanol_water_azeotrope') * 710)
    .fluidOutputs(fluid('toluene') * 10)
    .fluidOutputs(fluid('water') * 70)
    .fluidOutputs(fluid('ethanol') * 630)
    .duration(50)
    .EUt(30)
    .buildAndRegister()

SIEVE_DT.recipeBuilder()
    .fluidInputs(fluid('ethanol_water_azeotrope') * 700)
    .notConsumable(fluid('toluene') * 10)
    .fluidOutputs(fluid('water') * 70)
    .fluidOutputs(fluid('ethanol') * 630)
    .duration(50)
    .EUt(30)
    .buildAndRegister()

DISTILLATION_TOWER.recipeBuilder()
    .fluidInputs(fluid('fusel_oil') * 1000)
    .fluidOutputs(fluid('isoamyl_alcohol') * 615)
    .fluidOutputs(fluid('n_butanol') * 10)
    .fluidOutputs(fluid('isobutyl_alcohol') * 155)
    .fluidOutputs(fluid('water') * 110)
    .fluidOutputs(fluid('n_propanol') * 10)
    .fluidOutputs(fluid('ethanol_water_azeotrope') * 100)
    .duration(50)
    .EUt(30)
    .buildAndRegister()

// Propanol
BR.recipeBuilder()
    .inputs(ore('dustDicobaltOctacarbonyl') * 18)
    .fluidInputs(fluid('hydrogen') * 2000)
    .fluidInputs(fluid('carbon_monoxide') * 1000)
    .fluidInputs(fluid('ethylene') * 1000)
    .fluidOutputs(fluid('propanal_mixture') * 1000)
    .EUt(Globals.voltAmps[3])
    .duration(80)
    .buildAndRegister()

DISTILLERY.recipeBuilder()
    .fluidInputs(fluid('propanal_mixture') * 1000)
    .outputs(metaitem('dustDicobaltOctacarbonyl') * 18)
    .fluidOutputs(fluid('propionaldehyde') * 800)
    .EUt(Globals.voltAmps[3])
    .duration(80)
    .buildAndRegister()

FBR.recipeBuilder()
    .fluidInputs(fluid('propionaldehyde') * 50)
    .fluidInputs(fluid('hydrogen') * 100)
    .notConsumable(metaitem('catalystBedPlatinum'))
    .fluidOutputs(fluid('n_propanol') * 50)
    .EUt(Globals.voltAmps[3])
    .duration(4)
    .buildAndRegister()

// n-Pentanol
REACTION_FURNACE.recipeBuilder()
    .inputs(metaitem('dustDicobaltOctacarbonyl') * 18)
    .fluidInputs(fluid('hot_hp_hydrogen') * 2000)
    .fluidInputs(fluid('carbon_monoxide') * 1000)
    .fluidInputs(fluid('one_butene') * 1000)
    .fluidOutputs(fluid('pentanal_mixture') * 1000)
    .EUt(Globals.voltAmps[3])
    .duration(80)
    .buildAndRegister()

DISTILLERY.recipeBuilder()
    .fluidInputs(fluid('pentanal_mixture') * 1000)
    .outputs(metaitem('dustDicobaltOctacarbonyl') * 18)
    .fluidOutputs(fluid('valeraldehyde') * 800)
    .EUt(Globals.voltAmps[3])
    .duration(80)
    .buildAndRegister()

FBR.recipeBuilder()
    .fluidInputs(fluid('valeraldehyde') * 50)
    .fluidInputs(fluid('hydrogen') * 100)
    .notConsumable(metaitem('susy:hv_catalyst_bed_reduction'))
    .fluidOutputs(fluid('n_pentanol') * 50)
    .EUt(Globals.voltAmps[3])
    .duration(4)
    .buildAndRegister()

FBR.recipeBuilder()
    .fluidInputs(fluid('valeraldehyde') * 50)
    .fluidInputs(fluid('hydrogen') * 100)
    .notConsumable(metaitem('catalystBedPlatinum'))
    .fluidOutputs(fluid('n_pentanol') * 50)
    .EUt(Globals.voltAmps[3])
    .duration(4)
    .buildAndRegister()

// Isodecanol

FBR.recipeBuilder()
    .notConsumable(metaitem('catalystBedZsmFive'))
    .fluidInputs(fluid('propene') * 150)
    .fluidOutputs(fluid('tripropylene') * 50)
    .duration(5)
    .EUt(Globals.voltAmps[1])
    .buildAndRegister()

REACTION_FURNACE.recipeBuilder()
    .inputs(metaitem('dustDicobaltOctacarbonyl') * 18)
    .fluidInputs(fluid('hot_hp_hydrogen') * 2000)
    .fluidInputs(fluid('carbon_monoxide') * 1000)
    .fluidInputs(fluid('tripropylene') * 1000)
    .fluidOutputs(fluid('isodecanal_mixture') * 1000)
    .EUt(Globals.voltAmps[3])
    .duration(80)
    .buildAndRegister()

DISTILLERY.recipeBuilder()
    .fluidInputs(fluid('isodecanal_mixture') * 1000)
    .outputs(metaitem('dustDicobaltOctacarbonyl') * 18)
    .fluidOutputs(fluid('isodecanal') * 500)
    .EUt(Globals.voltAmps[3])
    .duration(80)
    .buildAndRegister()

FBR.recipeBuilder()
    .fluidInputs(fluid('isodecanal') * 50)
    .fluidInputs(fluid('hydrogen') * 100)
    .notConsumable(metaitem('catalystBedPlatinum'))
    .fluidOutputs(fluid('isodecanol') * 50)
    .EUt(Globals.voltAmps[3])
    .duration(4)
    .buildAndRegister()
