import globals.Globals
import static globals.CarbonGlobals.*

MIXER = recipemap('mixer')
FLOTATION = recipemap('froth_flotation')
CLARIFIER = recipemap('clarifier')
CHEMICAL_BATH = recipemap('chemical_bath')
CRYSTALLIZER = recipemap('crystallizer')
DISTILLERY = recipemap('distillery')
ROASTER = recipemap('roaster')
REACTION_FURNACE = recipemap('reaction_furnace')
VACUUM_DT = recipemap('vacuum_distillation')
BR = recipemap('batch_reactor')
FLUID_SOLIDIFIER = recipemap('fluid_solidifier')

// From pollucite
MIXER.recipeBuilder()
    .inputs(ore('dustImpurePollucite') * 8)
    .fluidInputs(fluid('distilled_water') * 2000)
    .fluidOutputs(fluid('impure_pollucite_slurry') * 2000)
    .EUt(Globals.voltAmps[3])
    .duration(80)
    .buildAndRegister()

FLOTATION.recipeBuilder()
    .fluidInputs(fluid('impure_pollucite_slurry') * 2000)
    .fluidInputs(fluid('aluminium_sulfate_solution') * 50)
    .notConsumable(fluid('coco_amine_acetate') * 1000)
    .notConsumable(fluid('sulfuric_acid') * 100)
    .fluidOutputs(fluid('pollucite_slurry') * 1000)
    .fluidOutputs(fluid('pegmatite_tailing_slurry') * 1000)
    .EUt(Globals.voltAmps[3])
    .duration(80)
    .buildAndRegister()

CLARIFIER.recipeBuilder()
    .fluidInputs(fluid('pollucite_slurry') * 1000)
    .outputs(metaitem('dustPollucite') * 16)
    .fluidOutputs(fluid('wastewater') * 1000)
    .EUt(Globals.voltAmps[1])
    .duration(20)
    .buildAndRegister()

CHEMICAL_BATH.recipeBuilder()
    .inputs(ore('dustPollucite'))
    .fluidInputs(fluid('hot_sulfuric_acid') * 4000)
    .outputs(metaitem('dustSiliconDioxide') * 12)
    .fluidOutputs(fluid('pollucite_leach') * 4000)
    .EUt(Globals.voltAmps[2])
    .duration(80)
    .buildAndRegister()

CRYSTALLIZER.recipeBuilder()
    .fluidInputs(fluid('pollucite_leach') * 4000)
    .fluidOutputs(fluid('sodium_alum_solution') * 4000)
    .outputs(metaitem('dustCaesiumRubidiumAlumMixture'))
    .EUt(Globals.voltAmps[2])
    .duration(80)
    .buildAndRegister()

DISTILLERY.recipeBuilder()
    .fluidInputs(fluid('sodium_alum_solution') * 4000)
    .outputs(metaitem('dustSodiumAlum') * 12)
    .fluidOutputs(fluid('water') * 4000)
    .EUt(Globals.voltAmps[1])
    .duration(20)
    .buildAndRegister()

CRYSTALLIZER.recipeBuilder()
    .inputs(ore('dustCaesiumRubidiumAlumMixture'))
    .fluidOutputs(fluid('gtfo_heated_water') * 10000)
    .chancedOutput(metaitem('dustCaesiumAlum') * 12, 9500, 0)
    .chancedOutput(metaitem('dustRubidiumAlum') * 12, 500, 0)
    .EUt(Globals.voltAmps[1])
    .duration(800)
    .buildAndRegister()

// Refining into metal

for (highPurityCombustible in highPurityCombustibles()) {
    ROASTER.recipeBuilder()
    .inputs(ore('dustCaesiumAlum') * 24)
    .inputs(ore(highPurityCombustible.name) * highPurityCombustible.equivalent(2))
    .outputs(metaitem('dustCaesiumAluminaMixture') * 8)
    .fluidOutputs(fluid('carbon_dioxide') * 2000)
    .fluidOutputs(fluid('sulfur_dioxide') * 4000)
    .EUt(Globals.voltAmps[1])
    .duration(160 * highPurityCombustible.duration)
    .buildAndRegister()
}

CHEMICAL_BATH.recipeBuilder()
    .inputs(ore('dustCaesiumAluminaMixture') * 8)
    .fluidInputs(fluid('sulfuric_acid') * 1000)
    .outputs(metaitem('dustAlumina') * 5)
    .fluidOutputs(fluid('caesium_sulfate_solution') * 1000)
    .EUt(Globals.voltAmps[1])
    .duration(80)
    .buildAndRegister()

CHEMICAL_BATH.recipeBuilder()
    .inputs(ore('dustCaesiumAluminaMixture') * 8)
    .fluidInputs(fluid('hydrochloric_acid') * 2000)
    .outputs(metaitem('dustAlumina') * 5)
    .fluidOutputs(fluid('caesium_chloride_solution') * 3000)
    .EUt(Globals.voltAmps[1])
    .duration(80)
    .buildAndRegister()

DISTILLERY.recipeBuilder()
    .fluidInputs(fluid('caesium_chloride_solution') * 3000)
    .outputs(metaitem('dustCaesiumChloride') * 4)
    .fluidOutputs(fluid('water') * 3000)
    .EUt(Globals.voltAmps[1])
    .duration(20)
    .buildAndRegister()

REACTION_FURNACE.recipeBuilder()
    .inputs(ore('dustCaesiumChloride') * 4)
    .inputs(ore('dustCalcium'))
    .outputs(metaitem('dustReducedCaesiumMixture') * 5)
    .EUt(Globals.voltAmps[1])
    .duration(80)
    .buildAndRegister()

VACUUM_DT.recipeBuilder()
    .inputs(ore('dustReducedCaesiumMixture') * 5)
    .outputs(metaitem('dustCalciumChloride') * 3)
    .fluidOutputs(fluid('caesium') * 288)
    .EUt(Globals.voltAmps[2])
    .duration(80)
    .buildAndRegister()

// Caesium Formate (for drilling fluid)

BR.recipeBuilder()
    .fluidInputs(fluid('caesium_sulfate_solution') * 1000)
    .fluidInputs(fluid('calcium_hydroxide_slurry') * 1000)
    .outputs(metaitem('dustCalciumSulfate') * 6)
    .fluidOutputs(fluid('caesium_hydroxide_solution') * 2000)
    .EUt(Globals.voltAmps[2])
    .duration(80)
    .buildAndRegister()

CSTR.recipeBuilder()
    .fluidInputs(fluid('caesium_hydroxide_solution') * 50)
    .fluidInputs(fluid('formic_acid') * 50)
    .fluidOutputs(fluid('caesium_formate_solution') * 100)
    .EUt(Globals.voltAmps[2])
    .duration(4)
    .buildAndRegister()

FLUID_SOLIDIFIER.recipeBuilder()
    .fluidInputs(fluid('caesium') * 144)
    .outputs(metaitem('dustCaesium'))
    .EUt(Globals.voltAmps[1])
    .duration(20)
    .buildAndRegister()