import globals.Globals

BR = recipemap('batch_reactor')
ROASTER = recipemap('roaster')
MIXER = recipemap('mixer')
FLOTATION = recipemap('froth_flotation')
CLARIFIER = recipemap('clarifier')
EBF = recipemap('electric_blast_furnace')
BR = recipemap('batch_reactor')
REACTION_FURNACE = recipemap('reaction_furnace')

// BENEFICIATION

    // LIQUIDATION (1.5x)

    ROASTER.recipeBuilder()
        .inputs(ore('dustImpureStibnite') * 2)
        .notConsumable(fluid('nitrogen') * 8000)
        .outputs(metaitem('dustStibnite') * 3)
        .outputs(metaitem('dustPegmatiteTailings'))
        .EUt(Globals.voltAmps[2])
        .duration(200)
        .buildAndRegister()

    // FLOTATION (2x)

    MIXER.recipeBuilder()
        .inputs(ore('dustImpureStibnite') * 8)
        .fluidInputs(fluid('distilled_water') * 2000)
        .fluidOutputs(fluid('impure_stibnite_slurry') * 2000)
        .EUt(Globals.voltAmps[3])
        .duration(80)
        .buildAndRegister()

    FLOTATION.recipeBuilder()
        .fluidInputs(fluid('impure_stibnite_slurry') * 2000)
        .notConsumable(metaitem('dustSodiumIsobutylXanthate'))
        .notConsumable(metaitem('dustLeadNitrate'))
        .notConsumable(fluid('sodium_cyanide_solution') * 100)
        .fluidOutputs(fluid('stibnite_slurry') * 1000)
        .fluidOutputs(fluid('pegmatite_tailing_slurry') * 1000)
        .EUt(Globals.voltAmps[3])
        .duration(80)
        .buildAndRegister()

    CLARIFIER.recipeBuilder()
        .fluidInputs(fluid('stibnite_slurry') * 1000)
        .outputs(metaitem('dustStibnite') * 16)
        .fluidOutputs(fluid('wastewater') * 1000)
        .EUt(Globals.voltAmps[1])
        .duration(20)
        .buildAndRegister()

// PROCESSING

ROASTER.recipeBuilder()
    .inputs(ore('dustAntimonyIiiSulfide') * 5)
    .fluidInputs(fluid('oxygen') * 9000)
    .outputs(metaitem('dustAntimonyTrioxide') * 5)
    .fluidOutputs(fluid('sulfur_dioxide') * 3000)
    .EUt(Globals.voltAmps[2])
    .duration(200)
    .buildAndRegister()
    
// Antimony Trioxide Dust * 1
mods.gregtech.electric_blast_furnace.removeByInput(120, [metaitem('dustStibnite')], [fluid('oxygen') * 3000])

ROASTER.recipeBuilder()
    .inputs(ore('dustStibnite'))
    .fluidInputs(fluid('oxygen') * 9000)
    .outputs(metaitem('dustAntimonyTrioxide') * 5)
    .fluidOutputs(fluid('sulfur_dioxide') * 3000)
    .EUt(Globals.voltAmps[2])
    .duration(200)
    .buildAndRegister()

EBF.recipeBuilder()
    .inputs(ore('dustStibnite'))
    .fluidInputs(fluid('oxygen') * 6000)
    .outputs(metaitem('ingotAntimony') * 2)
    .fluidOutputs(fluid('sulfur_dioxide') * 3000)
    .EUt(Globals.voltAmps[2] * 2)
    .duration(200)
    .buildAndRegister()

EBF.recipeBuilder()
    .inputs(ore('dustAntimonyIiiSulfide') * 5)
    .fluidInputs(fluid('oxygen') * 6000)
    .outputs(metaitem('ingotAntimony') * 2)
    .fluidOutputs(fluid('sulfur_dioxide') * 3000)
    .EUt(Globals.voltAmps[2] * 2)
    .duration(200)
    .buildAndRegister()

// TETRAHEDRITE PROCESSING

BR.recipeBuilder()
    .notConsumable(ore('springCupronickel'))
    .inputs(ore('dustTetrahedrite') * 1)
    .inputs(ore('dustSodiumSulfide') * 18)
    .fluidInputs(fluid('gtfo_heated_water') * 12000)
    .outputs(metaitem('dustCopperISulfide') * 15)
    .outputs(metaitem('dustCopperIiSulfide') * 4)
    .fluidOutputs(fluid('sodium_thioantimonite_solution') * 12000)
    .EUt(Globals.voltAmps[2])
    .duration(200)
    .buildAndRegister()

BR.recipeBuilder()
    .fluidInputs(fluid('sodium_thioantimonite_solution') * 12000)
    .fluidInputs(fluid('hydrochloric_acid') * 12000)
    .outputs(metaitem('dustAntimonyIiiSulfide') * 10)
    .fluidOutputs(fluid('diluted_saltwater') * 24000)
    .fluidOutputs(fluid('hydrogen_sulfide') * 6000)
    .EUt(Globals.voltAmps[2])
    .duration(200)
    .buildAndRegister()

// FROM LEAD (KROLL-BETTERTON PROCESS)

BR.recipeBuilder()
    .fluidInputs(fluid('antimony_dross') * 720)
    .fluidInputs(fluid('chlorine') * 6000)
    .outputs(metaitem('dustAntimony') * 2)
    .outputs(metaitem('dustMagnesiumChloride') * 6)
    .outputs(metaitem('dustCalciumChloride') * 3)
    .EUt(Globals.voltAmps[2])
    .duration(200)
    .buildAndRegister()

// FROM LEAD (ANODE SLIME)

ROASTER.recipeBuilder()
    .inputs(ore('dustAntimonyArsenicFlueDust') * 5)
    .inputs(ore('dustSodiumHydroxide') * 54)
    .outputs(metaitem('dustAntimony') * 4)
    .outputs(metaitem('dustSodiumArsenate') * 48)
    .fluidOutputs(fluid('steam') * 9000)
    .EUt(Globals.voltAmps[2])
    .duration(200)
    .buildAndRegister()

// REFINING

VACUUM_DT.recipeBuilder()
    .fluidInputs(fluid('antimony_trichloride') * 1000)
    .fluidOutputs(fluid('purified_antimony_trichloride') * 1000)
    .EUt(Globals.voltAmps[2])
    .duration(200)
    .buildAndRegister()

BR.recipeBuilder()
    .fluidInputs(fluid('purified_antimony_trichloride') * 2000)
    .fluidInputs(fluid('ultrapure_water') * 6000)
    .outputs(metaitem('dustPurifiedAntimonyTrioxide') * 5)
    .fluidOutputs(fluid('hydrochloric_acid') * 3000)
    .EUt(Globals.voltAmps[2])
    .duration(400)
    .buildAndRegister()

REACTION_FURNACE.recipeBuilder()
    .inputs(ore('dustPurifiedAntimonyTrioxide') * 5)
    .fluidInputs(fluid('hydrogen') * 6000)
    .outputs(metaitem('dustHighPurityAntimony') * 2)
    .fluidOutputs(fluid('steam') * 3000)
    .EUt(Globals.voltAmps[2])
    .duration(400)
    .buildAndRegister()