import globals.Globals
import static globals.SinteringGlobals.*
import gregtech.api.recipes.ingredients.GTRecipeItemInput;

AUTOCLAVE = recipemap('autoclave')
CHEMICAL_BATH = recipemap('chemical_bath')
ROTARY_KILN = recipemap('rotary_kiln')
DT = recipemap('distillation_tower')
BR = recipemap('batch_reactor')
TUBE_FURNACE = recipemap('tube_furnace')
ZONE_REFINER = recipemap('zone_refiner')
MIXER = recipemap('mixer')
BLENDER = recipemap('blender')
CENTRIFUGE = recipemap('centrifuge')
ROASTER = recipemap('roaster')

// Tannic acid for Ge precipitation

CHEMICAL_BATH.recipeBuilder()
    .inputs(ore('logWood'))
    .fluidInputs(fluid('distilled_water') * 100)
    .fluidOutputs(fluid('tannic_acid_solution') * 100)
    .duration(200)
    .EUt(30)
    .buildAndRegister()

// Zinc hydrometallurgy route (primitive)

oreDict.add('dustZincResidues', metaitem('dustZincHydrochloricLeachResidue'))
oreDict.add('dustZincResidues', metaitem('dustZincLeachResidue'))

carbons = new ItemStack[]{
        metaitem('dustCarbon'),
        metaitem('dustHighPurityCarbon'),
        metaitem('dustCoke')
}

for (fuel in rotary_kiln_fuels) {
	for (comburent in rotary_kiln_comburents) {
		ROTARY_KILN.recipeBuilder()
			.inputs(ore('dustZincResidues') * 8)
			.input(new GTRecipeItemInput(carbons, 1))
			.outputs(metaitem('dustGermaniumRichOxide') )
			.outputs(metaitem('dustWaelzSlag'))
			.fluidInputs(fluid(fuel.name) * fuel.amountRequired)
			.fluidInputs(fluid(comburent.name) * comburent.amountRequired)
			.fluidOutputs(fluid(fuel.byproduct) * fuel.byproductAmount)
			.duration(fuel.duration + comburent.duration)
			.EUt(120)
			.buildAndRegister()
	}
}

AUTOCLAVE.recipeBuilder()
    .inputs(ore('dustGermaniumRichOxide'))
    .fluidInputs(fluid('sulfuric_acid') * 1000)
    .fluidOutputs(fluid('germanium_leach') * 1000)
    .duration(200)
    .EUt(30)
    .buildAndRegister()

AUTOCLAVE.recipeBuilder()
    .inputs(ore('dustWaelzOxide'))
    .fluidInputs(fluid('sulfuric_acid') * 1000)
    .fluidOutputs(fluid('germanium_leach') * 1000)
    .duration(200)
    .EUt(30)
    .buildAndRegister()

BR.recipeBuilder()
    .fluidInputs(fluid('tannic_acid_solution') * 100)
    .fluidInputs(fluid('germanium_leach') * 1000)
    .chancedOutput(metaitem('dustGermaniumConcentrate'), 8000, 0)
    .fluidOutputs(fluid('zinc_leach') * 1000)
    .duration(200)
    .EUt(30)
    .buildAndRegister()

// Oxalate SX route (universal)

MIXER.recipeBuilder()
    .inputs(ore('dustOxalicAcid'))
    .fluidInputs(fluid('distilled_water') * 1000)
    .fluidOutputs(fluid('oxalic_acid_solution') * 1000)
    .duration(200)
    .EUt(30)
    .buildAndRegister()

AUTOCLAVE.recipeBuilder()
    .inputs(ore('dustGermaniumRichOxide') * 2)
    .fluidInputs(fluid('oxalic_acid_solution') * 1000)
    .outputs(metaitem('dustLeadSilicaResidue'))
    .fluidOutputs(fluid('germanium_oxalate_leach') * 1000)
    .duration(200)
    .EUt(30)
    .buildAndRegister()

BR.recipeBuilder()
    .inputs(ore('dustSmallIron') * 2)
    .fluidInputs(fluid('germanium_oxalate_leach') * 8000)
    .outputs(metaitem('dustIronOxalateDihydrate') * 9)
    .fluidOutputs(fluid('purified_germanium_oxalate_leach') * 6000)
    .duration(200)
    .EUt(30)
    .buildAndRegister()

ROASTER.recipeBuilder()
    .inputs(ore('dustIronOxalateDihydrate') * 9)
    .outputs(metaitem('dustIronIiOxide') * 2)
    .fluidOutputs(fluid('dense_steam') * 2000)
    .fluidOutputs(fluid('carbon_monoxide') * 1000)
    .fluidOutputs(fluid('carbon_dioxide') * 1000)
    .duration(200)
    .EUt(30)
    .buildAndRegister()

BLENDER.recipeBuilder()
    .fluidInputs(fluid('kerosene') * 700)
    .fluidInputs(fluid('sulfuric_acid') * 200)
    .fluidInputs(fluid('tri_octyl_decyl_amine') * 200)
    .fluidInputs(fluid('tributyl_phosphate') * 100)
    .fluidOutputs(fluid('germanium_gallium_extraction_mixture') * 1000)
    .duration(200)
    .EUt(30)
    .buildAndRegister()

CENTRIFUGE.recipeBuilder()
    .fluidInputs(fluid('germanium_gallium_extraction_mixture') * 1000)
    .fluidInputs(fluid('purified_germanium_oxalate_leach') * 1000)
    .fluidOutputs(fluid('germanium_gallium_extract') * 1000)
    .fluidOutputs(fluid('oxalic_acid_solution') * 1000)
    .duration(200)
    .EUt(30)
    .buildAndRegister()

CENTRIFUGE.recipeBuilder()
    .fluidInputs(fluid('germanium_gallium_extract') * 1000)
    .fluidInputs(fluid('diluted_sulfuric_acid') * 600)
    .fluidOutputs(fluid('germanium_extract') * 1000)
    .fluidOutputs(fluid('gallium_sulfate_solution') * 300)
    .duration(200)
    .EUt(30)
    .buildAndRegister()

// 1 Ga2(SO4)3, 3 H2O, 6 oxalic acid
ELECTROLYZER.recipeBuilder()
    .notConsumable(ore('stickSteel'))
    .notConsumable(metaitem('graphite_electrode'))
    .fluidInputs(fluid('gallium_sulfate_solution') * 3000)
    .outputs(metaitem('dustGallium') * 2)
    .outputs(metaitem('dustOxalicAcid') * 6)
    .fluidOutputs(fluid('oxygen') * 3000)
    .fluidOutputs(fluid('sulfuric_acid') * 3000)
    .duration(300)
    .EUt(Globals.voltAmps[1])
    .buildAndRegister()

CENTRIFUGE.recipeBuilder()
    .fluidInputs(fluid('germanium_extract') * 1000)
    .fluidInputs(fluid('sodium_hydroxide_solution') * 200)
    .fluidOutputs(fluid('germanium_gallium_extraction_mixture') * 1000)
    .fluidOutputs(fluid('germanium_oxalate_solution') * 400)
    .duration(200)
    .EUt(30)
    .buildAndRegister()

BR.recipeBuilder()
    .notConsumable(ore('springCupronickel'))
    .fluidInputs(fluid('germanium_oxalate_solution') * 400)
    .fluidInputs(fluid('hydrochloric_acid') * 400)
    .fluidInputs(fluid('chlorine') * 50)
    .fluidOutputs(fluid('impure_germanium_tetrachloride') * 100)
    .fluidOutputs(fluid('wastewater') * 1000)
    .duration(200)
    .EUt(30)
    .buildAndRegister()

// Concentrate purification

BR.recipeBuilder()
    .notConsumable(ore('springCupronickel'))
    .inputs(ore('dustGermaniumConcentrate'))
    .fluidInputs(fluid('hydrochloric_acid') * 400)
    .fluidInputs(fluid('chlorine') * 50)
    .fluidOutputs(fluid('impure_germanium_tetrachloride') * 100)
    .fluidOutputs(fluid('wastewater') * 600)
    .duration(200)
    .EUt(30)
    .buildAndRegister()

DT.recipeBuilder()
    .fluidInputs(fluid('impure_germanium_tetrachloride') * 1000)
    .fluidOutputs(fluid('arsenic_trichloride') * 100)
    .fluidOutputs(fluid('germanium_tetrachloride') * 900)
    .duration(200)
    .EUt(30)
    .buildAndRegister()

BR.recipeBuilder()
    .fluidInputs(fluid('germanium_tetrachloride') * 1000)
    .fluidInputs(fluid('ultrapure_water') * 6000)
    .outputs(metaitem('dustGermaniumDioxide') * 3)
    .fluidOutputs(fluid('hydrochloric_acid') * 4000)
    .duration(200)
    .EUt(30)
    .buildAndRegister()

TUBE_FURNACE.recipeBuilder()
    .inputs(ore('dustGermaniumDioxide') * 3)
    .fluidInputs(fluid('hydrogen') * 4000)
    .outputs(metaitem('dustGermanium'))
    .fluidOutputs(fluid('dense_steam') * 2000)
    .duration(200)
    .EUt(30)
    .buildAndRegister()

ZONE_REFINER.recipeBuilder()
    .inputs(ore('ingotGermanium'))
    .outputs(metaitem('ingotHighPurityGermanium'))
    .duration(200)
    .EUt(30)
    .buildAndRegister()