VACUUM_FREEZER = recipemap('vacuum_freezer')
CSTR = recipemap('continuous_stirred_tank_reactor')
TBR = recipemap('trickle_bed_reactor')
FBR = recipemap('fixed_bed_reactor')
BCR = recipemap('bubble_column_reactor')
BR = recipemap('batch_reactor')
FLUIDIZEDBR = recipemap('fluidized_bed_reactor')
DISTILLATION_TOWER = recipemap('distillation_tower')
DISTILLERY = recipemap('distillery')
ROASTER = recipemap('roaster')
MIXER = recipemap('mixer')
DRYER = recipemap('dryer')
SIFTER = recipemap('sifter')
CENTRIFUGE = recipemap('centrifuge')
PYROLYSE = recipemap('pyrolyse_oven')
LCR = recipemap('large_chemical_reactor')
EBF = recipemap('electric_blast_furnace')
VULCANIZER = recipemap('vulcanizing_press')
ALLOY_SMELTER = recipemap('alloy_smelter')
ARC_FURNACE = recipemap('arc_furnace')
AUTOCLAVE = recipemap('autoclave')
COMPRESSOR = recipemap('compressor')
ASSEMBLER = recipemap('assembler')
ELECTROLYZER = recipemap('electrolyzer')
ELECTROLYTIC_CELL = recipemap('electrolytic_cell')
REACTION_FURNACE = recipemap('reaction_furnace')
ELECTROMAGNETIC_SEPARATOR = recipemap('electromagnetic_separator')
PSA = recipemap('pressure_swing_adsorption')
CHEMICAL_BATH = recipemap('chemical_bath')
ROTARY_KILN = recipemap('rotary_kiln')

MIXER.recipeBuilder()
        .fluidInputs(fluid('hot_sulfuric_acid') * 2000)
        .fluidInputs(fluid('distilled_water') * 4000)
        .inputs(ore('dustCarnotite'))
        .fluidOutputs(fluid('carnotite_leach') * 6000)
        .EUt(120)
        .duration(300)
        .buildAndRegister()

MIXER.recipeBuilder()
        .fluidInputs(fluid('carnotite_leach') * 6000)
        .inputs(ore('dustAnyPurityIron'))
        .inputs(ore('dustCalcite') * 3)
        .fluidOutputs(fluid('reduced_carnotite_leach') * 6000)
        .EUt(120)
        .duration(300)
        .buildAndRegister()

MIXER.recipeBuilder()
        .fluidInputs(fluid('kerosene') * 900)
        .fluidInputs(fluid('tributyl_phosphate') * 40)
        .fluidInputs(fluid('di_two_ethylhexyl_phosphoric_acid') * 60)
        .fluidOutputs(fluid('uranium_vanadium_extraction_mixture') * 1000)
        .EUt(120)
        .duration(200)
        .buildAndRegister()

CENTRIFUGE.recipeBuilder()
        .fluidInputs(fluid('uranium_vanadium_extraction_mixture') * 1000)
        .fluidInputs(fluid('reduced_carnotite_leach') * 1000)
        .fluidOutputs(fluid('uranium_vanadium_extract') * 1000)
        .fluidOutputs(fluid('wastewater') * 1000)
        .EUt(240)
        .duration(200)
        .buildAndRegister()

CENTRIFUGE.recipeBuilder()
        .fluidInputs(fluid('uranium_vanadium_extract') * 3000)
        .fluidInputs(fluid('diluted_sulfuric_acid') * 2000)
        .fluidOutputs(fluid('uranium_extract') * 3000)
        .fluidOutputs(fluid('acidic_vanadyl_solution') * 2000)
        .EUt(240)
        .duration(200)
        .buildAndRegister()

LCR.recipeBuilder()
        .fluidInputs(fluid('acidic_vanadyl_solution') * 6000)
        .fluidInputs(fluid('ammonia') * 1000)
        .inputs(metaitem('gregtechfoodoption:sodium_chlorate_dust') * 5)
        .fluidOutputs(fluid('wastewater') * 6000)
        .outputs(metaitem('dustVanadiumPentoxide') * 7)
        .EUt(240)
        .duration(200)
        .buildAndRegister()

CENTRIFUGE.recipeBuilder()
        .fluidInputs(fluid('uranium_extract') * 3000)
        .fluidInputs(fluid('soda_ash_solution') * 1000)
        .fluidOutputs(fluid('uranium_vanadium_extraction_mixture') * 3000)
        .fluidOutputs(fluid('impure_uranyl_carbonate_solution') * 1000)
        .EUt(720)
        .duration(160)
        .buildAndRegister()

SIFTER.recipeBuilder()
        .fluidInputs(fluid('impure_uranyl_carbonate_solution') * 6000)
        .chancedOutput(metaitem('dustAluminiumHydroxide') * 7, 1000, 1000)
        .chancedOutput(metaitem('dustIronCarbonate') * 5, 4000, 1000)
        .fluidOutputs(fluid('uranyl_carbonate_solution') * 6000)
        .EUt(240)
        .duration(200)
        .buildAndRegister()

ROASTER.recipeBuilder()
        .inputs(ore('dustIronCarbonate') * 5)
        .outputs(metaitem('dustIronIiOxide') * 2)
        .fluidOutputs(fluid('carbon_dioxide') * 1000)
        .EUt(120)
        .duration(200)
        .buildAndRegister()

CSTR.recipeBuilder()
        .fluidInputs(fluid('uranyl_carbonate_solution') * 50)
        .fluidInputs(fluid('sulfuric_acid') * 50)
        .fluidOutputs(fluid('uranyl_sulfate_solution') * 100)
        .fluidOutputs(fluid('carbon_dioxide') * 50)
        .EUt(240)
        .duration(5)
        .buildAndRegister()

LCR.recipeBuilder()
        .fluidInputs(fluid('uranyl_sulfate_solution') * 2000)
        .fluidInputs(fluid('ammonia') * 6000)
        .fluidInputs(fluid('distilled_water') * 1000)
        .fluidOutputs(fluid('ammonium_sulfate_solution') * 2000)
        .outputs(metaitem('dustAmmoniumDiuranate') * 19)
        .EUt(720)
        .duration(200)
        .buildAndRegister()

REACTION_FURNACE.recipeBuilder()
        .inputs(ore('dustAmmoniumDiuranate') * 19)
        .fluidInputs(fluid('hydrogen') * 2000)
        .outputs(metaitem('dustUraniumDioxide') * 6)
        .fluidOutputs(fluid('ammonia') * 2000)
        .fluidOutputs(fluid('dense_steam') * 3000)
        .EUt(3840)
        .duration(600)
        .buildAndRegister()

REACTION_FURNACE.recipeBuilder()
        .inputs(ore('dustUraniumDioxide') * 3)
        .inputs(ore('dustAnyPurityMagnesium') * 2)
        .outputs(metaitem('dustUranium'))
        .outputs(metaitem('dustMagnesia') * 4)
        .EUt(3840)
        .duration(300)
        .buildAndRegister()

ROTARY_KILN.recipeBuilder()
        .inputs(ore('dustUraniumDioxide') * 3)
        .fluidInputs(fluid('hydrogen_fluoride') * 4000)
        .outputs(metaitem('dustUraniumTetrafluoride') * 5)
        .fluidOutputs(fluid('dense_steam') * 2000)
        .EUt(1920)
        .duration(80)
        .buildAndRegister()

FLUIDIZEDBR.recipeBuilder()
        .inputs(ore('dustUraniumTetrafluoride') * 5)
        .fluidInputs(fluid('fluorine') * 2000)
        .fluidOutputs(fluid('uranium_hexafluoride') * 1000)
        .EUt(240)
        .duration(80)
        .buildAndRegister()

FLUIDIZEDBR.recipeBuilder()
        .fluidInputs(fluid('uranium_hexafluoride') * 1000)
        .fluidInputs(fluid('hydrogen') * 2000)
        .outputs(metaitem('dustUraniumTetrafluoride') * 5)
        .fluidOutputs(fluid('hydrogen_fluoride') * 2000)
        .EUt(240)
        .duration(80)
        .buildAndRegister()

REACTION_FURNACE.recipeBuilder()
        .inputs(ore('dustUraniumTetrafluoride') * 5)
        .inputs(ore('dustMagnesium') * 2)
        .outputs(ore('dustUranium238').first())
        .outputs(metaitem('dustMagnesiumFluoride') * 6)
        .EUt(3840)
        .duration(80)
        .buildAndRegister()
