import globals.Globals

ELECTROSTATIC_SEPARATOR = recipemap('electrostatic_separator')
BR = recipemap('batch_reactor')
ION_EXCHANGE = recipemap('ion_exchange_column')
CRYSTALLIZER = recipemap('crystallizer')

ELECTROSTATIC_SEPARATOR.recipeBuilder()
    .notConsumable(metaitem('item_filter'))
    .fluidInputs(fluid('molybdenite_flue_gas') * 2000)
    .chancedOutput(metaitem('dustRheniumRichFlue'), 5000, 0)
    .fluidOutputs(fluid('sulfur_dioxide') * 2000)
    .duration(20)
    .EUt(Globals.voltAmps[1])
    .buildAndRegister()

BR.recipeBuilder()
    .inputs(ore('dustRheniumRichFlue'))
    .fluidInputs(fluid('distilled_water') * 50)
    .outputs(metaitem('dustAsh'))
    .fluidOutputs(fluid('scrubbed_perrhenate_solution') * 50)
    .duration(20)
    .EUt(Globals.voltAmps[1])
    .buildAndRegister()

ION_EXCHANGE.recipeBuilder()
    .inputs(metaitem('beads.rhenium_ion_exchange'))
    .fluidInputs(fluid('scrubbed_perrhenate_solution') * 1000)
    .outputs(metaitem('beads.loaded_rhenium_ion_exchange'))
    .fluidOutputs(fluid('wastewater') * 1000)
    .duration(200)
    .EUt(Globals.voltAmps[4])
    .buildAndRegister()
    
BR.recipeBuilder()
    .inputs(metaitem('beads.loaded_rhenium_ion_exchange'))
    .fluidInputs(fluid('ammonia_solution') * 1000)
    .outputs(metaitem('beads.rhenium_ion_exchange'))
    .fluidOutputs(fluid('ammonium_perrhenate_solution') * 1000)
    .duration(200)
    .EUt(Globals.voltAmps[3])
    .buildAndRegister()

CRYSTALLIZER.recipeBuilder()
    .fluidInputs(fluid('ammonium_perrhenate_solution') * 1000)
    .outputs(metaitem('dustAmmoniumPerrhenate') * 10)
    .fluidOutputs(fluid('wastewater') * 1000)
    .duration(200)
    .EUt(Globals.voltAmps[3])
    .buildAndRegister()

REACTION_FURNACE.recipeBuilder()
    .inputs(ore('dustAmmoniumPerrhenate') * 10)
    .fluidInputs(fluid('hydrogen') * 7000)
    .outputs(metaitem('dustRhenium'))
    .fluidOutputs(fluid('dense_steam') * 4000)
    .fluidOutputs(fluid('ammonia') * 1000)
    .duration(200)
    .EUt(Globals.voltAmps[4])
    .buildAndRegister()

