import globals.Globals
import static globals.SinteringGlobals.*

import static gregtech.api.unification.material.Materials.*;
import gregtech.api.unification.material.MarkerMaterials;
import static gregtech.api.unification.ore.OrePrefix.dye;

ROTARY_KILN = recipemap('rotary_kiln')
ADVANCED_ARC_FURNACE = recipemap('advanced_arc_furnace')
BR = recipemap('batch_reactor')
REACTION_FURNACE = recipemap('reaction_furnace')
CRYSTALLIZER = recipemap('crystallizer')
BCR = recipemap('bubble_column_reactor')
ELECTROLYTIC_CELL = recipemap('electrolytic_cell')
VACUUM_CHAMBER = recipemap('vacuum_chamber')
ROASTER = recipemap('roaster')
CSTR = recipemap('continuous_stirred_tank_reactor')

ADVANCED_ARC_FURNACE.recipeBuilder()
.inputs(ore('dustChromite'))
.inputs(ore('dustAnyPurityCarbon') * 4)
.inputs(ore('dustTinyQuicklime'))
.outputs(metaitem('dustFerrochromium') * 3)
.fluidOutputs(fluid('carbon_monoxide') * 4000)
.duration(200)
.EUt(Globals.voltAmps[2])
.buildAndRegister()

for (fuel in sintering_fuels) {
    if (!fuel.isPlasma) {
        ROTARY_KILN.recipeBuilder()
                .inputs(ore('dustChromite') * 2)
                .inputs(ore('dustSodaAsh') * 24)
                .fluidInputs(fluid(fuel.name) * fuel.amountRequired)
                .fluidInputs(fluid('oxygen') * 7010)
                .outputs(metaitem('dustSodiumChromateMixture') * 5)
                .fluidOutputs(fluid('carbon_dioxide') * 4000)
                .duration(400)
                .EUt(Globals.voltAmps[2])
                .buildAndRegister()
    }
}

BR.recipeBuilder()
.inputs(ore('dustSodiumChromateMixture') * 10)
.fluidInputs(fluid('distilled_water') * 8000)
.outputs(metaitem('dustIronIiiOxide') * 10)
.fluidOutputs(fluid('sodium_chromate_solution') * 8000)
.duration(800)
.EUt(Globals.voltAmps[2])
.buildAndRegister()

CSTR.recipeBuilder()
.fluidInputs(fluid('sodium_chromate_solution') * 50)
.fluidInputs(fluid('sulfuric_acid') * 50)
.fluidOutputs(fluid('sodium_dichromate_solution') * 50)
.duration(5)
.EUt(Globals.voltAmps[2])
.buildAndRegister()

DISTILLATION_TOWER.recipeBuilder()
.fluidInputs(fluid('sodium_dichromate_solution') * 1000)
.outputs(metaitem('dustSodiumDichromate') * 11)
.fluidOutputs(fluid('sulfuric_acid') * 1000)
.fluidOutputs(fluid('water') * 1000)
.duration(100)
.EUt(Globals.voltAmps[2])
.buildAndRegister()

ROASTER.recipeBuilder()
.inputs(ore('dustAnyPurityCarbon') * 2)
.inputs(ore('dustSodiumDichromate') * 11)
.outputs(metaitem('dustChromiumSodaMixture') * 2)
.fluidOutputs(fluid('carbon_monoxide') * 1000)
.duration(100)
.EUt(Globals.voltAmps[2])
.buildAndRegister()

BR.recipeBuilder()
.inputs(ore('dustChromiumSodaMixture') * 2)
.fluidInputs(fluid('water') * 1000)
.outputs(metaitem('dustChromiumIiiOxide') * 5)
.fluidOutputs(fluid('soda_ash_solution') * 1000)
.duration(100)
.EUt(Globals.voltAmps[2])
.buildAndRegister()

ROASTER.recipeBuilder()
.inputs(ore('dustChromiumIiiHydroxide') * 14)
.outputs(metaitem('dustChromiumIiiOxide') * 5)
.fluidOutputs(fluid('dense_steam') * 3000)
.EUt(Globals.voltAmps[2])
.duration(100)
.buildAndRegister()

REACTION_FURNACE.recipeBuilder()
.inputs(ore('dustAnyPurityAluminium') * 2)
.inputs(ore('dustChromiumIiiOxide') * 5)
.outputs(metaitem('dustAlumina') * 5)
.outputs(metaitem('dustChrome') * 2)
.EUt(Globals.voltAmps[2])
.duration(100)
.buildAndRegister()

BCR.recipeBuilder()
.fluidInputs(fluid('ammonia') * 100)
.fluidInputs(fluid('diluted_sulfuric_acid') * 100)
.fluidOutputs(fluid('ammonium_sulfate_solution') * 50)
.EUt(Globals.voltAmps[2])
.duration(5)
.buildAndRegister()

DISTILLERY.recipeBuilder()
.fluidInputs(fluid('ammonium_sulfate_solution') * 1000)
.outputs(metaitem('dustAmmoniumSulfate') * 15)
.fluidOutputs(fluid('water') * 1000)
.EUt(Globals.voltAmps[2])
.duration(5)
.buildAndRegister()

BR.recipeBuilder()
.circuitMeta(1)
.inputs(ore('dustFerrochromium') * 3)
.inputs(ore('dustAmmoniumSulfate') * 15)
.fluidInputs(fluid('sulfuric_acid') * 6000)
.fluidInputs(fluid('distilled_water') * 750)
.fluidOutputs(fluid('hydrogen') * 2000)
.fluidOutputs(fluid('dissolved_ferrochromium') * 1000)
.EUt(Globals.voltAmps[3])
.duration(200)
.buildAndRegister()

BR.recipeBuilder()
.fluidInputs(fluid('dissolved_ferrochromium') * 1000)
.fluidInputs(fluid('ammonia') * 4000)
.outputs(metaitem('dustCrudeAmmoniumIronIiSulfate') * 21)
.fluidOutputs(fluid('ammonium_chrome_alum_solution') * 750)
.EUt(Globals.voltAmps[3])
.duration(200)
.buildAndRegister()

BR.recipeBuilder()
.fluidInputs(fluid('dissolved_ferrochromium') * 1000)
.fluidInputs(fluid('ammonia') * 4000)
.fluidInputs(fluid('mohr_mother_liquor') * 250)
.outputs(metaitem('dustCrudeAmmoniumIronIiSulfate') * 21)
.fluidOutputs(fluid('ammonium_chrome_alum_solution') * 1000)
.EUt(Globals.voltAmps[3])
.duration(200)
.buildAndRegister()

BR.recipeBuilder()
.inputs(ore('dustCrudeAmmoniumIronIiSulfate') * 21)
.fluidInputs(fluid('gtfo_heated_water') * 250)
.fluidOutputs(fluid('crude_ammonium_iron_ii_sulfate_solution') * 250)
.EUt(Globals.voltAmps[3])
.duration(200)
.buildAndRegister()

CRYSTALLIZER.recipeBuilder()
.fluidInputs(fluid('crude_ammonium_iron_ii_sulfate_solution') * 250)
.outputs(metaitem('dustAmmoniumIronIiSulfate') * 21)
.fluidOutputs(fluid('mohr_mother_liquor') * 250)
.EUt(Globals.voltAmps[3])
.duration(200)
.buildAndRegister()

BR.recipeBuilder()
.inputs(ore('dustAmmoniumIronIiSulfate') * 21)
.fluidInputs(fluid('gtfo_heated_water') * 1000)
.fluidOutputs(fluid('ammonium_iron_ii_sulfate_solution') * 1000)
.EUt(Globals.voltAmps[3])
.duration(200)
.buildAndRegister()

BR.recipeBuilder()
.fluidInputs(fluid('ammonia_solution') * 2000)
.fluidInputs(fluid('crude_ammonium_iron_ii_sulfate_solution') * 1000)
.outputs(metaitem('dustIronIiHydroxide') * 5)
.fluidOutputs(fluid('ammonium_sulfate_solution') * 2000)
.EUt(Globals.voltAmps[3])
.duration(200)
.buildAndRegister()

BR.recipeBuilder()
.fluidInputs(fluid('warm_water') * 1000)
.fluidInputs(fluid('ammonium_chrome_alum_solution') * 1000)
.fluidOutputs(fluid('aged_ammonium_chrome_alum_solution') * 2000)
.EUt(Globals.voltAmps[1])
.duration(800)
.buildAndRegister()

CRYSTALLIZER.recipeBuilder()
.fluidInputs(fluid('aged_ammonium_chrome_alum_solution') * 2000)
.outputs(metaitem('dustAmmoniumChromeAlum') * 12)
.fluidOutputs(fluid('chromium_mother_liquor') * 2000)
.EUt(Globals.voltAmps[3])
.duration(200)
.buildAndRegister()

BR.recipeBuilder()
.fluidInputs(fluid('gtfo_heated_water') * 1000)
.inputs(ore('dustAmmoniumChromeAlum') * 16)
.fluidOutputs(fluid('purified_ammonium_chrome_alum_solution') * 1000)
.EUt(Globals.voltAmps[1])
.duration(800)
.buildAndRegister()

ELECTROLYTIC_CELL.recipeBuilder()
.fluidInputs(fluid('purified_ammonium_chrome_alum_solution') * 1000)
.fluidInputs(fluid('distilled_water') * 400)
.notConsumable(metaitem('plateStainlessSteel'))
.notConsumable(metaitem('plateSilver'))
.notConsumable(metaitem('foilAsbestos') * 4)
.chancedOutput(metaitem('dustElectrolyticChromium'), 8000, 0)
.fluidOutputs(fluid('oxygen') * 1200)
.fluidOutputs(fluid('chromium_anolyte') * 100)
.fluidOutputs(fluid('chromium_catholyte') * 100)
.EUt(Globals.voltAmps[3])
.duration(200)
.buildAndRegister()

BR.recipeBuilder()
.fluidInputs(fluid('warm_water') * 1000)
.fluidInputs(fluid('chromium_catholyte') * 1000)
.fluidOutputs(fluid('aged_ammonium_chrome_alum_solution') * 2000)
.EUt(Globals.voltAmps[1])
.duration(800)
.buildAndRegister()

BCR.recipeBuilder()
.fluidInputs(fluid('chromium_anolyte') * 100)
.fluidInputs(fluid('sulfur_dioxide') * 150)
.fluidOutputs(fluid('reduced_chromium_anolyte') * 100)
.EUt(Globals.voltAmps[1])
.duration(10)
.buildAndRegister()

BR.recipeBuilder()
.inputs(ore('dustFerrochromium') * 3)
.inputs(ore('dustAmmoniumSulfate') * 15)
.fluidInputs(fluid('reduced_chromium_anolyte') * 3000)
.fluidInputs(fluid('sulfuric_acid') * 6000)
.fluidInputs(fluid('distilled_water') * 750)
.fluidOutputs(fluid('hydrogen') * 2000)
.fluidOutputs(fluid('dissolved_ferrochromium') * 2000)
.EUt(Globals.voltAmps[3])
.duration(200)
.buildAndRegister()

BR.recipeBuilder()
.inputs(ore('dustFerrochromium') * 3)
.inputs(ore('dustAmmoniumSulfate') * 15)
.fluidInputs(fluid('chromium_mother_liquor') * 8000)
.fluidInputs(fluid('sulfuric_acid') * 6000)
.fluidInputs(fluid('distilled_water') * 750)
.fluidOutputs(fluid('hydrogen') * 2000)
.fluidOutputs(fluid('dissolved_ferrochromium') * 2000)
.EUt(Globals.voltAmps[3])
.duration(200)
.buildAndRegister()

VACUUM_CHAMBER.recipeBuilder()
.fluidInputs(fluid('electrolytic_chromium') * 1440)
.fluidOutputs(fluid('high_purity_chrome') * 1440)
.fluidOutputs(fluid('oxygen') * 144)
.EUt(Globals.voltAmps[3])
.duration(200)
.buildAndRegister()

ROASTER.recipeBuilder()
        .inputs(ore('dustChromiumTrioxide') * 8)
        .outputs(metaitem('dustChromiumIiiOxide') * 5)
        .fluidOutputs(fluid('oxygen') * 3000)
        .EUt(120)
        .duration(200)
        .buildAndRegister()
