BR = recipemap('batch_reactor')

// From zinc pyrometallurgy
BR.recipeBuilder()
    .inputs(ore('dustZincFlue'))
    .fluidInputs(fluid('sulfuric_acid') * 1000)
    .outputs(metaitem('dustAsh'))
    .fluidOutputs(fluid('impure_cadmium_sulfate_solution') * 1000)
    .EUt(30)
    .duration(20)
    .buildAndRegister()

BR.recipeBuilder()
    .inputs(ore('dustSalt') * 2)
    .fluidInputs(fluid('impure_cadmium_sulfate_solution') * 10000)
    .outputs(metaitem('dustThalliumIChloride') * 2)
    .fluidOutputs(fluid('cadmium_sulfate_solution') * 10000)
    .EUt(30)
    .duration(20)
    .buildAndRegister()

// From zinc hydrometallurgy
BR.recipeBuilder()
    .fluidInputs(fluid('sulfuric_acid') * 1000)
    .fluidInputs(fluid('water') * 1000)
    .inputs(ore('dustCopperCadmiumResidue') * 30)
    .fluidOutputs(fluid('cadmium_sulfate_solution') * 1000)
    .fluidOutputs(fluid('hydrogen') * 2000)
    .outputs(metaitem('dustCopper') * 2)
    .EUt(30)
    .duration(160)
    .buildAndRegister()

BR.recipeBuilder()
    .inputs(ore('dustZinc'))
    .fluidInputs(fluid('cadmium_sulfate_solution') * 1000)
    .chancedOutput(metaitem('sponge.cadmium'), 9000, 0)
    .fluidOutputs(fluid('wastewater') * 1000)
    .EUt(30)
    .duration(160)
    .buildAndRegister()

// Electrorefining
BR.recipeBuilder()
    .inputs(metaitem('sponge.cadmium'))
    .fluidInputs(fluid('sulfuric_acid') * 1000)
    .fluidInputs(fluid('air') * 4000)
    .fluidOutputs(fluid('purified_cadmium_solution') * 1000)
    .EUt(30)
    .duration(160)
    .buildAndRegister()

ELECTROLYTIC_CELL.recipeBuilder()
    .notConsumable(ore('stickLead'))
    .notConsumable(ore('plateAluminium'))
    .fluidInputs(fluid('purified_cadmium_solution') * 1000)
    .outputs(metaitem('dustCadmium'))
    .fluidOutputs(fluid('oxygen') * 1000)
    .fluidOutputs(fluid('sulfuric_acid') * 1000)
    .EUt(30)
    .duration(160)
    .buildAndRegister()
