# Drone Case

![Droning on.](oredict:oc:droneCase1)

The drone case is used to build [drones](drone.md) in the [assembler](../block/assembler.md). [Drones](drone.md) are light-weight, fast and very mobile machines with limited functionality (fewer upgrade and component slots available). Unlike [robots](../block/robot.md) they cannot use tools, and can interact with the world only in a relatively limited manner.

They make up for their limitations with speed and lower running energy costs. They are well suited for transport of small amounts of items, and ideal for reconnaissance. Pairing a [drone](drone.md) with a [robot](../block/robot.md) can be quite powerful, with the [robot](../block/robot.md) doing the "hard work", and the [drone](drone.md) providing information about the environment and transporting items to and from a central hub, for example.

Like [microcontrollers](../block/microcontroller.md), [drones](drone.md) can only be programmed using their [EEPROM](eeprom.md). Accordingly, the [EEPROM](eeprom.md) can be changed by crafting the [drone](drone.md) with another [EEPROM](eeprom.md); the existing [EEPROM](eeprom.md) is return to the player's inventory.

The tier 1 drone case is capable of taking the following components:
- 1x tier 1 [CPU](cpu1.md)
- 1x tier 1 [RAM](ram1.md)
- 1x [EEPROM](eeprom.md)
- 1x Expansion card (tier 2)
- 1x Expansion card (tier 1)
- 1x Upgrade (tier 1)
- 1x Upgrade (tier 2)

The tier 2 drone case is capable of taking the following components:
- 1x tier 1 [CPU)](cpu1.md)
- 2x tier 1 [RAM](ram1.md)
- 1x [EEPROM](eeprom.md)
- 2x Expansion card (tier 2)
- 1x Upgrade (tier 1) 
- 1x Upgrade (tier 2)
- 1x Upgrade (tier 3)

The tier 4 (Creative) drone case is capable of taking the following components:
- 1x tier 3 [CPU](cpu3.md)
- 2x tier 3 [RAM](ram5.md)
- 1x [EEPROM](eeprom.md)
- 3x Expansion card (tier 3)
- 9x Upgrade (tier 3)