## Card Writer

![](https://i.imgur.com/5Rmq5nh.png)

Card Writer, writes RFID, MagCards and EEPROMs.
### Methods
```lua
writer = require("component").os_cardwriter

writer.write(String:data, String:displayName, Optional Boolean:locked, Optional Integer:color)
writer.write("Test Data", "Display", true) -- writes data to an magnetic/rfid card, 3rd parameter sets the card to readonly

writer.flash(String:data, String:title, Boolean:writelock) -- flashes data to an eeprom
```

Will write "Test Data" to a card, name it "Display" and lock it     from further writing, the same method works on RFID and MagStrip cards,
though the limit on string length is different from both, 64 characters for [RFID Cards](RFID_Card), and 128 for [Magnetic Cards](MagneticCard).
the first call to write will also assign the card a UUID to help identify your cards.

### Events

```
event, address = event.pull("cardInsert")
```

The cardInsert event is triggered when a [RFID Card](RFID_Card) or [Magnetic Card](MagneticCard) is inserted. 

```
event, address = event.pull("cardRemove")
```

The cardRemove event is triggered when you remove the card.

event is the event name, address is the card writer address

# Binary Data
If you want to write binary data (eg. encryption keys) to a Magnetic/RFID Card you have to encode it to a String before writing it, and convert it back after reading. 
This can be done with a OpenComputers Data Card and the [encode64/decode64](https://ocdoc.cil.li/component:data) methods.
