/*
 * Decompiled with CFR 0.152.
 */
package weatherpony.fenceoverhual;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFence;
import net.minecraft.block.BlockFenceGate;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import weatherpony.fenceoverhual.IDiagonal;
import weatherpony.util.lists.InitializationListHelper;

public interface IOverhauledFence
extends IDiagonal {
    public static final PropertyBool NORTH = PropertyBool.func_177716_a((String)"north");
    public static final PropertyBool EAST = PropertyBool.func_177716_a((String)"east");
    public static final PropertyBool SOUTH = PropertyBool.func_177716_a((String)"south");
    public static final PropertyBool WEST = PropertyBool.func_177716_a((String)"west");
    public static final PropertyBool[] allFacings = new PropertyBool[]{NORTH, SOUTH, EAST, WEST, NORTHEAST, SOUTHEAST, NORTHWEST, SOUTHWEST};
    public static final PropertyBool[] allProperties = new InitializationListHelper<PropertyBool>(allFacings).getList((PropertyBool[])new PropertyBool[0]);
    public static final List<List<PropertyBool>> acceptableCombinations = ExecutionCode.makeAcceptableCombinations();

    public static enum FacingOrdering {
        North(NORTH, false, new Vec3i(0, 0, -1), new double[]{0.0}, new FacingOrdering[0]),
        South(SOUTH, North, false, new Vec3i(0, 0, 1), new double[]{0.5}, new FacingOrdering[0]),
        East(EAST, false, new Vec3i(1, 0, 0), new double[]{0.25}, new FacingOrdering[0]),
        West(WEST, East, false, new Vec3i(-1, 0, 0), new double[]{0.75}, new FacingOrdering[0]),
        NorthEast(IDiagonal.NORTHEAST, true, new Vec3i(1, 0, -1), new double[]{0.125}, North, East),
        NorthWest(IDiagonal.NORTHWEST, true, new Vec3i(-1, 0, -1), new double[]{0.875}, North, West),
        SouthEast(IDiagonal.SOUTHEAST, NorthWest, true, new Vec3i(1, 0, 1), new double[]{0.375}, South, East),
        SouthWest(IDiagonal.SOUTHWEST, NorthEast, true, new Vec3i(-1, 0, 1), new double[]{0.625}, South, West);

        private FacingOrdering reverse;
        private final PropertyBool property;
        private final Vec3i offset;
        private final boolean requiresOverhaul;
        private final List<FacingOrdering> incompatibleFacings;
        private final double[] rotationsFromStandardNorth;
        private static Map<PropertyBool, FacingOrdering> propToEnum;

        private FacingOrdering(PropertyBool property, FacingOrdering reverse, boolean requiresOverhaul, Vec3i offset, double[] rotationsFromStandardNorth, FacingOrdering ... incompatiblePrevious) {
            this(property, requiresOverhaul, offset, rotationsFromStandardNorth, incompatiblePrevious);
            this.reverse = reverse;
            reverse.reverse = this;
        }

        private FacingOrdering(PropertyBool property, boolean requiresOverhaul, Vec3i offset, double[] rotationsFromStandardNorth, FacingOrdering ... incompatiblePrevious) {
            this.property = property;
            this.incompatibleFacings = Collections.unmodifiableList(Arrays.asList(incompatiblePrevious));
            this.requiresOverhaul = requiresOverhaul;
            this.offset = offset;
            this.rotationsFromStandardNorth = rotationsFromStandardNorth;
            FacingOrdering.addToPropMap(property, this);
        }

        public boolean isIncompatible(List<FacingOrdering> currentFacings) {
            if (currentFacings.isEmpty() || this.incompatibleFacings.isEmpty()) {
                return false;
            }
            return !Collections.disjoint(currentFacings, this.incompatibleFacings);
        }

        public boolean getRequiresOverhaul() {
            return this.requiresOverhaul;
        }

        public FacingOrdering getReverse() {
            return this.reverse;
        }

        public PropertyBool getProperty() {
            return this.property;
        }

        public List<FacingOrdering> getIncomptibles() {
            return this.incompatibleFacings;
        }

        public Vec3i getOffset() {
            return this.offset;
        }

        private static void addToPropMap(PropertyBool prop, FacingOrdering enumelem) {
            if (propToEnum == null) {
                propToEnum = new HashMap<PropertyBool, FacingOrdering>();
            }
            propToEnum.put(prop, enumelem);
        }

        public static FacingOrdering getFromProperty(PropertyBool prop) {
            return propToEnum.get(prop);
        }

        public double[] getRotationsFromStandardNorth() {
            return (double[])this.rotationsFromStandardNorth.clone();
        }
    }

    public static class ExecutionCode {
        static List<List<PropertyBool>> makeAcceptableCombinations() {
            Stack<FacingOrdering> facings = new Stack<FacingOrdering>();
            ArrayList<FacingOrdering> temp = new ArrayList<FacingOrdering>(Arrays.asList(FacingOrdering.values()));
            Collections.reverse(temp);
            facings.addAll(temp);
            ArrayList<List<PropertyBool>> acceptable = new ArrayList<List<PropertyBool>>();
            ExecutionCode.compileSection(facings, new ArrayList<FacingOrdering>(), acceptable);
            acceptable.trimToSize();
            return Collections.unmodifiableList(acceptable);
        }

        static void compileSection(Stack<FacingOrdering> remaining, List<FacingOrdering> runningWith, List<List<PropertyBool>> compiled) {
            if (remaining.isEmpty()) {
                ArrayList<PropertyBool> props = new ArrayList<PropertyBool>();
                for (FacingOrdering each : runningWith) {
                    props.add(each.getProperty());
                }
                props.trimToSize();
                compiled.add(Collections.unmodifiableList(props));
            } else {
                FacingOrdering next = remaining.pop();
                ExecutionCode.compileSection(remaining, runningWith, compiled);
                if (!next.isIncompatible(runningWith)) {
                    runningWith.add(next);
                    ExecutionCode.compileSection(remaining, runningWith, compiled);
                    runningWith.remove(runningWith.size() - 1);
                }
                remaining.push(next);
            }
        }

        public static boolean NORMAL_canPotentiallyConnectOnDiagonal(IBlockAccess world, BlockPos pos, PropertyBool direction) {
            return true;
        }

        public static boolean NORMAL_isConnectedFrom_askingByPotentialConnection(IBlockAccess world, BlockPos pos, PropertyBool direction) {
            FacingOrdering fromFacing = FacingOrdering.getFromProperty(direction);
            for (FacingOrdering eachInc : fromFacing.getIncomptibles()) {
                if (!ExecutionCode.canPotentiallyConnectTo(world, pos, eachInc)) continue;
                return false;
            }
            return true;
        }

        public static boolean isConnectedTo(IBlockAccess worldIn, BlockPos myPos, FacingOrdering facing) {
            if (facing.getRequiresOverhaul()) {
                for (FacingOrdering eachInc : facing.getIncomptibles()) {
                    if (!ExecutionCode.canPotentiallyConnectTo(worldIn, myPos, eachInc)) continue;
                    return false;
                }
                BlockPos targetPos = myPos.func_177971_a(facing.getOffset());
                FacingOrdering fromFacing = facing.getReverse();
                Block block = worldIn.func_180495_p(targetPos).func_177230_c();
                if (block instanceof IDiagonal) {
                    return ((IDiagonal)block).isConnectedFrom_askingByPotentialConnection(worldIn, targetPos, fromFacing.getProperty());
                }
                return false;
            }
            return ExecutionCode.canPotentiallyConnectTo(worldIn, myPos, facing);
        }

        public static boolean isConnectedTo_noConflicts(IBlockAccess worldIn, BlockPos myPos, FacingOrdering facing) {
            if (facing.getRequiresOverhaul()) {
                BlockPos targetPos = myPos.func_177971_a(facing.getOffset());
                FacingOrdering fromFacing = facing.getReverse();
                Block block = worldIn.func_180495_p(targetPos).func_177230_c();
                if (block instanceof IDiagonal) {
                    return ((IDiagonal)block).isConnectedFrom_askingByPotentialConnection(worldIn, targetPos, fromFacing.getProperty());
                }
                return false;
            }
            return ExecutionCode.canPotentiallyConnectTo(worldIn, myPos, facing);
        }

        public static boolean canPotentiallyConnectTo(IBlockAccess worldIn, BlockPos ownPos, FacingOrdering facing) {
            BlockPos pos = ownPos.func_177971_a(facing.getOffset());
            IBlockState state = worldIn.func_180495_p(pos);
            Block block = state.func_177230_c();
            if (block == Blocks.field_180401_cv) {
                return false;
            }
            if (facing.getRequiresOverhaul()) {
                if (block instanceof IOverhauledFence) {
                    return true;
                }
                if (block instanceof IDiagonal) {
                    return ((IDiagonal)block).canPotentiallyConnectOnDiagonal(worldIn, pos, facing.getReverse().getProperty());
                }
                Material mat = block.func_149688_o(state);
                return mat.func_76218_k() && block.func_149686_d(state) && mat != Material.field_151572_C;
            }
            if (block instanceof IOverhauledFence || block instanceof BlockFence || block instanceof BlockFenceGate) {
                return true;
            }
            Material mat = block.func_149688_o(state);
            return mat.func_76218_k() && block.func_149686_d(state) && mat != Material.field_151572_C;
        }

        public static IBlockState fillDirectionState(IBlockState blankState, IBlockAccess worldIn, BlockPos pos) {
            ArrayList<FacingOrdering> acceptedFacings = new ArrayList<FacingOrdering>();
            for (FacingOrdering eachFacing : FacingOrdering.values()) {
                if (eachFacing.isIncompatible(acceptedFacings) || !ExecutionCode.isConnectedTo_noConflicts(worldIn, pos, eachFacing)) continue;
                blankState = blankState.func_177226_a((IProperty)eachFacing.getProperty(), (Comparable)Boolean.valueOf(true));
            }
            return blankState;
        }
    }
}

