/*
 * Decompiled with CFR 0.152.
 */
package weatherpony.fenceoverhual;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockPlanks;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.ShapedRecipes;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.ModMetadata;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import weatherpony.fenceoverhual.BlockOverhauledFence;
import weatherpony.fenceoverhual.CommonProxy;
import weatherpony.fenceoverhual.api.FenceOverhaulAPI;

@Mod(modid="fenceoverhaul", name="Fence Overhaul", version="1.3.4", acceptedMinecraftVersions="[1.12,1.12.2]")
public class FenceOverhaulMod {
    public static final String FENCEOVERHAUL_MODID = "fenceoverhaul";
    public static final String FENCEOVERHAUL_NAME = "Fence Overhaul";
    public static final String FENCEOVERHAUL_VERSION = "1.3.4";
    @Mod.Metadata(value="fenceoverhaul")
    public static ModMetadata meta;
    @SidedProxy(modId="fenceoverhaul", serverSide="weatherpony.fenceoverhual.CommonProxy", clientSide="weatherpony.fenceoverhual.ClientProxy")
    public static CommonProxy proxy;
    private static List<FenceCraftingUnit> registeredFences;
    public static final BlockPlanks.EnumType[] vanillaWoods;

    private void fillInMeta() {
        FenceOverhaulMod.meta.authorList = Arrays.asList("The_WeatherPony");
        FenceOverhaulMod.meta.autogenerated = false;
        FenceOverhaulMod.meta.credits = "";
        FenceOverhaulMod.meta.description = "Adds improved fences to Minecraft";
        FenceOverhaulMod.meta.useDependencyInformation = false;
        FenceOverhaulMod.meta.dependencies.clear();
        FenceOverhaulMod.meta.logoFile = "";
        FenceOverhaulMod.meta.updateJSON = "";
        FenceOverhaulMod.meta.parent = "";
        FenceOverhaulMod.meta.parentMod = null;
        FenceOverhaulMod.meta.requiredMods.clear();
        FenceOverhaulMod.meta.url = "";
    }

    @SubscribeEvent
    public void registerBlocks(RegistryEvent.Register<Block> event) {
        IForgeRegistry registry = event.getRegistry();
        for (FenceCraftingUnit each : registeredFences) {
            registry.register((IForgeRegistryEntry)each.fence);
        }
    }

    public void makeItems() {
        for (CommonProxy.FenceTextureUnit each : FenceOverhaulMod.proxy.fenceResourceList) {
            Item item = each.item = (Item)new ItemBlock(each.fence).setRegistryName(each.fence.getRegistryName());
        }
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void registerItemRendering(ModelRegistryEvent event) {
        for (CommonProxy.FenceTextureUnit each : FenceOverhaulMod.proxy.fenceResourceList) {
            Item item = each.item;
            ModelResourceLocation inventory = new ModelResourceLocation("fenceoverhaul:" + each.name, "inventory");
            ModelLoader.setCustomModelResourceLocation((Item)item, (int)0, (ModelResourceLocation)inventory);
        }
    }

    @SubscribeEvent
    public void registerItems(RegistryEvent.Register<Item> event) {
        IForgeRegistry registry = event.getRegistry();
        for (CommonProxy.FenceTextureUnit each : FenceOverhaulMod.proxy.fenceResourceList) {
            registry.register((IForgeRegistryEntry)each.item);
        }
    }

    @SubscribeEvent
    public void registerRecipes(RegistryEvent.Register<IRecipe> event) {
        try {
            for (FenceCraftingUnit each : registeredFences) {
                CraftingHelper.ShapedPrimer primer = CraftingHelper.parseShaped((Object[])new Object[]{new String[]{"# #", "WWW", "# #"}, Character.valueOf('#'), each.sticks.provide(), Character.valueOf('W'), each.baseFence.provide()});
                ResourceLocation recipeName = each.fence.getRegistryName();
                IRecipe recipe = (IRecipe)new ShapedRecipes("", primer.width, primer.height, primer.input, new ItemStack(each.fence, 3)).setRegistryName(recipeName);
                event.getRegistry().register((IForgeRegistryEntry)recipe);
            }
        }
        catch (RuntimeException e) {
            e.printStackTrace();
            throw e;
        }
    }

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        MinecraftForge.EVENT_BUS.register((Object)this);
        FenceOverhaulMod.registerStandardFences();
        try {
            this.makeItems();
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to register fence rendering code!", e);
        }
        proxy.modPreInit(event);
    }

    @Mod.EventHandler
    @SideOnly(value=Side.CLIENT)
    public void init(FMLInitializationEvent event) {
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
    }

    private static void registerStandardFences() {
        for (BlockPlanks.EnumType each : vanillaWoods) {
            String type = each.func_176610_l().toLowerCase();
            FenceOverhaulMod.registerFence(Material.field_151575_d, each.func_181070_c(), type, 2.0f, 5.0f, SoundType.field_185848_a, "blocks/planks_" + each.func_176840_c().toLowerCase());
        }
    }

    public static void registerFence(FenceOverhaulAPI.FenceData data) {
    }

    public static void registerFence(Material material, MapColor mapColor, String type, float hardness, float resistance, SoundType sound, String defaultTexture) {
        String name = type + "_overhauledfence";
        FenceOverhaulMod.connectFence(new BlockOverhauledFence(material, mapColor, sound, type).func_149711_c(hardness).func_149752_b(resistance).func_149663_c(name), type, name, defaultTexture);
    }

    private static Block connectFence(Block fence, final String type, String name, String defaultTexture) {
        registeredFences.add(new FenceCraftingUnit(fence, new Provider(){

            public Object provide() {
                Block block = (Block)Block.field_149771_c.func_82594_a((Object)new ResourceLocation(type.equals("oak") ? "fence" : type + "_fence"));
                if (block == null) {
                    System.out.println("Base Fence not found... " + type);
                }
                return block;
            }
        }, new Provider(){

            public Object provide() {
                return "stickWood";
            }
        }));
        FenceOverhaulMod.proxy.fenceResourceList.add(new CommonProxy.FenceTextureUnit(fence, type, name, defaultTexture));
        fence.setRegistryName(new ResourceLocation(FENCEOVERHAUL_MODID, name));
        return fence;
    }

    static {
        registeredFences = new ArrayList<FenceCraftingUnit>();
        vanillaWoods = new BlockPlanks.EnumType[]{BlockPlanks.EnumType.OAK, BlockPlanks.EnumType.SPRUCE, BlockPlanks.EnumType.BIRCH, BlockPlanks.EnumType.JUNGLE, BlockPlanks.EnumType.ACACIA, BlockPlanks.EnumType.DARK_OAK};
    }

    public static class FenceCraftingUnit {
        Block fence;
        Provider baseFence;
        Provider sticks;

        FenceCraftingUnit(Block fence, Provider baseFence, Provider sticks) {
            this.fence = fence;
            this.baseFence = baseFence;
            this.sticks = sticks;
        }
    }

    public static interface Provider<Type> {
        public Type provide();
    }
}

