/*
 * Decompiled with CFR 0.152.
 */
package weatherpony.fenceoverhual;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFence;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import weatherpony.fenceoverhual.IDiagonal;
import weatherpony.fenceoverhual.IOverhauledFence;

public class BlockOverhauledFence
extends BlockFence
implements IOverhauledFence {
    IBlockState basedOn;
    public final String type;
    private static final AxisAlignedBB[] BOUNDING_BOXES;
    private static final AxisAlignedBB[][] COLLISIONBOXES;

    public BlockOverhauledFence(Material p_i46395_1_, MapColor p_i46395_2_, SoundType sound, String type) {
        super(p_i46395_1_, p_i46395_2_);
        IBlockState defaultState = this.field_176227_L.func_177621_b();
        for (PropertyBool each : IOverhauledFence.allProperties) {
            defaultState = defaultState.func_177226_a((IProperty)each, (Comparable)Boolean.valueOf(false));
        }
        this.func_180632_j(defaultState);
        this.type = type;
        this.func_149672_a(sound);
    }

    public BlockOverhauledFence(IBlockState basedOn, String type) {
        this(basedOn.func_177230_c().func_149688_o(basedOn), null, basedOn.func_177230_c().func_185467_w(), type);
        this.basedOn = basedOn;
        try {
            this.func_149711_c(basedOn.func_177230_c().func_176195_g(basedOn, null, null));
            this.func_149752_b(basedOn.func_177230_c().func_149638_a(null) * 5.0f);
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    @Deprecated
    public MapColor func_180659_g(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        return super.func_180659_g(this.basedOn == null ? state : this.basedOn, worldIn, pos);
    }

    public int func_176201_c(IBlockState state) {
        return 0;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        state = this.func_176221_a(state, world, pos);
        boolean n = (Boolean)state.func_177229_b((IProperty)IOverhauledFence.NORTH);
        boolean s = (Boolean)state.func_177229_b((IProperty)IOverhauledFence.SOUTH);
        boolean e = (Boolean)state.func_177229_b((IProperty)IOverhauledFence.EAST);
        boolean w = (Boolean)state.func_177229_b((IProperty)IOverhauledFence.WEST);
        boolean ne = (Boolean)state.func_177229_b((IProperty)IOverhauledFence.NORTHEAST);
        boolean se = (Boolean)state.func_177229_b((IProperty)IOverhauledFence.SOUTHEAST);
        boolean sw = (Boolean)state.func_177229_b((IProperty)IOverhauledFence.SOUTHWEST);
        boolean nw = (Boolean)state.func_177229_b((IProperty)IOverhauledFence.NORTHWEST);
        int boundingIndex = 0;
        if (n || ne || nw) {
            boundingIndex |= 1 << EnumFacing.NORTH.func_176736_b();
        }
        if (e || ne || se) {
            boundingIndex |= 1 << EnumFacing.EAST.func_176736_b();
        }
        if (s || se || sw) {
            boundingIndex |= 1 << EnumFacing.SOUTH.func_176736_b();
        }
        if (w || nw || sw) {
            boundingIndex |= 1 << EnumFacing.WEST.func_176736_b();
        }
        return BOUNDING_BOXES[boundingIndex];
    }

    private static AxisAlignedBB[] generateDiagonalCollisionBoxes(PropertyBool diagonal) {
        int diagonalSteps = 16;
        int diagonalCoreSteps = 4;
        float squareRadius = 0.125f;
        int diagonalWalkCount = 6;
        float minY = 0.0f;
        float maxY = 1.5f;
        ArrayList<AxisAlignedBB> collisions = new ArrayList<AxisAlignedBB>();
        IOverhauledFence.FacingOrdering facing = IOverhauledFence.FacingOrdering.getFromProperty(diagonal);
        Vec3i vec = facing.getOffset();
        int x = vec.func_177958_n();
        float startX = 0.5f + 0.5f * (float)x;
        float addX = (float)(-x) * 0.125f;
        float spanX = (float)x * 0.125f * 2.0f;
        int z = vec.func_177952_p();
        float startZ = 0.5f + 0.5f * (float)z;
        float addZ = (float)(-z) * 0.125f;
        float spanZ = (float)z * 0.125f * 2.0f;
        for (int walk = 0; walk < 6; ++walk) {
            collisions.add(new AxisAlignedBB((double)startX, (double)minY, (double)startZ, (double)(startX + spanX), (double)maxY, (double)(startZ + spanZ)));
            startX += addX;
            startZ += addZ;
        }
        return collisions.toArray(new AxisAlignedBB[collisions.size()]);
    }

    public void func_185477_a(IBlockState state, World worldIn, BlockPos pos, AxisAlignedBB mask, List<AxisAlignedBB> list, @Nullable Entity entityIn, boolean p_185477_7_) {
        IBlockState actual = state;
        actual = this.func_176221_a(state, (IBlockAccess)worldIn, pos);
        BlockOverhauledFence.func_185492_a((BlockPos)pos, (AxisAlignedBB)mask, list, (AxisAlignedBB)BlockFence.field_185671_f);
        for (IOverhauledFence.FacingOrdering each : IOverhauledFence.FacingOrdering.values()) {
            if (!((Boolean)actual.func_177229_b((IProperty)each.getProperty())).booleanValue()) continue;
            for (AxisAlignedBB eachBox : COLLISIONBOXES[each.ordinal()]) {
                BlockOverhauledFence.func_185492_a((BlockPos)pos, (AxisAlignedBB)mask, list, (AxisAlignedBB)eachBox);
            }
        }
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        return IOverhauledFence.ExecutionCode.fillDirectionState(this.func_176223_P(), worldIn, pos);
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, (IProperty[])IOverhauledFence.allProperties);
    }

    @Override
    public boolean canPotentiallyConnectOnDiagonal(IBlockAccess world, BlockPos pos, PropertyBool direction) {
        return IOverhauledFence.ExecutionCode.NORMAL_canPotentiallyConnectOnDiagonal(world, pos, direction);
    }

    @Override
    public boolean isConnectedFrom_askingByPotentialConnection(IBlockAccess world, BlockPos pos, PropertyBool direction) {
        return IOverhauledFence.ExecutionCode.NORMAL_isConnectedFrom_askingByPotentialConnection(world, pos, direction);
    }

    public IBlockState func_185499_a(IBlockState state, Rotation rotation) {
        switch (rotation) {
            case CLOCKWISE_90: {
                return state.func_177226_a((IProperty)IOverhauledFence.NORTH, state.func_177229_b((IProperty)IOverhauledFence.EAST)).func_177226_a((IProperty)IOverhauledFence.EAST, state.func_177229_b((IProperty)IOverhauledFence.SOUTH)).func_177226_a((IProperty)IOverhauledFence.SOUTH, state.func_177229_b((IProperty)IOverhauledFence.WEST)).func_177226_a((IProperty)IOverhauledFence.WEST, state.func_177229_b((IProperty)IOverhauledFence.NORTH)).func_177226_a((IProperty)IOverhauledFence.NORTHEAST, state.func_177229_b((IProperty)IOverhauledFence.SOUTHEAST)).func_177226_a((IProperty)IOverhauledFence.SOUTHEAST, state.func_177229_b((IProperty)IOverhauledFence.SOUTHWEST)).func_177226_a((IProperty)IOverhauledFence.SOUTHWEST, state.func_177229_b((IProperty)IOverhauledFence.NORTHWEST)).func_177226_a((IProperty)IOverhauledFence.NORTHWEST, state.func_177229_b((IProperty)IOverhauledFence.NORTHEAST));
            }
            case CLOCKWISE_180: {
                return state.func_177226_a((IProperty)IOverhauledFence.NORTH, state.func_177229_b((IProperty)IOverhauledFence.SOUTH)).func_177226_a((IProperty)IOverhauledFence.EAST, state.func_177229_b((IProperty)IOverhauledFence.WEST)).func_177226_a((IProperty)IOverhauledFence.SOUTH, state.func_177229_b((IProperty)IOverhauledFence.NORTH)).func_177226_a((IProperty)IOverhauledFence.WEST, state.func_177229_b((IProperty)IOverhauledFence.EAST)).func_177226_a((IProperty)IOverhauledFence.NORTHEAST, state.func_177229_b((IProperty)IOverhauledFence.SOUTHWEST)).func_177226_a((IProperty)IOverhauledFence.SOUTHEAST, state.func_177229_b((IProperty)IOverhauledFence.NORTHWEST)).func_177226_a((IProperty)IOverhauledFence.SOUTHWEST, state.func_177229_b((IProperty)IOverhauledFence.NORTHEAST)).func_177226_a((IProperty)IOverhauledFence.NORTHWEST, state.func_177229_b((IProperty)IOverhauledFence.SOUTHEAST));
            }
            case COUNTERCLOCKWISE_90: {
                return state.func_177226_a((IProperty)IOverhauledFence.NORTH, state.func_177229_b((IProperty)IOverhauledFence.WEST)).func_177226_a((IProperty)IOverhauledFence.EAST, state.func_177229_b((IProperty)IOverhauledFence.NORTH)).func_177226_a((IProperty)IOverhauledFence.SOUTH, state.func_177229_b((IProperty)IOverhauledFence.EAST)).func_177226_a((IProperty)IOverhauledFence.WEST, state.func_177229_b((IProperty)IOverhauledFence.SOUTH)).func_177226_a((IProperty)IOverhauledFence.NORTHEAST, state.func_177229_b((IProperty)IOverhauledFence.NORTHWEST)).func_177226_a((IProperty)IOverhauledFence.SOUTHEAST, state.func_177229_b((IProperty)IOverhauledFence.NORTHEAST)).func_177226_a((IProperty)IOverhauledFence.SOUTHWEST, state.func_177229_b((IProperty)IOverhauledFence.SOUTHEAST)).func_177226_a((IProperty)IOverhauledFence.NORTHWEST, state.func_177229_b((IProperty)IOverhauledFence.SOUTHWEST));
            }
            case NONE: {
                return state;
            }
        }
        throw new RuntimeException("Fell through switch: " + rotation);
    }

    public IBlockState func_185471_a(IBlockState state, Mirror mirror) {
        switch (mirror) {
            case FRONT_BACK: {
                return state.func_177226_a((IProperty)IOverhauledFence.EAST, state.func_177229_b((IProperty)IOverhauledFence.WEST)).func_177226_a((IProperty)IOverhauledFence.WEST, state.func_177229_b((IProperty)IOverhauledFence.EAST)).func_177226_a((IProperty)IDiagonal.NORTHEAST, state.func_177229_b((IProperty)IDiagonal.NORTHWEST)).func_177226_a((IProperty)IDiagonal.NORTHWEST, state.func_177229_b((IProperty)IDiagonal.NORTHEAST)).func_177226_a((IProperty)IDiagonal.SOUTHEAST, state.func_177229_b((IProperty)IDiagonal.SOUTHWEST)).func_177226_a((IProperty)IDiagonal.SOUTHWEST, state.func_177229_b((IProperty)IDiagonal.SOUTHEAST));
            }
            case LEFT_RIGHT: {
                return state.func_177226_a((IProperty)IOverhauledFence.NORTH, state.func_177229_b((IProperty)IOverhauledFence.SOUTH)).func_177226_a((IProperty)IOverhauledFence.SOUTH, state.func_177229_b((IProperty)IOverhauledFence.NORTH)).func_177226_a((IProperty)IDiagonal.NORTHEAST, state.func_177229_b((IProperty)IDiagonal.SOUTHEAST)).func_177226_a((IProperty)IDiagonal.SOUTHEAST, state.func_177229_b((IProperty)IDiagonal.NORTHEAST)).func_177226_a((IProperty)IDiagonal.NORTHWEST, state.func_177229_b((IProperty)IDiagonal.SOUTHWEST)).func_177226_a((IProperty)IDiagonal.SOUTHWEST, state.func_177229_b((IProperty)IDiagonal.NORTHWEST));
            }
            case NONE: {
                return state;
            }
        }
        throw new RuntimeException("Fell through switch: " + mirror);
    }

    static {
        IOverhauledFence.acceptableCombinations.get(0);
        BOUNDING_BOXES = new AxisAlignedBB[]{new AxisAlignedBB(0.375, 0.0, 0.375, 0.625, 1.0, 0.625), new AxisAlignedBB(0.375, 0.0, 0.375, 0.625, 1.0, 1.0), new AxisAlignedBB(0.0, 0.0, 0.375, 0.625, 1.0, 0.625), new AxisAlignedBB(0.0, 0.0, 0.375, 0.625, 1.0, 1.0), new AxisAlignedBB(0.375, 0.0, 0.0, 0.625, 1.0, 0.625), new AxisAlignedBB(0.375, 0.0, 0.0, 0.625, 1.0, 1.0), new AxisAlignedBB(0.0, 0.0, 0.0, 0.625, 1.0, 0.625), new AxisAlignedBB(0.0, 0.0, 0.0, 0.625, 1.0, 1.0), new AxisAlignedBB(0.375, 0.0, 0.375, 1.0, 1.0, 0.625), new AxisAlignedBB(0.375, 0.0, 0.375, 1.0, 1.0, 1.0), new AxisAlignedBB(0.0, 0.0, 0.375, 1.0, 1.0, 0.625), new AxisAlignedBB(0.0, 0.0, 0.375, 1.0, 1.0, 1.0), new AxisAlignedBB(0.375, 0.0, 0.0, 1.0, 1.0, 0.625), new AxisAlignedBB(0.375, 0.0, 0.0, 1.0, 1.0, 1.0), new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 0.625), new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 1.0)};
        COLLISIONBOXES = new AxisAlignedBB[][]{{BlockFence.field_185668_C}, {BlockFence.field_185672_g}, {BlockFence.field_185669_D}, {BlockFence.field_185667_B}, BlockOverhauledFence.generateDiagonalCollisionBoxes(IDiagonal.NORTHEAST), BlockOverhauledFence.generateDiagonalCollisionBoxes(IDiagonal.NORTHWEST), BlockOverhauledFence.generateDiagonalCollisionBoxes(IDiagonal.SOUTHEAST), BlockOverhauledFence.generateDiagonalCollisionBoxes(IDiagonal.SOUTHWEST)};
    }
}

