/*
 * Decompiled with CFR 0.152.
 */
package com.codetaylor.mc.athenaeum.util;

import org.lwjgl.util.vector.Quaternion;

public final class QuaternionHelper {
    public static Quaternion setFromAxisAngle(Quaternion q, float x, float y, float z, float angle) {
        q.x = x;
        q.y = y;
        q.z = z;
        float n = (float)Math.sqrt(q.x * q.x + q.y * q.y + q.z * q.z);
        float s = (float)(Math.sin(0.5 * (double)angle) / (double)n);
        q.x *= s;
        q.y *= s;
        q.z *= s;
        q.w = (float)Math.cos(0.5 * (double)angle);
        return q;
    }

    public static Quaternion mult(Quaternion q0, Quaternion q1, Quaternion res) {
        if (res == null) {
            res = new Quaternion();
        }
        float q0w = q0.w;
        float q0x = q0.x;
        float q0y = q0.y;
        float q0z = q0.z;
        float q1w = q1.w;
        float q1x = q1.x;
        float q1y = q1.y;
        float q1z = q1.z;
        res.x = q0x * q1w + q0y * q1z - q0z * q1y + q0w * q1x;
        res.y = -q0x * q1z + q0y * q1w + q0z * q1x + q0w * q1y;
        res.z = q0x * q1y - q0y * q1x + q0z * q1w + q0w * q1z;
        res.w = -q0x * q1x - q0y * q1y - q0z * q1z + q0w * q1w;
        return res;
    }

    private QuaternionHelper() {
    }
}

