/*
 * Decompiled with CFR 0.152.
 */
package com.codetaylor.mc.athenaeum.packer.atlas;

import com.codetaylor.mc.athenaeum.packer.atlas.AtlasOutOfRoomException;
import com.codetaylor.mc.athenaeum.packer.atlas.ILeaseMap;
import com.codetaylor.mc.athenaeum.packer.atlas.Lease;
import com.codetaylor.mc.athenaeum.packer.atlas.Node;
import com.codetaylor.mc.athenaeum.packer.atlas.NodeHandler;
import com.codetaylor.mc.athenaeum.packer.atlas.NodePool;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;

public class Atlas {
    private NodeHandler nodeHandler;
    private NodePool nodePool;
    private List<Node> pageNodeList;
    private ILeaseMap leaseMap;
    private List<Lease> toSort;
    private List<Lease> leasePool;
    private final int width;
    private final int height;
    private final int depth;
    private int nextLeaseId;

    public Atlas(int width, int height, int depth) {
        int i;
        if (width <= 0) {
            throw new IllegalArgumentException("Atlas width must be greater than zero");
        }
        if (height <= 0) {
            throw new IllegalArgumentException("Atlas height must be greater than zero");
        }
        if (depth <= 0) {
            throw new IllegalArgumentException("Depth must be greater than zero");
        }
        ArrayDeque<Node> nodePool = new ArrayDeque<Node>(4096);
        for (i = 0; i < 4096; ++i) {
            nodePool.push(new Node());
        }
        this.nodePool = new NodePool(nodePool);
        this.nodeHandler = new NodeHandler(this.nodePool);
        this.width = width;
        this.height = height;
        this.depth = depth;
        this.pageNodeList = new ArrayList<Node>();
        this.leaseMap = ILeaseMap.withExpectedSize(128);
        this.toSort = new ArrayList<Lease>();
        this.leasePool = new ArrayList<Lease>();
        for (i = 0; i < 128; ++i) {
            this.leasePool.add(new Lease());
        }
        this.createPageNode();
    }

    public int leaseIdCreate() {
        if (this.nextLeaseId == Integer.MAX_VALUE) {
            this.nextLeaseId = 0;
        }
        return this.nextLeaseId++;
    }

    public List<Lease> leaseListGet(List<Lease> list) {
        list.addAll(this.leaseMap.values());
        return list;
    }

    public boolean leaseDispose(int id) {
        Lease lease = (Lease)this.leaseMap.remove(id);
        if (lease != null) {
            this.nodeHandler.dispose(lease.getNode());
            lease.initDefault();
            this.leasePool.add(lease);
            return true;
        }
        return false;
    }

    public Lease leaseGet(int id) {
        return (Lease)this.leaseMap.get(id);
    }

    public void repack(Comparator<Lease> comparator) {
        this.toSort.addAll(this.leaseMap.values());
        this.toSort.sort(comparator);
        for (Node node : this.pageNodeList) {
            this.nodePool.releaseNode(node);
        }
        this.pageNodeList.clear();
        for (Lease lease : this.toSort) {
            this._insert(lease.getId(), lease.getWidth(), lease.getHeight(), lease);
        }
        this.toSort.clear();
    }

    public Lease insert(int id, int width, int height) {
        if (this.leaseMap.containsKey(id)) {
            throw new IllegalArgumentException(String.format("Atlas image id [%s] already in use", id));
        }
        Lease lease = this.leasePool.isEmpty() ? new Lease() : this.leasePool.remove(this.leasePool.size() - 1);
        lease = this._insert(id, width, height, lease);
        this.leaseMap.put(id, lease);
        return lease;
    }

    private Lease _insert(int id, int width, int height, Lease lease) throws AtlasOutOfRoomException {
        if (width > this.width) {
            throw new IllegalStateException(String.format("Image width [%d] is too large for the atlas width [%d]", width, this.width));
        }
        if (height > this.height) {
            throw new IllegalStateException(String.format("Image height [%d] is too large for the atlas height [%d]", height, this.height));
        }
        Node resultNode = null;
        int pageId = 0;
        for (int i = 0; i < this.pageNodeList.size(); ++i) {
            Node pageNode = this.pageNodeList.get(i);
            resultNode = this.nodeHandler.insert(pageNode, width, height);
            if (resultNode == null) continue;
            pageId = i;
            break;
        }
        if (resultNode == null) {
            if (this.pageNodeList.size() == this.depth) {
                throw new AtlasOutOfRoomException(String.format("Page depth of [%d] exceeded", this.depth));
            }
            pageId = this.pageNodeList.size();
            Node pageNode = this.createPageNode();
            resultNode = this.nodeHandler.insert(pageNode, width, height);
        }
        assert (resultNode != null);
        if (resultNode.imageId == -1) {
            resultNode.imageId = id;
            lease.init(id, resultNode.posX, resultNode.posY, resultNode.width, resultNode.height, (float)resultNode.posX / (float)this.width, (float)resultNode.posY / (float)this.height, (float)resultNode.posX / (float)this.width + (float)resultNode.width / (float)this.width, (float)resultNode.posY / (float)this.height + (float)resultNode.height / (float)this.height, pageId, resultNode);
            return lease;
        }
        throw new IllegalStateException("Something is awry");
    }

    private Node createPageNode() {
        Node pageNode = this.nodePool.getNode(null, 0, 0, this.width, this.height);
        this.pageNodeList.add(pageNode);
        return pageNode;
    }
}

