/*
 * Decompiled with CFR 0.152.
 */
package com.codetaylor.mc.athenaeum.network;

import com.codetaylor.mc.athenaeum.network.IPacketService;
import com.codetaylor.mc.athenaeum.network.ThreadedNetworkWrapper;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldProvider;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class PacketService
implements IPacketService {
    private static final int DEFAULT_RANGE = 64;
    private ThreadedNetworkWrapper threadedNetworkWrapper;

    public PacketService(ThreadedNetworkWrapper threadedNetworkWrapper) {
        this.threadedNetworkWrapper = threadedNetworkWrapper;
    }

    @Override
    public void sendToAllAround(IMessage message, int dimension, double x, double y, double z, double range) {
        this.threadedNetworkWrapper.sendToAllAround(message, new NetworkRegistry.TargetPoint(dimension, x, y, z, range));
    }

    @Override
    public void sendToAllAround(IMessage message, int dimension, double x, double y, double z) {
        this.sendToAllAround(message, dimension, x, y, z, 64.0);
    }

    @Override
    public void sendToAllAround(IMessage message, int dimension, BlockPos blockPos, double range) {
        this.sendToAllAround(message, dimension, blockPos.func_177958_n(), blockPos.func_177956_o(), blockPos.func_177952_p(), range);
    }

    @Override
    public void sendToAllAround(IMessage message, int dimension, BlockPos blockPos) {
        this.sendToAllAround(message, dimension, blockPos.func_177958_n(), blockPos.func_177956_o(), blockPos.func_177952_p());
    }

    @Override
    public void sendToAllAround(IMessage message, TileEntity tileEntity, int range) {
        BlockPos pos = tileEntity.func_174877_v();
        World world = tileEntity.func_145831_w();
        WorldProvider provider = world.field_73011_w;
        int dimension = provider.getDimension();
        this.sendToAllAround(message, dimension, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), range);
    }

    @Override
    public void sendToAllAround(IMessage message, TileEntity tileEntity) {
        this.sendToAllAround(message, tileEntity, 64);
    }

    @Override
    public void sendToDimension(IMessage message, TileEntity tileEntity) {
        World world = tileEntity.func_145831_w();
        WorldProvider provider = world.field_73011_w;
        int dimension = provider.getDimension();
        this.sendToDimension(message, dimension);
    }

    @Override
    public void sendToDimension(IMessage message, int dimension) {
        this.threadedNetworkWrapper.sendToDimension(message, dimension);
    }

    @Override
    public void sendToAll(IMessage message) {
        this.threadedNetworkWrapper.sendToAll(message);
    }

    @Override
    public void sendTo(IMessage message, EntityPlayerMP player) {
        this.threadedNetworkWrapper.sendTo(message, player);
    }

    @Override
    public void sendToServer(IMessage message) {
        this.threadedNetworkWrapper.sendToServer(message);
    }
}

