/*
 * Decompiled with CFR 0.152.
 */
package com.codetaylor.mc.athenaeum.module;

import com.codetaylor.mc.athenaeum.module.ModuleBase;
import com.codetaylor.mc.athenaeum.module.ModuleConstructor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class ModuleRegistry {
    private List<Class<? extends ModuleBase>> moduleClassList;
    private List<ModuleBase> moduleList;
    private ModuleConstructor moduleConstructor;

    ModuleRegistry(List<ModuleBase> moduleList, ModuleConstructor moduleConstructor) {
        this.moduleConstructor = moduleConstructor;
        this.moduleClassList = new ArrayList<Class<? extends ModuleBase>>();
        this.moduleList = moduleList;
    }

    @SafeVarargs
    public final void registerModules(Class<? extends ModuleBase> ... moduleClassArray) {
        this.moduleClassList.addAll(Arrays.asList(moduleClassArray));
    }

    void initializeModules(String modId) {
        for (Class<? extends ModuleBase> moduleClass : this.moduleClassList) {
            ModuleBase module = this.moduleConstructor.constructModule(modId, moduleClass);
            if (module == null) continue;
            this.moduleList.add(module);
        }
        this.moduleClassList = null;
        Collections.sort(this.moduleList);
    }
}

