/*
 * Decompiled with CFR 0.152.
 */
package com.codetaylor.mc.athenaeum.interaction.api;

public class Quaternion {
    public float x;
    public float y;
    public float z;
    public float w;

    public Quaternion() {
    }

    public Quaternion(Quaternion rotation) {
        this.x = rotation.x;
        this.y = rotation.y;
        this.z = rotation.z;
        this.w = rotation.w;
    }

    public Quaternion setFromAxisAngle(float x, float y, float z, float angle) {
        this.x = x;
        this.y = y;
        this.z = z;
        float n = (float)Math.sqrt(this.x * this.x + this.y * this.y + this.z * this.z);
        float s = (float)(Math.sin(0.5 * (double)angle) / (double)n);
        this.x *= s;
        this.y *= s;
        this.z *= s;
        this.w = (float)Math.cos(0.5 * (double)angle);
        return this;
    }

    public Quaternion multLocal(Quaternion q1) {
        return this.mult(q1, this);
    }

    public Quaternion mult(Quaternion q1, Quaternion res) {
        if (res == null) {
            res = new Quaternion();
        }
        float q0w = this.w;
        float q0x = this.x;
        float q0y = this.y;
        float q0z = this.z;
        float q1w = q1.w;
        float q1x = q1.x;
        float q1y = q1.y;
        float q1z = q1.z;
        res.x = q0x * q1w + q0y * q1z - q0z * q1y + q0w * q1x;
        res.y = -q0x * q1z + q0y * q1w + q0z * q1x + q0w * q1y;
        res.z = q0x * q1y - q0y * q1x + q0z * q1w + q0w * q1z;
        res.w = -q0x * q1x - q0y * q1y - q0z * q1z + q0w * q1w;
        return res;
    }
}

