/*
 * Decompiled with CFR 0.152.
 */
package com.codetaylor.mc.athenaeum.integration.gamestages;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class Stages {
    private final Mode mode;
    private final List<Object> list;

    private Stages(Mode mode, List<Object> list) {
        this.mode = mode;
        this.list = Collections.unmodifiableList(this.toLowercase(list));
    }

    private List<Object> toLowercase(List<Object> list) {
        ArrayList<Object> result = new ArrayList<Object>(list.size());
        for (Object o : list) {
            if (o instanceof String) {
                result.add(((String)o).toLowerCase());
                continue;
            }
            result.add(o);
        }
        return result;
    }

    public Mode getMode() {
        return this.mode;
    }

    public List<Object> getList() {
        return this.list;
    }

    public boolean allowed(Collection<String> playerStages) {
        return Stages.allowed(playerStages, this);
    }

    private static boolean allowed(Collection<String> playerStages, Stages stages) {
        if (stages.mode == Mode.AND) {
            for (Object o : stages.list) {
                if (!(o instanceof String ? !playerStages.contains(o) : o instanceof Stages && !Stages.allowed(playerStages, (Stages)o))) continue;
                return false;
            }
            return true;
        }
        if (stages.mode == Mode.OR) {
            for (Object o : stages.list) {
                if (!(o instanceof String ? playerStages.contains(o) : o instanceof Stages && Stages.allowed(playerStages, (Stages)o))) continue;
                return true;
            }
            return false;
        }
        if (stages.mode == Mode.NOT) {
            for (Object o : stages.list) {
                if (!(o instanceof String ? playerStages.contains(o) : o instanceof Stages && Stages.allowed(playerStages, (Stages)o))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static Stages and(Object[] stages) {
        return new Stages(Mode.AND, Arrays.asList(stages));
    }

    public static Stages or(Object[] stages) {
        return new Stages(Mode.OR, Arrays.asList(stages));
    }

    public static Stages not(String stage) {
        return new Stages(Mode.NOT, Collections.singletonList(stage));
    }

    public static Stages not(Stages stages) {
        return new Stages(Mode.NOT, Collections.singletonList(stages));
    }

    public static enum Mode {
        OR,
        AND,
        NOT;

    }
}

