/*
 * Decompiled with CFR 0.152.
 */
package com.codetaylor.mc.athenaeum.gui;

import java.awt.Color;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.ResourceLocation;

public class GuiHelper {
    public static void drawModalRectWithCustomSizedTexture(int x, int y, int z, float u, float v, int width, int height, float textureWidth, float textureHeight) {
        float f = 1.0f / textureWidth;
        float f1 = 1.0f / textureHeight;
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        bufferbuilder.func_181662_b((double)x, (double)(y + height), (double)z).func_187315_a((double)(u * f), (double)((v + (float)height) * f1)).func_181675_d();
        bufferbuilder.func_181662_b((double)(x + width), (double)(y + height), (double)z).func_187315_a((double)((u + (float)width) * f), (double)((v + (float)height) * f1)).func_181675_d();
        bufferbuilder.func_181662_b((double)(x + width), (double)y, (double)z).func_187315_a((double)((u + (float)width) * f), (double)(v * f1)).func_181675_d();
        bufferbuilder.func_181662_b((double)x, (double)y, (double)z).func_187315_a((double)(u * f), (double)(v * f1)).func_181675_d();
        tessellator.func_78381_a();
    }

    public static void drawStringOutlined(String translateKey, int x, int y, FontRenderer fontRenderer, int textShadowColor) {
        String displayText = I18n.func_135052_a((String)translateKey, (Object[])new Object[0]);
        fontRenderer.func_78276_b(displayText, x + 0, y + 1, textShadowColor);
        fontRenderer.func_78276_b(displayText, x + 1, y + 1, textShadowColor);
        fontRenderer.func_78276_b(displayText, x + 1, y - 1, textShadowColor);
        fontRenderer.func_78276_b(displayText, x + 1, y + 0, textShadowColor);
        fontRenderer.func_78276_b(displayText, x - 0, y - 1, textShadowColor);
        fontRenderer.func_78276_b(displayText, x - 1, y - 1, textShadowColor);
        fontRenderer.func_78276_b(displayText, x - 1, y + 1, textShadowColor);
        fontRenderer.func_78276_b(displayText, x - 1, y - 0, textShadowColor);
        fontRenderer.func_78276_b(displayText, x, y, Color.BLACK.getRGB());
    }

    public static void drawTexturedRect(Minecraft minecraft, ResourceLocation texture, int x, int y, int width, int height, int zLevel, double u0, double v0, double u1, double v1) {
        TextureManager renderEngine = minecraft.func_175598_ae().field_78724_e;
        renderEngine.func_110577_a(texture);
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        bufferbuilder.func_181662_b((double)x, (double)(y + height), (double)zLevel).func_187315_a(u0, v1).func_181675_d();
        bufferbuilder.func_181662_b((double)(x + width), (double)(y + height), (double)zLevel).func_187315_a(u1, v1).func_181675_d();
        bufferbuilder.func_181662_b((double)(x + width), (double)y, (double)zLevel).func_187315_a(u1, v0).func_181675_d();
        bufferbuilder.func_181662_b((double)x, (double)y, (double)zLevel).func_187315_a(u0, v0).func_181675_d();
        tessellator.func_78381_a();
    }

    public static void drawColoredRect(BufferBuilder renderer, int x, int y, int width, int height, int red, int green, int blue, int alpha) {
        renderer.func_181668_a(7, DefaultVertexFormats.field_181706_f);
        renderer.func_181662_b((double)(x + 0), (double)(y + 0), 0.0).func_181669_b(red, green, blue, alpha).func_181675_d();
        renderer.func_181662_b((double)(x + 0), (double)(y + height), 0.0).func_181669_b(red, green, blue, alpha).func_181675_d();
        renderer.func_181662_b((double)(x + width), (double)(y + height), 0.0).func_181669_b(red, green, blue, alpha).func_181675_d();
        renderer.func_181662_b((double)(x + width), (double)(y + 0), 0.0).func_181669_b(red, green, blue, alpha).func_181675_d();
        Tessellator.func_178181_a().func_78381_a();
    }

    public static void drawDurabilityBar(int xPosition, int yPosition, double durabilityPercentage, int color, int width) {
        GlStateManager.func_179140_f();
        GlStateManager.func_179097_i();
        GlStateManager.func_179090_x();
        GlStateManager.func_179118_c();
        GlStateManager.func_179084_k();
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        int subWidth = Math.round((float)width - (float)durabilityPercentage * (float)width);
        GuiHelper.drawColoredRect(bufferbuilder, xPosition += 2, yPosition += 13, width, 2, 0, 0, 0, 255);
        int red = color >> 16 & 0xFF;
        int green = color >> 8 & 0xFF;
        int blue = color & 0xFF;
        GuiHelper.drawColoredRect(bufferbuilder, xPosition, yPosition, subWidth, 1, red, green, blue, 255);
        GlStateManager.func_179147_l();
        GlStateManager.func_179141_d();
        GlStateManager.func_179098_w();
        GlStateManager.func_179145_e();
        GlStateManager.func_179126_j();
    }

    public static void drawVerticalScaledTexturedModalRectFromIconAnchorBottomLeft(int x, int y, float z, TextureAtlasSprite icon, int width, int height) {
        if (icon == null) {
            return;
        }
        int iconHeight = icon.func_94216_b();
        int iconWidth = icon.func_94211_a();
        double minU = icon.func_94209_e();
        double maxU = icon.func_94212_f();
        double minV = icon.func_94206_g();
        double maxV = icon.func_94210_h();
        BufferBuilder buffer = Tessellator.func_178181_a().func_178180_c();
        buffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        int sections = height / iconHeight;
        for (int i = 0; i < sections; ++i) {
            buffer.func_181662_b((double)x, (double)(y + height - i * iconHeight), (double)z).func_187315_a(minU, maxV).func_181675_d();
            buffer.func_181662_b((double)(x + width), (double)(y + height - i * iconHeight), (double)z).func_187315_a(minU + (maxU - minU) * (double)width / (double)iconWidth, maxV).func_181675_d();
            buffer.func_181662_b((double)(x + width), (double)(y + height - (i + 1) * iconHeight), (double)z).func_187315_a(minU + (maxU - minU) * (double)width / (double)iconWidth, maxV - (maxV - minV)).func_181675_d();
            buffer.func_181662_b((double)x, (double)(y + height - (i + 1) * iconHeight), (double)z).func_187315_a(minU, maxV - (maxV - minV)).func_181675_d();
        }
        int remainder = height - sections * iconHeight;
        if (remainder > 0) {
            buffer.func_181662_b((double)x, (double)(y + height - sections * iconHeight), (double)z).func_187315_a(minU, maxV).func_181675_d();
            buffer.func_181662_b((double)(x + width), (double)(y + height - sections * iconHeight), (double)z).func_187315_a(minU + (maxU - minU) * (double)width / (double)iconWidth, maxV).func_181675_d();
            buffer.func_181662_b((double)(x + width), (double)(y + height - (sections * iconHeight + remainder)), (double)z).func_187315_a(minU + (maxU - minU) * (double)width / (double)iconWidth, maxV - (maxV - minV) * (double)remainder / (double)iconHeight).func_181675_d();
            buffer.func_181662_b((double)x, (double)(y + height - (sections * iconHeight + remainder)), (double)z).func_187315_a(minU, maxV - (maxV - minV) * (double)remainder / (double)iconHeight).func_181675_d();
        }
        Tessellator.func_178181_a().func_78381_a();
    }

    public static void drawScaledTexturedModalRectFromIconAnchorBottomLeft(int x, int y, float z, TextureAtlasSprite icon, int width, int height) {
        if (icon == null) {
            return;
        }
        int iconHeight = icon.func_94216_b();
        int iconWidth = icon.func_94211_a();
        double minU = icon.func_94209_e();
        double maxU = icon.func_94212_f();
        double minV = icon.func_94206_g();
        double maxV = icon.func_94210_h();
        int verticalSections = height / iconHeight + 1;
        int horizontalSections = width / iconWidth + 1;
        BufferBuilder buffer = Tessellator.func_178181_a().func_178180_c();
        buffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        for (int i = 0; i < verticalSections; ++i) {
            for (int j = 0; j < horizontalSections; ++j) {
                int px1 = x + j * iconWidth;
                int px2 = x + Math.min((j + 1) * iconWidth, width);
                int py1 = y + height - i * iconHeight;
                int py2 = y + height - Math.min((i + 1) * iconHeight, height);
                double tu2 = minU + (maxU - minU) * (double)((j + 1) * iconWidth > width ? (float)(width - j * iconWidth) / (float)iconWidth : 1.0f);
                double tv2 = maxV - (maxV - minV) * (double)((i + 1) * iconHeight > height ? (float)(height - i * iconHeight) / (float)iconHeight : 1.0f);
                buffer.func_181662_b((double)px1, (double)py1, (double)z).func_187315_a(minU, maxV).func_181675_d();
                buffer.func_181662_b((double)px2, (double)py1, (double)z).func_187315_a(tu2, maxV).func_181675_d();
                buffer.func_181662_b((double)px2, (double)py2, (double)z).func_187315_a(tu2, tv2).func_181675_d();
                buffer.func_181662_b((double)px1, (double)py2, (double)z).func_187315_a(minU, tv2).func_181675_d();
            }
        }
        Tessellator.func_178181_a().func_78381_a();
    }

    public static int getFluidHeight(int fluidAmount, int fluidCapacity, int displayHeight) {
        float fluidHeightScalar = GuiHelper.getFluidHeightScalar(fluidAmount, fluidCapacity, displayHeight);
        int elementHeightModified = (int)(fluidHeightScalar * (float)displayHeight);
        return Math.max(0, Math.min(elementHeightModified, displayHeight));
    }

    public static float getFluidHeightScalar(int fluidAmount, int fluidCapacity, int displayHeight) {
        if (fluidAmount > 0) {
            return Math.max((float)fluidAmount / (float)fluidCapacity, 1.0f / (float)displayHeight);
        }
        return 0.0f;
    }

    public static int getFluidY(int fluidAmount, int fluidCapacity, int displayHeight, int offsetY) {
        float fluidHeightScalar = GuiHelper.getFluidHeightScalar(fluidAmount, fluidCapacity, displayHeight);
        int elementHeightModified = (int)(fluidHeightScalar * (float)displayHeight);
        return displayHeight - Math.max(0, Math.min(elementHeightModified, displayHeight)) + offsetY;
    }

    public static void drawScaledTexturedModalRectFromIcon(int x, int y, float z, TextureAtlasSprite icon, int width, int height) {
        if (icon == null) {
            return;
        }
        int iconHeight = icon.func_94216_b();
        int iconWidth = icon.func_94211_a();
        double minU = icon.func_94209_e();
        double maxU = icon.func_94212_f();
        double minV = icon.func_94206_g();
        double maxV = icon.func_94210_h();
        BufferBuilder buffer = Tessellator.func_178181_a().func_178180_c();
        buffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        buffer.func_181662_b((double)x, (double)(y + height), (double)z).func_187315_a(minU, minV + (maxV - minV) * (double)height / (double)iconHeight).func_181675_d();
        buffer.func_181662_b((double)(x + width), (double)(y + height), (double)z).func_187315_a(minU + (maxU - minU) * (double)width / (double)iconWidth, minV + (maxV - minV) * (double)height / (double)iconHeight).func_181675_d();
        buffer.func_181662_b((double)(x + width), (double)y, (double)z).func_187315_a(minU + (maxU - minU) * (double)width / (double)iconWidth, minV).func_181675_d();
        buffer.func_181662_b((double)x, (double)y, (double)z).func_187315_a(minU, minV).func_181675_d();
        Tessellator.func_178181_a().func_78381_a();
    }

    public static void drawSizedModalRect(int x1, int y1, int x2, int y2, float z, Color color) {
        int temp;
        if (x1 < x2) {
            temp = x1;
            x1 = x2;
            x2 = temp;
        }
        if (y1 < y2) {
            temp = y1;
            y1 = y2;
            y2 = temp;
        }
        GlStateManager.func_179147_l();
        GlStateManager.func_179090_x();
        GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        float a = (float)color.getAlpha() / 255.0f;
        float r = (float)color.getRed() / 255.0f;
        float g = (float)color.getGreen() / 255.0f;
        float b = (float)color.getBlue() / 255.0f;
        GlStateManager.func_179131_c((float)r, (float)g, (float)b, (float)a);
        BufferBuilder buffer = Tessellator.func_178181_a().func_178180_c();
        buffer.func_181668_a(7, DefaultVertexFormats.field_181705_e);
        buffer.func_181662_b((double)x1, (double)y2, (double)z).func_181675_d();
        buffer.func_181662_b((double)x2, (double)y2, (double)z).func_181675_d();
        buffer.func_181662_b((double)x2, (double)y1, (double)z).func_181675_d();
        buffer.func_181662_b((double)x1, (double)y1, (double)z).func_181675_d();
        Tessellator.func_178181_a().func_78381_a();
        GlStateManager.func_179098_w();
        GlStateManager.func_179084_k();
    }

    public static void drawRotatedTexturedModalSquare(int x, int y, float z, int textureX, int textureY, int size, int rotation) {
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder vertexbuffer = tessellator.func_178180_c();
        vertexbuffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        if (rotation == 1) {
            vertexbuffer.func_181662_b((double)x, (double)(y + size), (double)z).func_187315_a((double)((float)(textureX + size) * 0.00390625f), (double)((float)(textureY + size) * 0.00390625f)).func_181675_d();
            vertexbuffer.func_181662_b((double)(x + size), (double)(y + size), (double)z).func_187315_a((double)((float)(textureX + size) * 0.00390625f), (double)((float)textureY * 0.00390625f)).func_181675_d();
            vertexbuffer.func_181662_b((double)(x + size), (double)y, (double)z).func_187315_a((double)((float)textureX * 0.00390625f), (double)((float)textureY * 0.00390625f)).func_181675_d();
            vertexbuffer.func_181662_b((double)x, (double)y, (double)z).func_187315_a((double)((float)textureX * 0.00390625f), (double)((float)(textureY + size) * 0.00390625f)).func_181675_d();
        } else if (rotation == 2) {
            vertexbuffer.func_181662_b((double)x, (double)(y + size), (double)z).func_187315_a((double)((float)(textureX + size) * 0.00390625f), (double)((float)textureY * 0.00390625f)).func_181675_d();
            vertexbuffer.func_181662_b((double)(x + size), (double)(y + size), (double)z).func_187315_a((double)((float)textureX * 0.00390625f), (double)((float)textureY * 0.00390625f)).func_181675_d();
            vertexbuffer.func_181662_b((double)(x + size), (double)y, (double)z).func_187315_a((double)((float)textureX * 0.00390625f), (double)((float)(textureY + size) * 0.00390625f)).func_181675_d();
            vertexbuffer.func_181662_b((double)x, (double)y, (double)z).func_187315_a((double)((float)(textureX + size) * 0.00390625f), (double)((float)(textureY + size) * 0.00390625f)).func_181675_d();
        } else if (rotation == 3) {
            vertexbuffer.func_181662_b((double)x, (double)(y + size), (double)z).func_187315_a((double)((float)textureX * 0.00390625f), (double)((float)textureY * 0.00390625f)).func_181675_d();
            vertexbuffer.func_181662_b((double)(x + size), (double)(y + size), (double)z).func_187315_a((double)((float)textureX * 0.00390625f), (double)((float)(textureY + size) * 0.00390625f)).func_181675_d();
            vertexbuffer.func_181662_b((double)(x + size), (double)y, (double)z).func_187315_a((double)((float)(textureX + size) * 0.00390625f), (double)((float)(textureY + size) * 0.00390625f)).func_181675_d();
            vertexbuffer.func_181662_b((double)x, (double)y, (double)z).func_187315_a((double)((float)(textureX + size) * 0.00390625f), (double)((float)textureY * 0.00390625f)).func_181675_d();
        } else {
            vertexbuffer.func_181662_b((double)x, (double)(y + size), (double)z).func_187315_a((double)((float)textureX * 0.00390625f), (double)((float)(textureY + size) * 0.00390625f)).func_181675_d();
            vertexbuffer.func_181662_b((double)(x + size), (double)(y + size), (double)z).func_187315_a((double)((float)(textureX + size) * 0.00390625f), (double)((float)(textureY + size) * 0.00390625f)).func_181675_d();
            vertexbuffer.func_181662_b((double)(x + size), (double)y, (double)z).func_187315_a((double)((float)(textureX + size) * 0.00390625f), (double)((float)textureY * 0.00390625f)).func_181675_d();
            vertexbuffer.func_181662_b((double)x, (double)y, (double)z).func_187315_a((double)((float)textureX * 0.00390625f), (double)((float)textureY * 0.00390625f)).func_181675_d();
        }
        tessellator.func_78381_a();
    }

    private GuiHelper() {
    }
}

