/*
 * Decompiled with CFR 0.152.
 */
package com.leobeliik.extremesoundmuffler.utils;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonSyntaxException;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.leobeliik.extremesoundmuffler.ESMConfig;
import com.leobeliik.extremesoundmuffler.SoundMuffler;
import com.leobeliik.extremesoundmuffler.interfaces.ISoundLists;
import com.leobeliik.extremesoundmuffler.utils.Anchor;
import it.unimi.dsi.fastutil.objects.Object2FloatAVLTreeMap;
import it.unimi.dsi.fastutil.objects.Object2FloatMap;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.storage.ThreadedFileIOBase;
import net.minecraftforge.fml.common.FMLCommonHandler;
import org.apache.commons.io.FileUtils;

public class DataManager
implements ISoundLists {
    public static String identifier;
    private static final Gson gson;

    public static void loadData(String address) {
        identifier = DataManager.getIdentifier(address);
        DataManager.loadMuffledMap().forEach((R, F) -> muffledSounds.put((Object)new ResourceLocation(R), F));
        if (!ESMConfig.getDisableAnchors()) {
            anchorList.clear();
            anchorList.addAll(DataManager.loadAnchors());
        }
    }

    public static void saveData() {
        DataManager.saveMuffledMap();
        if (!ESMConfig.getDisableAnchors()) {
            DataManager.saveAnchors();
        }
    }

    private static String getIdentifier(String address) {
        if (Minecraft.func_71410_x().func_71356_B()) {
            return FMLCommonHandler.instance().getMinecraftServerInstance().func_71270_I();
        }
        int index = address.indexOf("/") + 1;
        return address.substring(index).replace(":", ".");
    }

    private static NBTTagCompound serializeAnchor(Anchor anchor) {
        NBTTagCompound anchorNBT = new NBTTagCompound();
        NBTTagCompound muffledNBT = new NBTTagCompound();
        anchorNBT.func_74768_a("ID", anchor.getAnchorId());
        anchorNBT.func_74778_a("NAME", anchor.getName());
        if (anchor.getAnchorPos() == null) {
            return anchorNBT;
        }
        anchorNBT.func_74782_a("POS", (NBTBase)NBTUtil.func_186859_a((BlockPos)anchor.getAnchorPos()));
        anchorNBT.func_74778_a("DIM", anchor.getDimension());
        anchorNBT.func_74768_a("RAD", anchor.getRadius());
        anchor.getMuffledSounds().forEach((R, F) -> muffledNBT.func_74776_a(R.toString(), F.floatValue()));
        anchorNBT.func_74782_a("MUFFLED", (NBTBase)muffledNBT);
        return anchorNBT;
    }

    public static Anchor deserializeAnchor(NBTTagCompound nbt) {
        if (!nbt.func_74764_b("POS")) {
            return new Anchor(nbt.func_74762_e("ID"), nbt.func_74779_i("NAME"));
        }
        Object2FloatAVLTreeMap muffledSounds = new Object2FloatAVLTreeMap();
        NBTTagCompound muffledNBT = nbt.func_74775_l("MUFFLED");
        for (String key : muffledNBT.func_150296_c()) {
            muffledSounds.put((Object)key, muffledNBT.func_74760_g(key));
        }
        return new Anchor(nbt.func_74762_e("ID"), nbt.func_74779_i("NAME"), NBTUtil.func_186861_c((NBTTagCompound)nbt.func_74775_l("POS")), nbt.func_74779_i("DIM"), nbt.func_74762_e("RAD"), (Object2FloatMap<String>)muffledSounds);
    }

    private static void saveMuffledMap() {
        new File("ESM/").mkdir();
        try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream("ESM/soundsMuffled.dat"), StandardCharsets.UTF_8);){
            writer.write(gson.toJson((Object)muffledSounds));
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static Map<String, Float> loadMuffledMap() {
        Map map;
        InputStreamReader reader = new InputStreamReader((InputStream)new FileInputStream("ESM/soundsMuffled.dat"), StandardCharsets.UTF_8);
        try {
            map = (Map)gson.fromJson(new JsonReader((Reader)reader), new TypeToken<Map<String, Float>>(){}.getType());
        }
        catch (Throwable throwable) {
            try {
                try {
                    reader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (JsonSyntaxException | IOException e) {
                return new HashMap<String, Float>();
            }
        }
        reader.close();
        return map;
    }

    private static void saveAnchors() {
        File file = new File("ESM/" + identifier, "anchor.dat");
        NBTTagCompound anchorsNBT = new NBTTagCompound();
        for (Anchor anchor : anchorList) {
            anchorsNBT.func_74782_a("Anchor" + anchor.getAnchorId(), (NBTBase)DataManager.serializeAnchor(anchor));
        }
        DataManager.writeNBT(file, anchorsNBT);
    }

    private static List<Anchor> loadAnchors() {
        File file = new File("ESM/" + identifier, "anchor.dat");
        NBTTagCompound anchorsNBT = DataManager.readNBT(file);
        if (anchorsNBT == null) {
            return IntStream.range(0, 10).mapToObj(i -> new Anchor(i, "Anchor " + i)).collect(Collectors.toList());
        }
        ArrayList<Anchor> temp = new ArrayList<Anchor>();
        for (int i2 = 0; i2 < anchorsNBT.func_150296_c().size(); ++i2) {
            temp.add(DataManager.deserializeAnchor(anchorsNBT.func_74775_l("Anchor" + i2)));
        }
        return temp;
    }

    public static void writeNBT(File file, NBTTagCompound tag) {
        ThreadedFileIOBase.func_178779_a().func_75735_a(() -> {
            try (FileOutputStream stream = FileUtils.openOutputStream((File)file);){
                CompressedStreamTools.func_74799_a((NBTTagCompound)tag, (OutputStream)stream);
            }
            catch (Exception ex) {
                SoundMuffler.LOGGER.warn("Failed to save file: {}", (Object)file.getName(), (Object)ex);
            }
            return false;
        });
    }

    @Nullable
    public static NBTTagCompound readNBT(File file) {
        NBTTagCompound nBTTagCompound;
        block11: {
            if (!file.exists() || !file.isFile()) {
                return null;
            }
            FileInputStream stream = FileUtils.openInputStream((File)file);
            try {
                nBTTagCompound = CompressedStreamTools.func_74796_a((InputStream)stream);
                if (stream == null) break block11;
            }
            catch (Throwable throwable) {
                try {
                    if (stream != null) {
                        try {
                            ((InputStream)stream).close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception ex) {
                    try {
                        return CompressedStreamTools.func_74797_a((File)file);
                    }
                    catch (Exception ex1) {
                        return null;
                    }
                }
            }
            ((InputStream)stream).close();
        }
        return nBTTagCompound;
    }

    static {
        gson = new GsonBuilder().setPrettyPrinting().create();
    }
}

