/*
 * Decompiled with CFR 0.152.
 */
package com.leobeliik.extremesoundmuffler.utils;

import com.leobeliik.extremesoundmuffler.interfaces.ISoundLists;
import it.unimi.dsi.fastutil.objects.Object2FloatAVLTreeMap;
import it.unimi.dsi.fastutil.objects.Object2FloatMap;
import java.util.Objects;
import java.util.SortedMap;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraftforge.common.DimensionManager;

public class Anchor {
    private final int id;
    private String name;
    private String dimension;
    private int radius;
    private Object2FloatMap<String> muffledSounds = new Object2FloatAVLTreeMap();
    private BlockPos anchorPos;

    public Anchor(int id, String name) {
        this.id = id;
        this.name = name;
    }

    public Anchor(int id, String name, BlockPos anchorPos, String dimension, int radius, Object2FloatMap<String> muffledSounds) {
        this.id = id;
        this.name = name;
        this.anchorPos = anchorPos;
        this.dimension = dimension;
        this.radius = radius;
        this.muffledSounds = muffledSounds;
    }

    public BlockPos getAnchorPos() {
        return this.anchorPos;
    }

    private void setAnchorPos(BlockPos pos) {
        this.anchorPos = pos;
    }

    public int getAnchorId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public int getRadius() {
        return this.radius;
    }

    public void setRadius(int Radius) {
        this.radius = Radius;
    }

    private void setName(String name) {
        this.name = name;
    }

    public Object2FloatMap<ResourceLocation> getMuffledSounds() {
        Object2FloatAVLTreeMap temp = new Object2FloatAVLTreeMap();
        this.muffledSounds.forEach((arg_0, arg_1) -> Anchor.lambda$getMuffledSounds$0((Object2FloatMap)temp, arg_0, arg_1));
        return temp;
    }

    public void setMuffledSounds(SortedMap<ResourceLocation, Float> muffledSounds) {
        muffledSounds.forEach((R, F) -> this.muffledSounds.put((Object)R.toString(), F));
    }

    public void addSound(ResourceLocation sound, float volume) {
        this.muffledSounds.put((Object)sound.toString(), volume);
    }

    public void replaceSound(ResourceLocation sound, float volume) {
        this.muffledSounds.replace((Object)sound.toString(), (Object)Float.valueOf(volume));
    }

    public int getX() {
        return this.anchorPos == null ? 0 : this.anchorPos.func_177958_n();
    }

    public int getY() {
        return this.anchorPos == null ? 0 : this.anchorPos.func_177956_o();
    }

    public int getZ() {
        return this.anchorPos == null ? 0 : this.anchorPos.func_177952_p();
    }

    public String getDimension() {
        return this.dimension;
    }

    private void setDimension(String dimension) {
        this.dimension = dimension;
    }

    public void removeSound(ResourceLocation sound) {
        this.muffledSounds.remove((Object)sound.toString());
    }

    public void setAnchor() {
        EntityPlayerSP player = Objects.requireNonNull(Minecraft.func_71410_x().field_71439_g);
        this.setAnchorPos(player.func_180425_c());
        this.setDimension(DimensionManager.getProvider((int)player.field_71093_bK).func_186058_p().func_186065_b());
        this.setRadius(this.getRadius() == 0 ? 32 : this.getRadius());
    }

    public void deleteAnchor() {
        this.setName("Anchor: " + this.getAnchorId());
        this.anchorPos = null;
        this.setDimension(null);
        this.setRadius(0);
        this.muffledSounds.clear();
    }

    public void editAnchor(String title, int Radius) {
        this.setName(title);
        this.setRadius(Radius);
    }

    public static Anchor getAnchor(ISound sound) {
        BlockPos soundPos = new BlockPos((double)sound.func_147649_g(), (double)sound.func_147654_h(), (double)sound.func_147651_i());
        for (Anchor anchor : ISoundLists.anchorList) {
            WorldClient world = Minecraft.func_71410_x().field_71441_e;
            if (anchor.getAnchorPos() == null || world == null || !world.field_73011_w.func_186058_p().func_186065_b().equals(anchor.getDimension()) || !(Math.sqrt(soundPos.func_177951_i((Vec3i)anchor.getAnchorPos())) <= (double)anchor.getRadius()) || !anchor.getMuffledSounds().containsKey((Object)sound.func_147650_b())) continue;
            return anchor;
        }
        return null;
    }

    private static /* synthetic */ void lambda$getMuffledSounds$0(Object2FloatMap temp, String R, Float F) {
        temp.put((Object)new ResourceLocation(R), (Object)F);
    }
}

