/*
 * Decompiled with CFR 0.152.
 */
package com.leobeliik.extremesoundmuffler.mixins.minecraft;

import com.leobeliik.extremesoundmuffler.ESMConfig;
import com.leobeliik.extremesoundmuffler.gui.MainScreen;
import com.leobeliik.extremesoundmuffler.interfaces.ISoundLists;
import com.leobeliik.extremesoundmuffler.utils.Anchor;
import com.leobeliik.extremesoundmuffler.utils.PlayButtonSound;
import com.leobeliik.extremesoundmuffler.utils.SliderSound;
import com.llamalad7.mixinextras.injector.ModifyReturnValue;
import com.llamalad7.mixinextras.sugar.Local;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.SoundManager;
import net.minecraft.util.ResourceLocation;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;

@Mixin(value={SoundManager.class})
public abstract class SoundMixin
implements ISoundLists {
    @Unique
    private static boolean extremeSoundMuffler$isForbidden(ISound sound) {
        return forbiddenSounds.stream().anyMatch(fs -> sound.func_147650_b().toString().contains((CharSequence)fs));
    }

    @ModifyReturnValue(method={"getClampedVolume"}, at={@At(value="RETURN")})
    private float checkSound(float original, @Local(ordinal=0, argsOnly=true) ISound sound) {
        if (SoundMixin.extremeSoundMuffler$isForbidden(sound) || sound instanceof PlayButtonSound || sound instanceof SliderSound) {
            return original;
        }
        ResourceLocation soundLocation = sound.func_147650_b();
        recentSoundsList.add((Object)soundLocation);
        if (MainScreen.isMuffled()) {
            if (muffledSounds.containsKey((Object)soundLocation)) {
                return original * ((Float)muffledSounds.get((Object)soundLocation)).floatValue();
            }
            if (ESMConfig.getDisableAnchors()) {
                return original;
            }
            Anchor anchor = Anchor.getAnchor(sound);
            if (anchor != null) {
                return original * ((Float)anchor.getMuffledSounds().get((Object)soundLocation)).floatValue();
            }
        }
        return original;
    }
}

