/*
 * Decompiled with CFR 0.152.
 */
package com.leobeliik.extremesoundmuffler.gui;

import com.leobeliik.extremesoundmuffler.ESMConfig;
import com.leobeliik.extremesoundmuffler.SoundMuffler;
import com.leobeliik.extremesoundmuffler.gui.buttons.ESMButton;
import com.leobeliik.extremesoundmuffler.gui.buttons.MuffledSlider;
import com.leobeliik.extremesoundmuffler.interfaces.IColorsGui;
import com.leobeliik.extremesoundmuffler.interfaces.ISoundLists;
import com.leobeliik.extremesoundmuffler.utils.Anchor;
import com.leobeliik.extremesoundmuffler.utils.DataManager;
import com.leobeliik.extremesoundmuffler.utils.Icon;
import com.leobeliik.extremesoundmuffler.utils.Tips;
import it.unimi.dsi.fastutil.objects.Object2FloatMap;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.util.ResourceLocation;
import org.apache.commons.lang3.StringUtils;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;

public class MainScreen
extends GuiScreen
implements ISoundLists,
IColorsGui {
    private static final Minecraft minecraft = Minecraft.func_71410_x();
    private static final Pattern NUMBER_PATTERN = Pattern.compile("[0-9]*(?:[0-9]*)?");
    private static final String mainTitle = "ESM - Main Screen";
    private final List<GuiButton> filteredButtons = new ArrayList<GuiButton>();
    private static boolean isMuffling = true;
    private static String searchBarText = "";
    private static String screenTitle = "";
    private final int xSize = 256;
    private final int ySize = 202;
    private final boolean isAnchorsDisabled = ESMConfig.getDisableAnchors();
    private final String tip = Tips.randomTip();
    private int minYButton;
    private int maxYButton;
    private int index;
    private ESMButton btnToggleMuffled;
    private ESMButton btnToggleSoundsList;
    private ESMButton btnSetAnchor;
    private ESMButton btnEditAnchor;
    private ESMButton btnAccept;
    private ESMButton btnCancel;
    private ESMButton btnDelete;
    private GuiTextField searchBar;
    private GuiTextField editAnchorTitleBar;
    private GuiTextField editAnchorRadiusBar;
    private Anchor anchor;
    private final List<GuiTextField> textFields = new ArrayList<GuiTextField>();
    private static ListMode listMode;

    private static void open(String title, ListMode mode, String searchMessage) {
        screenTitle = title;
        listMode = mode;
        searchBarText = searchMessage;
        minecraft.func_147108_a((GuiScreen)new MainScreen());
    }

    public static void open() {
        MainScreen.open(mainTitle, ListMode.RECENT, "");
    }

    public static boolean isMuffled() {
        return isMuffling;
    }

    public static boolean isMain() {
        return screenTitle.equals(mainTitle);
    }

    @Nullable
    public static Anchor getAnchorByName(String name) {
        return anchorList.stream().filter(a -> a.getName().equals(name)).findFirst().orElse(null);
    }

    @Nullable
    public static Anchor getCurrentAnchor() {
        return MainScreen.getAnchorByName(screenTitle);
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        SoundMuffler.renderGui();
        this.func_73729_b(this.getX(), this.getY(), 0, 0, 256, 202);
        this.func_73732_a(this.field_146289_q, screenTitle, this.getX() + 128, this.getY() + 8, 0xFFFFFF);
        this.renderButtonsTextures(mouseX, mouseY);
        super.func_73863_a(mouseX, mouseY, partialTicks);
        this.renderTip();
    }

    public boolean func_73868_f() {
        return false;
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        Keyboard.enableRepeatEvents((boolean)true);
        MuffledSlider.showSlider = true;
        this.textFields.clear();
        this.index = 0;
        this.minYButton = this.getY() + 46;
        this.maxYButton = this.getY() + 164;
        this.addSoundButtons();
        this.addAnchorButtons();
        String display = StringUtils.capitalize((String)listMode.toString().toLowerCase());
        this.btnToggleSoundsList = new ESMButton(0, this.getX() + 13, this.getY() + 181, 52, 13, display, this::toggleSoundList).setRenderText(true).setTooltip("Showing " + display + " Sounds", false);
        this.func_189646_b((GuiButton)this.btnToggleSoundsList);
        this.btnToggleMuffled = new ESMButton(0, this.getX() + 229, this.getY() + 179, 17, 17, () -> {
            isMuffling = !isMuffling;
        }).setTooltip(isMuffling ? "Stop Muffling" : "Start Muffling", false);
        this.func_189646_b((GuiButton)this.btnToggleMuffled);
        this.btnDelete = new ESMButton(1, this.getX() + 205, this.getY() + 179, 17, 17, () -> {
            this.anchor = MainScreen.getAnchorByName(screenTitle);
            if (this.clearRecentSounds()) {
                recentSoundsList.clear();
                if (MainScreen.isMain()) {
                    MainScreen.open(mainTitle, listMode, this.searchBar.func_146179_b());
                } else if (this.anchor != null) {
                    MainScreen.open(this.anchor.getName(), listMode, this.searchBar.func_146179_b());
                }
                return;
            }
            if (MainScreen.isMain()) {
                muffledSounds.clear();
                MainScreen.open(mainTitle, listMode, this.searchBar.func_146179_b());
            } else if (this.anchor != null) {
                this.anchor.deleteAnchor();
                this.field_146292_n.clear();
                MainScreen.open(this.anchor.getName(), listMode, this.searchBar.func_146179_b());
            }
        }).setTooltip(this::getDeleteTooltip, false);
        this.func_189646_b((GuiButton)this.btnDelete);
        this.btnSetAnchor = new ESMButton(2, this.getX() + 260, this.getY() + 62, 11, 11, () -> Objects.requireNonNull(MainScreen.getAnchorByName(screenTitle)).setAnchor()).setVisible(!MainScreen.isMain()).setTooltip(() -> this.btnSetAnchor.mouseOver && !this.editAnchorTitleBar.func_146176_q() ? "Set Anchor" : "", true);
        this.func_189646_b((GuiButton)this.btnSetAnchor);
        this.btnEditAnchor = new ESMButton(3, this.getX() + 274, this.getY() + 62, 11, 11, () -> this.editTitle(Objects.requireNonNull(MainScreen.getAnchorByName(screenTitle)))).setVisible(() -> !MainScreen.isMain() && this.anchor != null && this.anchor.getAnchorPos() != null).setIcon(Icon.EDIT_ANCHOR).setTooltip(() -> this.btnEditAnchor.mouseOver && !this.editAnchorTitleBar.func_146176_q() ? "Edit Anchor" : "", true);
        this.func_189646_b((GuiButton)this.btnEditAnchor);
        this.addEditAnchorButtons();
        this.searchBar = new GuiTextField(0, this.field_146289_q, this.getX() + 74, this.getY() + 183, 119, 13);
        this.textFields.add(this.searchBar);
        this.searchBar.func_146180_a(searchBarText);
        this.searchBar.func_146185_a(false);
        this.func_189646_b((GuiButton)new ESMButton(0, this.getX() + 10, this.getY() + 22, 13, 20, () -> this.listScroll(!this.searchBar.func_146179_b().isEmpty() ? this.filteredButtons : this.field_146292_n, -1.0)).setTooltip("Previous Sounds", true));
        this.func_189646_b((GuiButton)new ESMButton(0, this.getX() + 233, this.getY() + 22, 13, 20, () -> this.listScroll(!this.searchBar.func_146179_b().isEmpty() ? this.filteredButtons : this.field_146292_n, 1.0)).setTooltip("Next Sounds", true));
        this.updateText();
    }

    private void addSoundButtons() {
        int buttonH = this.minYButton;
        this.anchor = MainScreen.getAnchorByName(screenTitle);
        if (!MainScreen.isMain() && this.anchor == null) {
            return;
        }
        soundsList.clear();
        switch (listMode) {
            case RECENT: {
                if (!ESMConfig.GENERAL.hideMuffledFromRecent) {
                    soundsList.addAll((Collection)this.getMuffledSounds().keySet());
                }
                soundsList.addAll((Collection)recentSoundsList);
                break;
            }
            case ALL: {
                soundsList.addAll((Collection)Minecraft.func_71410_x().func_147118_V().field_147697_e.func_148742_b());
                if (!ESMConfig.getLawfulAllList()) break;
                forbiddenSounds.forEach(fs -> soundsList.removeIf(sl -> sl.toString().contains((CharSequence)fs)));
                break;
            }
            case MUFFLED: {
                soundsList.addAll((Collection)this.getMuffledSounds().keySet());
            }
        }
        if (soundsList.isEmpty()) {
            return;
        }
        int id = 0;
        for (ResourceLocation sound : soundsList) {
            float maxVolume = 1.0f;
            float volume = this.getMuffledSounds().get((Object)sound) == null ? maxVolume : ((Float)this.getMuffledSounds().get((Object)sound)).floatValue();
            MuffledSlider volumeSlider = this.getMuffledSlider(sound, id++, buttonH, volume);
            buttonH += volumeSlider.field_146121_g + 2;
            this.func_189646_b((GuiButton)volumeSlider);
            volumeSlider.setVisible(this.field_146292_n.indexOf(volumeSlider) < this.index + 10);
        }
    }

    private MuffledSlider getMuffledSlider(ResourceLocation sound, int id, int buttonH, float volume) {
        int x = ESMConfig.getLeftButtons() ? this.getX() + 36 : this.getX() + 11;
        boolean muffled = this.getMuffledSounds().containsKey((Object)sound);
        return new MuffledSlider(id, x, buttonH, 205, 11, volume, sound, this.anchor).setMuffled(muffled);
    }

    private void addAnchorButtons() {
        int buttonW = this.getX() + 30;
        for (int i = 0; i <= 9; ++i) {
            ESMButton btnAnchor;
            if (this.isAnchorsDisabled) {
                String[] disabledMsg = new String[]{"-", "D", "i", "s", "a", "b", "l", "e", "d", "-"};
                btnAnchor = new ESMButton(0, buttonW, this.getY() + 24, 16, 16, disabledMsg[i]).setRenderText(true).setEnabled(false);
            } else {
                int finalI = i;
                btnAnchor = new ESMButton(0, buttonW, this.getY() + 24, 16, 16, String.valueOf(finalI), () -> {
                    this.anchor = (Anchor)anchorList.get(finalI);
                    if (this.anchor == null) {
                        return;
                    }
                    screenTitle = screenTitle.equals(this.anchor.getName()) ? mainTitle : this.anchor.getName();
                    this.field_146292_n.clear();
                    MainScreen.open(screenTitle, listMode, this.searchBar.func_146179_b());
                }).setRenderText(true);
                if (!anchorList.isEmpty()) {
                    btnAnchor.setTextColor(((Anchor)anchorList.get(i)).getAnchorPos() != null ? 65280 : 0xFFFFFF).setIcon(this.isActiveAnchor(btnAnchor) ? Icon.ANCHOR : null, -5, -2, 27, 22);
                }
            }
            this.func_189646_b((GuiButton)btnAnchor.setTooltip(this.isAnchorsDisabled ? "Anchors are disabled" : ((Anchor)anchorList.get(i)).getName(), true));
            buttonW += 20;
        }
    }

    private void addEditAnchorButtons() {
        this.editAnchorTitleBar = new GuiTextField(0, this.field_146289_q, this.getX() + 302, this.btnEditAnchor.field_146129_i + 20, 84, 11);
        this.textFields.add(this.editAnchorTitleBar);
        this.editAnchorTitleBar.func_146189_e(false);
        this.editAnchorRadiusBar = new GuiTextField(0, this.field_146289_q, this.getX() + 302, this.editAnchorTitleBar.field_146210_g + 15, 30, 11);
        this.textFields.add(this.editAnchorRadiusBar);
        this.editAnchorRadiusBar.func_175205_a(s -> NUMBER_PATTERN.matcher((CharSequence)s).matches());
        this.editAnchorRadiusBar.func_146189_e(false);
        this.btnAccept = new ESMButton(100, this.getX() + 259, this.editAnchorRadiusBar.field_146210_g + 15, 40, 20, "Accept", () -> {
            this.anchor = MainScreen.getAnchorByName(screenTitle);
            if (!this.editAnchorTitleBar.func_146179_b().isEmpty() && !this.editAnchorRadiusBar.func_146179_b().isEmpty() && this.anchor != null) {
                int radius = Integer.parseInt(this.editAnchorRadiusBar.func_146179_b());
                if (radius > 32) {
                    radius = 32;
                } else if (radius < 1) {
                    radius = 1;
                }
                this.anchor.editAnchor(this.editAnchorTitleBar.func_146179_b(), radius);
                screenTitle = this.editAnchorTitleBar.func_146179_b();
                this.editTitle(this.anchor);
            }
        }).renderNormalButton(true).setVisible(false);
        this.func_189646_b((GuiButton)this.btnAccept);
        this.btnCancel = new ESMButton(101, this.getX() + 300, this.editAnchorRadiusBar.field_146210_g + 15, 40, 20, "Cancel", () -> this.editTitle(Objects.requireNonNull(MainScreen.getAnchorByName(screenTitle)))).renderNormalButton(true).setVisible(false);
        this.func_189646_b((GuiButton)this.btnCancel);
    }

    private void renderButtonsTextures(int mouseX, int mouseY) {
        int stringW;
        if (this.field_146292_n.size() < soundsList.size()) {
            return;
        }
        this.btnDelete.setIcon(this.clearRecentSounds() ? Icon.RESET : null, 2, 2, 13, 13);
        this.btnToggleMuffled.setIcon(isMuffling ? Icon.MUFFLE : null, 1, 1, 15, 15);
        String dimensionName = "";
        int x = this.btnSetAnchor.field_146128_h;
        int y = this.btnSetAnchor.field_146129_i;
        if (this.anchor != null) {
            stringW = this.field_146289_q.func_78256_a("Dimension: ");
            int radius = this.anchor.getRadius();
            if (this.anchor.getDimension() != null) {
                stringW += this.field_146289_q.func_78256_a(this.anchor.getDimension());
                dimensionName = StringUtils.capitalize((String)this.anchor.getDimension());
            }
            MainScreen.func_73734_a((int)(x - 5), (int)(y - 56), (int)(x + stringW + 6), (int)(y + 16), (int)-1157627904);
            this.func_73731_b(this.field_146289_q, "X: " + this.anchor.getX(), x + 1, y - 50, 0xFFFFFF);
            this.func_73731_b(this.field_146289_q, "Y: " + this.anchor.getY(), x + 1, y - 40, 0xFFFFFF);
            this.func_73731_b(this.field_146289_q, "Z: " + this.anchor.getZ(), x + 1, y - 30, 0xFFFFFF);
            this.func_73731_b(this.field_146289_q, "Radius: " + radius, x + 1, y - 20, 0xFFFFFF);
            this.func_73731_b(this.field_146289_q, "Dimension: " + dimensionName, x + 1, y - 10, 0xFFFFFF);
            SoundMuffler.renderGui();
            MainScreen.func_146110_a((int)x, (int)y, (float)0.0f, (float)69.45f, (int)11, (int)11, (float)88.0f, (float)88.0f);
            for (GuiButton btn : this.field_146292_n) {
                MuffledSlider slider;
                if (!(btn instanceof MuffledSlider) || !(slider = (MuffledSlider)btn).getBtnToggleSound().isMouseOver(mouseX, mouseY) || this.anchor.getAnchorPos() != null) continue;
                MainScreen.func_73734_a((int)(x - 5), (int)(y + 16), (int)(x + 65), (int)(y + 40), (int)-1157627904);
                this.field_146289_q.func_78276_b("Set the", x, y + 18, 0xFFFFFF);
                this.field_146289_q.func_78276_b("Anchor first", x, y + 29, 0xFFFFFF);
            }
        }
        x = this.btnSetAnchor.field_146128_h;
        y = this.editAnchorTitleBar.field_146210_g;
        if (this.editAnchorRadiusBar.func_146176_q()) {
            MainScreen.func_73734_a((int)(x - 4), (int)(y - 4), (int)(this.editAnchorTitleBar.field_146209_f + this.editAnchorTitleBar.func_146200_o() + 10), (int)(this.btnAccept.field_146129_i + 23), (int)-1157627904);
            this.field_146289_q.func_78276_b("Title: ", x - 2, y + 1, 0xFFFFFF);
            this.field_146289_q.func_78276_b("Radius: ", x - 2, this.editAnchorRadiusBar.field_146210_g + 1, 0xFFFFFF);
            x = this.editAnchorRadiusBar.field_146209_f + this.editAnchorRadiusBar.func_146200_o();
            y = this.editAnchorRadiusBar.field_146210_g;
            String message = "Range: 1 - 32";
            stringW = this.field_146289_q.func_78256_a(message);
            if (this.editAnchorRadiusBar.func_146206_l()) {
                MainScreen.func_73734_a((int)(x + 3), (int)y, (int)(x + stringW + 9), (int)(y + 12), (int)-1157627904);
                this.field_146289_q.func_78276_b(message, x + 10, y + 2, 0xFFFFFF);
            }
        }
        x = this.searchBar.field_146209_f;
        y = this.searchBar.field_146210_g;
        String searchHint = "Search";
        if (!this.searchBar.func_146206_l() && this.searchBar.func_146179_b().isEmpty()) {
            this.func_73731_b(this.field_146289_q, searchHint, x + 1, y + 1, -1);
        }
        for (GuiTextField textField : this.textFields) {
            if (!textField.func_146176_q()) continue;
            textField.func_146194_f();
        }
    }

    private boolean clearRecentSounds() {
        return listMode.equals((Object)ListMode.RECENT) && MainScreen.func_146272_n();
    }

    private void renderTip() {
        if (!ESMConfig.getShowTip()) {
            return;
        }
        List tips = this.field_146289_q.func_78271_c(this.tip, 256);
        this.drawHoveringText(tips, this.getX() - 5, this.getY() + 223, this.field_146289_q);
    }

    private void editTitle(Anchor anchor) {
        this.editAnchorTitleBar.func_146180_a(anchor.getName());
        this.editAnchorTitleBar.func_146189_e(!this.editAnchorTitleBar.func_146176_q());
        this.editAnchorRadiusBar.func_146180_a(String.valueOf(anchor.getRadius()));
        this.editAnchorRadiusBar.func_146189_e(!this.editAnchorRadiusBar.func_146176_q());
        this.btnAccept.setVisible(!this.btnAccept.field_146125_m);
        this.btnCancel.setVisible(!this.btnCancel.field_146125_m);
        this.editAnchorRadiusBar.func_146193_g(0xFFFFFF);
    }

    public void func_146274_d() throws IOException {
        int scroll = Mouse.getEventDWheel();
        if (scroll != 0) {
            if (this.searchBar.func_146179_b().isEmpty()) {
                this.listScroll(this.field_146292_n, scroll * -1);
            } else {
                this.listScroll(this.filteredButtons, scroll * -1);
            }
        }
        super.func_146274_d();
    }

    protected void func_146273_a(int mouseX, int mouseY, int clickedMouseButton, long timeSinceLastClick) {
        super.func_146273_a(mouseX, mouseY, clickedMouseButton, timeSinceLastClick);
    }

    private void listScroll(List<GuiButton> buttonList, double direction) {
        int buttonH = this.minYButton;
        if (this.index <= 0 && direction < 0.0) {
            return;
        }
        if ((this.index >= buttonList.size() - 10 || this.index >= soundsList.size() - 10) && direction > 0.0) {
            return;
        }
        this.index += direction > 0.0 ? 10 : -10;
        for (GuiButton btn : buttonList) {
            if (!(btn instanceof MuffledSlider)) continue;
            MuffledSlider slider = (MuffledSlider)btn;
            int buttonIndex = buttonList.indexOf(btn);
            slider.setVisible(buttonIndex < this.index + 10 && buttonIndex >= this.index);
            if (slider.isVisible()) {
                slider.field_146129_i = buttonH;
                buttonH += slider.field_146121_g + 2;
            }
            slider.refreshButtons();
        }
    }

    private void updateText() {
        if (!this.searchBar.func_146206_l()) {
            return;
        }
        int buttonH = this.minYButton;
        this.filteredButtons.clear();
        for (GuiButton button : this.field_146292_n) {
            if (!(button instanceof MuffledSlider)) continue;
            MuffledSlider btn = (MuffledSlider)button;
            if (btn.field_146126_j.contains(this.searchBar.func_146179_b().toLowerCase())) {
                if (!this.filteredButtons.contains(btn)) {
                    this.filteredButtons.add((GuiButton)btn);
                }
                btn.field_146129_i = buttonH;
                buttonH += btn.field_146121_g + 2;
                btn.setVisible(btn.field_146129_i < this.maxYButton);
            } else {
                btn.setVisible(false);
            }
            btn.refreshButtons();
        }
    }

    protected void func_73869_a(char typedChar, int keyCode) throws IOException {
        if (keyCode == 28) {
            this.searchBar.func_146195_b(false);
            this.editAnchorTitleBar.func_146195_b(false);
            this.editAnchorRadiusBar.func_146195_b(false);
            return;
        }
        for (GuiTextField textField : this.textFields) {
            if (!textField.func_146176_q() || !textField.func_146201_a(typedChar, keyCode)) continue;
            this.updateText();
            return;
        }
        if (!(this.searchBar.func_146206_l() || this.editAnchorTitleBar.func_146206_l() || this.editAnchorRadiusBar.func_146206_l() || MainScreen.minecraft.field_71474_y.field_151445_Q.func_151463_i() != keyCode && keyCode != SoundMuffler.getHotkey())) {
            this.func_146281_b();
            this.field_146297_k.func_71381_h();
            this.filteredButtons.clear();
            return;
        }
        super.func_73869_a(typedChar, keyCode);
    }

    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        for (GuiTextField textField : this.textFields) {
            if (textField.func_146176_q()) {
                textField.func_146192_a(mouseX, mouseY, mouseButton);
            }
            if (mouseButton != 1 || !textField.func_146206_l()) continue;
            textField.func_146180_a("");
            this.updateText();
            break;
        }
        if (mouseButton == 1) {
            MuffledSlider.showSlider = !MuffledSlider.showSlider;
            MuffledSlider.stopTickSound();
        }
        super.func_73864_a(mouseX, mouseY, mouseButton);
    }

    public void func_73876_c() {
        for (GuiTextField textField : this.textFields) {
            textField.func_146178_a();
        }
    }

    public void func_146281_b() {
        DataManager.saveData();
        MuffledSlider.stopTickSound();
        super.func_146281_b();
    }

    private int getX() {
        return (this.field_146294_l - 256) / 2;
    }

    private int getY() {
        return (this.field_146295_m - 202) / 2;
    }

    private void toggleSoundList() {
        if ((listMode = listMode.next()).equals((Object)ListMode.MUFFLED) && this.getMuffledSounds().isEmpty()) {
            listMode = listMode.next();
        }
        this.btnToggleSoundsList.field_146126_j = StringUtils.capitalize((String)listMode.toString().toLowerCase());
        this.field_146292_n.clear();
        MainScreen.open(screenTitle, listMode, this.searchBar.func_146179_b());
    }

    private Object2FloatMap<ResourceLocation> getMuffledSounds() {
        return MainScreen.isMain() ? muffledSounds : this.anchor.getMuffledSounds();
    }

    private boolean isActiveAnchor(ESMButton anchorButton) {
        return this.anchor != null && anchorButton.field_146126_j.equals(String.valueOf(this.anchor.getAnchorId()));
    }

    private String getDeleteTooltip() {
        if (!this.clearRecentSounds()) {
            return MainScreen.isMain() ? "Delete Muffled List" : "Delete Anchor";
        }
        return "Clear recent sounds list";
    }

    static enum ListMode {
        RECENT,
        ALL,
        MUFFLED;

        private static final ListMode[] vals;

        public ListMode next() {
            return vals[(this.ordinal() + 1) % vals.length];
        }

        static {
            vals = ListMode.values();
        }
    }
}

