/*
 * Decompiled with CFR 0.152.
 */
package com.leobeliik.extremesoundmuffler;

import net.minecraftforge.common.config.Config;
import net.minecraftforge.common.config.ConfigManager;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@Mod.EventBusSubscriber(modid="extremesoundmuffler")
@Config(modid="extremesoundmuffler", category="")
public class ESMConfig {
    @Config.LangKey(value="stat.generalButton")
    public static final General GENERAL = new General();
    @Config.Name(value="inventory_button")
    @Config.Comment(value={"Buttons can be moved by holding CTRL and LMB over the button and dragging it around"})
    public static final Buttons BUTTONS = new Buttons();
    public static final Anchors ANCHORS = new Anchors();

    static boolean getDisableInventoryButton() {
        return ESMConfig.BUTTONS.disableInventoryButton;
    }

    static boolean useDarkTheme() {
        return ESMConfig.GENERAL.useDarkTheme;
    }

    static String[] getForbiddenSounds() {
        return ESMConfig.GENERAL.forbiddenSounds;
    }

    public static boolean getLawfulAllList() {
        return ESMConfig.GENERAL.lawfulAllList;
    }

    public static boolean getDisableAnchors() {
        return ESMConfig.ANCHORS.disableAnchors;
    }

    public static float getDefaultMuteVolume() {
        return (float)ESMConfig.GENERAL.defaultMuteVolume;
    }

    public static boolean getLeftButtons() {
        return ESMConfig.GENERAL.leftButtons;
    }

    public static boolean getShowTip() {
        return ESMConfig.GENERAL.showTip;
    }

    public static void setInvButtonPosition(int x, int y) {
        ESMConfig.BUTTONS.invButtonX = x;
        ESMConfig.BUTTONS.invButtonY = y;
        ESMConfig.sync();
    }

    public static void sync() {
        ConfigManager.sync((String)"extremesoundmuffler", (Config.Type)Config.Type.INSTANCE);
    }

    @SubscribeEvent
    public void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
        if (event.getModID().equals("extremesoundmuffler")) {
            ESMConfig.sync();
        }
    }

    public static class Buttons {
        @Config.Comment(value={"Disable the Muffle button in the player inventory?"})
        public boolean disableInventoryButton = false;
        @Config.Comment(value={"X coordinate of the Muffler button in the player inventory."})
        public int invButtonX = 75;
        @Config.Comment(value={"Y coordinate of the Muffler button in the player inventory."})
        public int invButtonY = 7;
    }

    public static class General {
        @Config.Comment(value={"Blacklisted Sounds - add the name of the sounds to blacklist, separated with comma"})
        public String[] forbiddenSounds = new String[]{"ui.", "music.", "ambient."};
        @Config.Comment(value={"Allow the \"ALL\" sounds list to include the blacklisted sounds?"})
        public boolean lawfulAllList = false;
        @Config.Comment(value={"Move the muffle and play buttons to the left side of the GUI"})
        public boolean leftButtons = false;
        @Config.Comment(value={"Volume set when pressed the mute button by default"})
        @Config.RangeDouble(min=0.0, max=0.99)
        @Config.SlidingOption
        public double defaultMuteVolume = 0.0;
        @Config.Comment(value={"Show tips in the Muffler screen?"})
        public boolean showTip = true;
        @Config.Comment(value={"Whether or not use the dark theme"})
        public boolean useDarkTheme = false;
        @Config.Comment(value={"Hide non-recent muffled sounds from the recent sounds list"})
        public boolean hideMuffledFromRecent = true;
    }

    public static class Anchors {
        @Config.Comment(value={"Disable the Anchors?"})
        public boolean disableAnchors = false;
    }
}

