/*
 * Decompiled with CFR 0.152.
 */
package gregtech.loaders.recipe.handlers;

import com.google.common.collect.ImmutableList;
import gregtech.api.GTValues;
import gregtech.api.capability.GregtechCapabilities;
import gregtech.api.capability.IElectricItem;
import gregtech.api.items.metaitem.MetaItem;
import gregtech.api.items.toolitem.IGTTool;
import gregtech.api.items.toolitem.ToolHelper;
import gregtech.api.recipes.ModHandler;
import gregtech.api.recipes.RecipeMaps;
import gregtech.api.recipes.builders.SimpleRecipeBuilder;
import gregtech.api.unification.OreDictUnifier;
import gregtech.api.unification.material.MarkerMaterials;
import gregtech.api.unification.material.Material;
import gregtech.api.unification.material.Materials;
import gregtech.api.unification.material.info.MaterialFlags;
import gregtech.api.unification.material.properties.PropertyKey;
import gregtech.api.unification.material.properties.ToolProperty;
import gregtech.api.unification.ore.OrePrefix;
import gregtech.api.unification.stack.UnificationEntry;
import gregtech.common.crafting.ToolHeadReplaceRecipe;
import gregtech.common.items.MetaItems;
import gregtech.common.items.ToolItems;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.jetbrains.annotations.NotNull;

public class ToolRecipeHandler {
    public static Map<Integer, MetaItem.MetaValueItem> motorItems = new HashMap<Integer, MetaItem.MetaValueItem>();
    public static Map<Integer, Material> baseMaterials = new HashMap<Integer, Material>();
    public static Map<Integer, List<MetaItem.MetaValueItem>> batteryItems = new HashMap<Integer, List<MetaItem.MetaValueItem>>();
    public static Map<Integer, MetaItem.MetaValueItem> powerUnitItems = new HashMap<Integer, MetaItem.MetaValueItem>();

    public static void register() {
        OrePrefix.plate.addProcessingHandler(PropertyKey.TOOL, ToolRecipeHandler::processTool);
        OrePrefix.plate.addProcessingHandler(PropertyKey.TOOL, ToolRecipeHandler::processElectricTool);
    }

    public static void initializeMetaItems() {
        motorItems.put(1, MetaItems.ELECTRIC_MOTOR_LV);
        motorItems.put(2, MetaItems.ELECTRIC_MOTOR_MV);
        motorItems.put(3, MetaItems.ELECTRIC_MOTOR_HV);
        motorItems.put(4, MetaItems.ELECTRIC_MOTOR_EV);
        motorItems.put(5, MetaItems.ELECTRIC_MOTOR_IV);
        baseMaterials.put(1, Materials.Steel);
        baseMaterials.put(2, Materials.Aluminium);
        baseMaterials.put(3, Materials.StainlessSteel);
        baseMaterials.put(4, Materials.Titanium);
        baseMaterials.put(5, Materials.TungstenSteel);
        powerUnitItems.put(1, MetaItems.POWER_UNIT_LV);
        powerUnitItems.put(2, MetaItems.POWER_UNIT_MV);
        powerUnitItems.put(3, MetaItems.POWER_UNIT_HV);
        powerUnitItems.put(4, MetaItems.POWER_UNIT_EV);
        powerUnitItems.put(5, MetaItems.POWER_UNIT_IV);
        batteryItems.put(0, Collections.singletonList(MetaItems.BATTERY_ULV_TANTALUM));
        batteryItems.put(1, (List<MetaItem.MetaValueItem>)ImmutableList.of((Object)MetaItems.BATTERY_LV_LITHIUM, (Object)MetaItems.BATTERY_LV_CADMIUM, (Object)MetaItems.BATTERY_LV_SODIUM));
        batteryItems.put(2, (List<MetaItem.MetaValueItem>)ImmutableList.of((Object)MetaItems.BATTERY_MV_LITHIUM, (Object)MetaItems.BATTERY_MV_CADMIUM, (Object)MetaItems.BATTERY_MV_SODIUM));
        batteryItems.put(3, (List<MetaItem.MetaValueItem>)ImmutableList.of((Object)MetaItems.BATTERY_HV_LITHIUM, (Object)MetaItems.BATTERY_HV_CADMIUM, (Object)MetaItems.BATTERY_HV_SODIUM, (Object)MetaItems.ENERGIUM_CRYSTAL));
        batteryItems.put(4, (List<MetaItem.MetaValueItem>)ImmutableList.of((Object)MetaItems.BATTERY_EV_VANADIUM, (Object)MetaItems.LAPOTRON_CRYSTAL));
        batteryItems.put(5, (List<MetaItem.MetaValueItem>)ImmutableList.of((Object)MetaItems.BATTERY_IV_VANADIUM, (Object)MetaItems.ENERGY_LAPOTRONIC_ORB));
        batteryItems.put(6, (List<MetaItem.MetaValueItem>)ImmutableList.of((Object)MetaItems.BATTERY_LUV_VANADIUM, (Object)MetaItems.ENERGY_LAPOTRONIC_ORB_CLUSTER));
        batteryItems.put(7, (List<MetaItem.MetaValueItem>)ImmutableList.of((Object)MetaItems.BATTERY_ZPM_NAQUADRIA, (Object)MetaItems.ENERGY_MODULE));
        batteryItems.put(8, (List<MetaItem.MetaValueItem>)ImmutableList.of((Object)MetaItems.BATTERY_UV_NAQUADRIA, (Object)MetaItems.ENERGY_CLUSTER));
        ToolHeadReplaceRecipe.setToolHeadForTool(OrePrefix.toolHeadDrill, ToolItems.DRILL_LV);
        ToolHeadReplaceRecipe.setToolHeadForTool(OrePrefix.toolHeadDrill, ToolItems.DRILL_MV);
        ToolHeadReplaceRecipe.setToolHeadForTool(OrePrefix.toolHeadDrill, ToolItems.DRILL_HV);
        ToolHeadReplaceRecipe.setToolHeadForTool(OrePrefix.toolHeadDrill, ToolItems.DRILL_EV);
        ToolHeadReplaceRecipe.setToolHeadForTool(OrePrefix.toolHeadDrill, ToolItems.DRILL_IV);
        ToolHeadReplaceRecipe.setToolHeadForTool(OrePrefix.toolHeadChainsaw, ToolItems.CHAINSAW_LV);
        ToolHeadReplaceRecipe.setToolHeadForTool(OrePrefix.toolHeadWrench, ToolItems.WRENCH_LV);
        ToolHeadReplaceRecipe.setToolHeadForTool(OrePrefix.toolHeadWrench, ToolItems.WRENCH_HV);
        ToolHeadReplaceRecipe.setToolHeadForTool(OrePrefix.toolHeadWrench, ToolItems.WRENCH_IV);
        ToolHeadReplaceRecipe.setToolHeadForTool(OrePrefix.toolHeadBuzzSaw, ToolItems.BUZZSAW);
        ToolHeadReplaceRecipe.setToolHeadForTool(OrePrefix.toolHeadScrewdriver, ToolItems.SCREWDRIVER_LV);
        ForgeRegistries.RECIPES.register((IForgeRegistryEntry)((IRecipe)new ToolHeadReplaceRecipe().setRegistryName(new ResourceLocation("gregtech", "replacetoolhead"))));
    }

    public static void registerPowerUnitRecipes() {
        for (int tier : powerUnitItems.keySet()) {
            List<MetaItem.MetaValueItem> tieredBatteryItems = batteryItems.get(tier);
            for (MetaItem.MetaValueItem batteryItem : tieredBatteryItems) {
                ItemStack batteryStack = batteryItem.getStackForm();
                long maxCharge = ((IElectricItem)batteryStack.getCapability(GregtechCapabilities.CAPABILITY_ELECTRIC_ITEM, null)).getMaxCharge();
                ItemStack powerUnitStack = powerUnitItems.get(tier).getMaxChargeOverrideStack(maxCharge);
                String recipeName = String.format("%s_%s", ToolRecipeHandler.powerUnitItems.get((Object)Integer.valueOf((int)tier)).unlocalizedName, batteryItem.unlocalizedName);
                ModHandler.addShapedEnergyTransferRecipe(recipeName, powerUnitStack, (Predicate<ItemStack>)Ingredient.func_193369_a((ItemStack[])new ItemStack[]{batteryStack}), true, false, "S d", "GMG", "PBP", Character.valueOf('M'), motorItems.get(tier).getStackForm(), Character.valueOf('S'), new UnificationEntry(OrePrefix.screw, baseMaterials.get(tier)), Character.valueOf('P'), new UnificationEntry(OrePrefix.plate, baseMaterials.get(tier)), Character.valueOf('G'), new UnificationEntry(OrePrefix.gearSmall, baseMaterials.get(tier)), Character.valueOf('B'), batteryStack);
            }
        }
    }

    private static void processTool(OrePrefix prefix, Material material, ToolProperty property) {
        UnificationEntry stick = new UnificationEntry(OrePrefix.stick, Materials.Wood);
        UnificationEntry plate = new UnificationEntry(OrePrefix.plate, material);
        UnificationEntry ingot = new UnificationEntry(material.hasProperty(PropertyKey.GEM) ? OrePrefix.gem : OrePrefix.ingot, material);
        if (material.hasFlag(MaterialFlags.GENERATE_PLATE)) {
            ToolRecipeHandler.addToolRecipe(material, ToolItems.MINING_HAMMER, true, "PPf", "PPS", "PPh", Character.valueOf('P'), plate, Character.valueOf('S'), stick);
            ToolRecipeHandler.addToolRecipe(material, ToolItems.SPADE, false, "fPh", "PSP", " S ", Character.valueOf('P'), plate, Character.valueOf('S'), stick);
            ToolRecipeHandler.addToolRecipe(material, ToolItems.SAW, false, "PPS", "fhS", Character.valueOf('P'), plate, Character.valueOf('S'), stick);
            ToolRecipeHandler.addToolRecipe(material, ToolItems.AXE, false, "PIh", "PS ", "fS ", Character.valueOf('P'), plate, Character.valueOf('I'), ingot, Character.valueOf('S'), stick);
            ToolRecipeHandler.addToolRecipe(material, ToolItems.HOE, false, "PIh", "fS ", " S ", Character.valueOf('P'), plate, Character.valueOf('I'), ingot, Character.valueOf('S'), stick);
            ToolRecipeHandler.addToolRecipe(material, ToolItems.PICKAXE, false, "PII", "fSh", " S ", Character.valueOf('P'), plate, Character.valueOf('I'), ingot, Character.valueOf('S'), stick);
            ToolRecipeHandler.addToolRecipe(material, ToolItems.SCYTHE, false, "PPI", "fSh", " S ", Character.valueOf('P'), plate, Character.valueOf('I'), ingot, Character.valueOf('S'), stick);
            ToolRecipeHandler.addToolRecipe(material, ToolItems.SHOVEL, false, "fPh", " S ", " S ", Character.valueOf('P'), plate, Character.valueOf('S'), stick);
            ToolRecipeHandler.addToolRecipe(material, ToolItems.SWORD, false, " P ", "fPh", " S ", Character.valueOf('P'), plate, Character.valueOf('S'), stick);
            ToolRecipeHandler.addToolRecipe(material, ToolItems.HARD_HAMMER, true, "II ", "IIS", "II ", Character.valueOf('I'), ingot, Character.valueOf('S'), stick);
            ToolRecipeHandler.addToolRecipe(material, ToolItems.FILE, true, "P", "P", "S", Character.valueOf('P'), plate, Character.valueOf('S'), stick);
            ToolRecipeHandler.addToolRecipe(material, ToolItems.KNIFE, false, "fPh", " S ", Character.valueOf('P'), plate, Character.valueOf('S'), stick);
            ToolRecipeHandler.addToolRecipe(material, ToolItems.WRENCH, false, "PhP", " P ", " P ", Character.valueOf('P'), plate);
        }
        if (material.hasFlag(MaterialFlags.GENERATE_ROD)) {
            UnificationEntry rod = new UnificationEntry(OrePrefix.stick, material);
            if (material.hasFlag(MaterialFlags.GENERATE_PLATE)) {
                ToolRecipeHandler.addToolRecipe(material, ToolItems.BUTCHERY_KNIFE, false, "PPf", "PP ", "Sh ", Character.valueOf('P'), plate, Character.valueOf('S'), rod);
                if (material.hasFlag(MaterialFlags.GENERATE_BOLT_SCREW)) {
                    ToolRecipeHandler.addToolRecipe(material, ToolItems.WIRE_CUTTER, false, "PfP", "hPd", "STS", Character.valueOf('P'), plate, Character.valueOf('T'), new UnificationEntry(OrePrefix.screw, material), Character.valueOf('S'), rod);
                }
            }
            ToolRecipeHandler.addToolRecipe(material, ToolItems.SCREWDRIVER, true, " fS", " Sh", "W  ", Character.valueOf('S'), rod, Character.valueOf('W'), stick);
            ToolRecipeHandler.addToolRecipe(material, ToolItems.CROWBAR, true, "hDS", "DSD", "SDf", Character.valueOf('S'), rod, Character.valueOf('D'), new UnificationEntry(OrePrefix.dye, MarkerMaterials.Color.Blue));
        }
    }

    private static void processElectricTool(OrePrefix prefix, Material material, ToolProperty property) {
        OrePrefix toolPrefix;
        int voltageMultiplier;
        int n = voltageMultiplier = material.getBlastTemperature() > 2800 ? GTValues.VA[1] : GTValues.VA[0];
        if (material.hasFlag(MaterialFlags.GENERATE_PLATE)) {
            UnificationEntry plate = new UnificationEntry(OrePrefix.plate, material);
            UnificationEntry steelPlate = new UnificationEntry(OrePrefix.plate, Materials.Steel);
            UnificationEntry steelRing = new UnificationEntry(OrePrefix.ring, Materials.Steel);
            toolPrefix = OrePrefix.toolHeadDrill;
            ModHandler.addShapedRecipe(String.format("drill_head_%s", material), OreDictUnifier.get(toolPrefix, material), "XSX", "XSX", "ShS", Character.valueOf('X'), plate, Character.valueOf('S'), steelPlate);
            ToolRecipeHandler.addElectricToolRecipe(toolPrefix, material, new IGTTool[]{ToolItems.DRILL_LV, ToolItems.DRILL_MV, ToolItems.DRILL_HV, ToolItems.DRILL_EV, ToolItems.DRILL_IV});
            toolPrefix = OrePrefix.toolHeadChainsaw;
            ModHandler.addShapedRecipe(String.format("chainsaw_head_%s", material), OreDictUnifier.get(toolPrefix, material), "SRS", "XhX", "SRS", Character.valueOf('X'), plate, Character.valueOf('S'), steelPlate, Character.valueOf('R'), steelRing);
            ToolRecipeHandler.addElectricToolRecipe(toolPrefix, material, new IGTTool[]{ToolItems.CHAINSAW_LV});
            toolPrefix = OrePrefix.toolHeadWrench;
            ToolRecipeHandler.addElectricToolRecipe(toolPrefix, material, new IGTTool[]{ToolItems.WRENCH_LV, ToolItems.WRENCH_HV, ToolItems.WRENCH_IV});
            ModHandler.addShapedRecipe(String.format("wrench_head_%s", material), OreDictUnifier.get(toolPrefix, material), "hXW", "XRX", "WXd", Character.valueOf('X'), plate, Character.valueOf('R'), steelRing, Character.valueOf('W'), new UnificationEntry(OrePrefix.screw, Materials.Steel));
            toolPrefix = OrePrefix.toolHeadBuzzSaw;
            ToolRecipeHandler.addElectricToolRecipe(toolPrefix, material, new IGTTool[]{ToolItems.BUZZSAW});
            ModHandler.addShapedRecipe(String.format("buzzsaw_blade_%s", material), OreDictUnifier.get(toolPrefix, material), "sXh", "X X", "fXx", Character.valueOf('X'), plate);
            if (material.hasFlag(MaterialFlags.GENERATE_GEAR)) {
                ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.LATHE_RECIPES.recipeBuilder().input(OrePrefix.gear, material)).output(toolPrefix, material)).duration((int)material.getMass() * 4)).EUt(8 * voltageMultiplier)).buildAndRegister();
            }
            ToolRecipeHandler.addElectricWirecutterRecipe(material, new IGTTool[]{ToolItems.WIRECUTTER_LV, ToolItems.WIRECUTTER_HV, ToolItems.WIRECUTTER_IV});
        }
        if (material.hasFlag(MaterialFlags.GENERATE_LONG_ROD)) {
            toolPrefix = OrePrefix.toolHeadScrewdriver;
            ToolRecipeHandler.addElectricToolRecipe(toolPrefix, material, new IGTTool[]{ToolItems.SCREWDRIVER_LV});
            ModHandler.addShapedRecipe(String.format("screwdriver_tip_%s", material), OreDictUnifier.get(toolPrefix, material), "fR", " h", Character.valueOf('R'), new UnificationEntry(OrePrefix.stickLong, material));
        }
    }

    public static void addElectricToolRecipe(OrePrefix toolHead, Material material, IGTTool[] toolItems) {
        for (IGTTool toolItem : toolItems) {
            int tier = toolItem.getElectricTier();
            ItemStack powerUnitStack = powerUnitItems.get(tier).getStackForm();
            IElectricItem powerUnit = (IElectricItem)powerUnitStack.getCapability(GregtechCapabilities.CAPABILITY_ELECTRIC_ITEM, null);
            ItemStack tool = toolItem.get(material, 0L, powerUnit.getMaxCharge());
            ModHandler.addShapedEnergyTransferRecipe(String.format("%s_%s", toolItem.getToolId(), material), tool, (Predicate<ItemStack>)Ingredient.func_193369_a((ItemStack[])new ItemStack[]{powerUnitStack}), true, true, "wHd", " U ", Character.valueOf('H'), new UnificationEntry(toolHead, material), Character.valueOf('U'), powerUnitStack);
        }
    }

    public static void addElectricWirecutterRecipe(Material material, IGTTool[] toolItems) {
        for (IGTTool toolItem : toolItems) {
            int tier = toolItem.getElectricTier();
            ItemStack powerUnitStack = powerUnitItems.get(tier).getStackForm();
            IElectricItem powerUnit = (IElectricItem)powerUnitStack.getCapability(GregtechCapabilities.CAPABILITY_ELECTRIC_ITEM, null);
            ItemStack tool = toolItem.get(material, 0L, powerUnit.getMaxCharge());
            ModHandler.addShapedEnergyTransferRecipe(String.format("%s_%s", toolItem.getToolId(), material), tool, (Predicate<ItemStack>)Ingredient.func_193369_a((ItemStack[])new ItemStack[]{powerUnitStack}), true, true, "PfP", "hPd", "RUR", Character.valueOf('P'), new UnificationEntry(OrePrefix.plate, material), Character.valueOf('U'), powerUnitStack, Character.valueOf('R'), new UnificationEntry(OrePrefix.stick, material));
        }
    }

    public static void addToolRecipe(@NotNull Material material, @NotNull IGTTool tool, boolean mirrored, Object ... recipe) {
        if (mirrored) {
            ModHandler.addMirroredShapedRecipe(String.format("%s_%s", tool.getToolId(), material), tool.get(material), recipe);
        } else {
            ModHandler.addShapedRecipe(String.format("%s_%s", tool.getToolId(), material), tool.get(material), recipe);
        }
    }

    public static void registerCustomToolRecipes() {
        ToolRecipeHandler.registerFlintToolRecipes();
        ToolRecipeHandler.registerMortarRecipes();
        ToolRecipeHandler.registerSoftToolRecipes();
        ToolRecipeHandler.registerElectricRecipes();
    }

    private static void registerFlintToolRecipes() {
        UnificationEntry flint = new UnificationEntry(OrePrefix.gem, Materials.Flint);
        UnificationEntry stick = new UnificationEntry(OrePrefix.stick, Materials.Wood);
        ToolRecipeHandler.addToolRecipe(Materials.Flint, ToolItems.MORTAR, false, " I ", "SIS", "SSS", Character.valueOf('I'), flint, Character.valueOf('S'), OrePrefix.stone);
        ToolRecipeHandler.addToolRecipe(Materials.Flint, ToolItems.SWORD, false, "I", "I", "S", Character.valueOf('I'), flint, Character.valueOf('S'), stick);
        ToolRecipeHandler.addToolRecipe(Materials.Flint, ToolItems.PICKAXE, false, "III", " S ", " S ", Character.valueOf('I'), flint, Character.valueOf('S'), stick);
        ToolRecipeHandler.addToolRecipe(Materials.Flint, ToolItems.SHOVEL, false, "I", "S", "S", Character.valueOf('I'), flint, Character.valueOf('S'), stick);
        ToolRecipeHandler.addToolRecipe(Materials.Flint, ToolItems.AXE, true, "II", "IS", " S", Character.valueOf('I'), flint, Character.valueOf('S'), stick);
        ToolRecipeHandler.addToolRecipe(Materials.Flint, ToolItems.HOE, true, "II", " S", " S", Character.valueOf('I'), flint, Character.valueOf('S'), stick);
        ToolRecipeHandler.addToolRecipe(Materials.Flint, ToolItems.KNIFE, false, "I", "S", Character.valueOf('I'), flint, Character.valueOf('S'), stick);
    }

    private static void registerMortarRecipes() {
        for (Material material : new Material[]{Materials.Bronze, Materials.Iron, Materials.Invar, Materials.Steel, Materials.DamascusSteel, Materials.CobaltBrass, Materials.WroughtIron}) {
            ToolRecipeHandler.addToolRecipe(material, ToolItems.MORTAR, false, " I ", "SIS", "SSS", Character.valueOf('I'), new UnificationEntry(material.hasProperty(PropertyKey.GEM) ? OrePrefix.gem : OrePrefix.ingot, material), Character.valueOf('S'), OrePrefix.stone);
        }
    }

    private static void registerSoftToolRecipes() {
        Material[] softMaterials = new Material[]{Materials.Wood, Materials.Rubber, Materials.Polyethylene, Materials.Polytetrafluoroethylene, Materials.Polybenzimidazole};
        UnificationEntry stick = new UnificationEntry(OrePrefix.stick, Materials.Wood);
        for (int i = 0; i < softMaterials.length; ++i) {
            Material material = softMaterials[i];
            if (ModHandler.isMaterialWood(material)) {
                ModHandler.addMirroredShapedRecipe(String.format("soft_mallet_%s", material), ToolHelper.getAndSetToolData(ToolItems.SOFT_MALLET, material, 47, 1, 4.0f, 1.0f), "II ", "IIS", "II ", Character.valueOf('I'), new UnificationEntry(OrePrefix.plank, material), Character.valueOf('S'), stick);
                continue;
            }
            ModHandler.addMirroredShapedRecipe(String.format("soft_mallet_%s", material), ToolHelper.getAndSetToolData(ToolItems.SOFT_MALLET, material, 128 * (1 << i) - 1, 1, 4.0f, 1.0f), "II ", "IIS", "II ", Character.valueOf('I'), new UnificationEntry(OrePrefix.ingot, material), Character.valueOf('S'), stick);
            ModHandler.addMirroredShapedRecipe(String.format("plunger_%s", material), ToolHelper.getAndSetToolData(ToolItems.PLUNGER, material, 128 * (i << 1) - 1, 1, 4.0f, 0.0f), "xPP", " SP", "S f", Character.valueOf('P'), new UnificationEntry(OrePrefix.plate, material), Character.valueOf('S'), stick);
        }
    }

    private static void registerElectricRecipes() {
        for (MetaItem.MetaValueItem batteryItem : batteryItems.get(1)) {
            ModHandler.addShapedEnergyTransferRecipe("prospector_lv_" + batteryItem.unlocalizedName, MetaItems.PROSPECTOR_LV.getStackForm(), batteryItem::isItemEqual, true, true, "EPS", "CDC", "PBP", Character.valueOf('E'), MetaItems.EMITTER_LV.getStackForm(), Character.valueOf('P'), new UnificationEntry(OrePrefix.plate, Materials.Steel), Character.valueOf('S'), MetaItems.SENSOR_LV.getStackForm(), Character.valueOf('D'), new UnificationEntry(OrePrefix.plate, Materials.Glass), Character.valueOf('C'), new UnificationEntry(OrePrefix.circuit, MarkerMaterials.Tier.LV), Character.valueOf('B'), batteryItem.getStackForm());
            ModHandler.addShapedEnergyTransferRecipe("magnet_lv_" + batteryItem.unlocalizedName, MetaItems.ITEM_MAGNET_LV.getStackForm(), batteryItem::isItemEqual, true, true, "MwM", "MBM", "CPC", Character.valueOf('M'), new UnificationEntry(OrePrefix.stick, Materials.SteelMagnetic), Character.valueOf('P'), new UnificationEntry(OrePrefix.plate, Materials.Steel), Character.valueOf('C'), new UnificationEntry(OrePrefix.cableGtSingle, Materials.Tin), Character.valueOf('B'), batteryItem.getStackForm());
        }
        for (MetaItem.MetaValueItem batteryItem : batteryItems.get(2)) {
            ModHandler.addShapedEnergyTransferRecipe("tricorder_" + batteryItem.unlocalizedName, MetaItems.TRICORDER_SCANNER.getStackForm(), batteryItem::isItemEqual, true, true, "EPS", "CDC", "PBP", Character.valueOf('E'), MetaItems.EMITTER_MV.getStackForm(), Character.valueOf('P'), new UnificationEntry(OrePrefix.plate, Materials.Aluminium), Character.valueOf('S'), MetaItems.SENSOR_MV.getStackForm(), Character.valueOf('D'), MetaItems.COVER_SCREEN.getStackForm(), Character.valueOf('C'), new UnificationEntry(OrePrefix.circuit, MarkerMaterials.Tier.HV), Character.valueOf('B'), batteryItem.getStackForm());
        }
        for (MetaItem.MetaValueItem batteryItem : batteryItems.get(3)) {
            ModHandler.addShapedEnergyTransferRecipe("prospector_hv_" + batteryItem.unlocalizedName, MetaItems.PROSPECTOR_HV.getStackForm(), batteryItem::isItemEqual, true, true, "EPS", "CDC", "PBP", Character.valueOf('E'), MetaItems.EMITTER_HV.getStackForm(), Character.valueOf('P'), new UnificationEntry(OrePrefix.plate, Materials.StainlessSteel), Character.valueOf('S'), MetaItems.SENSOR_HV.getStackForm(), Character.valueOf('D'), MetaItems.COVER_SCREEN.getStackForm(), Character.valueOf('C'), new UnificationEntry(OrePrefix.circuit, MarkerMaterials.Tier.HV), Character.valueOf('B'), batteryItem.getStackForm());
            ModHandler.addShapedEnergyTransferRecipe("magnet_hv_" + batteryItem.unlocalizedName, MetaItems.ITEM_MAGNET_HV.getStackForm(), batteryItem::isItemEqual, true, true, "MwM", "MBM", "CPC", Character.valueOf('M'), new UnificationEntry(OrePrefix.stick, Materials.NeodymiumMagnetic), Character.valueOf('P'), new UnificationEntry(OrePrefix.plate, Materials.StainlessSteel), Character.valueOf('C'), new UnificationEntry(OrePrefix.cableGtSingle, Materials.Gold), Character.valueOf('B'), batteryItem.getStackForm());
        }
        for (MetaItem.MetaValueItem batteryItem : batteryItems.get(6)) {
            ModHandler.addShapedEnergyTransferRecipe("prospector_luv_" + batteryItem.unlocalizedName, MetaItems.PROSPECTOR_LUV.getStackForm(), batteryItem::isItemEqual, true, true, "EPS", "CDC", "PBP", Character.valueOf('E'), MetaItems.EMITTER_LuV.getStackForm(), Character.valueOf('P'), new UnificationEntry(OrePrefix.plate, Materials.RhodiumPlatedPalladium), Character.valueOf('S'), MetaItems.SENSOR_LuV.getStackForm(), Character.valueOf('D'), MetaItems.COVER_SCREEN.getStackForm(), Character.valueOf('C'), new UnificationEntry(OrePrefix.circuit, MarkerMaterials.Tier.LuV), Character.valueOf('B'), batteryItem.getStackForm());
        }
    }
}

