/*
 * Decompiled with CFR 0.152.
 */
package gregtech.loaders.recipe;

import gregtech.api.GTValues;
import gregtech.api.items.OreDictNames;
import gregtech.api.items.metaitem.MetaItem;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.multiblock.CleanroomType;
import gregtech.api.recipes.ModHandler;
import gregtech.api.recipes.RecipeMaps;
import gregtech.api.recipes.builders.AssemblerRecipeBuilder;
import gregtech.api.recipes.builders.BlastRecipeBuilder;
import gregtech.api.recipes.builders.PrimitiveRecipeBuilder;
import gregtech.api.recipes.builders.SimpleRecipeBuilder;
import gregtech.api.unification.OreDictUnifier;
import gregtech.api.unification.material.MarkerMaterial;
import gregtech.api.unification.material.MarkerMaterials;
import gregtech.api.unification.material.Material;
import gregtech.api.unification.material.Materials;
import gregtech.api.unification.material.properties.PropertyKey;
import gregtech.api.unification.ore.OrePrefix;
import gregtech.api.unification.stack.MaterialStack;
import gregtech.api.unification.stack.UnificationEntry;
import gregtech.api.util.Mods;
import gregtech.common.ConfigHolder;
import gregtech.common.blocks.BlockAsphalt;
import gregtech.common.blocks.BlockCleanroomCasing;
import gregtech.common.blocks.BlockFusionCasing;
import gregtech.common.blocks.BlockGlassCasing;
import gregtech.common.blocks.BlockLamp;
import gregtech.common.blocks.BlockMachineCasing;
import gregtech.common.blocks.BlockMetalCasing;
import gregtech.common.blocks.BlockTurbineCasing;
import gregtech.common.blocks.BlockWireCoil;
import gregtech.common.blocks.MetaBlocks;
import gregtech.common.blocks.StoneVariantBlock;
import gregtech.common.items.MetaItems;
import gregtech.common.metatileentities.MetaTileEntities;
import gregtech.common.metatileentities.storage.MetaTileEntityQuantumChest;
import gregtech.common.metatileentities.storage.MetaTileEntityQuantumTank;
import gregtech.loaders.recipe.AssemblyLineLoader;
import gregtech.loaders.recipe.BatteryRecipes;
import gregtech.loaders.recipe.CircuitRecipes;
import gregtech.loaders.recipe.ComponentRecipes;
import gregtech.loaders.recipe.ComputerRecipes;
import gregtech.loaders.recipe.DecorationRecipes;
import gregtech.loaders.recipe.FuelRecipes;
import gregtech.loaders.recipe.FusionLoader;
import gregtech.loaders.recipe.MiscRecipeLoader;
import gregtech.loaders.recipe.WoodRecipeLoader;
import gregtech.loaders.recipe.chemistry.AssemblerRecipeLoader;
import gregtech.loaders.recipe.chemistry.ChemistryRecipes;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.oredict.OreDictionary;

public class MachineRecipeLoader {
    private static final MaterialStack[][] alloySmelterList = new MaterialStack[][]{{new MaterialStack(Materials.Copper, 3L), new MaterialStack(Materials.Tin, 1L), new MaterialStack(Materials.Bronze, 4L)}, {new MaterialStack(Materials.Copper, 3L), new MaterialStack(Materials.Zinc, 1L), new MaterialStack(Materials.Brass, 4L)}, {new MaterialStack(Materials.Copper, 1L), new MaterialStack(Materials.Nickel, 1L), new MaterialStack(Materials.Cupronickel, 2L)}, {new MaterialStack(Materials.Copper, 1L), new MaterialStack(Materials.Redstone, 4L), new MaterialStack(Materials.RedAlloy, 1L)}, {new MaterialStack(Materials.AnnealedCopper, 3L), new MaterialStack(Materials.Tin, 1L), new MaterialStack(Materials.Bronze, 4L)}, {new MaterialStack(Materials.AnnealedCopper, 3L), new MaterialStack(Materials.Zinc, 1L), new MaterialStack(Materials.Brass, 4L)}, {new MaterialStack(Materials.AnnealedCopper, 1L), new MaterialStack(Materials.Nickel, 1L), new MaterialStack(Materials.Cupronickel, 2L)}, {new MaterialStack(Materials.AnnealedCopper, 1L), new MaterialStack(Materials.Redstone, 4L), new MaterialStack(Materials.RedAlloy, 1L)}, {new MaterialStack(Materials.Iron, 1L), new MaterialStack(Materials.Tin, 1L), new MaterialStack(Materials.TinAlloy, 2L)}, {new MaterialStack(Materials.WroughtIron, 1L), new MaterialStack(Materials.Tin, 1L), new MaterialStack(Materials.TinAlloy, 2L)}, {new MaterialStack(Materials.Iron, 2L), new MaterialStack(Materials.Nickel, 1L), new MaterialStack(Materials.Invar, 3L)}, {new MaterialStack(Materials.WroughtIron, 2L), new MaterialStack(Materials.Nickel, 1L), new MaterialStack(Materials.Invar, 3L)}, {new MaterialStack(Materials.Lead, 4L), new MaterialStack(Materials.Antimony, 1L), new MaterialStack(Materials.BatteryAlloy, 5L)}, {new MaterialStack(Materials.Gold, 1L), new MaterialStack(Materials.Silver, 1L), new MaterialStack(Materials.Electrum, 2L)}, {new MaterialStack(Materials.Magnesium, 1L), new MaterialStack(Materials.Aluminium, 2L), new MaterialStack(Materials.Magnalium, 3L)}, {new MaterialStack(Materials.Silver, 1L), new MaterialStack(Materials.Electrotine, 4L), new MaterialStack(Materials.BlueAlloy, 1L)}};

    private MachineRecipeLoader() {
    }

    public static void init() {
        ChemistryRecipes.init();
        FuelRecipes.registerFuels();
        AssemblyLineLoader.init();
        FusionLoader.init();
        AssemblerRecipeLoader.init();
        ComponentRecipes.register();
        MiscRecipeLoader.init();
        BatteryRecipes.init();
        CircuitRecipes.init();
        ComputerRecipes.init();
        DecorationRecipes.init();
        WoodRecipeLoader.registerRecipes();
        MachineRecipeLoader.registerDecompositionRecipes();
        MachineRecipeLoader.registerBlastFurnaceRecipes();
        MachineRecipeLoader.registerAssemblerRecipes();
        MachineRecipeLoader.registerAlloyRecipes();
        MachineRecipeLoader.registerBendingCompressingRecipes();
        MachineRecipeLoader.registerCokeOvenRecipes();
        MachineRecipeLoader.registerFluidRecipes();
        MachineRecipeLoader.registerMixingCrystallizationRecipes();
        MachineRecipeLoader.registerPrimitiveBlastFurnaceRecipes();
        MachineRecipeLoader.registerRecyclingRecipes();
        MachineRecipeLoader.registerStoneBricksRecipes();
        MachineRecipeLoader.registerNBTRemoval();
        MachineRecipeLoader.ConvertHatchToHatch();
    }

    private static void registerBendingCompressingRecipes() {
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.COMPRESSOR_RECIPES.recipeBuilder().input(OrePrefix.dust, Materials.Fireclay)).outputs(MetaItems.COMPRESSED_FIRECLAY.getStackForm())).duration(80)).EUt(4)).buildAndRegister();
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.FORMING_PRESS_RECIPES.recipeBuilder().duration(100)).EUt(16)).notConsumable(MetaItems.SHAPE_MOLD_CREDIT.getStackForm())).input(OrePrefix.plate, Materials.Cupronickel, 1)).outputs(MetaItems.CREDIT_CUPRONICKEL.getStackForm(4))).buildAndRegister();
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.FORMING_PRESS_RECIPES.recipeBuilder().duration(100)).EUt(16)).notConsumable(MetaItems.SHAPE_MOLD_CREDIT.getStackForm())).input(OrePrefix.plate, Materials.Brass, 1)).outputs(MetaItems.COIN_DOGE.getStackForm(4))).buildAndRegister();
        for (MetaItem.MetaValueItem shapeMold : MetaItems.SHAPE_MOLDS) {
            ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.FORMING_PRESS_RECIPES.recipeBuilder().duration(120)).EUt(22)).notConsumable(shapeMold.getStackForm())).inputs(MetaItems.SHAPE_EMPTY.getStackForm())).outputs(shapeMold.getStackForm())).buildAndRegister();
        }
        for (MetaItem.MetaValueItem shapeExtruder : MetaItems.SHAPE_EXTRUDERS) {
            if (shapeExtruder == null) continue;
            ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.FORMING_PRESS_RECIPES.recipeBuilder().duration(120)).EUt(22)).notConsumable(shapeExtruder.getStackForm())).inputs(MetaItems.SHAPE_EMPTY.getStackForm())).outputs(shapeExtruder.getStackForm())).buildAndRegister();
        }
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.BENDER_RECIPES.recipeBuilder().circuitMeta(4)).input(OrePrefix.plate, Materials.Steel, 4)).outputs(MetaItems.SHAPE_EMPTY.getStackForm())).duration(180)).EUt(12)).buildAndRegister();
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.BENDER_RECIPES.recipeBuilder().circuitMeta(12)).input(OrePrefix.plate, Materials.Tin, 2)).outputs(MetaItems.FLUID_CELL.getStackForm())).duration(200)).EUt(GTValues.VA[0])).buildAndRegister();
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.BENDER_RECIPES.recipeBuilder().circuitMeta(12)).input(OrePrefix.plate, Materials.Steel)).outputs(MetaItems.FLUID_CELL.getStackForm())).duration(100)).EUt(GTValues.VA[0])).buildAndRegister();
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.BENDER_RECIPES.recipeBuilder().circuitMeta(12)).input(OrePrefix.plate, Materials.Polytetrafluoroethylene)).outputs(MetaItems.FLUID_CELL.getStackForm(4))).duration(100)).EUt(GTValues.VA[0])).buildAndRegister();
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.BENDER_RECIPES.recipeBuilder().circuitMeta(12)).input(OrePrefix.plate, Materials.Polybenzimidazole)).outputs(MetaItems.FLUID_CELL.getStackForm(16))).duration(100)).EUt(GTValues.VA[0])).buildAndRegister();
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.EXTRUDER_RECIPES.recipeBuilder().input(OrePrefix.ingot, Materials.Tin, 2)).notConsumable(MetaItems.SHAPE_EXTRUDER_CELL)).outputs(MetaItems.FLUID_CELL.getStackForm())).duration(128)).EUt(GTValues.VA[1])).buildAndRegister();
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.EXTRUDER_RECIPES.recipeBuilder().input(OrePrefix.ingot, Materials.Steel)).notConsumable(MetaItems.SHAPE_EXTRUDER_CELL)).outputs(MetaItems.FLUID_CELL.getStackForm())).duration(128)).EUt(GTValues.VA[1])).buildAndRegister();
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.EXTRUDER_RECIPES.recipeBuilder().input(OrePrefix.ingot, Materials.Polytetrafluoroethylene)).notConsumable(MetaItems.SHAPE_EXTRUDER_CELL)).outputs(MetaItems.FLUID_CELL.getStackForm(4))).duration(128)).EUt(GTValues.VA[1])).buildAndRegister();
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.EXTRUDER_RECIPES.recipeBuilder().input(OrePrefix.ingot, Materials.Polybenzimidazole)).notConsumable(MetaItems.SHAPE_EXTRUDER_CELL)).outputs(MetaItems.FLUID_CELL.getStackForm(16))).duration(128)).EUt(GTValues.VA[1])).buildAndRegister();
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.EXTRUDER_RECIPES.recipeBuilder().input(OrePrefix.dust, Materials.Glass)).notConsumable(MetaItems.SHAPE_EXTRUDER_CELL)).outputs(MetaItems.FLUID_CELL_GLASS_VIAL.getStackForm(4))).duration(128)).EUt(GTValues.VA[1])).buildAndRegister();
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.COMPRESSOR_RECIPES.recipeBuilder().input(OrePrefix.dust, Materials.NetherQuartz)).output(OrePrefix.plate, Materials.NetherQuartz)).duration(400)).EUt(2)).buildAndRegister();
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.COMPRESSOR_RECIPES.recipeBuilder().input(OrePrefix.dust, Materials.CertusQuartz)).output(OrePrefix.plate, Materials.CertusQuartz)).duration(400)).EUt(2)).buildAndRegister();
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.COMPRESSOR_RECIPES.recipeBuilder().input(OrePrefix.dust, Materials.Quartzite)).output(OrePrefix.plate, Materials.Quartzite)).duration(400)).EUt(2)).buildAndRegister();
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.COMPRESSOR_RECIPES.recipeBuilder().input(MetaItems.COKE_OVEN_BRICK, 4)).outputs(MetaBlocks.METAL_CASING.getItemVariant(BlockMetalCasing.MetalCasingType.COKE_BRICKS))).duration(300)).EUt(2)).buildAndRegister();
    }

    private static void registerPrimitiveBlastFurnaceRecipes() {
        ((PrimitiveRecipeBuilder)((PrimitiveRecipeBuilder)((PrimitiveRecipeBuilder)((PrimitiveRecipeBuilder)((PrimitiveRecipeBuilder)RecipeMaps.PRIMITIVE_BLAST_FURNACE_RECIPES.recipeBuilder().input(OrePrefix.ingot, Materials.Iron)).input(OrePrefix.gem, Materials.Coal, 2)).output(OrePrefix.ingot, Materials.Steel)).output(OrePrefix.dustTiny, Materials.DarkAsh, 2)).duration(1800)).buildAndRegister();
        ((PrimitiveRecipeBuilder)((PrimitiveRecipeBuilder)((PrimitiveRecipeBuilder)((PrimitiveRecipeBuilder)((PrimitiveRecipeBuilder)RecipeMaps.PRIMITIVE_BLAST_FURNACE_RECIPES.recipeBuilder().input(OrePrefix.ingot, Materials.Iron)).input(OrePrefix.dust, Materials.Coal, 2)).output(OrePrefix.ingot, Materials.Steel)).output(OrePrefix.dustTiny, Materials.DarkAsh, 2)).duration(1800)).buildAndRegister();
        ((PrimitiveRecipeBuilder)((PrimitiveRecipeBuilder)((PrimitiveRecipeBuilder)((PrimitiveRecipeBuilder)((PrimitiveRecipeBuilder)RecipeMaps.PRIMITIVE_BLAST_FURNACE_RECIPES.recipeBuilder().input(OrePrefix.ingot, Materials.Iron)).input(OrePrefix.gem, Materials.Charcoal, 2)).output(OrePrefix.ingot, Materials.Steel)).output(OrePrefix.dustTiny, Materials.DarkAsh, 2)).duration(1800)).buildAndRegister();
        ((PrimitiveRecipeBuilder)((PrimitiveRecipeBuilder)((PrimitiveRecipeBuilder)((PrimitiveRecipeBuilder)((PrimitiveRecipeBuilder)RecipeMaps.PRIMITIVE_BLAST_FURNACE_RECIPES.recipeBuilder().input(OrePrefix.ingot, Materials.Iron)).input(OrePrefix.dust, Materials.Charcoal, 2)).output(OrePrefix.ingot, Materials.Steel)).output(OrePrefix.dustTiny, Materials.DarkAsh, 2)).duration(1800)).buildAndRegister();
        ((PrimitiveRecipeBuilder)((PrimitiveRecipeBuilder)((PrimitiveRecipeBuilder)((PrimitiveRecipeBuilder)((PrimitiveRecipeBuilder)RecipeMaps.PRIMITIVE_BLAST_FURNACE_RECIPES.recipeBuilder().input(OrePrefix.ingot, Materials.Iron)).input("fuelCoke")).output(OrePrefix.ingot, Materials.Steel)).output(OrePrefix.dustTiny, Materials.Ash)).duration(1500)).buildAndRegister();
        ((PrimitiveRecipeBuilder)((PrimitiveRecipeBuilder)((PrimitiveRecipeBuilder)((PrimitiveRecipeBuilder)((PrimitiveRecipeBuilder)RecipeMaps.PRIMITIVE_BLAST_FURNACE_RECIPES.recipeBuilder().input(OrePrefix.ingot, Materials.Iron)).input(OrePrefix.dust, Materials.Coke)).output(OrePrefix.ingot, Materials.Steel)).output(OrePrefix.dustTiny, Materials.Ash)).duration(1500)).buildAndRegister();
        ((PrimitiveRecipeBuilder)((PrimitiveRecipeBuilder)((PrimitiveRecipeBuilder)((PrimitiveRecipeBuilder)((PrimitiveRecipeBuilder)RecipeMaps.PRIMITIVE_BLAST_FURNACE_RECIPES.recipeBuilder().input(OrePrefix.block, Materials.Iron)).input(OrePrefix.block, Materials.Coal, 2)).output(OrePrefix.block, Materials.Steel)).output(OrePrefix.dust, Materials.DarkAsh, 2)).duration(16200)).buildAndRegister();
        ((PrimitiveRecipeBuilder)((PrimitiveRecipeBuilder)((PrimitiveRecipeBuilder)((PrimitiveRecipeBuilder)((PrimitiveRecipeBuilder)RecipeMaps.PRIMITIVE_BLAST_FURNACE_RECIPES.recipeBuilder().input(OrePrefix.block, Materials.Iron)).input(OrePrefix.block, Materials.Charcoal, 2)).output(OrePrefix.block, Materials.Steel)).output(OrePrefix.dust, Materials.DarkAsh, 2)).duration(16200)).buildAndRegister();
        ((PrimitiveRecipeBuilder)((PrimitiveRecipeBuilder)((PrimitiveRecipeBuilder)((PrimitiveRecipeBuilder)((PrimitiveRecipeBuilder)RecipeMaps.PRIMITIVE_BLAST_FURNACE_RECIPES.recipeBuilder().input(OrePrefix.block, Materials.Iron)).input("blockFuelCoke")).output(OrePrefix.block, Materials.Steel)).output(OrePrefix.dust, Materials.Ash)).duration(13500)).buildAndRegister();
        ((PrimitiveRecipeBuilder)((PrimitiveRecipeBuilder)((PrimitiveRecipeBuilder)((PrimitiveRecipeBuilder)((PrimitiveRecipeBuilder)RecipeMaps.PRIMITIVE_BLAST_FURNACE_RECIPES.recipeBuilder().input(OrePrefix.ingot, Materials.WroughtIron)).input(OrePrefix.gem, Materials.Coal, 2)).output(OrePrefix.ingot, Materials.Steel)).output(OrePrefix.dustTiny, Materials.DarkAsh, 2)).duration(800)).buildAndRegister();
        ((PrimitiveRecipeBuilder)((PrimitiveRecipeBuilder)((PrimitiveRecipeBuilder)((PrimitiveRecipeBuilder)((PrimitiveRecipeBuilder)RecipeMaps.PRIMITIVE_BLAST_FURNACE_RECIPES.recipeBuilder().input(OrePrefix.ingot, Materials.WroughtIron)).input(OrePrefix.dust, Materials.Coal, 2)).output(OrePrefix.ingot, Materials.Steel)).output(OrePrefix.dustTiny, Materials.DarkAsh, 2)).duration(800)).buildAndRegister();
        ((PrimitiveRecipeBuilder)((PrimitiveRecipeBuilder)((PrimitiveRecipeBuilder)((PrimitiveRecipeBuilder)((PrimitiveRecipeBuilder)RecipeMaps.PRIMITIVE_BLAST_FURNACE_RECIPES.recipeBuilder().input(OrePrefix.ingot, Materials.WroughtIron)).input(OrePrefix.gem, Materials.Charcoal, 2)).output(OrePrefix.ingot, Materials.Steel)).output(OrePrefix.dustTiny, Materials.DarkAsh, 2)).duration(800)).buildAndRegister();
        ((PrimitiveRecipeBuilder)((PrimitiveRecipeBuilder)((PrimitiveRecipeBuilder)((PrimitiveRecipeBuilder)((PrimitiveRecipeBuilder)RecipeMaps.PRIMITIVE_BLAST_FURNACE_RECIPES.recipeBuilder().input(OrePrefix.ingot, Materials.WroughtIron)).input(OrePrefix.dust, Materials.Charcoal, 2)).output(OrePrefix.ingot, Materials.Steel)).output(OrePrefix.dustTiny, Materials.DarkAsh, 2)).duration(800)).buildAndRegister();
        ((PrimitiveRecipeBuilder)((PrimitiveRecipeBuilder)((PrimitiveRecipeBuilder)((PrimitiveRecipeBuilder)((PrimitiveRecipeBuilder)RecipeMaps.PRIMITIVE_BLAST_FURNACE_RECIPES.recipeBuilder().input(OrePrefix.ingot, Materials.WroughtIron)).input("fuelCoke")).output(OrePrefix.ingot, Materials.Steel)).output(OrePrefix.dustTiny, Materials.Ash)).duration(600)).buildAndRegister();
        ((PrimitiveRecipeBuilder)((PrimitiveRecipeBuilder)((PrimitiveRecipeBuilder)((PrimitiveRecipeBuilder)((PrimitiveRecipeBuilder)RecipeMaps.PRIMITIVE_BLAST_FURNACE_RECIPES.recipeBuilder().input(OrePrefix.ingot, Materials.WroughtIron)).input(OrePrefix.dust, Materials.Coke)).output(OrePrefix.ingot, Materials.Steel)).output(OrePrefix.dustTiny, Materials.Ash)).duration(600)).buildAndRegister();
        ((PrimitiveRecipeBuilder)((PrimitiveRecipeBuilder)((PrimitiveRecipeBuilder)((PrimitiveRecipeBuilder)((PrimitiveRecipeBuilder)RecipeMaps.PRIMITIVE_BLAST_FURNACE_RECIPES.recipeBuilder().input(OrePrefix.block, Materials.WroughtIron)).input(OrePrefix.block, Materials.Coal, 2)).output(OrePrefix.block, Materials.Steel)).output(OrePrefix.dust, Materials.DarkAsh, 2)).duration(7200)).buildAndRegister();
        ((PrimitiveRecipeBuilder)((PrimitiveRecipeBuilder)((PrimitiveRecipeBuilder)((PrimitiveRecipeBuilder)((PrimitiveRecipeBuilder)RecipeMaps.PRIMITIVE_BLAST_FURNACE_RECIPES.recipeBuilder().input(OrePrefix.block, Materials.WroughtIron)).input(OrePrefix.block, Materials.Charcoal, 2)).output(OrePrefix.block, Materials.Steel)).output(OrePrefix.dust, Materials.DarkAsh, 2)).duration(7200)).buildAndRegister();
        ((PrimitiveRecipeBuilder)((PrimitiveRecipeBuilder)((PrimitiveRecipeBuilder)((PrimitiveRecipeBuilder)((PrimitiveRecipeBuilder)RecipeMaps.PRIMITIVE_BLAST_FURNACE_RECIPES.recipeBuilder().input(OrePrefix.block, Materials.WroughtIron)).input("blockFuelCoke")).output(OrePrefix.block, Materials.Steel)).output(OrePrefix.dust, Materials.Ash)).duration(5400)).buildAndRegister();
    }

    private static void registerCokeOvenRecipes() {
        ((PrimitiveRecipeBuilder)((PrimitiveRecipeBuilder)((PrimitiveRecipeBuilder)((PrimitiveRecipeBuilder)RecipeMaps.COKE_OVEN_RECIPES.recipeBuilder().input(OrePrefix.log, Materials.Wood)).output(OrePrefix.gem, Materials.Charcoal)).fluidOutputs(Materials.Creosote.getFluid(250))).duration(900)).buildAndRegister();
        ((PrimitiveRecipeBuilder)((PrimitiveRecipeBuilder)((PrimitiveRecipeBuilder)((PrimitiveRecipeBuilder)RecipeMaps.COKE_OVEN_RECIPES.recipeBuilder().input(OrePrefix.gem, Materials.Coal)).output(OrePrefix.gem, Materials.Coke)).fluidOutputs(Materials.Creosote.getFluid(500))).duration(900)).buildAndRegister();
        ((PrimitiveRecipeBuilder)((PrimitiveRecipeBuilder)((PrimitiveRecipeBuilder)((PrimitiveRecipeBuilder)RecipeMaps.COKE_OVEN_RECIPES.recipeBuilder().input(OrePrefix.block, Materials.Coal)).output(OrePrefix.block, Materials.Coke)).fluidOutputs(Materials.Creosote.getFluid(4500))).duration(8100)).buildAndRegister();
    }

    private static void registerStoneBricksRecipes() {
        EnumMap variantListMap = new EnumMap(StoneVariantBlock.StoneVariant.class);
        for (StoneVariantBlock.StoneVariant shape : StoneVariantBlock.StoneVariant.values()) {
            StoneVariantBlock block = MetaBlocks.STONE_BLOCKS.get((Object)shape);
            variantListMap.put(shape, Arrays.stream(StoneVariantBlock.StoneType.values()).map(block::getItemVariant).collect(Collectors.toList()));
        }
        List cobbles = (List)variantListMap.get((Object)StoneVariantBlock.StoneVariant.COBBLE);
        List mossCobbles = (List)variantListMap.get((Object)StoneVariantBlock.StoneVariant.COBBLE_MOSSY);
        List smooths = (List)variantListMap.get((Object)StoneVariantBlock.StoneVariant.SMOOTH);
        List polisheds = (List)variantListMap.get((Object)StoneVariantBlock.StoneVariant.POLISHED);
        List bricks = (List)variantListMap.get((Object)StoneVariantBlock.StoneVariant.BRICKS);
        List crackedBricks = (List)variantListMap.get((Object)StoneVariantBlock.StoneVariant.BRICKS_CRACKED);
        List mossBricks = (List)variantListMap.get((Object)StoneVariantBlock.StoneVariant.BRICKS_MOSSY);
        List chiseledBricks = (List)variantListMap.get((Object)StoneVariantBlock.StoneVariant.CHISELED);
        List tiledBricks = (List)variantListMap.get((Object)StoneVariantBlock.StoneVariant.TILED);
        List smallTiledBricks = (List)variantListMap.get((Object)StoneVariantBlock.StoneVariant.TILED_SMALL);
        List windmillA = (List)variantListMap.get((Object)StoneVariantBlock.StoneVariant.WINDMILL_A);
        List windmillB = (List)variantListMap.get((Object)StoneVariantBlock.StoneVariant.WINDMILL_B);
        List squareBricks = (List)variantListMap.get((Object)StoneVariantBlock.StoneVariant.BRICKS_SQUARE);
        List smallBricks = (List)variantListMap.get((Object)StoneVariantBlock.StoneVariant.BRICKS_SMALL);
        MachineRecipeLoader.registerSmoothRecipe(cobbles, smooths);
        MachineRecipeLoader.registerCobbleRecipe(smooths, cobbles);
        MachineRecipeLoader.registerMossRecipe(cobbles, mossCobbles);
        MachineRecipeLoader.registerSmoothRecipe(smooths, polisheds);
        MachineRecipeLoader.registerBricksRecipe(polisheds, bricks, MarkerMaterials.Color.LightBlue);
        MachineRecipeLoader.registerCobbleRecipe(bricks, crackedBricks);
        MachineRecipeLoader.registerMossRecipe(bricks, mossBricks);
        MachineRecipeLoader.registerBricksRecipe(polisheds, chiseledBricks, MarkerMaterials.Color.White);
        MachineRecipeLoader.registerBricksRecipe(polisheds, tiledBricks, MarkerMaterials.Color.Red);
        MachineRecipeLoader.registerBricksRecipe(tiledBricks, smallTiledBricks, MarkerMaterials.Color.Red);
        MachineRecipeLoader.registerBricksRecipe(polisheds, windmillA, MarkerMaterials.Color.Blue);
        MachineRecipeLoader.registerBricksRecipe(polisheds, windmillB, MarkerMaterials.Color.Yellow);
        MachineRecipeLoader.registerBricksRecipe(polisheds, squareBricks, MarkerMaterials.Color.Green);
        MachineRecipeLoader.registerBricksRecipe(polisheds, smallBricks, MarkerMaterials.Color.Pink);
        for (int i = 0; i < smooths.size(); ++i) {
            ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.EXTRUDER_RECIPES.recipeBuilder().inputs((ItemStack)smooths.get(i))).notConsumable(MetaItems.SHAPE_EXTRUDER_INGOT.getStackForm())).outputs((ItemStack)bricks.get(i))).duration(24)).EUt(8)).buildAndRegister();
        }
    }

    private static void registerMixingCrystallizationRecipes() {
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.AUTOCLAVE_RECIPES.recipeBuilder().input(OrePrefix.dust, Materials.SiliconDioxide)).fluidInputs(Materials.DistilledWater.getFluid(250))).chancedOutput(OreDictUnifier.get(OrePrefix.gem, Materials.Quartzite), 1000, 1000)).duration(1200)).EUt(24)).buildAndRegister();
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.MIXER_RECIPES.recipeBuilder().input(OrePrefix.crushedPurified, Materials.Sphalerite)).input(OrePrefix.crushedPurified, Materials.Galena)).fluidInputs(Materials.SulfuricAcid.getFluid(4000))).fluidOutputs(Materials.IndiumConcentrate.getFluid(1000))).duration(60)).EUt(150)).buildAndRegister();
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.MIXER_RECIPES.recipeBuilder().input(OrePrefix.dust, Materials.Coal)).fluidInputs(Materials.Concrete.getFluid(144))).outputs(MetaBlocks.ASPHALT.getItemVariant(BlockAsphalt.BlockType.ASPHALT))).duration(60)).EUt(16)).buildAndRegister();
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.MIXER_RECIPES.recipeBuilder().input(OrePrefix.dust, Materials.Charcoal)).fluidInputs(Materials.Concrete.getFluid(144))).outputs(MetaBlocks.ASPHALT.getItemVariant(BlockAsphalt.BlockType.ASPHALT))).duration(60)).EUt(16)).buildAndRegister();
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.MIXER_RECIPES.recipeBuilder().input(OrePrefix.dust, Materials.Carbon)).fluidInputs(Materials.Concrete.getFluid(144))).outputs(MetaBlocks.ASPHALT.getItemVariant(BlockAsphalt.BlockType.ASPHALT))).duration(60)).EUt(16)).buildAndRegister();
    }

    private static void registerAlloyRecipes() {
        for (MaterialStack[] stack : alloySmelterList) {
            if (stack[0].material.hasProperty(PropertyKey.INGOT)) {
                ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.ALLOY_SMELTER_RECIPES.recipeBuilder().duration((int)stack[2].amount * 50)).EUt(16)).input(OrePrefix.ingot, stack[0].material, (int)stack[0].amount)).input(OrePrefix.dust, stack[1].material, (int)stack[1].amount)).outputs(OreDictUnifier.get(OrePrefix.ingot, stack[2].material, (int)stack[2].amount))).buildAndRegister();
            }
            if (stack[1].material.hasProperty(PropertyKey.INGOT)) {
                ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.ALLOY_SMELTER_RECIPES.recipeBuilder().duration((int)stack[2].amount * 50)).EUt(16)).input(OrePrefix.dust, stack[0].material, (int)stack[0].amount)).input(OrePrefix.ingot, stack[1].material, (int)stack[1].amount)).outputs(OreDictUnifier.get(OrePrefix.ingot, stack[2].material, (int)stack[2].amount))).buildAndRegister();
            }
            if (stack[0].material.hasProperty(PropertyKey.INGOT) && stack[1].material.hasProperty(PropertyKey.INGOT)) {
                ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.ALLOY_SMELTER_RECIPES.recipeBuilder().duration((int)stack[2].amount * 50)).EUt(16)).input(OrePrefix.ingot, stack[0].material, (int)stack[0].amount)).input(OrePrefix.ingot, stack[1].material, (int)stack[1].amount)).outputs(OreDictUnifier.get(OrePrefix.ingot, stack[2].material, (int)stack[2].amount))).buildAndRegister();
            }
            ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.ALLOY_SMELTER_RECIPES.recipeBuilder().duration((int)stack[2].amount * 50)).EUt(16)).input(OrePrefix.dust, stack[0].material, (int)stack[0].amount)).input(OrePrefix.dust, stack[1].material, (int)stack[1].amount)).outputs(OreDictUnifier.get(OrePrefix.ingot, stack[2].material, (int)stack[2].amount))).buildAndRegister();
        }
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.COMPRESSOR_RECIPES.recipeBuilder().inputs(MetaItems.CARBON_FIBERS.getStackForm(2))).outputs(MetaItems.CARBON_MESH.getStackForm())).duration(100)).buildAndRegister();
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.COMPRESSOR_RECIPES.recipeBuilder().inputs(MetaItems.CARBON_MESH.getStackForm())).outputs(MetaItems.CARBON_FIBER_PLATE.getStackForm())).buildAndRegister();
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.ALLOY_SMELTER_RECIPES.recipeBuilder().duration(10)).EUt(GTValues.VA[0])).input(OrePrefix.ingot, Materials.Rubber, 2)).notConsumable(MetaItems.SHAPE_MOLD_PLATE)).output(OrePrefix.plate, Materials.Rubber)).buildAndRegister();
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.ALLOY_SMELTER_RECIPES.recipeBuilder().duration(100)).EUt(GTValues.VA[0])).input(OrePrefix.dust, Materials.Sulfur)).input(OrePrefix.dust, Materials.RawRubber, 3)).output(OrePrefix.ingot, Materials.Rubber)).buildAndRegister();
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.ALLOY_SMELTER_RECIPES.recipeBuilder().duration(150)).EUt(GTValues.VA[0])).inputs(OreDictUnifier.get("sand"))).inputs(new ItemStack(Items.field_151119_aD))).outputs(MetaItems.COKE_OVEN_BRICK.getStackForm(2))).buildAndRegister();
    }

    private static void registerAssemblerRecipes() {
        for (int i = 0; i < Materials.CHEMICAL_DYES.length; ++i) {
            int lampMeta;
            ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.CANNER_RECIPES.recipeBuilder().inputs(MetaItems.SPRAY_EMPTY.getStackForm())).fluidInputs(Materials.CHEMICAL_DYES[i].getFluid(576))).outputs(MetaItems.SPRAY_CAN_DYES[i].getStackForm())).EUt(GTValues.VA[0])).duration(200)).buildAndRegister();
            EnumDyeColor color = EnumDyeColor.func_176764_b((int)i);
            BlockLamp lamp = MetaBlocks.LAMPS.get(color);
            for (lampMeta = 0; lampMeta < lamp.getItemMetadataStates(); ++lampMeta) {
                ((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)RecipeMaps.ASSEMBLER_RECIPES.recipeBuilder().input(OrePrefix.plate, Materials.Glass, 6)).input(OrePrefix.dust, Materials.Glowstone, 1)).fluidInputs(Materials.CHEMICAL_DYES[i].getFluid(144))).outputs(new ItemStack((Block)lamp, 6, lampMeta))).circuitMeta(lampMeta + 1)).EUt(GTValues.VA[0])).duration(40)).buildAndRegister();
                ((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)RecipeMaps.ASSEMBLER_RECIPES.recipeBuilder().input(OrePrefix.lampGt, (Material)MarkerMaterials.Color.COLORS.get((Object)color))).outputs(new ItemStack((Block)lamp, 1, lampMeta))).circuitMeta(lampMeta + 1)).EUt(GTValues.VA[0])).duration(10)).buildAndRegister();
            }
            lamp = MetaBlocks.BORDERLESS_LAMPS.get(color);
            for (lampMeta = 0; lampMeta < lamp.getItemMetadataStates(); ++lampMeta) {
                ((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)RecipeMaps.ASSEMBLER_RECIPES.recipeBuilder().input(OrePrefix.plate, Materials.Glass, 6)).input(OrePrefix.dust, Materials.Glowstone, 1)).fluidInputs(Materials.CHEMICAL_DYES[i].getFluid(144))).outputs(new ItemStack((Block)lamp, 6, lampMeta))).circuitMeta(lampMeta + 9)).EUt(GTValues.VA[0])).duration(40)).buildAndRegister();
                ((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)RecipeMaps.ASSEMBLER_RECIPES.recipeBuilder().input(OrePrefix.lampGt, (Material)MarkerMaterials.Color.COLORS.get((Object)color))).outputs(new ItemStack((Block)lamp, 1, lampMeta))).circuitMeta(lampMeta + 9)).EUt(GTValues.VA[0])).duration(10)).buildAndRegister();
            }
        }
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.CANNER_RECIPES.recipeBuilder().input(MetaItems.SPRAY_EMPTY)).fluidInputs(Materials.Acetone.getFluid(1000))).output(MetaItems.SPRAY_SOLVENT)).EUt(GTValues.VA[0])).duration(200)).buildAndRegister();
        Material material = Materials.Iron;
        ((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)RecipeMaps.ASSEMBLER_RECIPES.recipeBuilder().inputs(new ItemStack(Items.field_151139_aw))).input(OrePrefix.plate, material, 2)).outputs(MetaItems.COVER_SHUTTER.getStackForm(2))).EUt(16)).duration(100)).buildAndRegister();
        FluidStack solder = Materials.SolderingAlloy.getFluid(72);
        ((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)RecipeMaps.ASSEMBLER_RECIPES.recipeBuilder().inputs(new ItemStack(Blocks.field_150442_at))).input(OrePrefix.plate, material)).fluidInputs(solder)).outputs(MetaItems.COVER_MACHINE_CONTROLLER.getStackForm(1))).EUt(16)).duration(100)).buildAndRegister();
        ((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)RecipeMaps.ASSEMBLER_RECIPES.recipeBuilder().input(OrePrefix.cableGtSingle, Materials.Copper, 4)).input(OrePrefix.circuit, MarkerMaterials.Tier.LV)).input(OrePrefix.plate, material)).fluidInputs(solder)).outputs(MetaItems.COVER_ENERGY_DETECTOR.getStackForm())).EUt(16)).duration(100)).buildAndRegister();
        ((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)RecipeMaps.ASSEMBLER_RECIPES.recipeBuilder().input(MetaItems.COVER_ENERGY_DETECTOR)).input(MetaItems.SENSOR_HV)).fluidInputs(solder)).output(MetaItems.COVER_ENERGY_DETECTOR_ADVANCED)).EUt(16)).duration(100)).buildAndRegister();
        ((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)RecipeMaps.ASSEMBLER_RECIPES.recipeBuilder().inputs(new ItemStack(Blocks.field_150429_aA))).input(OrePrefix.plate, material)).fluidInputs(solder)).outputs(MetaItems.COVER_ACTIVITY_DETECTOR.getStackForm())).EUt(16)).duration(100)).buildAndRegister();
        ((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)RecipeMaps.ASSEMBLER_RECIPES.recipeBuilder().input(OrePrefix.wireFine, Materials.Gold, 4)).input(OrePrefix.circuit, MarkerMaterials.Tier.HV)).input(OrePrefix.plate, Materials.Aluminium)).fluidInputs(solder)).outputs(MetaItems.COVER_ACTIVITY_DETECTOR_ADVANCED.getStackForm())).EUt(16)).duration(100)).buildAndRegister();
        ((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)RecipeMaps.ASSEMBLER_RECIPES.recipeBuilder().inputs(new ItemStack(Blocks.field_150443_bT))).input(OrePrefix.plate, material)).fluidInputs(solder)).outputs(MetaItems.COVER_FLUID_DETECTOR.getStackForm())).EUt(16)).duration(100)).buildAndRegister();
        ((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)RecipeMaps.ASSEMBLER_RECIPES.recipeBuilder().inputs(new ItemStack(Blocks.field_150445_bS))).input(OrePrefix.plate, material)).fluidInputs(solder)).outputs(MetaItems.COVER_ITEM_DETECTOR.getStackForm())).EUt(16)).duration(100)).buildAndRegister();
        ((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)RecipeMaps.ASSEMBLER_RECIPES.recipeBuilder().input(MetaItems.COVER_FLUID_DETECTOR)).input(MetaItems.SENSOR_HV)).fluidInputs(solder)).outputs(MetaItems.COVER_FLUID_DETECTOR_ADVANCED.getStackForm())).EUt(16)).duration(100)).buildAndRegister();
        ((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)RecipeMaps.ASSEMBLER_RECIPES.recipeBuilder().input(MetaItems.COVER_ITEM_DETECTOR)).input(MetaItems.SENSOR_HV)).fluidInputs(solder)).outputs(MetaItems.COVER_ITEM_DETECTOR_ADVANCED.getStackForm())).EUt(16)).duration(100)).buildAndRegister();
        ((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)RecipeMaps.ASSEMBLER_RECIPES.recipeBuilder().input(MetaItems.EMITTER_LV)).input(OrePrefix.plate, Materials.Steel)).circuitMeta(1)).fluidInputs(solder)).outputs(MetaItems.COVER_MAINTENANCE_DETECTOR.getStackForm())).EUt(16)).duration(100)).buildAndRegister();
        ((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)RecipeMaps.ASSEMBLER_RECIPES.recipeBuilder().input(OrePrefix.plate, Materials.Glass)).input(OrePrefix.foil, Materials.Aluminium, 4)).input(OrePrefix.circuit, MarkerMaterials.Tier.LV)).input(OrePrefix.wireFine, Materials.Copper, 4)).outputs(MetaItems.COVER_SCREEN.getStackForm())).EUt(16)).duration(50)).buildAndRegister();
        ((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)RecipeMaps.ASSEMBLER_RECIPES.recipeBuilder().input(MetaItems.ELECTRIC_PUMP_HV, 2)).inputs(new ItemStack(Items.field_151066_bu))).input(OrePrefix.circuit, MarkerMaterials.Tier.HV)).output(MetaItems.COVER_INFINITE_WATER)).EUt(GTValues.VA[3])).duration(100)).buildAndRegister();
        ((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)RecipeMaps.ASSEMBLER_RECIPES.recipeBuilder().input(OrePrefix.plate, Materials.EnderPearl, 9)).input(OrePrefix.plateDouble, Materials.StainlessSteel)).input(MetaItems.SENSOR_HV)).input(MetaItems.EMITTER_HV)).input(MetaItems.ELECTRIC_PUMP_HV)).fluidInputs(Materials.Polyethylene.getFluid(288))).output(MetaItems.COVER_ENDER_FLUID_LINK)).EUt(GTValues.VA[3])).duration(320)).buildAndRegister();
        ((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)RecipeMaps.ASSEMBLER_RECIPES.recipeBuilder().input(OreDictNames.chestWood.toString())).input(MetaItems.ELECTRIC_PISTON_LV)).input(OrePrefix.plate, Materials.Iron)).fluidInputs(Materials.SolderingAlloy.getFluid(72))).output(MetaItems.COVER_STORAGE)).EUt(16)).duration(100)).buildAndRegister();
        ((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)RecipeMaps.ASSEMBLER_RECIPES.recipeBuilder().EUt(16)).input(OrePrefix.plate, Materials.WroughtIron, 8)).outputs(MetaBlocks.MACHINE_CASING.getItemVariant(BlockMachineCasing.MachineCasingType.ULV))).circuitMeta(8)).duration(25)).buildAndRegister();
        ((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)RecipeMaps.ASSEMBLER_RECIPES.recipeBuilder().EUt(16)).input(OrePrefix.plate, Materials.Steel, 8)).outputs(MetaBlocks.MACHINE_CASING.getItemVariant(BlockMachineCasing.MachineCasingType.LV))).circuitMeta(8)).duration(50)).buildAndRegister();
        ((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)RecipeMaps.ASSEMBLER_RECIPES.recipeBuilder().EUt(16)).input(OrePrefix.plate, Materials.Aluminium, 8)).outputs(MetaBlocks.MACHINE_CASING.getItemVariant(BlockMachineCasing.MachineCasingType.MV))).circuitMeta(8)).duration(50)).buildAndRegister();
        ((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)RecipeMaps.ASSEMBLER_RECIPES.recipeBuilder().EUt(16)).input(OrePrefix.plate, Materials.StainlessSteel, 8)).outputs(MetaBlocks.MACHINE_CASING.getItemVariant(BlockMachineCasing.MachineCasingType.HV))).circuitMeta(8)).duration(50)).buildAndRegister();
        ((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)RecipeMaps.ASSEMBLER_RECIPES.recipeBuilder().EUt(16)).input(OrePrefix.plate, Materials.Titanium, 8)).outputs(MetaBlocks.MACHINE_CASING.getItemVariant(BlockMachineCasing.MachineCasingType.EV))).circuitMeta(8)).duration(50)).buildAndRegister();
        ((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)RecipeMaps.ASSEMBLER_RECIPES.recipeBuilder().EUt(16)).input(OrePrefix.plate, Materials.TungstenSteel, 8)).outputs(MetaBlocks.MACHINE_CASING.getItemVariant(BlockMachineCasing.MachineCasingType.IV))).circuitMeta(8)).duration(50)).buildAndRegister();
        ((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)RecipeMaps.ASSEMBLER_RECIPES.recipeBuilder().EUt(16)).input(OrePrefix.plate, Materials.RhodiumPlatedPalladium, 8)).outputs(MetaBlocks.MACHINE_CASING.getItemVariant(BlockMachineCasing.MachineCasingType.LuV))).circuitMeta(8)).duration(50)).buildAndRegister();
        ((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)RecipeMaps.ASSEMBLER_RECIPES.recipeBuilder().EUt(16)).input(OrePrefix.plate, Materials.NaquadahAlloy, 8)).outputs(MetaBlocks.MACHINE_CASING.getItemVariant(BlockMachineCasing.MachineCasingType.ZPM))).circuitMeta(8)).duration(50)).buildAndRegister();
        ((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)RecipeMaps.ASSEMBLER_RECIPES.recipeBuilder().EUt(16)).input(OrePrefix.plate, Materials.Darmstadtium, 8)).outputs(MetaBlocks.MACHINE_CASING.getItemVariant(BlockMachineCasing.MachineCasingType.UV))).circuitMeta(8)).duration(50)).buildAndRegister();
        ((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)RecipeMaps.ASSEMBLER_RECIPES.recipeBuilder().EUt(16)).input(OrePrefix.plate, Materials.Neutronium, 8)).outputs(MetaBlocks.MACHINE_CASING.getItemVariant(BlockMachineCasing.MachineCasingType.UHV))).circuitMeta(8)).duration(50)).buildAndRegister();
        ((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)RecipeMaps.ASSEMBLER_RECIPES.recipeBuilder().EUt(GTValues.VA[1])).input(OrePrefix.wireGtDouble, Materials.Cupronickel, 8)).input(OrePrefix.foil, Materials.Bronze, 8)).fluidInputs(Materials.TinAlloy.getFluid(144))).outputs(MetaBlocks.WIRE_COIL.getItemVariant(BlockWireCoil.CoilType.CUPRONICKEL))).duration(200)).buildAndRegister();
        ((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)RecipeMaps.ASSEMBLER_RECIPES.recipeBuilder().EUt(GTValues.VA[2])).input(OrePrefix.wireGtDouble, Materials.Kanthal, 8)).input(OrePrefix.foil, Materials.Aluminium, 8)).fluidInputs(Materials.Copper.getFluid(144))).outputs(MetaBlocks.WIRE_COIL.getItemVariant(BlockWireCoil.CoilType.KANTHAL))).duration(300)).buildAndRegister();
        ((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)RecipeMaps.ASSEMBLER_RECIPES.recipeBuilder().EUt(GTValues.VA[3])).input(OrePrefix.wireGtDouble, Materials.Nichrome, 8)).input(OrePrefix.foil, Materials.StainlessSteel, 8)).fluidInputs(Materials.Aluminium.getFluid(144))).outputs(MetaBlocks.WIRE_COIL.getItemVariant(BlockWireCoil.CoilType.NICHROME))).duration(400)).buildAndRegister();
        ((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)RecipeMaps.ASSEMBLER_RECIPES.recipeBuilder().EUt(GTValues.VA[4])).input(OrePrefix.wireGtDouble, Materials.RTMAlloy, 8)).input(OrePrefix.foil, Materials.VanadiumSteel, 8)).fluidInputs(Materials.Nichrome.getFluid(144))).outputs(MetaBlocks.WIRE_COIL.getItemVariant(BlockWireCoil.CoilType.RTM_ALLOY))).duration(500)).buildAndRegister();
        ((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)RecipeMaps.ASSEMBLER_RECIPES.recipeBuilder().EUt(GTValues.VA[5])).input(OrePrefix.wireGtDouble, Materials.HSSG, 8)).input(OrePrefix.foil, Materials.TungstenCarbide, 8)).fluidInputs(Materials.Tungsten.getFluid(144))).outputs(MetaBlocks.WIRE_COIL.getItemVariant(BlockWireCoil.CoilType.HSS_G))).duration(600)).buildAndRegister();
        ((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)RecipeMaps.ASSEMBLER_RECIPES.recipeBuilder().EUt(GTValues.VA[6])).input(OrePrefix.wireGtDouble, Materials.Naquadah, 8)).input(OrePrefix.foil, Materials.Osmium, 8)).fluidInputs(Materials.TungstenSteel.getFluid(144))).outputs(MetaBlocks.WIRE_COIL.getItemVariant(BlockWireCoil.CoilType.NAQUADAH))).duration(700)).buildAndRegister();
        ((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)RecipeMaps.ASSEMBLER_RECIPES.recipeBuilder().EUt(GTValues.VA[7])).input(OrePrefix.wireGtDouble, Materials.Trinium, 8)).input(OrePrefix.foil, Materials.NaquadahEnriched, 8)).fluidInputs(Materials.Naquadah.getFluid(144))).outputs(MetaBlocks.WIRE_COIL.getItemVariant(BlockWireCoil.CoilType.TRINIUM))).duration(800)).buildAndRegister();
        ((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)RecipeMaps.ASSEMBLER_RECIPES.recipeBuilder().EUt(GTValues.VA[8])).input(OrePrefix.wireGtDouble, Materials.Tritanium, 8)).input(OrePrefix.foil, Materials.Naquadria, 8)).fluidInputs(Materials.Trinium.getFluid(144))).outputs(MetaBlocks.WIRE_COIL.getItemVariant(BlockWireCoil.CoilType.TRITANIUM))).duration(900)).buildAndRegister();
        ((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)RecipeMaps.ASSEMBLER_RECIPES.recipeBuilder().EUt(16)).input(OrePrefix.plate, Materials.Bronze, 6)).inputs(new ItemStack(Blocks.field_150336_V, 1))).circuitMeta(6)).outputs(MetaBlocks.METAL_CASING.getItemVariant(BlockMetalCasing.MetalCasingType.BRONZE_BRICKS, ConfigHolder.recipes.casingsPerCraft))).duration(50)).buildAndRegister();
        ((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)RecipeMaps.ASSEMBLER_RECIPES.recipeBuilder().EUt(16)).input(OrePrefix.plate, Materials.Invar, 6)).input(OrePrefix.frameGt, Materials.Invar, 1)).circuitMeta(6)).outputs(MetaBlocks.METAL_CASING.getItemVariant(BlockMetalCasing.MetalCasingType.INVAR_HEATPROOF, ConfigHolder.recipes.casingsPerCraft))).duration(50)).buildAndRegister();
        ((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)RecipeMaps.ASSEMBLER_RECIPES.recipeBuilder().EUt(16)).input(OrePrefix.plate, Materials.Steel, 6)).input(OrePrefix.frameGt, Materials.Steel, 1)).circuitMeta(6)).outputs(MetaBlocks.METAL_CASING.getItemVariant(BlockMetalCasing.MetalCasingType.STEEL_SOLID, ConfigHolder.recipes.casingsPerCraft))).duration(50)).buildAndRegister();
        ((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)RecipeMaps.ASSEMBLER_RECIPES.recipeBuilder().EUt(16)).input(OrePrefix.plate, Materials.Aluminium, 6)).input(OrePrefix.frameGt, Materials.Aluminium, 1)).circuitMeta(6)).outputs(MetaBlocks.METAL_CASING.getItemVariant(BlockMetalCasing.MetalCasingType.ALUMINIUM_FROSTPROOF, ConfigHolder.recipes.casingsPerCraft))).duration(50)).buildAndRegister();
        ((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)RecipeMaps.ASSEMBLER_RECIPES.recipeBuilder().EUt(16)).input(OrePrefix.plate, Materials.TungstenSteel, 6)).input(OrePrefix.frameGt, Materials.TungstenSteel, 1)).circuitMeta(6)).outputs(MetaBlocks.METAL_CASING.getItemVariant(BlockMetalCasing.MetalCasingType.TUNGSTENSTEEL_ROBUST, ConfigHolder.recipes.casingsPerCraft))).duration(50)).buildAndRegister();
        ((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)RecipeMaps.ASSEMBLER_RECIPES.recipeBuilder().EUt(16)).input(OrePrefix.plate, Materials.StainlessSteel, 6)).input(OrePrefix.frameGt, Materials.StainlessSteel, 1)).circuitMeta(6)).outputs(MetaBlocks.METAL_CASING.getItemVariant(BlockMetalCasing.MetalCasingType.STAINLESS_CLEAN, ConfigHolder.recipes.casingsPerCraft))).duration(50)).buildAndRegister();
        ((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)RecipeMaps.ASSEMBLER_RECIPES.recipeBuilder().EUt(16)).input(OrePrefix.plate, Materials.Titanium, 6)).input(OrePrefix.frameGt, Materials.Titanium, 1)).circuitMeta(6)).outputs(MetaBlocks.METAL_CASING.getItemVariant(BlockMetalCasing.MetalCasingType.TITANIUM_STABLE, ConfigHolder.recipes.casingsPerCraft))).duration(50)).buildAndRegister();
        ((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)RecipeMaps.ASSEMBLER_RECIPES.recipeBuilder().EUt(16)).input(OrePrefix.plate, Materials.HSSE, 6)).input(OrePrefix.frameGt, Materials.Europium)).circuitMeta(6)).outputs(MetaBlocks.METAL_CASING.getItemVariant(BlockMetalCasing.MetalCasingType.HSSE_STURDY, ConfigHolder.recipes.casingsPerCraft))).duration(50)).buildAndRegister();
        ((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)RecipeMaps.ASSEMBLER_RECIPES.recipeBuilder().EUt(16)).input(OrePrefix.plate, Materials.Palladium, 6)).input(OrePrefix.frameGt, Materials.Iridium)).circuitMeta(6)).outputs(MetaBlocks.METAL_CASING.getItemVariant(BlockMetalCasing.MetalCasingType.PALLADIUM_SUBSTATION, ConfigHolder.recipes.casingsPerCraft))).duration(50)).buildAndRegister();
        ((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)RecipeMaps.ASSEMBLER_RECIPES.recipeBuilder().EUt(16)).inputs(MetaBlocks.METAL_CASING.getItemVariant(BlockMetalCasing.MetalCasingType.STEEL_SOLID))).fluidInputs(Materials.Polytetrafluoroethylene.getFluid(216))).circuitMeta(6)).outputs(MetaBlocks.METAL_CASING.getItemVariant(BlockMetalCasing.MetalCasingType.PTFE_INERT_CASING))).duration(50)).buildAndRegister();
        ((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)RecipeMaps.ASSEMBLER_RECIPES.recipeBuilder().EUt(GTValues.VA[6])).input(OrePrefix.wireGtDouble, Materials.IndiumTinBariumTitaniumCuprate, 32)).input(OrePrefix.foil, Materials.NiobiumTitanium, 32)).fluidInputs(Materials.Trinium.getFluid(3456))).outputs(MetaBlocks.FUSION_CASING.getItemVariant(BlockFusionCasing.CasingType.SUPERCONDUCTOR_COIL))).duration(100)).buildAndRegister();
        ((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)RecipeMaps.ASSEMBLER_RECIPES.recipeBuilder().EUt(GTValues.VA[7])).input(OrePrefix.wireGtDouble, Materials.UraniumRhodiumDinaquadide, 16)).input(OrePrefix.foil, Materials.NiobiumTitanium, 16)).fluidInputs(Materials.Trinium.getFluid(2304))).outputs(MetaBlocks.FUSION_CASING.getItemVariant(BlockFusionCasing.CasingType.SUPERCONDUCTOR_COIL))).duration(100)).buildAndRegister();
        ((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)RecipeMaps.ASSEMBLER_RECIPES.recipeBuilder().EUt(GTValues.VA[8])).input(OrePrefix.wireGtDouble, Materials.EnrichedNaquadahTriniumEuropiumDuranide, 8)).input(OrePrefix.foil, Materials.NiobiumTitanium, 8)).fluidInputs(Materials.Trinium.getFluid(1152))).outputs(MetaBlocks.FUSION_CASING.getItemVariant(BlockFusionCasing.CasingType.SUPERCONDUCTOR_COIL))).duration(100)).buildAndRegister();
        ((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)RecipeMaps.ASSEMBLER_RECIPES.recipeBuilder().EUt(GTValues.VA[8])).input(OrePrefix.wireGtDouble, Materials.RutheniumTriniumAmericiumNeutronate, 4)).input(OrePrefix.foil, Materials.NiobiumTitanium, 4)).fluidInputs(Materials.Trinium.getFluid(576))).outputs(MetaBlocks.FUSION_CASING.getItemVariant(BlockFusionCasing.CasingType.SUPERCONDUCTOR_COIL))).duration(200)).buildAndRegister();
        ((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)RecipeMaps.ASSEMBLER_RECIPES.recipeBuilder().EUt(GTValues.VA[7])).inputs(MetaBlocks.FUSION_CASING.getItemVariant(BlockFusionCasing.CasingType.SUPERCONDUCTOR_COIL))).inputs(MetaItems.FIELD_GENERATOR_IV.getStackForm(2))).inputs(MetaItems.ELECTRIC_PUMP_IV.getStackForm())).inputs(MetaItems.NEUTRON_REFLECTOR.getStackForm(2))).input(OrePrefix.circuit, MarkerMaterials.Tier.LuV, 4)).input(OrePrefix.pipeSmallFluid, Materials.Naquadah, 4)).input(OrePrefix.plate, Materials.Europium, 4)).fluidInputs(Materials.VanadiumGallium.getFluid(576))).outputs(MetaBlocks.FUSION_CASING.getItemVariant(BlockFusionCasing.CasingType.FUSION_COIL))).duration(100)).cleanroom(CleanroomType.CLEANROOM)).buildAndRegister();
        ((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)RecipeMaps.ASSEMBLER_RECIPES.recipeBuilder().EUt(GTValues.VA[6])).inputs(MetaBlocks.TRANSPARENT_CASING.getItemVariant(BlockGlassCasing.CasingType.LAMINATED_GLASS))).input(OrePrefix.plate, Materials.Naquadah, 4)).inputs(MetaItems.NEUTRON_REFLECTOR.getStackForm(4))).outputs(MetaBlocks.TRANSPARENT_CASING.getItemVariant(BlockGlassCasing.CasingType.FUSION_GLASS, ConfigHolder.recipes.casingsPerCraft))).fluidInputs(Materials.Polybenzimidazole.getFluid(144))).duration(50)).cleanroom(CleanroomType.CLEANROOM)).buildAndRegister();
        ((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)RecipeMaps.ASSEMBLER_RECIPES.recipeBuilder().EUt(GTValues.VA[6])).inputs(MetaBlocks.MACHINE_CASING.getItemVariant(BlockMachineCasing.MachineCasingType.LuV))).inputs(MetaBlocks.FUSION_CASING.getItemVariant(BlockFusionCasing.CasingType.SUPERCONDUCTOR_COIL))).inputs(MetaItems.NEUTRON_REFLECTOR.getStackForm())).inputs(MetaItems.ELECTRIC_PUMP_LuV.getStackForm())).input(OrePrefix.plate, Materials.TungstenSteel, 6)).fluidInputs(Materials.Polybenzimidazole.getFluid(144))).outputs(MetaBlocks.FUSION_CASING.getItemVariant(BlockFusionCasing.CasingType.FUSION_CASING, ConfigHolder.recipes.casingsPerCraft))).duration(100)).cleanroom(CleanroomType.CLEANROOM)).buildAndRegister();
        ((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)RecipeMaps.ASSEMBLER_RECIPES.recipeBuilder().EUt(GTValues.VA[7])).inputs(MetaBlocks.MACHINE_CASING.getItemVariant(BlockMachineCasing.MachineCasingType.ZPM))).inputs(MetaBlocks.FUSION_CASING.getItemVariant(BlockFusionCasing.CasingType.FUSION_COIL))).inputs(MetaItems.VOLTAGE_COIL_ZPM.getStackForm(2))).inputs(MetaItems.FIELD_GENERATOR_LuV.getStackForm())).input(OrePrefix.plate, Materials.Europium, 6)).fluidInputs(Materials.Polybenzimidazole.getFluid(288))).outputs(MetaBlocks.FUSION_CASING.getItemVariant(BlockFusionCasing.CasingType.FUSION_CASING_MK2, ConfigHolder.recipes.casingsPerCraft))).duration(100)).cleanroom(CleanroomType.CLEANROOM)).buildAndRegister();
        ((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)RecipeMaps.ASSEMBLER_RECIPES.recipeBuilder().EUt(GTValues.VA[8])).inputs(MetaBlocks.MACHINE_CASING.getItemVariant(BlockMachineCasing.MachineCasingType.UV))).inputs(MetaBlocks.FUSION_CASING.getItemVariant(BlockFusionCasing.CasingType.FUSION_COIL))).inputs(MetaItems.VOLTAGE_COIL_UV.getStackForm(2))).inputs(MetaItems.FIELD_GENERATOR_ZPM.getStackForm())).input(OrePrefix.plate, Materials.Americium, 6)).fluidInputs(Materials.Polybenzimidazole.getFluid(576))).outputs(MetaBlocks.FUSION_CASING.getItemVariant(BlockFusionCasing.CasingType.FUSION_CASING_MK3, ConfigHolder.recipes.casingsPerCraft))).duration(100)).cleanroom(CleanroomType.CLEANROOM)).buildAndRegister();
        ((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)RecipeMaps.ASSEMBLER_RECIPES.recipeBuilder().EUt(16)).input(OrePrefix.plate, Materials.Magnalium, 6)).input(OrePrefix.frameGt, Materials.BlueSteel, 1)).circuitMeta(6)).outputs(MetaBlocks.TURBINE_CASING.getItemVariant(BlockTurbineCasing.TurbineCasingType.STEEL_TURBINE_CASING, ConfigHolder.recipes.casingsPerCraft))).duration(50)).buildAndRegister();
        ((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)RecipeMaps.ASSEMBLER_RECIPES.recipeBuilder().EUt(16)).inputs(MetaBlocks.TURBINE_CASING.getItemVariant(BlockTurbineCasing.TurbineCasingType.STEEL_TURBINE_CASING))).input(OrePrefix.plate, Materials.StainlessSteel, 6)).circuitMeta(6)).outputs(MetaBlocks.TURBINE_CASING.getItemVariant(BlockTurbineCasing.TurbineCasingType.STAINLESS_TURBINE_CASING, ConfigHolder.recipes.casingsPerCraft))).duration(50)).buildAndRegister();
        ((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)RecipeMaps.ASSEMBLER_RECIPES.recipeBuilder().EUt(16)).inputs(MetaBlocks.TURBINE_CASING.getItemVariant(BlockTurbineCasing.TurbineCasingType.STEEL_TURBINE_CASING))).input(OrePrefix.plate, Materials.Titanium, 6)).circuitMeta(6)).outputs(MetaBlocks.TURBINE_CASING.getItemVariant(BlockTurbineCasing.TurbineCasingType.TITANIUM_TURBINE_CASING, ConfigHolder.recipes.casingsPerCraft))).duration(50)).buildAndRegister();
        ((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)RecipeMaps.ASSEMBLER_RECIPES.recipeBuilder().EUt(16)).inputs(MetaBlocks.TURBINE_CASING.getItemVariant(BlockTurbineCasing.TurbineCasingType.STEEL_TURBINE_CASING))).input(OrePrefix.plate, Materials.TungstenSteel, 6)).circuitMeta(6)).outputs(MetaBlocks.TURBINE_CASING.getItemVariant(BlockTurbineCasing.TurbineCasingType.TUNGSTENSTEEL_TURBINE_CASING, ConfigHolder.recipes.casingsPerCraft))).duration(50)).buildAndRegister();
        ((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)RecipeMaps.ASSEMBLER_RECIPES.recipeBuilder().EUt(48)).input(OrePrefix.frameGt, Materials.Steel)).input(OrePrefix.plate, Materials.Polyethylene, 6)).fluidInputs(Materials.Concrete.getFluid(144))).outputs(MetaBlocks.CLEANROOM_CASING.getItemVariant(BlockCleanroomCasing.CasingType.PLASCRETE, ConfigHolder.recipes.casingsPerCraft))).duration(200)).buildAndRegister();
        ((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)RecipeMaps.ASSEMBLER_RECIPES.recipeBuilder().EUt(48)).input(OrePrefix.frameGt, Materials.Steel)).input(OrePrefix.plate, Materials.Polyethylene, 6)).fluidInputs(Materials.Glass.getFluid(144))).outputs(MetaBlocks.TRANSPARENT_CASING.getItemVariant(BlockGlassCasing.CasingType.CLEANROOM_GLASS, ConfigHolder.recipes.casingsPerCraft))).duration(200)).buildAndRegister();
        ((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)RecipeMaps.ASSEMBLER_RECIPES.recipeBuilder().duration(25)).EUt(16)).inputs(MetaBlocks.MACHINE_CASING.getItemVariant(BlockMachineCasing.MachineCasingType.ULV))).input(OrePrefix.cableGtSingle, Materials.RedAlloy, 2)).fluidInputs(Materials.Polyethylene.getFluid(288))).outputs(MetaTileEntities.HULL[0].getStackForm())).buildAndRegister();
        ((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)RecipeMaps.ASSEMBLER_RECIPES.recipeBuilder().duration(50)).EUt(16)).inputs(MetaBlocks.MACHINE_CASING.getItemVariant(BlockMachineCasing.MachineCasingType.LV))).input(OrePrefix.cableGtSingle, Materials.Tin, 2)).fluidInputs(Materials.Polyethylene.getFluid(288))).outputs(MetaTileEntities.HULL[1].getStackForm())).buildAndRegister();
        ((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)RecipeMaps.ASSEMBLER_RECIPES.recipeBuilder().duration(50)).EUt(16)).inputs(MetaBlocks.MACHINE_CASING.getItemVariant(BlockMachineCasing.MachineCasingType.MV))).input(OrePrefix.cableGtSingle, Materials.Copper, 2)).fluidInputs(Materials.Polyethylene.getFluid(288))).outputs(MetaTileEntities.HULL[2].getStackForm())).buildAndRegister();
        ((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)RecipeMaps.ASSEMBLER_RECIPES.recipeBuilder().duration(50)).EUt(16)).inputs(MetaBlocks.MACHINE_CASING.getItemVariant(BlockMachineCasing.MachineCasingType.MV))).input(OrePrefix.cableGtSingle, Materials.AnnealedCopper, 2)).fluidInputs(Materials.Polyethylene.getFluid(288))).outputs(MetaTileEntities.HULL[2].getStackForm())).buildAndRegister();
        ((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)RecipeMaps.ASSEMBLER_RECIPES.recipeBuilder().duration(50)).EUt(16)).inputs(MetaBlocks.MACHINE_CASING.getItemVariant(BlockMachineCasing.MachineCasingType.HV))).input(OrePrefix.cableGtSingle, Materials.Gold, 2)).fluidInputs(Materials.Polyethylene.getFluid(288))).outputs(MetaTileEntities.HULL[3].getStackForm())).buildAndRegister();
        ((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)RecipeMaps.ASSEMBLER_RECIPES.recipeBuilder().duration(50)).EUt(16)).inputs(MetaBlocks.MACHINE_CASING.getItemVariant(BlockMachineCasing.MachineCasingType.EV))).input(OrePrefix.cableGtSingle, Materials.Aluminium, 2)).fluidInputs(Materials.Polyethylene.getFluid(288))).outputs(MetaTileEntities.HULL[4].getStackForm())).buildAndRegister();
        ((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)RecipeMaps.ASSEMBLER_RECIPES.recipeBuilder().duration(50)).EUt(16)).inputs(MetaBlocks.MACHINE_CASING.getItemVariant(BlockMachineCasing.MachineCasingType.IV))).input(OrePrefix.cableGtSingle, Materials.Platinum, 2)).fluidInputs(Materials.Polytetrafluoroethylene.getFluid(288))).outputs(MetaTileEntities.HULL[5].getStackForm())).buildAndRegister();
        ((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)RecipeMaps.ASSEMBLER_RECIPES.recipeBuilder().duration(50)).EUt(16)).inputs(MetaBlocks.MACHINE_CASING.getItemVariant(BlockMachineCasing.MachineCasingType.LuV))).input(OrePrefix.cableGtSingle, Materials.NiobiumTitanium, 2)).fluidInputs(Materials.Polytetrafluoroethylene.getFluid(288))).outputs(MetaTileEntities.HULL[6].getStackForm())).buildAndRegister();
        ((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)RecipeMaps.ASSEMBLER_RECIPES.recipeBuilder().duration(50)).EUt(16)).inputs(MetaBlocks.MACHINE_CASING.getItemVariant(BlockMachineCasing.MachineCasingType.ZPM))).input(OrePrefix.cableGtSingle, Materials.VanadiumGallium, 2)).fluidInputs(Materials.Polybenzimidazole.getFluid(288))).outputs(MetaTileEntities.HULL[7].getStackForm())).buildAndRegister();
        ((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)RecipeMaps.ASSEMBLER_RECIPES.recipeBuilder().duration(50)).EUt(16)).inputs(MetaBlocks.MACHINE_CASING.getItemVariant(BlockMachineCasing.MachineCasingType.UV))).input(OrePrefix.cableGtSingle, Materials.YttriumBariumCuprate, 2)).fluidInputs(Materials.Polybenzimidazole.getFluid(288))).outputs(MetaTileEntities.HULL[8].getStackForm())).buildAndRegister();
        ((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)RecipeMaps.ASSEMBLER_RECIPES.recipeBuilder().duration(50)).EUt(16)).inputs(MetaBlocks.MACHINE_CASING.getItemVariant(BlockMachineCasing.MachineCasingType.UHV))).input(OrePrefix.cableGtSingle, Materials.Europium, 2)).fluidInputs(Materials.Polybenzimidazole.getFluid(288))).outputs(MetaTileEntities.HULL[9].getStackForm())).buildAndRegister();
        ((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)RecipeMaps.ASSEMBLER_RECIPES.recipeBuilder().EUt(2)).input(OreDictNames.chestWood.toString())).input(OrePrefix.plate, Materials.Iron, 5)).outputs(new ItemStack((Block)Blocks.field_150438_bZ))).duration(800)).circuitMeta(1)).buildAndRegister();
        ((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)RecipeMaps.ASSEMBLER_RECIPES.recipeBuilder().EUt(2)).input(OreDictNames.chestWood.toString())).input(OrePrefix.plate, Materials.WroughtIron, 5)).outputs(new ItemStack((Block)Blocks.field_150438_bZ))).duration(800)).circuitMeta(1)).buildAndRegister();
        ((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)RecipeMaps.ASSEMBLER_RECIPES.recipeBuilder().EUt(16)).input(OrePrefix.plank, Materials.Wood, 4)).input(OrePrefix.screw, Materials.Iron, 4)).outputs(MetaTileEntities.WOODEN_CRATE.getStackForm())).duration(100)).circuitMeta(5)).buildAndRegister();
        ((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)RecipeMaps.ASSEMBLER_RECIPES.recipeBuilder().EUt(16)).input(OrePrefix.stickLong, Materials.Bronze, 4)).input(OrePrefix.plate, Materials.Bronze, 4)).outputs(MetaTileEntities.BRONZE_CRATE.getStackForm())).duration(200)).circuitMeta(1)).buildAndRegister();
        ((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)RecipeMaps.ASSEMBLER_RECIPES.recipeBuilder().EUt(16)).input(OrePrefix.stickLong, Materials.Steel, 4)).input(OrePrefix.plate, Materials.Steel, 4)).outputs(MetaTileEntities.STEEL_CRATE.getStackForm())).duration(200)).circuitMeta(1)).buildAndRegister();
        ((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)RecipeMaps.ASSEMBLER_RECIPES.recipeBuilder().EUt(16)).input(OrePrefix.stickLong, Materials.Aluminium, 4)).input(OrePrefix.plate, Materials.Aluminium, 4)).outputs(MetaTileEntities.ALUMINIUM_CRATE.getStackForm())).duration(200)).circuitMeta(1)).buildAndRegister();
        ((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)RecipeMaps.ASSEMBLER_RECIPES.recipeBuilder().EUt(16)).input(OrePrefix.stickLong, Materials.StainlessSteel, 4)).input(OrePrefix.plate, Materials.StainlessSteel, 4)).outputs(MetaTileEntities.STAINLESS_STEEL_CRATE.getStackForm())).circuitMeta(1)).duration(200)).buildAndRegister();
        ((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)RecipeMaps.ASSEMBLER_RECIPES.recipeBuilder().EUt(16)).input(OrePrefix.stickLong, Materials.Titanium, 4)).input(OrePrefix.plate, Materials.Titanium, 4)).outputs(MetaTileEntities.TITANIUM_CRATE.getStackForm())).duration(200)).circuitMeta(1)).buildAndRegister();
        ((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)RecipeMaps.ASSEMBLER_RECIPES.recipeBuilder().EUt(16)).input(OrePrefix.stickLong, Materials.TungstenSteel, 4)).input(OrePrefix.plate, Materials.TungstenSteel, 4)).outputs(MetaTileEntities.TUNGSTENSTEEL_CRATE.getStackForm())).duration(200)).circuitMeta(1)).buildAndRegister();
        ((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)RecipeMaps.ASSEMBLER_RECIPES.recipeBuilder().EUt(16)).input(OrePrefix.stickLong, Materials.Bronze, 2)).input(OrePrefix.plate, Materials.Bronze, 4)).outputs(MetaTileEntities.BRONZE_DRUM.getStackForm())).duration(200)).circuitMeta(2)).buildAndRegister();
        ((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)RecipeMaps.ASSEMBLER_RECIPES.recipeBuilder().EUt(16)).input(OrePrefix.stickLong, Materials.Steel, 2)).input(OrePrefix.plate, Materials.Steel, 4)).outputs(MetaTileEntities.STEEL_DRUM.getStackForm())).duration(200)).circuitMeta(2)).buildAndRegister();
        ((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)RecipeMaps.ASSEMBLER_RECIPES.recipeBuilder().EUt(16)).input(OrePrefix.stickLong, Materials.Aluminium, 2)).input(OrePrefix.plate, Materials.Aluminium, 4)).outputs(MetaTileEntities.ALUMINIUM_DRUM.getStackForm())).duration(200)).circuitMeta(2)).buildAndRegister();
        ((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)RecipeMaps.ASSEMBLER_RECIPES.recipeBuilder().EUt(16)).input(OrePrefix.stickLong, Materials.StainlessSteel, 2)).input(OrePrefix.plate, Materials.StainlessSteel, 4)).outputs(MetaTileEntities.STAINLESS_STEEL_DRUM.getStackForm())).duration(200)).circuitMeta(2)).buildAndRegister();
        ((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)RecipeMaps.ASSEMBLER_RECIPES.recipeBuilder().EUt(16)).input(OrePrefix.stickLong, Materials.Titanium, 2)).input(OrePrefix.plate, Materials.Titanium, 4)).outputs(MetaTileEntities.TITANIUM_DRUM.getStackForm())).duration(200)).circuitMeta(2)).buildAndRegister();
        ((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)RecipeMaps.ASSEMBLER_RECIPES.recipeBuilder().EUt(16)).input(OrePrefix.stickLong, Materials.TungstenSteel, 2)).input(OrePrefix.plate, Materials.TungstenSteel, 4)).outputs(MetaTileEntities.TUNGSTENSTEEL_DRUM.getStackForm())).duration(200)).circuitMeta(2)).buildAndRegister();
        ((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)RecipeMaps.ASSEMBLER_RECIPES.recipeBuilder().EUt(16)).input(OrePrefix.stickLong, Materials.Gold, 2)).input(OrePrefix.plate, Materials.Gold, 4)).outputs(MetaTileEntities.GOLD_DRUM.getStackForm())).duration(200)).circuitMeta(2)).buildAndRegister();
        ((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)RecipeMaps.ASSEMBLER_RECIPES.recipeBuilder().EUt(GTValues.VA[1])).input(OrePrefix.foil, Materials.Polyethylene, 4)).input(MetaItems.CARBON_MESH)).fluidInputs(Materials.Polyethylene.getFluid(288))).output(MetaItems.DUCT_TAPE)).duration(100)).buildAndRegister();
        ((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)RecipeMaps.ASSEMBLER_RECIPES.recipeBuilder().EUt(GTValues.VA[1])).input(OrePrefix.foil, Materials.SiliconeRubber, 2)).input(MetaItems.CARBON_MESH)).fluidInputs(Materials.Polyethylene.getFluid(288))).output(MetaItems.DUCT_TAPE, 2)).duration(100)).buildAndRegister();
        ((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)RecipeMaps.ASSEMBLER_RECIPES.recipeBuilder().EUt(GTValues.VA[1])).input(OrePrefix.foil, Materials.Polycaprolactam, 2)).input(MetaItems.CARBON_MESH)).fluidInputs(Materials.Polyethylene.getFluid(144))).output(MetaItems.DUCT_TAPE, 4)).duration(100)).buildAndRegister();
        ((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)RecipeMaps.ASSEMBLER_RECIPES.recipeBuilder().EUt(GTValues.VA[1])).input(OrePrefix.foil, Materials.Polybenzimidazole)).input(MetaItems.CARBON_MESH)).fluidInputs(Materials.Polyethylene.getFluid(72))).output(MetaItems.DUCT_TAPE, 8)).duration(100)).buildAndRegister();
        ModHandler.addShapedRecipe("basic_tape", MetaItems.BASIC_TAPE.getStackForm(), " P ", "PSP", " P ", Character.valueOf('P'), new UnificationEntry(OrePrefix.plate, Materials.Paper), Character.valueOf('S'), MetaItems.STICKY_RESIN.getStackForm());
        ((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)RecipeMaps.ASSEMBLER_RECIPES.recipeBuilder().EUt(GTValues.VA[0])).input(OrePrefix.plate, Materials.Paper, 2)).input(MetaItems.STICKY_RESIN)).output(MetaItems.BASIC_TAPE, 2)).duration(100)).buildAndRegister();
        ((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)RecipeMaps.ASSEMBLER_RECIPES.recipeBuilder().input(OrePrefix.plateDouble, Materials.Steel, 2)).input(OrePrefix.ring, Materials.Bronze, 2)).output(MetaItems.FLUID_CELL_LARGE_STEEL)).duration(200)).EUt(GTValues.VA[1])).buildAndRegister();
        ((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)RecipeMaps.ASSEMBLER_RECIPES.recipeBuilder().input(OrePrefix.plateDouble, Materials.Aluminium, 2)).input(OrePrefix.ring, Materials.Silver, 2)).output(MetaItems.FLUID_CELL_LARGE_ALUMINIUM)).duration(200)).EUt(64)).buildAndRegister();
        ((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)RecipeMaps.ASSEMBLER_RECIPES.recipeBuilder().input(OrePrefix.plateDouble, Materials.StainlessSteel, 3)).input(OrePrefix.ring, Materials.Electrum, 3)).output(MetaItems.FLUID_CELL_LARGE_STAINLESS_STEEL)).duration(200)).EUt(GTValues.VA[2])).buildAndRegister();
        ((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)RecipeMaps.ASSEMBLER_RECIPES.recipeBuilder().input(OrePrefix.plateDouble, Materials.Titanium, 3)).input(OrePrefix.ring, Materials.RoseGold, 3)).output(MetaItems.FLUID_CELL_LARGE_TITANIUM)).duration(200)).EUt(256)).buildAndRegister();
        ((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)RecipeMaps.ASSEMBLER_RECIPES.recipeBuilder().input(OrePrefix.plateDouble, Materials.TungstenSteel, 4)).input(OrePrefix.ring, Materials.Platinum, 4)).output(MetaItems.FLUID_CELL_LARGE_TUNGSTEN_STEEL)).duration(200)).EUt(GTValues.VA[3])).buildAndRegister();
    }

    private static void registerBlastFurnaceRecipes() {
        ((BlastRecipeBuilder)((BlastRecipeBuilder)((BlastRecipeBuilder)((BlastRecipeBuilder)((BlastRecipeBuilder)((BlastRecipeBuilder)RecipeMaps.BLAST_RECIPES.recipeBuilder().duration(500)).EUt(GTValues.VA[2])).input(OrePrefix.ingot, Materials.Iron)).fluidInputs(Materials.Oxygen.getFluid(200))).output(OrePrefix.ingot, Materials.Steel)).chancedOutput(OrePrefix.dust, Materials.Ash, 1111, 0)).blastFurnaceTemp(1000).buildAndRegister();
        ((BlastRecipeBuilder)((BlastRecipeBuilder)((BlastRecipeBuilder)((BlastRecipeBuilder)((BlastRecipeBuilder)((BlastRecipeBuilder)((BlastRecipeBuilder)RecipeMaps.BLAST_RECIPES.recipeBuilder().duration(400)).EUt(GTValues.VA[2])).input(OrePrefix.dust, Materials.Iron)).fluidInputs(Materials.Oxygen.getFluid(200))).output(OrePrefix.ingot, Materials.Steel)).chancedOutput(OrePrefix.dust, Materials.Ash, 1111, 0)).circuitMeta(2)).blastFurnaceTemp(1000).buildAndRegister();
        ((BlastRecipeBuilder)((BlastRecipeBuilder)((BlastRecipeBuilder)((BlastRecipeBuilder)((BlastRecipeBuilder)((BlastRecipeBuilder)RecipeMaps.BLAST_RECIPES.recipeBuilder().duration(300)).EUt(GTValues.VA[2])).input(OrePrefix.ingot, Materials.WroughtIron)).fluidInputs(Materials.Oxygen.getFluid(200))).output(OrePrefix.ingot, Materials.Steel)).chancedOutput(OrePrefix.dust, Materials.Ash, 1111, 0)).blastFurnaceTemp(1000).buildAndRegister();
        ((BlastRecipeBuilder)((BlastRecipeBuilder)((BlastRecipeBuilder)((BlastRecipeBuilder)((BlastRecipeBuilder)((BlastRecipeBuilder)((BlastRecipeBuilder)RecipeMaps.BLAST_RECIPES.recipeBuilder().duration(100)).EUt(GTValues.VA[2])).input(OrePrefix.dust, Materials.WroughtIron)).fluidInputs(Materials.Oxygen.getFluid(200))).output(OrePrefix.ingot, Materials.Steel)).chancedOutput(OrePrefix.dust, Materials.Ash, 1111, 0)).circuitMeta(2)).blastFurnaceTemp(1000).buildAndRegister();
        ((BlastRecipeBuilder)((BlastRecipeBuilder)((BlastRecipeBuilder)((BlastRecipeBuilder)((BlastRecipeBuilder)((BlastRecipeBuilder)RecipeMaps.BLAST_RECIPES.recipeBuilder().duration(250)).EUt(GTValues.VA[4])).input(OrePrefix.dust, Materials.Iron, 4)).input(OrePrefix.dust, Materials.Carbon)).output(OrePrefix.ingot, Materials.Steel, 4)).chancedOutput(OrePrefix.dust, Materials.Ash, 1111, 0)).blastFurnaceTemp(2000).buildAndRegister();
        ((BlastRecipeBuilder)((BlastRecipeBuilder)((BlastRecipeBuilder)((BlastRecipeBuilder)((BlastRecipeBuilder)((BlastRecipeBuilder)RecipeMaps.BLAST_RECIPES.recipeBuilder().duration(50)).EUt(GTValues.VA[4])).input(OrePrefix.dust, Materials.WroughtIron, 4)).input(OrePrefix.dust, Materials.Carbon)).output(OrePrefix.ingot, Materials.Steel, 4)).chancedOutput(OrePrefix.dust, Materials.Ash, 1111, 0)).blastFurnaceTemp(2000).buildAndRegister();
        ((BlastRecipeBuilder)((BlastRecipeBuilder)((BlastRecipeBuilder)((BlastRecipeBuilder)((BlastRecipeBuilder)RecipeMaps.BLAST_RECIPES.recipeBuilder().duration(400)).EUt(100)).input(OrePrefix.dust, Materials.Ruby)).output(OrePrefix.nugget, Materials.Aluminium, 3)).chancedOutput(OrePrefix.dust, Materials.Ash, 1111, 0)).blastFurnaceTemp(1200).buildAndRegister();
        ((BlastRecipeBuilder)((BlastRecipeBuilder)((BlastRecipeBuilder)((BlastRecipeBuilder)((BlastRecipeBuilder)RecipeMaps.BLAST_RECIPES.recipeBuilder().duration(320)).EUt(100)).input(OrePrefix.gem, Materials.Ruby)).output(OrePrefix.nugget, Materials.Aluminium, 3)).chancedOutput(OrePrefix.dust, Materials.Ash, 1111, 0)).blastFurnaceTemp(1200).buildAndRegister();
        ((BlastRecipeBuilder)((BlastRecipeBuilder)((BlastRecipeBuilder)((BlastRecipeBuilder)((BlastRecipeBuilder)RecipeMaps.BLAST_RECIPES.recipeBuilder().duration(400)).EUt(100)).input(OrePrefix.dust, Materials.GreenSapphire)).output(OrePrefix.nugget, Materials.Aluminium, 3)).chancedOutput(OrePrefix.dust, Materials.Ash, 1111, 0)).blastFurnaceTemp(1200).buildAndRegister();
        ((BlastRecipeBuilder)((BlastRecipeBuilder)((BlastRecipeBuilder)((BlastRecipeBuilder)((BlastRecipeBuilder)RecipeMaps.BLAST_RECIPES.recipeBuilder().duration(320)).EUt(100)).input(OrePrefix.gem, Materials.GreenSapphire)).output(OrePrefix.nugget, Materials.Aluminium, 3)).chancedOutput(OrePrefix.dust, Materials.Ash, 1111, 0)).blastFurnaceTemp(1200).buildAndRegister();
        ((BlastRecipeBuilder)((BlastRecipeBuilder)((BlastRecipeBuilder)((BlastRecipeBuilder)RecipeMaps.BLAST_RECIPES.recipeBuilder().duration(400)).EUt(100)).input(OrePrefix.dust, Materials.Sapphire)).output(OrePrefix.nugget, Materials.Aluminium, 3)).blastFurnaceTemp(1200).buildAndRegister();
        ((BlastRecipeBuilder)((BlastRecipeBuilder)((BlastRecipeBuilder)((BlastRecipeBuilder)RecipeMaps.BLAST_RECIPES.recipeBuilder().duration(320)).EUt(100)).input(OrePrefix.gem, Materials.Sapphire)).output(OrePrefix.nugget, Materials.Aluminium, 3)).blastFurnaceTemp(1200).buildAndRegister();
        ((BlastRecipeBuilder)((BlastRecipeBuilder)((BlastRecipeBuilder)((BlastRecipeBuilder)((BlastRecipeBuilder)((BlastRecipeBuilder)RecipeMaps.BLAST_RECIPES.recipeBuilder().duration(800)).EUt(GTValues.VA[3])).input(OrePrefix.dust, Materials.Magnesium, 2)).fluidInputs(Materials.TitaniumTetrachloride.getFluid(1000))).output(OrePrefix.ingotHot, Materials.Titanium)).output(OrePrefix.dust, Materials.MagnesiumChloride, 6)).blastFurnaceTemp(Materials.Titanium.getBlastTemperature() + 200).buildAndRegister();
        ((BlastRecipeBuilder)((BlastRecipeBuilder)((BlastRecipeBuilder)((BlastRecipeBuilder)((BlastRecipeBuilder)((BlastRecipeBuilder)((BlastRecipeBuilder)RecipeMaps.BLAST_RECIPES.recipeBuilder().input(OrePrefix.dust, Materials.Ilmenite, 10)).input(OrePrefix.dust, Materials.Carbon, 4)).output(OrePrefix.ingot, Materials.WroughtIron, 2)).output(OrePrefix.dust, Materials.Rutile, 4)).fluidOutputs(Materials.CarbonDioxide.getFluid(2000))).blastFurnaceTemp(1700).duration(1600)).EUt(GTValues.VA[3])).buildAndRegister();
        ((BlastRecipeBuilder)((BlastRecipeBuilder)((BlastRecipeBuilder)((BlastRecipeBuilder)((BlastRecipeBuilder)RecipeMaps.BLAST_RECIPES.recipeBuilder().input(OrePrefix.block, Materials.Glass)).fluidInputs(Materials.Oxygen.getFluid(100))).outputs(MetaBlocks.TRANSPARENT_CASING.getItemVariant(BlockGlassCasing.CasingType.TEMPERED_GLASS))).blastFurnaceTemp(1000).duration(200)).EUt(GTValues.VA[2])).buildAndRegister();
        MachineRecipeLoader.registerBlastFurnaceMetallurgyRecipes();
    }

    private static void registerBlastFurnaceMetallurgyRecipes() {
        MachineRecipeLoader.createSulfurDioxideRecipe(Materials.Stibnite, Materials.AntimonyTrioxide, 1500);
        MachineRecipeLoader.createSulfurDioxideRecipe(Materials.Sphalerite, Materials.Zincite, 1000);
        MachineRecipeLoader.createSulfurDioxideRecipe(Materials.Pyrite, Materials.BandedIron, 2000);
        MachineRecipeLoader.createSulfurDioxideRecipe(Materials.Pentlandite, Materials.Garnierite, 1000);
        ((BlastRecipeBuilder)((BlastRecipeBuilder)((BlastRecipeBuilder)((BlastRecipeBuilder)((BlastRecipeBuilder)((BlastRecipeBuilder)((BlastRecipeBuilder)RecipeMaps.BLAST_RECIPES.recipeBuilder().duration(120)).EUt(GTValues.VA[2])).blastFurnaceTemp(1200).input(OrePrefix.dust, Materials.Tetrahedrite)).fluidInputs(Materials.Oxygen.getFluid(3000))).output(OrePrefix.dust, Materials.CupricOxide)).output(OrePrefix.dustTiny, Materials.AntimonyTrioxide, 3)).fluidOutputs(Materials.SulfurDioxide.getFluid(2000))).buildAndRegister();
        ((BlastRecipeBuilder)((BlastRecipeBuilder)((BlastRecipeBuilder)((BlastRecipeBuilder)((BlastRecipeBuilder)((BlastRecipeBuilder)((BlastRecipeBuilder)RecipeMaps.BLAST_RECIPES.recipeBuilder().duration(120)).EUt(GTValues.VA[2])).blastFurnaceTemp(1200).input(OrePrefix.dust, Materials.Cobaltite)).fluidInputs(Materials.Oxygen.getFluid(3000))).output(OrePrefix.dust, Materials.CobaltOxide)).output(OrePrefix.dust, Materials.ArsenicTrioxide)).fluidOutputs(Materials.SulfurDioxide.getFluid(1000))).buildAndRegister();
        ((BlastRecipeBuilder)((BlastRecipeBuilder)((BlastRecipeBuilder)((BlastRecipeBuilder)((BlastRecipeBuilder)((BlastRecipeBuilder)((BlastRecipeBuilder)RecipeMaps.BLAST_RECIPES.recipeBuilder().duration(120)).EUt(GTValues.VA[2])).blastFurnaceTemp(1200).input(OrePrefix.dust, Materials.Galena)).fluidInputs(Materials.Oxygen.getFluid(3000))).output(OrePrefix.dust, Materials.Massicot)).output(OrePrefix.nugget, Materials.Silver, 6)).fluidOutputs(Materials.SulfurDioxide.getFluid(1000))).buildAndRegister();
        ((BlastRecipeBuilder)((BlastRecipeBuilder)((BlastRecipeBuilder)((BlastRecipeBuilder)((BlastRecipeBuilder)((BlastRecipeBuilder)((BlastRecipeBuilder)((BlastRecipeBuilder)RecipeMaps.BLAST_RECIPES.recipeBuilder().duration(120)).EUt(GTValues.VA[2])).blastFurnaceTemp(1200).input(OrePrefix.dust, Materials.Chalcopyrite)).input(OrePrefix.dust, Materials.SiliconDioxide)).fluidInputs(Materials.Oxygen.getFluid(3000))).output(OrePrefix.dust, Materials.CupricOxide)).output(OrePrefix.dust, Materials.Ferrosilite)).fluidOutputs(Materials.SulfurDioxide.getFluid(2000))).buildAndRegister();
        ((BlastRecipeBuilder)((BlastRecipeBuilder)((BlastRecipeBuilder)((BlastRecipeBuilder)((BlastRecipeBuilder)((BlastRecipeBuilder)((BlastRecipeBuilder)RecipeMaps.BLAST_RECIPES.recipeBuilder().duration(240)).EUt(GTValues.VA[2])).blastFurnaceTemp(2273).input(OrePrefix.dust, Materials.SiliconDioxide, 3)).input(OrePrefix.dust, Materials.Carbon, 2)).output(OrePrefix.ingotHot, Materials.Silicon)).chancedOutput(OrePrefix.dust, Materials.Ash, 1111, 0)).fluidOutputs(Materials.CarbonMonoxide.getFluid(2000))).buildAndRegister();
    }

    private static void createSulfurDioxideRecipe(Material inputMaterial, Material outputMaterial, int sulfurDioxideAmount) {
        ((BlastRecipeBuilder)((BlastRecipeBuilder)((BlastRecipeBuilder)((BlastRecipeBuilder)((BlastRecipeBuilder)((BlastRecipeBuilder)((BlastRecipeBuilder)RecipeMaps.BLAST_RECIPES.recipeBuilder().duration(120)).EUt(GTValues.VA[2])).blastFurnaceTemp(1200).input(OrePrefix.dust, inputMaterial)).fluidInputs(Materials.Oxygen.getFluid(3000))).output(OrePrefix.dust, outputMaterial)).chancedOutput(OrePrefix.dust, Materials.Ash, 1111, 0)).fluidOutputs(Materials.SulfurDioxide.getFluid(sulfurDioxideAmount))).buildAndRegister();
    }

    private static void registerDecompositionRecipes() {
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.EXTRACTOR_RECIPES.recipeBuilder().inputs(MetaItems.STICKY_RESIN.getStackForm())).output(OrePrefix.dust, Materials.RawRubber, 3)).duration(150)).EUt(2)).buildAndRegister();
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.EXTRACTOR_RECIPES.recipeBuilder().duration(300)).EUt(2)).inputs(new ItemStack((Block)MetaBlocks.RUBBER_LEAVES, 16))).output(OrePrefix.dust, Materials.RawRubber)).buildAndRegister();
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.EXTRACTOR_RECIPES.recipeBuilder().duration(300)).EUt(2)).inputs(new ItemStack((Block)MetaBlocks.RUBBER_LOG))).output(OrePrefix.dust, Materials.RawRubber)).buildAndRegister();
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.EXTRACTOR_RECIPES.recipeBuilder().duration(300)).EUt(2)).inputs(new ItemStack((Block)MetaBlocks.RUBBER_SAPLING))).output(OrePrefix.dust, Materials.RawRubber)).buildAndRegister();
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.EXTRACTOR_RECIPES.recipeBuilder().duration(150)).EUt(2)).inputs(new ItemStack(Items.field_151123_aH))).output(OrePrefix.dust, Materials.RawRubber, 2)).buildAndRegister();
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.COMPRESSOR_RECIPES.recipeBuilder().duration(300)).EUt(2)).input("treeSapling", 8)).output(MetaItems.PLANT_BALL)).buildAndRegister();
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.COMPRESSOR_RECIPES.recipeBuilder().duration(300)).EUt(2)).inputs(new ItemStack(Items.field_151015_O, 8))).output(MetaItems.PLANT_BALL)).buildAndRegister();
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.COMPRESSOR_RECIPES.recipeBuilder().duration(300)).EUt(2)).inputs(new ItemStack(Items.field_151174_bG, 8))).output(MetaItems.PLANT_BALL)).buildAndRegister();
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.COMPRESSOR_RECIPES.recipeBuilder().duration(300)).EUt(2)).inputs(new ItemStack(Items.field_151172_bF, 8))).output(MetaItems.PLANT_BALL)).buildAndRegister();
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.COMPRESSOR_RECIPES.recipeBuilder().duration(300)).EUt(2)).inputs(new ItemStack((Block)Blocks.field_150434_aF, 8))).output(MetaItems.PLANT_BALL)).buildAndRegister();
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.COMPRESSOR_RECIPES.recipeBuilder().duration(300)).EUt(2)).inputs(new ItemStack(Items.field_151120_aE, 8))).output(MetaItems.PLANT_BALL)).buildAndRegister();
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.COMPRESSOR_RECIPES.recipeBuilder().duration(300)).EUt(2)).inputs(new ItemStack((Block)Blocks.field_150338_P, 8))).output(MetaItems.PLANT_BALL)).buildAndRegister();
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.COMPRESSOR_RECIPES.recipeBuilder().duration(300)).EUt(2)).inputs(new ItemStack((Block)Blocks.field_150337_Q, 8))).output(MetaItems.PLANT_BALL)).buildAndRegister();
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.COMPRESSOR_RECIPES.recipeBuilder().duration(300)).EUt(2)).inputs(new ItemStack(Items.field_185164_cV, 8))).output(MetaItems.PLANT_BALL)).buildAndRegister();
    }

    private static void registerRecyclingRecipes() {
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.MACERATOR_RECIPES.recipeBuilder().input(OrePrefix.stone, Materials.Endstone)).output(OrePrefix.dust, Materials.Endstone)).chancedOutput(OrePrefix.dust, Materials.Tungstate, 130, 30)).buildAndRegister();
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.MACERATOR_RECIPES.recipeBuilder().input(OrePrefix.stone, Materials.Netherrack)).output(OrePrefix.dust, Materials.Netherrack)).chancedOutput(OrePrefix.nugget, Materials.Gold, 500, 120)).buildAndRegister();
        if (!OreDictionary.getOres((String)"stoneSoapstone").isEmpty()) {
            ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.MACERATOR_RECIPES.recipeBuilder().input(OrePrefix.stone, Materials.Soapstone)).output(OrePrefix.dustImpure, Materials.Talc)).chancedOutput(OrePrefix.dust, Materials.Chromite, 111, 30)).buildAndRegister();
        }
        if (!OreDictionary.getOres((String)"stoneRedrock").isEmpty()) {
            ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.MACERATOR_RECIPES.recipeBuilder().input(OrePrefix.stone, Materials.Redrock)).output(OrePrefix.dust, Materials.Redrock)).chancedOutput(OrePrefix.dust, Materials.Redrock, 1000, 380)).buildAndRegister();
        }
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.MACERATOR_RECIPES.recipeBuilder().input(OrePrefix.stone, Materials.Marble)).output(OrePrefix.dust, Materials.Marble)).chancedOutput(OrePrefix.dust, Materials.Marble, 1000, 380)).buildAndRegister();
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.MACERATOR_RECIPES.recipeBuilder().input(OrePrefix.stone, Materials.Basalt)).output(OrePrefix.dust, Materials.Basalt)).chancedOutput(OrePrefix.dust, Materials.Basalt, 1000, 380)).buildAndRegister();
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.MACERATOR_RECIPES.recipeBuilder().input(OrePrefix.stone, Materials.GraniteBlack)).output(OrePrefix.dust, Materials.GraniteBlack)).chancedOutput(OrePrefix.dust, Materials.Thorium, 100, 40)).buildAndRegister();
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.MACERATOR_RECIPES.recipeBuilder().input(OrePrefix.stone, Materials.GraniteRed)).output(OrePrefix.dust, Materials.GraniteRed)).chancedOutput(OrePrefix.dust, Materials.Uranium238, 10, 5)).buildAndRegister();
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.MACERATOR_RECIPES.recipeBuilder().input(OrePrefix.stone, Materials.Andesite)).output(OrePrefix.dust, Materials.Andesite)).chancedOutput(OrePrefix.dust, Materials.Stone, 10, 5)).buildAndRegister();
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.MACERATOR_RECIPES.recipeBuilder().input(OrePrefix.stone, Materials.Diorite)).output(OrePrefix.dust, Materials.Diorite)).chancedOutput(OrePrefix.dust, Materials.Stone, 10, 5)).buildAndRegister();
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.MACERATOR_RECIPES.recipeBuilder().input(OrePrefix.stone, Materials.Granite)).output(OrePrefix.dust, Materials.Granite)).chancedOutput(OrePrefix.dust, Materials.Stone, 10, 5)).buildAndRegister();
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.MACERATOR_RECIPES.recipeBuilder().inputs(new ItemStack(Items.field_151147_al))).output(OrePrefix.dust, Materials.Meat)).chancedOutput(OrePrefix.dust, Materials.Meat, 5000, 0)).output(OrePrefix.dustTiny, Materials.Bone)).duration(102)).buildAndRegister();
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.MACERATOR_RECIPES.recipeBuilder().inputs(new ItemStack(Items.field_151115_aP, 1, Short.MAX_VALUE))).output(OrePrefix.dust, Materials.Meat)).chancedOutput(OrePrefix.dust, Materials.Meat, 5000, 0)).output(OrePrefix.dustTiny, Materials.Bone)).duration(102)).buildAndRegister();
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.MACERATOR_RECIPES.recipeBuilder().inputs(new ItemStack(Items.field_151076_bf))).output(OrePrefix.dust, Materials.Meat)).output(OrePrefix.dustTiny, Materials.Bone)).duration(102)).buildAndRegister();
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.MACERATOR_RECIPES.recipeBuilder().inputs(new ItemStack(Items.field_151082_bd))).output(OrePrefix.dust, Materials.Meat)).chancedOutput(OrePrefix.dust, Materials.Meat, 5000, 0)).output(OrePrefix.dustTiny, Materials.Bone)).duration(102)).buildAndRegister();
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.MACERATOR_RECIPES.recipeBuilder().inputs(new ItemStack(Items.field_179558_bo))).output(OrePrefix.dust, Materials.Meat)).chancedOutput(OrePrefix.dust, Materials.Meat, 5000, 0)).output(OrePrefix.dustTiny, Materials.Bone)).duration(102)).buildAndRegister();
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.MACERATOR_RECIPES.recipeBuilder().inputs(new ItemStack(Items.field_179561_bm))).output(OrePrefix.dust, Materials.Meat)).output(OrePrefix.dustTiny, Materials.Bone)).duration(102)).buildAndRegister();
    }

    private static void registerFluidRecipes() {
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.FLUID_HEATER_RECIPES.recipeBuilder().duration(32)).EUt(4)).fluidInputs(Materials.Ice.getFluid(144))).circuitMeta(1)).fluidOutputs(Materials.Water.getFluid(144))).buildAndRegister();
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.FLUID_SOLIDFICATION_RECIPES.recipeBuilder().fluidInputs(Materials.Toluene.getFluid(100))).notConsumable(MetaItems.SHAPE_MOLD_BALL)).output(MetaItems.GELLED_TOLUENE)).duration(100)).EUt(16)).buildAndRegister();
        for (int i = 0; i < Materials.CHEMICAL_DYES.length; ++i) {
            ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.FLUID_SOLIDFICATION_RECIPES.recipeBuilder().fluidInputs(Materials.CHEMICAL_DYES[i].getFluid(72))).notConsumable(MetaItems.SHAPE_MOLD_BALL.getStackForm())).outputs(MetaItems.DYE_ONLY_ITEMS[i].getStackForm())).duration(100)).EUt(16)).buildAndRegister();
        }
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.FLUID_HEATER_RECIPES.recipeBuilder().duration(30)).EUt(GTValues.VA[1])).fluidInputs(Materials.Water.getFluid(6))).circuitMeta(1)).fluidOutputs(Materials.Steam.getFluid(960))).buildAndRegister();
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.FLUID_HEATER_RECIPES.recipeBuilder().duration(30)).EUt(GTValues.VA[1])).fluidInputs(Materials.DistilledWater.getFluid(6))).circuitMeta(1)).fluidOutputs(Materials.Steam.getFluid(960))).buildAndRegister();
    }

    private static void registerSmoothRecipe(List<ItemStack> roughStack, List<ItemStack> smoothStack) {
        for (int i = 0; i < roughStack.size(); ++i) {
            ModHandler.addSmeltingRecipe(roughStack.get(i), smoothStack.get(i), 0.1f);
            ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.EXTRUDER_RECIPES.recipeBuilder().inputs(roughStack.get(i))).notConsumable(MetaItems.SHAPE_EXTRUDER_BLOCK.getStackForm())).outputs(smoothStack.get(i))).duration(24)).EUt(8)).buildAndRegister();
        }
    }

    private static void registerCobbleRecipe(List<ItemStack> smoothStack, List<ItemStack> cobbleStack) {
        for (int i = 0; i < smoothStack.size(); ++i) {
            ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.FORGE_HAMMER_RECIPES.recipeBuilder().inputs(smoothStack.get(i))).outputs(cobbleStack.get(i))).duration(12)).EUt(4)).buildAndRegister();
        }
    }

    private static void registerBricksRecipe(List<ItemStack> polishedStack, List<ItemStack> brickStack, MarkerMaterial color) {
        for (int i = 0; i < polishedStack.size(); ++i) {
            ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.LASER_ENGRAVER_RECIPES.recipeBuilder().inputs(polishedStack.get(i))).notConsumable(OrePrefix.craftingLens, color)).outputs(brickStack.get(i))).duration(50)).EUt(16)).buildAndRegister();
        }
    }

    private static void registerMossRecipe(List<ItemStack> regularStack, List<ItemStack> mossStack) {
        for (int i = 0; i < regularStack.size(); ++i) {
            ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.CHEMICAL_BATH_RECIPES.recipeBuilder().inputs(regularStack.get(i))).fluidInputs(Materials.Water.getFluid(100))).outputs(mossStack.get(i))).duration(50)).EUt(16)).buildAndRegister();
        }
    }

    private static void registerNBTRemoval() {
        for (MetaTileEntityQuantumChest metaTileEntityQuantumChest : MetaTileEntities.QUANTUM_CHEST) {
            if (metaTileEntityQuantumChest == null) continue;
            ModHandler.addShapelessNBTClearingRecipe("quantum_chest_nbt_" + metaTileEntityQuantumChest.getTier() + metaTileEntityQuantumChest.getMetaName(), metaTileEntityQuantumChest.getStackForm(), metaTileEntityQuantumChest.getStackForm());
        }
        for (MetaTileEntity metaTileEntity : MetaTileEntities.QUANTUM_TANK) {
            if (metaTileEntity == null) continue;
            ModHandler.addShapelessNBTClearingRecipe("quantum_tank_nbt_" + ((MetaTileEntityQuantumTank)metaTileEntity).getTier() + metaTileEntity.getMetaName(), metaTileEntity.getStackForm(), metaTileEntity.getStackForm());
        }
        ModHandler.addShapelessNBTClearingRecipe("drum_nbt_wood", MetaTileEntities.WOODEN_DRUM.getStackForm(), MetaTileEntities.WOODEN_DRUM.getStackForm());
        ModHandler.addShapelessNBTClearingRecipe("drum_nbt_bronze", MetaTileEntities.BRONZE_DRUM.getStackForm(), MetaTileEntities.BRONZE_DRUM.getStackForm());
        ModHandler.addShapelessNBTClearingRecipe("drum_nbt_steel", MetaTileEntities.STEEL_DRUM.getStackForm(), MetaTileEntities.STEEL_DRUM.getStackForm());
        ModHandler.addShapelessNBTClearingRecipe("drum_nbt_aluminium", MetaTileEntities.ALUMINIUM_DRUM.getStackForm(), MetaTileEntities.ALUMINIUM_DRUM.getStackForm());
        ModHandler.addShapelessNBTClearingRecipe("drum_nbt_stainless_steel", MetaTileEntities.STAINLESS_STEEL_DRUM.getStackForm(), MetaTileEntities.STAINLESS_STEEL_DRUM.getStackForm());
        ModHandler.addShapelessNBTClearingRecipe("drum_nbt_titanium", MetaTileEntities.TITANIUM_DRUM.getStackForm(), MetaTileEntities.TITANIUM_DRUM.getStackForm());
        ModHandler.addShapelessNBTClearingRecipe("drum_nbt_tungstensteel", MetaTileEntities.TUNGSTENSTEEL_DRUM.getStackForm(), MetaTileEntities.TUNGSTENSTEEL_DRUM.getStackForm());
        ModHandler.addShapelessNBTClearingRecipe("drum_nbt_gold", MetaTileEntities.GOLD_DRUM.getStackForm(), MetaTileEntities.GOLD_DRUM.getStackForm());
        ModHandler.addShapedNBTClearingRecipe("cell_nbt_regular", MetaItems.FLUID_CELL.getStackForm(), " C", "  ", Character.valueOf('C'), MetaItems.FLUID_CELL.getStackForm());
        ModHandler.addShapedNBTClearingRecipe("cell_nbt_universal", MetaItems.FLUID_CELL_UNIVERSAL.getStackForm(), " C", "  ", Character.valueOf('C'), MetaItems.FLUID_CELL_UNIVERSAL.getStackForm());
        ModHandler.addShapelessNBTClearingRecipe("cell_nbt_steel", MetaItems.FLUID_CELL_LARGE_STEEL.getStackForm(), MetaItems.FLUID_CELL_LARGE_STEEL.getStackForm());
        ModHandler.addShapelessNBTClearingRecipe("cell_nbt_aluminium", MetaItems.FLUID_CELL_LARGE_ALUMINIUM.getStackForm(), MetaItems.FLUID_CELL_LARGE_ALUMINIUM.getStackForm());
        ModHandler.addShapelessNBTClearingRecipe("cell_nbt_stainless_steel", MetaItems.FLUID_CELL_LARGE_STAINLESS_STEEL.getStackForm(), MetaItems.FLUID_CELL_LARGE_STAINLESS_STEEL.getStackForm());
        ModHandler.addShapelessNBTClearingRecipe("cell_nbt_titanium", MetaItems.FLUID_CELL_LARGE_TITANIUM.getStackForm(), MetaItems.FLUID_CELL_LARGE_TITANIUM.getStackForm());
        ModHandler.addShapelessNBTClearingRecipe("cell_nbt_tungstensteel", MetaItems.FLUID_CELL_LARGE_TUNGSTEN_STEEL.getStackForm(), MetaItems.FLUID_CELL_LARGE_TUNGSTEN_STEEL.getStackForm());
        ModHandler.addShapelessNBTClearingRecipe("cell_vial_nbt", MetaItems.FLUID_CELL_GLASS_VIAL.getStackForm(), MetaItems.FLUID_CELL_GLASS_VIAL.getStackForm());
        ModHandler.addShapelessNBTClearingRecipe("data_stick_nbt", MetaItems.TOOL_DATA_STICK.getStackForm(), MetaItems.TOOL_DATA_STICK.getStackForm());
        ModHandler.addShapelessNBTClearingRecipe("data_orb_nbt", MetaItems.TOOL_DATA_ORB.getStackForm(), MetaItems.TOOL_DATA_ORB.getStackForm());
        ModHandler.addShapelessNBTClearingRecipe("data_module_nbt", MetaItems.TOOL_DATA_MODULE.getStackForm(), MetaItems.TOOL_DATA_MODULE.getStackForm());
        ModHandler.addShapelessRecipe("fluid_jetpack_clear", MetaItems.SEMIFLUID_JETPACK.getStackForm(), MetaItems.SEMIFLUID_JETPACK.getStackForm());
        ModHandler.addShapelessNBTClearingRecipe("clipboard_nbt", MetaItems.CLIPBOARD.getStackForm(), MetaItems.CLIPBOARD.getStackForm());
    }

    private static void ConvertHatchToHatch() {
        int i;
        for (i = 0; i < MetaTileEntities.FLUID_IMPORT_HATCH.length; ++i) {
            if (MetaTileEntities.FLUID_IMPORT_HATCH[i] == null || MetaTileEntities.FLUID_EXPORT_HATCH[i] == null) continue;
            ModHandler.addShapedRecipe("fluid_hatch_output_to_input_" + MetaTileEntities.FLUID_IMPORT_HATCH[i].getTier(), MetaTileEntities.FLUID_IMPORT_HATCH[i].getStackForm(), "d", "B", Character.valueOf('B'), MetaTileEntities.FLUID_EXPORT_HATCH[i].getStackForm());
            ModHandler.addShapedRecipe("fluid_hatch_input_to_output_" + MetaTileEntities.FLUID_EXPORT_HATCH[i].getTier(), MetaTileEntities.FLUID_EXPORT_HATCH[i].getStackForm(), "d", "B", Character.valueOf('B'), MetaTileEntities.FLUID_IMPORT_HATCH[i].getStackForm());
        }
        for (i = 0; i < MetaTileEntities.ITEM_IMPORT_BUS.length; ++i) {
            if (MetaTileEntities.ITEM_IMPORT_BUS[i] == null || MetaTileEntities.ITEM_EXPORT_BUS[i] == null) continue;
            ModHandler.addShapedRecipe("item_bus_output_to_input_" + MetaTileEntities.ITEM_IMPORT_BUS[i].getTier(), MetaTileEntities.ITEM_IMPORT_BUS[i].getStackForm(), "d", "B", Character.valueOf('B'), MetaTileEntities.ITEM_EXPORT_BUS[i].getStackForm());
            ModHandler.addShapedRecipe("item_bus_input_to_output_" + MetaTileEntities.ITEM_EXPORT_BUS[i].getTier(), MetaTileEntities.ITEM_EXPORT_BUS[i].getStackForm(), "d", "B", Character.valueOf('B'), MetaTileEntities.ITEM_IMPORT_BUS[i].getStackForm());
        }
        for (i = 0; i < MetaTileEntities.QUADRUPLE_IMPORT_HATCH.length; ++i) {
            if (MetaTileEntities.QUADRUPLE_IMPORT_HATCH[i] == null || MetaTileEntities.QUADRUPLE_EXPORT_HATCH[i] == null) continue;
            ModHandler.addShapedRecipe("quadruple_fluid_hatch_output_to_input_" + MetaTileEntities.QUADRUPLE_IMPORT_HATCH[i].getTier(), MetaTileEntities.QUADRUPLE_IMPORT_HATCH[i].getStackForm(), "d", "B", Character.valueOf('B'), MetaTileEntities.QUADRUPLE_EXPORT_HATCH[i].getStackForm());
            ModHandler.addShapedRecipe("quadruple_fluid_hatch_input_to_output_" + MetaTileEntities.QUADRUPLE_EXPORT_HATCH[i].getTier(), MetaTileEntities.QUADRUPLE_EXPORT_HATCH[i].getStackForm(), "d", "B", Character.valueOf('B'), MetaTileEntities.QUADRUPLE_IMPORT_HATCH[i].getStackForm());
        }
        for (i = 0; i < MetaTileEntities.NONUPLE_IMPORT_HATCH.length; ++i) {
            if (MetaTileEntities.NONUPLE_IMPORT_HATCH[i] == null || MetaTileEntities.NONUPLE_EXPORT_HATCH[i] == null) continue;
            ModHandler.addShapedRecipe("nonuple_fluid_hatch_output_to_input_" + MetaTileEntities.NONUPLE_IMPORT_HATCH[i].getTier(), MetaTileEntities.NONUPLE_IMPORT_HATCH[i].getStackForm(), "d", "B", Character.valueOf('B'), MetaTileEntities.NONUPLE_EXPORT_HATCH[i].getStackForm());
            ModHandler.addShapedRecipe("nonuple_fluid_hatch_input_to_output_" + MetaTileEntities.NONUPLE_EXPORT_HATCH[i].getTier(), MetaTileEntities.NONUPLE_EXPORT_HATCH[i].getStackForm(), "d", "B", Character.valueOf('B'), MetaTileEntities.NONUPLE_IMPORT_HATCH[i].getStackForm());
        }
        if (Mods.AppliedEnergistics2.isModLoaded()) {
            ModHandler.addShapedRecipe("me_fluid_hatch_output_to_input", MetaTileEntities.FLUID_IMPORT_HATCH_ME.getStackForm(), "d", "B", Character.valueOf('B'), MetaTileEntities.FLUID_EXPORT_HATCH_ME.getStackForm());
            ModHandler.addShapedRecipe("me_fluid_hatch_input_to_output", MetaTileEntities.FLUID_EXPORT_HATCH_ME.getStackForm(), "d", "B", Character.valueOf('B'), MetaTileEntities.FLUID_IMPORT_HATCH_ME.getStackForm());
            ModHandler.addShapedRecipe("me_item_bus_output_to_input", MetaTileEntities.ITEM_IMPORT_BUS_ME.getStackForm(), "d", "B", Character.valueOf('B'), MetaTileEntities.ITEM_EXPORT_BUS_ME.getStackForm());
            ModHandler.addShapedRecipe("me_item_bus_input_to_output", MetaTileEntities.ITEM_EXPORT_BUS_ME.getStackForm(), "d", "B", Character.valueOf('B'), MetaTileEntities.ITEM_IMPORT_BUS_ME.getStackForm());
        }
        if (MetaTileEntities.STEAM_EXPORT_BUS != null && MetaTileEntities.STEAM_IMPORT_BUS != null) {
            ModHandler.addShapedRecipe("steam_bus_output_to_input_" + MetaTileEntities.STEAM_EXPORT_BUS.getTier(), MetaTileEntities.STEAM_EXPORT_BUS.getStackForm(), "d", "B", Character.valueOf('B'), MetaTileEntities.STEAM_IMPORT_BUS.getStackForm());
            ModHandler.addShapedRecipe("steam_bus_input_to_output_" + MetaTileEntities.STEAM_IMPORT_BUS.getTier(), MetaTileEntities.STEAM_IMPORT_BUS.getStackForm(), "d", "B", Character.valueOf('B'), MetaTileEntities.STEAM_EXPORT_BUS.getStackForm());
        }
    }
}

