/*
 * Decompiled with CFR 0.152.
 */
package gregtech.integration.theoneprobe.provider;

import gregtech.api.capability.GregtechTileCapabilities;
import gregtech.api.capability.ILaserContainer;
import gregtech.api.util.TextFormattingUtil;
import gregtech.integration.theoneprobe.provider.CapabilityInfoProvider;
import mcjty.theoneprobe.api.IProbeHitData;
import mcjty.theoneprobe.api.IProbeInfo;
import mcjty.theoneprobe.api.NumberFormat;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.capabilities.Capability;
import org.jetbrains.annotations.NotNull;

public class LaserContainerInfoProvider
extends CapabilityInfoProvider<ILaserContainer> {
    @Override
    @NotNull
    protected Capability<ILaserContainer> getCapability() {
        return GregtechTileCapabilities.CAPABILITY_LASER;
    }

    @Override
    protected boolean allowDisplaying(@NotNull ILaserContainer capability) {
        return !capability.isOneProbeHidden();
    }

    @Override
    protected void addProbeInfo(ILaserContainer capability, IProbeInfo probeInfo, EntityPlayer player, TileEntity tileEntity, IProbeHitData data) {
        long maxStorage = capability.getEnergyCapacity();
        if (maxStorage == 0L) {
            return;
        }
        probeInfo.progress(capability.getEnergyStored(), maxStorage, probeInfo.defaultProgressStyle().suffix(" / " + TextFormattingUtil.formatNumbers(maxStorage) + " EU").filledColor(-1120768).alternateFilledColor(-1120768).borderColor(-11184811).numberFormat(NumberFormat.COMMAS));
    }

    public String getID() {
        return "gregtech:laser_container_provider";
    }
}

