/*
 * Decompiled with CFR 0.152.
 */
package gregtech.integration.opencomputers.values;

import gregtech.api.cover.Cover;
import gregtech.common.covers.CoverFluidFilter;
import gregtech.common.covers.FluidFilterMode;
import gregtech.integration.opencomputers.InputValidator;
import gregtech.integration.opencomputers.values.ValueCoverBehavior;
import li.cil.oc.api.machine.Arguments;
import li.cil.oc.api.machine.Callback;
import li.cil.oc.api.machine.Context;
import net.minecraft.util.EnumFacing;

public class ValueCoverFluidFilter
extends ValueCoverBehavior {
    public ValueCoverFluidFilter(CoverFluidFilter coverBehavior, EnumFacing side) {
        super(coverBehavior, side, "gt_coverFluidFilter");
    }

    @Override
    protected CoverFluidFilter getCover() {
        Cover cover = super.getCover();
        return cover instanceof CoverFluidFilter ? (CoverFluidFilter)cover : null;
    }

    @Callback(doc="function(mode:number) --  Sets filter mode. (0:FILTER_FILL, 1:FILTER_DRAIN, 2:FILTER_BOTH)")
    public Object[] setFilterMode(Context context, Arguments args) {
        CoverFluidFilter cover = this.getCover();
        if (cover == null) {
            return this.NULL_COVER;
        }
        FluidFilterMode mode = (FluidFilterMode)InputValidator.getEnumArrayIndex((Arguments)args, (int)0, (Enum[])FluidFilterMode.values());
        cover.setFilterMode(mode);
        return new Object[0];
    }

    @Callback(doc="function():number --  Gets filter mode. (0:FILTER_FILL, 1:FILTER_DRAIN, 2:FILTER_BOTH)")
    public Object[] getFilterMode(Context context, Arguments args) {
        CoverFluidFilter cover = this.getCover();
        if (cover == null) {
            return this.NULL_COVER;
        }
        return new Object[]{cover.getFilterMode().ordinal()};
    }
}

