/*
 * Decompiled with CFR 0.152.
 */
package gregtech.integration.opencomputers.values;

import gregtech.api.cover.Cover;
import gregtech.common.covers.CoverConveyor;
import gregtech.integration.opencomputers.InputValidator;
import gregtech.integration.opencomputers.values.ValueCoverBehavior;
import li.cil.oc.api.machine.Arguments;
import li.cil.oc.api.machine.Callback;
import li.cil.oc.api.machine.Context;
import net.minecraft.util.EnumFacing;

public class ValueCoverConveyor
extends ValueCoverBehavior {
    protected ValueCoverConveyor(CoverConveyor coverBehavior, EnumFacing side, String name) {
        super(coverBehavior, side, name);
    }

    public ValueCoverConveyor(CoverConveyor coverBehavior, EnumFacing side) {
        this(coverBehavior, side, "gt_coverConveyor");
    }

    @Override
    protected CoverConveyor getCover() {
        CoverConveyor conveyor;
        Cover cover = super.getCover();
        return cover instanceof CoverConveyor ? (conveyor = (CoverConveyor)cover) : null;
    }

    @Callback(doc="function():number --  Returns tier.")
    public Object[] getTier(Context context, Arguments args) {
        CoverConveyor cover = this.getCover();
        if (cover == null) {
            return this.NULL_COVER;
        }
        return new Object[]{cover.tier};
    }

    @Callback(doc="function():number --  Returns transfer rate.")
    public Object[] getTransferRate(Context context, Arguments args) {
        CoverConveyor cover = this.getCover();
        if (cover == null) {
            return this.NULL_COVER;
        }
        return new Object[]{cover.getTransferRate()};
    }

    @Callback(doc="function(number) --  Sets transfer rate.")
    public Object[] setTransferRate(Context context, Arguments args) {
        CoverConveyor cover = this.getCover();
        if (cover == null) {
            return this.NULL_COVER;
        }
        int transferRate = InputValidator.getInteger(args, 0, 0, cover.maxItemTransferRate);
        cover.setTransferRate(transferRate);
        return new Object[0];
    }

    @Callback(doc="function(mode:number) --  Sets conveyor mode. (0:IMPORT, 1:EXPORT)")
    public Object[] setConveyorMode(Context context, Arguments args) {
        CoverConveyor cover = this.getCover();
        if (cover == null) {
            return this.NULL_COVER;
        }
        CoverConveyor.ConveyorMode mode = (CoverConveyor.ConveyorMode)InputValidator.getEnumArrayIndex((Arguments)args, (int)0, (Enum[])CoverConveyor.ConveyorMode.values());
        cover.setConveyorMode(mode);
        return new Object[0];
    }

    @Callback(doc="function():number --  Gets conveyor mode. (0:IMPORT, 1:EXPORT)")
    public Object[] getConveyorMode(Context context, Arguments args) {
        CoverConveyor cover = this.getCover();
        if (cover == null) {
            return this.NULL_COVER;
        }
        return new Object[]{cover.getConveyorMode().ordinal()};
    }
}

