/*
 * Decompiled with CFR 0.152.
 */
package gregtech.integration.opencomputers.values;

import gregtech.api.capability.GregtechTileCapabilities;
import gregtech.api.cover.Cover;
import gregtech.api.cover.CoverableView;
import gregtech.api.metatileentity.interfaces.IGregTechTileEntity;
import java.util.Objects;
import li.cil.oc.api.machine.Arguments;
import li.cil.oc.api.machine.Callback;
import li.cil.oc.api.machine.Context;
import li.cil.oc.api.prefab.AbstractValue;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.common.FMLCommonHandler;

public class ValueCoverBehavior
extends AbstractValue {
    private BlockPos pos;
    private EnumFacing side;
    private int dim;
    private String coverName;
    public final Object[] NULL_COVER = new Object[]{null, "Found no cover, this is an invalid object."};

    protected ValueCoverBehavior(Cover cover, EnumFacing side, String coverName) {
        this.pos = cover.getPos();
        this.dim = cover.getWorld().field_73011_w.getDimension();
        this.side = side;
        this.coverName = coverName;
    }

    public ValueCoverBehavior(Cover coverBehavior, EnumFacing side) {
        this(coverBehavior, side, "gt_coverBehavior");
    }

    protected Cover getCover() {
        CoverableView coverable;
        WorldServer world = FMLCommonHandler.instance().getMinecraftServerInstance().func_71218_a(this.dim);
        TileEntity te = world.func_175625_s(this.pos);
        if (te instanceof IGregTechTileEntity && (coverable = (CoverableView)te.getCapability(GregtechTileCapabilities.CAPABILITY_COVER_HOLDER, null)) != null) {
            return coverable.getCoverAtSide(this.side);
        }
        return null;
    }

    @Callback(doc="function():number --  Returns the side of the cover.")
    public Object[] getSide(Context context, Arguments args) {
        return new Object[]{this.side.ordinal()};
    }

    @Callback(doc="function():string --  Returns the type name of the cover.")
    public Object[] getTypeName(Context context, Arguments args) {
        return new Object[]{this.coverName};
    }

    @Callback(doc="function():number --  Gets redstone signal output.")
    public final Object[] getRedstoneSignalOutput(Context context, Arguments args) {
        Cover cover = this.getCover();
        if (cover == null) {
            return this.NULL_COVER;
        }
        return new Object[]{cover.getRedstoneSignalOutput()};
    }

    @Callback(doc="function():number --  Gets redstone signal input.")
    public final Object[] getRedstoneSignalInput(Context context, Arguments args) {
        Cover cover = this.getCover();
        if (cover == null) {
            return this.NULL_COVER;
        }
        return new Object[]{cover.getCoverableView().getInputRedstoneSignal(cover.getAttachedSide(), true)};
    }

    public int hashCode() {
        return Objects.hash(this.pos, this.dim);
    }

    public Object[] call(Context context, Arguments arguments) {
        return new Object[0];
    }

    public void load(NBTTagCompound nbt) {
        this.dim = nbt.func_74762_e("dim");
        this.pos = NBTUtil.func_186861_c((NBTTagCompound)nbt.func_74775_l("pos"));
        this.side = EnumFacing.values()[nbt.func_74762_e("side")];
        this.coverName = nbt.func_74779_i("name");
    }

    public void save(NBTTagCompound nbt) {
        nbt.func_74782_a("pos", (NBTBase)NBTUtil.func_186859_a((BlockPos)this.pos));
        nbt.func_74768_a("dim", this.dim);
        nbt.func_74768_a("side", this.side.ordinal());
        nbt.func_74778_a("name", this.coverName);
    }
}

