/*
 * Decompiled with CFR 0.152.
 */
package gregtech.integration.opencomputers.drivers;

import gregtech.api.capability.GregtechTileCapabilities;
import gregtech.api.capability.IWorkable;
import gregtech.api.metatileentity.interfaces.IGregTechTileEntity;
import gregtech.integration.opencomputers.drivers.EnvironmentMetaTileEntity;
import li.cil.oc.api.machine.Arguments;
import li.cil.oc.api.machine.Callback;
import li.cil.oc.api.machine.Context;
import li.cil.oc.api.network.ManagedEnvironment;
import li.cil.oc.api.prefab.DriverSidedTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class DriverWorkable
extends DriverSidedTileEntity {
    public Class<?> getTileEntityClass() {
        return IWorkable.class;
    }

    public boolean worksWith(World world, BlockPos pos, EnumFacing side) {
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity instanceof IGregTechTileEntity) {
            return tileEntity.hasCapability(GregtechTileCapabilities.CAPABILITY_WORKABLE, side);
        }
        return false;
    }

    public ManagedEnvironment createEnvironment(World world, BlockPos pos, EnumFacing side) {
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity instanceof IGregTechTileEntity) {
            return new EnvironmentIWorkable((IGregTechTileEntity)tileEntity, (IWorkable)tileEntity.getCapability(GregtechTileCapabilities.CAPABILITY_WORKABLE, side));
        }
        return null;
    }

    public static final class EnvironmentIWorkable
    extends EnvironmentMetaTileEntity<IWorkable> {
        public EnvironmentIWorkable(IGregTechTileEntity holder, IWorkable capability) {
            super(holder, capability, "gt_workable");
        }

        @Callback(doc="function():number --  Returns the MaxProgress!")
        public Object[] getMaxProgress(Context context, Arguments args) {
            return new Object[]{((IWorkable)this.tileEntity).getMaxProgress()};
        }

        @Callback(doc="function():number --  Returns the Progress!")
        public Object[] getProgress(Context context, Arguments args) {
            return new Object[]{((IWorkable)this.tileEntity).getProgress()};
        }

        @Callback(doc="function():boolean --  Returns is active or not.")
        public Object[] isActive(Context context, Arguments args) {
            return new Object[]{((IWorkable)this.tileEntity).isActive()};
        }

        @Callback(doc="function():boolean --  Returns is working enabled.")
        public Object[] isWorkingEnabled(Context context, Arguments args) {
            return new Object[]{((IWorkable)this.tileEntity).isWorkingEnabled()};
        }

        @Callback(doc="function(workingEnabled:boolean):boolean -- Sets working enabled, return last working enabled.")
        public Object[] setWorkingEnabled(Context context, Arguments args) {
            boolean lsatState = ((IWorkable)this.tileEntity).isWorkingEnabled();
            ((IWorkable)this.tileEntity).setWorkingEnabled(args.checkBoolean(0));
            return new Object[]{lsatState};
        }
    }
}

