/*
 * Decompiled with CFR 0.152.
 */
package gregtech.integration.opencomputers.drivers;

import gregtech.api.capability.GregtechTileCapabilities;
import gregtech.api.capability.IMultipleTankHandler;
import gregtech.api.capability.impl.MultiblockRecipeLogic;
import gregtech.api.metatileentity.interfaces.IGregTechTileEntity;
import gregtech.api.metatileentity.multiblock.RecipeMapMultiblockController;
import gregtech.integration.opencomputers.drivers.EnvironmentMetaTileEntity;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.ArrayList;
import li.cil.oc.api.machine.Arguments;
import li.cil.oc.api.machine.Callback;
import li.cil.oc.api.machine.Context;
import li.cil.oc.api.network.ManagedEnvironment;
import li.cil.oc.api.prefab.DriverSidedTileEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.items.IItemHandlerModifiable;
import org.jetbrains.annotations.NotNull;

public class DriverRecipeMapMultiblockController
extends DriverSidedTileEntity {
    public Class<?> getTileEntityClass() {
        return MultiblockRecipeLogic.class;
    }

    public boolean worksWith(World world, BlockPos pos, EnumFacing side) {
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity instanceof IGregTechTileEntity) {
            return tileEntity.hasCapability(GregtechTileCapabilities.CAPABILITY_WORKABLE, side);
        }
        return false;
    }

    public ManagedEnvironment createEnvironment(World world, BlockPos pos, EnumFacing side) {
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity instanceof IGregTechTileEntity && ((IGregTechTileEntity)tileEntity).getMetaTileEntity() instanceof RecipeMapMultiblockController) {
            return new EnvironmentMultiblockRecipeLogic((IGregTechTileEntity)tileEntity, (RecipeMapMultiblockController)((IGregTechTileEntity)tileEntity).getMetaTileEntity());
        }
        return null;
    }

    public static final class EnvironmentMultiblockRecipeLogic
    extends EnvironmentMetaTileEntity<RecipeMapMultiblockController> {
        public EnvironmentMultiblockRecipeLogic(IGregTechTileEntity holder, RecipeMapMultiblockController capability) {
            super(holder, capability, "gt_multiblockRecipeLogic");
        }

        @Callback(doc="function():number --  Returns the amount of electricity contained in this Block, in EU units!")
        public Object[] getEnergyStored(Context context, Arguments args) {
            return new Object[]{((RecipeMapMultiblockController)this.tileEntity).getEnergyContainer().getEnergyStored()};
        }

        @Callback(doc="function():number --  Returns the amount of electricity containable in this Block, in EU units!")
        public Object[] getEnergyCapacity(Context context, Arguments args) {
            return new Object[]{((RecipeMapMultiblockController)this.tileEntity).getEnergyContainer().getEnergyCapacity()};
        }

        @Callback(doc="function():number --  Gets the Output in EU/p.")
        public Object[] getOutputVoltage(Context context, Arguments args) {
            return new Object[]{((RecipeMapMultiblockController)this.tileEntity).getEnergyContainer().getOutputVoltage()};
        }

        @Callback(doc="function():number -- Gets the amount of Energy Packets per tick.")
        public Object[] getOutputAmperage(Context context, Arguments args) {
            return new Object[]{((RecipeMapMultiblockController)this.tileEntity).getEnergyContainer().getOutputAmperage()};
        }

        @Callback(doc="function():number -- Gets the maximum Input in EU/p.")
        public Object[] getInputVoltage(Context context, Arguments args) {
            return new Object[]{((RecipeMapMultiblockController)this.tileEntity).getEnergyContainer().getInputVoltage()};
        }

        @Callback(doc="function():number -- Gets the amount of Energy Packets per tick.")
        public Object[] getInputAmperage(Context context, Arguments args) {
            return new Object[]{((RecipeMapMultiblockController)this.tileEntity).getEnergyContainer().getInputAmperage()};
        }

        @Callback(doc="function():number -- Gets the energy input per second.")
        public Object[] getInputPerSec(Context context, Arguments args) {
            return new Object[]{((RecipeMapMultiblockController)this.tileEntity).getEnergyContainer().getInputPerSec()};
        }

        @Callback(doc="function():number -- Gets the energy output per second.")
        public Object[] getOutputPerSec(Context context, Arguments args) {
            return new Object[]{((RecipeMapMultiblockController)this.tileEntity).getEnergyContainer().getOutputPerSec()};
        }

        @NotNull
        private Object[] getInventory(IItemHandlerModifiable handler) {
            ArrayList<Object2ObjectOpenHashMap> result = new ArrayList<Object2ObjectOpenHashMap>();
            for (int slot = 0; slot < handler.getSlots(); ++slot) {
                ItemStack itemStack = handler.getStackInSlot(slot);
                if (itemStack.func_190926_b()) continue;
                Object2ObjectOpenHashMap map = new Object2ObjectOpenHashMap();
                map.put("count", itemStack.func_190916_E());
                map.put("name", itemStack.func_82833_r());
                result.add(map);
            }
            return new Object[]{result};
        }

        @Callback(doc="function():table -- Gets the Input Inventory.")
        public Object[] getInputInventory(Context context, Arguments args) {
            return this.getInventory(((RecipeMapMultiblockController)this.tileEntity).getInputInventory());
        }

        @Callback(doc="function():table -- Gets the Output Inventory.")
        public Object[] getOutputInventory(Context context, Arguments args) {
            return this.getInventory(((RecipeMapMultiblockController)this.tileEntity).getOutputInventory());
        }

        @NotNull
        private Object[] getTank(IMultipleTankHandler handler) {
            ArrayList result = new ArrayList();
            handler.getFluidTanks().forEach(tank -> {
                Object2ObjectOpenHashMap map = new Object2ObjectOpenHashMap();
                FluidStack fluid = tank.getFluid();
                if (fluid == null) {
                    map.put("amount", 0);
                    map.put("name", null);
                } else {
                    map.put("amount", fluid.amount);
                    map.put("name", fluid.getFluid().getName());
                }
                result.add(map);
            });
            return new Object[]{result};
        }

        @Callback(doc="function():table -- Gets the Input Tank.")
        public Object[] getInputTank(Context context, Arguments args) {
            return this.getTank(((RecipeMapMultiblockController)this.tileEntity).getInputFluidInventory());
        }

        @Callback(doc="function():table -- Gets the Output Tank.")
        public Object[] getOutputTank(Context context, Arguments args) {
            return this.getTank(((RecipeMapMultiblockController)this.tileEntity).getOutputFluidInventory());
        }

        @Callback(doc="function():number -- Gets the number of maintenance problems.")
        public Object[] getMaintenanceProblems(Context context, Arguments args) {
            return new Object[]{((RecipeMapMultiblockController)this.tileEntity).getNumMaintenanceProblems()};
        }
    }
}

