/*
 * Decompiled with CFR 0.152.
 */
package gregtech.integration.jei.utils.render;

import gregtech.api.recipes.chance.boost.BoostableChanceEntry;
import gregtech.api.recipes.chance.output.ChancedOutputLogic;
import gregtech.api.util.TextFormattingUtil;
import gregtech.client.utils.RenderUtil;
import mezz.jei.api.gui.IDrawable;
import mezz.jei.plugins.vanilla.ingredients.fluid.FluidStackRenderer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraftforge.fluids.FluidStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FluidStackTextRenderer
extends FluidStackRenderer {
    private boolean notConsumed;
    private int chanceBase = -1;
    private int chanceBoost = -1;
    private ChancedOutputLogic chanceLogic;

    public FluidStackTextRenderer(int capacityMb, boolean showCapacity, int width, int height, @Nullable IDrawable overlay) {
        super(capacityMb, showCapacity, width, height, overlay);
        this.notConsumed = false;
    }

    public FluidStackTextRenderer setNotConsumed(boolean notConsumed) {
        this.notConsumed = notConsumed;
        return this;
    }

    public FluidStackTextRenderer(int capacityMb, boolean showCapacity, int width, int height, @Nullable IDrawable overlay, BoostableChanceEntry<FluidStack> chance, ChancedOutputLogic chanceLogic) {
        if (chance != null) {
            this.chanceBase = chance.getChance();
            this.chanceBoost = chance.getChanceBoost();
            this.chanceLogic = chanceLogic;
        }
        this.notConsumed = false;
    }

    public void render(@NotNull Minecraft minecraft, int xPosition, int yPosition, @Nullable FluidStack fluidStack) {
        if (fluidStack == null) {
            return;
        }
        GlStateManager.func_179084_k();
        RenderUtil.drawFluidForGui(fluidStack, fluidStack.amount, xPosition, yPosition, 17, 17);
        GlStateManager.func_179094_E();
        GlStateManager.func_179139_a((double)0.5, (double)0.5, (double)1.0);
        String s = TextFormattingUtil.formatLongToCompactString(fluidStack.amount, 4) + "L";
        FontRenderer fontRenderer = Minecraft.func_71410_x().field_71466_p;
        fontRenderer.func_175063_a(s, (float)((xPosition + 6) * 2 - fontRenderer.func_78256_a(s) + 19), (float)((yPosition + 11) * 2), 0xFFFFFF);
        GlStateManager.func_179121_F();
        if (this.chanceBase >= 0) {
            GlStateManager.func_179094_E();
            GlStateManager.func_179139_a((double)0.5, (double)0.5, (double)1.0);
            GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)160.0f);
            String s2 = this.chanceBase / 100 + "%";
            if (this.chanceLogic != null && this.chanceLogic != ChancedOutputLogic.NONE && this.chanceLogic != ChancedOutputLogic.OR) {
                s2 = s2 + "*";
            } else if (this.chanceBoost > 0) {
                s2 = s2 + "+";
            }
            fontRenderer.func_175063_a(s2, (float)((xPosition + 6) * 2 - fontRenderer.func_78256_a(s2) + 19), (float)((yPosition + 1) * 2), 0xFFFF00);
            GlStateManager.func_179121_F();
        } else if (this.notConsumed) {
            GlStateManager.func_179094_E();
            GlStateManager.func_179139_a((double)0.5, (double)0.5, (double)1.0);
            fontRenderer.func_175063_a("NC", (float)((xPosition + 6) * 2 - fontRenderer.func_78256_a("NC") + 19), (float)((yPosition + 1) * 2), 0xFFFF00);
            GlStateManager.func_179121_F();
        }
        GlStateManager.func_179147_l();
    }
}

