/*
 * Decompiled with CFR 0.152.
 */
package gregtech.integration.jei.utils;

import com.google.common.collect.ImmutableSet;
import gregtech.api.gui.Widget;
import gregtech.api.gui.impl.ModularUIContainer;
import gregtech.api.gui.impl.ModularUIGui;
import gregtech.api.gui.ingredient.IGhostIngredientTarget;
import gregtech.api.gui.ingredient.IIngredientSlot;
import gregtech.api.gui.ingredient.IRecipeTransferHandlerWidget;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import mezz.jei.api.gui.IAdvancedGuiHandler;
import mezz.jei.api.gui.IGhostIngredientHandler;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.recipe.transfer.IRecipeTransferError;
import mezz.jei.api.recipe.transfer.IRecipeTransferHandler;
import mezz.jei.api.recipe.transfer.IRecipeTransferHandlerHelper;
import net.minecraft.entity.player.EntityPlayer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ModularUIGuiHandler
implements IAdvancedGuiHandler<ModularUIGui>,
IGhostIngredientHandler<ModularUIGui>,
IRecipeTransferHandler<ModularUIContainer> {
    private final IRecipeTransferHandlerHelper transferHelper;
    private Predicate<IRecipeTransferHandlerWidget> validHandlers = widget -> true;
    private final Set<String> recipeTransferCategoryBlacklist = new ObjectOpenHashSet();

    public ModularUIGuiHandler(IRecipeTransferHandlerHelper transferHelper) {
        this.transferHelper = transferHelper;
    }

    public void setValidHandlers(Predicate<IRecipeTransferHandlerWidget> validHandlers) {
        this.validHandlers = validHandlers;
    }

    @NotNull
    public Class<ModularUIGui> getGuiContainerClass() {
        return ModularUIGui.class;
    }

    @NotNull
    public Class<ModularUIContainer> getContainerClass() {
        return ModularUIContainer.class;
    }

    @Nullable
    public IRecipeTransferError transferRecipe(@NotNull ModularUIContainer container, @NotNull IRecipeLayout recipeLayout, @NotNull EntityPlayer player, boolean maxTransfer, boolean doTransfer) {
        if (this.recipeTransferCategoryBlacklist.contains(recipeLayout.getRecipeCategory().getUid())) {
            return this.transferHelper.createInternalError();
        }
        Optional<IRecipeTransferHandlerWidget> transferHandler = container.getModularUI().getFlatVisibleWidgetCollection().stream().filter(it -> it instanceof IRecipeTransferHandlerWidget).map(it -> (IRecipeTransferHandlerWidget)((Object)it)).filter(this.validHandlers).findFirst();
        if (!transferHandler.isPresent()) {
            return this.transferHelper.createInternalError();
        }
        String errorTooltip = transferHandler.get().transferRecipe(container, recipeLayout, player, maxTransfer, doTransfer);
        if (errorTooltip == null) {
            return null;
        }
        return this.transferHelper.createUserErrorWithTooltip(errorTooltip);
    }

    public void blacklistCategory(String ... category) {
        Collections.addAll(this.recipeTransferCategoryBlacklist, category);
    }

    @Nullable
    public Object getIngredientUnderMouse(ModularUIGui gui, int mouseX, int mouseY) {
        ImmutableSet widgets = gui.getModularUI().guiWidgets.values();
        for (Widget widget : widgets) {
            Object result;
            if (!(widget instanceof IIngredientSlot) || (result = ((IIngredientSlot)((Object)widget)).getIngredientOverMouse(mouseX, mouseY)) == null) continue;
            return result;
        }
        return null;
    }

    @NotNull
    public <I> List<IGhostIngredientHandler.Target<I>> getTargets(ModularUIGui gui, @NotNull I ingredient, boolean doStart) {
        ImmutableSet widgets = gui.getModularUI().guiWidgets.values();
        ArrayList<IGhostIngredientHandler.Target<I>> targets = new ArrayList<IGhostIngredientHandler.Target<I>>();
        for (Widget widget : widgets) {
            if (!(widget instanceof IGhostIngredientTarget)) continue;
            IGhostIngredientTarget ghostTarget = (IGhostIngredientTarget)((Object)widget);
            List<IGhostIngredientHandler.Target<?>> widgetTargets = ghostTarget.getPhantomTargets(ingredient);
            targets.addAll(widgetTargets);
        }
        return targets;
    }

    @Nullable
    public List<Rectangle> getGuiExtraAreas(@NotNull ModularUIGui guiContainer) {
        return Collections.emptyList();
    }

    public void onComplete() {
    }
}

