/*
 * Decompiled with CFR 0.152.
 */
package gregtech.integration.hwyla.provider;

import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.interfaces.IGregTechTileEntity;
import gregtech.api.metatileentity.multiblock.IPrimitivePump;
import gregtech.api.util.TextFormattingUtil;
import java.util.List;
import mcp.mobius.waila.api.IWailaConfigHandler;
import mcp.mobius.waila.api.IWailaDataAccessor;
import mcp.mobius.waila.api.IWailaDataProvider;
import mcp.mobius.waila.api.IWailaRegistrar;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import org.jetbrains.annotations.NotNull;

public class PrimitivePumpDataProvider
implements IWailaDataProvider {
    public static final PrimitivePumpDataProvider INSTANCE = new PrimitivePumpDataProvider();

    public void register(@NotNull IWailaRegistrar registrar) {
        registrar.registerBodyProvider((IWailaDataProvider)this, IGregTechTileEntity.class);
        registrar.registerNBTProvider((IWailaDataProvider)this, IGregTechTileEntity.class);
        registrar.addConfig("GregTech", "gregtech.primitive_pump");
    }

    @NotNull
    public NBTTagCompound getNBTData(EntityPlayerMP player, TileEntity te, NBTTagCompound tag, World world, BlockPos pos) {
        IGregTechTileEntity gtte;
        MetaTileEntity metaTileEntity;
        if (te instanceof IGregTechTileEntity && (metaTileEntity = (gtte = (IGregTechTileEntity)te).getMetaTileEntity()) instanceof IPrimitivePump) {
            IPrimitivePump pump = (IPrimitivePump)((Object)metaTileEntity);
            NBTTagCompound subTag = new NBTTagCompound();
            subTag.func_74768_a("Production", pump.getFluidProduction());
            tag.func_74782_a("gregtech.IPrimitivePump", (NBTBase)subTag);
        }
        return tag;
    }

    @NotNull
    public List<String> getWailaBody(ItemStack itemStack, List<String> tooltip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        IGregTechTileEntity gtte;
        TileEntity tileEntity;
        if (!(config.getConfig("gregtech.primitive_pump") && (tileEntity = accessor.getTileEntity()) instanceof IGregTechTileEntity && (gtte = (IGregTechTileEntity)tileEntity).getMetaTileEntity() instanceof IPrimitivePump)) {
            return tooltip;
        }
        if (accessor.getNBTData().func_74764_b("gregtech.IPrimitivePump")) {
            NBTTagCompound tag = accessor.getNBTData().func_74775_l("gregtech.IPrimitivePump");
            int production = tag.func_74762_e("Production");
            tooltip.add(I18n.func_135052_a((String)"gregtech.top.primitive_pump_production", (Object[])new Object[0]) + " " + TextFormatting.AQUA + TextFormattingUtil.formatNumbers(production) + TextFormatting.RESET + " L/s");
        }
        return tooltip;
    }
}

