/*
 * Decompiled with CFR 0.152.
 */
package gregtech.integration.hwyla.provider;

import gregtech.api.unification.ore.StoneType;
import gregtech.common.blocks.BlockOre;
import gregtech.integration.hwyla.HWYLAModule;
import java.util.List;
import mcp.mobius.waila.api.IWailaConfigHandler;
import mcp.mobius.waila.api.IWailaDataAccessor;
import mcp.mobius.waila.api.IWailaDataProvider;
import mcp.mobius.waila.api.IWailaRegistrar;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public class BlockOreDataProvider
implements IWailaDataProvider {
    public static final BlockOreDataProvider INSTANCE = new BlockOreDataProvider();

    public void register(@NotNull IWailaRegistrar registrar) {
        registrar.registerBodyProvider((IWailaDataProvider)this, BlockOre.class);
        registrar.addConfig("GregTech", "gregtech.block_ore");
    }

    @NotNull
    public List<String> getWailaBody(ItemStack itemStack, List<String> tooltip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        if (!config.getConfig("gregtech.block_ore")) {
            return tooltip;
        }
        Block block = accessor.getBlock();
        if (block instanceof BlockOre) {
            BlockOre ore = (BlockOre)block;
            StoneType type = (StoneType)accessor.getBlockState().func_177229_b((IProperty)ore.STONE_TYPE);
            if (accessor.getPlayer().func_70093_af() && !type.shouldBeDroppedAsItem) {
                tooltip.add(I18n.func_135052_a((String)"gregtech.top.block_drops", (Object[])new Object[0]) + ":");
                ItemStack itemDropped = ore.func_185473_a(accessor.getWorld(), accessor.getPosition(), accessor.getBlockState());
                tooltip.add(HWYLAModule.wailaStackWithName(itemDropped));
            }
        }
        return tooltip;
    }
}

