/*
 * Decompiled with CFR 0.152.
 */
package gregtech.integration.forestry.bees;

import forestry.api.apiculture.BeeManager;
import forestry.api.arboriculture.TreeManager;
import forestry.api.core.IItemModelRegister;
import forestry.api.core.IModelManager;
import forestry.api.core.Tabs;
import forestry.api.genetics.AlleleManager;
import forestry.api.genetics.ISpeciesRoot;
import forestry.api.lepidopterology.ButterflyManager;
import forestry.core.items.IColoredItem;
import gregtech.integration.forestry.bees.GTDropType;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GTDropItem
extends Item
implements IColoredItem,
IItemModelRegister {
    public GTDropItem() {
        this.func_77627_a(true);
        this.func_77637_a(Tabs.tabApiculture);
        this.func_77655_b("gt.honey_drop");
        this.setRegistryName("gregtech", "gt.honey_drop");
        this.setResearchSuitability((ISpeciesRoot)BeeManager.beeRoot);
        this.setResearchSuitability((ISpeciesRoot)TreeManager.treeRoot);
        this.setResearchSuitability((ISpeciesRoot)ButterflyManager.butterflyRoot);
        this.setResearchSuitability(AlleleManager.alleleRegistry.getSpeciesRoot("rootFlowers"));
    }

    private void setResearchSuitability(@Nullable ISpeciesRoot speciesRoot) {
        if (speciesRoot != null) {
            speciesRoot.setResearchSuitability(new ItemStack((Item)this, 1, Short.MAX_VALUE), 0.5f);
        }
    }

    public void registerModel(@NotNull Item item, @NotNull IModelManager manager) {
        manager.registerItemModel(item, 0);
        for (int i = 0; i < GTDropType.VALUES.length; ++i) {
            manager.registerItemModel(item, i, "forestry", "gt.honey_drop");
        }
    }

    @NotNull
    public String func_77667_c(@NotNull ItemStack stack) {
        GTDropType type = GTDropType.getDrop(stack.func_77952_i());
        return super.func_77667_c(stack) + "." + type.name;
    }

    public void func_150895_a(@NotNull CreativeTabs tab, @NotNull NonNullList<ItemStack> items) {
        if (tab == Tabs.tabApiculture) {
            for (GTDropType type : GTDropType.VALUES) {
                items.add((Object)new ItemStack((Item)this, 1, type.ordinal()));
            }
        }
    }

    public int getColorFromItemstack(@NotNull ItemStack stack, int i) {
        GTDropType type = GTDropType.getDrop(stack.func_77952_i());
        return type.color[i == 0 ? 0 : 1];
    }
}

