/*
 * Decompiled with CFR 0.152.
 */
package gregtech.integration.forestry.bees;

import forestry.api.apiculture.EnumBeeChromosome;
import forestry.api.apiculture.IAlleleBeeSpeciesBuilder;
import forestry.api.genetics.AlleleManager;
import forestry.api.genetics.IAllele;
import forestry.api.genetics.IAlleleFloat;
import forestry.api.genetics.IChromosomeType;
import forestry.api.genetics.IClassification;
import forestry.apiculture.genetics.alleles.AlleleBeeSpecies;
import forestry.core.genetics.alleles.AlleleFloat;
import gregtech.integration.IntegrationModule;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public class GTAlleleBeeSpecies
extends AlleleBeeSpecies {
    public static IAlleleFloat speedBlinding;

    public GTAlleleBeeSpecies(String modId, String uid, String unlocalizedName, String authority, String unlocalizedDescription, boolean dominant, IClassification branch, String binomial, int primaryColor, int secondaryColor) {
        super(modId, uid, unlocalizedName, authority, unlocalizedDescription, dominant, branch, binomial, primaryColor, secondaryColor);
        AlleleManager.alleleRegistry.registerAllele((IAllele)this, new IChromosomeType[]{EnumBeeChromosome.SPECIES});
    }

    @NotNull
    public IAlleleBeeSpeciesBuilder addProduct(@NotNull ItemStack product, @NotNull Float chance) {
        if (product == ItemStack.field_190927_a) {
            IntegrationModule.logger.warn("GTAlleleBeeSpecies#addProduct() passed an empty ItemStack for allele {}! Setting default", (Object)this.getUID());
            product = new ItemStack(Items.field_151124_az);
        }
        if (chance.floatValue() <= 0.0f || chance.floatValue() > 1.0f) {
            IntegrationModule.logger.warn("GTAlleleBeeSpecies#addProduct() passed a chance value out of bounds for allele {}! Setting to 0.1", (Object)this.getUID());
            chance = Float.valueOf(0.1f);
        }
        return super.addProduct(product, chance);
    }

    @NotNull
    public IAlleleBeeSpeciesBuilder addSpecialty(@NotNull ItemStack specialty, @NotNull Float chance) {
        if (specialty == ItemStack.field_190927_a) {
            IntegrationModule.logger.warn("GTAlleleBeeSpecies#addProduct() passed an empty ItemStack for allele {}! Setting default", (Object)this.getUID());
            specialty = new ItemStack(Items.field_151124_az);
        }
        if (chance.floatValue() <= 0.0f || chance.floatValue() > 1.0f) {
            IntegrationModule.logger.warn("GTAlleleBeeSpecies#addSpecialty() passed a chance value out of bounds for allele {}! Setting to 0.1", (Object)this.getUID());
            chance = Float.valueOf(0.1f);
        }
        return super.addSpecialty(specialty, chance);
    }

    public static void setupAlleles() {
        IAlleleFloat allele = (IAlleleFloat)AlleleManager.alleleRegistry.getAllele("magicbees.speedBlinding");
        if (allele == null) {
            allele = new AlleleFloat("gregtech", "gregtech.speedBlinding", "gregtech.speedBlinding", 2.0f, false);
            AlleleManager.alleleRegistry.registerAllele((IAllele)allele, new IChromosomeType[]{EnumBeeChromosome.SPEED});
        }
        speedBlinding = allele;
    }
}

