/*
 * Decompiled with CFR 0.152.
 */
package gregtech.integration.crafttweaker.recipe;

import com.cleanroommc.groovyscript.api.GroovyLog;
import crafttweaker.CraftTweakerAPI;
import crafttweaker.annotations.BracketHandler;
import crafttweaker.annotations.ZenRegister;
import crafttweaker.api.item.IItemStack;
import crafttweaker.mc1120.item.MCItemStack;
import crafttweaker.zenscript.IBracketHandler;
import gregtech.api.GregTechAPI;
import gregtech.api.items.metaitem.MetaItem;
import gregtech.api.pipenet.block.material.BlockMaterialPipe;
import gregtech.api.unification.material.Material;
import gregtech.api.unification.material.registry.MaterialRegistry;
import gregtech.common.blocks.BlockCompressed;
import gregtech.common.blocks.BlockFrame;
import gregtech.common.blocks.MetaBlocks;
import gregtech.common.pipelike.cable.BlockCable;
import gregtech.common.pipelike.fluidpipe.BlockFluidPipe;
import gregtech.common.pipelike.itempipe.BlockItemPipe;
import gregtech.integration.crafttweaker.recipe.MetaTileEntityBracketHandler;
import gregtech.integration.groovy.GroovyScriptModule;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.minecraft.item.ItemStack;
import stanhebben.zenscript.compiler.IEnvironmentGlobal;
import stanhebben.zenscript.expression.Expression;
import stanhebben.zenscript.expression.ExpressionCallStatic;
import stanhebben.zenscript.expression.ExpressionString;
import stanhebben.zenscript.parser.Token;
import stanhebben.zenscript.symbols.IZenSymbol;
import stanhebben.zenscript.type.natives.IJavaMethod;

@BracketHandler
@ZenRegister
public class MetaItemBracketHandler
implements IBracketHandler {
    private static final Map<String, Map<String, ItemStack>> metaItemNames = new Object2ObjectOpenHashMap();
    private static final Map<String, Map<String, ItemStack>> metaBlockNames = new Object2ObjectOpenHashMap();
    private final IJavaMethod method = CraftTweakerAPI.getJavaMethod(MetaItemBracketHandler.class, (String)"getCtMetaItem", (Class[])new Class[]{String.class});

    public static void rebuildComponentRegistry() {
        ItemStack stack;
        String name;
        String modid;
        Map map;
        metaItemNames.clear();
        for (MetaItem<?> metaItem : MetaItem.getMetaItems()) {
            String namespace = Objects.requireNonNull(metaItem.getRegistryName()).func_110624_b();
            map = metaItemNames.computeIfAbsent(namespace, k -> new Object2ObjectOpenHashMap());
            for (MetaItem.MetaValueItem entry : metaItem.getAllItems()) {
                if ("meta_item".equals(entry.unlocalizedName)) continue;
                map.put(entry.unlocalizedName, entry.getStackForm());
            }
        }
        for (Map.Entry entry : MetaBlocks.COMPRESSED.entrySet()) {
            modid = ((Material)entry.getKey()).getModid();
            map = metaBlockNames.computeIfAbsent(modid, k -> new Object2ObjectOpenHashMap());
            name = "block" + ((Material)entry.getKey()).toCamelCaseString();
            stack = ((BlockCompressed)((Object)entry.getValue())).getItem((Material)entry.getKey());
            map.put(name, stack);
        }
        for (Map.Entry entry : MetaBlocks.FRAMES.entrySet()) {
            modid = ((Material)entry.getKey()).getModid();
            map = metaBlockNames.computeIfAbsent(modid, k -> new Object2ObjectOpenHashMap());
            name = "frame" + ((Material)entry.getKey()).toCamelCaseString();
            stack = ((BlockFrame)((Object)entry.getValue())).getItem((Material)entry.getKey());
            map.put(name, stack);
        }
        for (MaterialRegistry materialRegistry : GregTechAPI.materialManager.getRegistries()) {
            modid = materialRegistry.getModid();
            map = metaBlockNames.computeIfAbsent(modid, k -> new Object2ObjectOpenHashMap());
            for (BlockCable blockCable : MetaBlocks.CABLES.get(modid)) {
                for (Material material : blockCable.getEnabledMaterials()) {
                    map.put(blockCable.getPrefix().name + material.toCamelCaseString(), blockCable.getItem(material));
                }
            }
            for (BlockMaterialPipe blockMaterialPipe : MetaBlocks.ITEM_PIPES.get(modid)) {
                for (Material material : ((BlockItemPipe)blockMaterialPipe).getEnabledMaterials()) {
                    map.put(blockMaterialPipe.getPrefix().name + material.toCamelCaseString(), blockMaterialPipe.getItem(material));
                }
            }
            for (BlockMaterialPipe blockMaterialPipe : MetaBlocks.FLUID_PIPES.get(modid)) {
                for (Material material : ((BlockFluidPipe)blockMaterialPipe).getEnabledMaterials()) {
                    map.put(blockMaterialPipe.getPrefix().name + material.toCamelCaseString(), blockMaterialPipe.getItem(material));
                }
            }
            metaBlockNames.put(modid, map);
        }
    }

    public static void clearComponentRegistry() {
        metaItemNames.clear();
        metaBlockNames.clear();
    }

    public static ItemStack getMetaItem(String name) {
        ItemStack item;
        String[] split = MetaTileEntityBracketHandler.splitObjectName(name);
        String modid = split[0];
        String itemName = split[1];
        Map<String, ItemStack> itemMap = metaItemNames.get(modid);
        Map<String, ItemStack> blockMap = metaBlockNames.get(modid);
        if (itemMap != null && (item = itemMap.get(itemName)) != null) {
            return item.func_77946_l();
        }
        if (blockMap != null && (item = blockMap.get(itemName)) != null) {
            return item.func_77946_l();
        }
        item = MetaTileEntityBracketHandler.getMetaTileEntityItem(split);
        if (item != null) {
            return item.func_77946_l();
        }
        if (GroovyScriptModule.isCurrentlyRunning()) {
            GroovyLog.get().error("Could not resolve metaitem('{}')", new Object[]{name});
        }
        return ItemStack.field_190927_a;
    }

    public static IItemStack getCtMetaItem(String name) {
        ItemStack itemStack = MetaItemBracketHandler.getMetaItem(name);
        if (itemStack.func_190926_b()) {
            CraftTweakerAPI.logError((String)("Could not resolve <metaitem:" + name + ">"));
            return MCItemStack.EMPTY;
        }
        return new MCItemStack(itemStack);
    }

    public IZenSymbol resolve(IEnvironmentGlobal environment, List<Token> tokens) {
        if (tokens.size() < 3) {
            return null;
        }
        if (!tokens.get(0).getValue().equalsIgnoreCase("metaitem")) {
            return null;
        }
        if (!tokens.get(1).getValue().equals(":")) {
            return null;
        }
        StringBuilder nameBuilder = new StringBuilder();
        for (int i = 2; i < tokens.size(); ++i) {
            nameBuilder.append(tokens.get(i).getValue());
        }
        return position -> new ExpressionCallStatic(position, environment, this.method, new Expression[]{new ExpressionString(position, nameBuilder.toString())});
    }
}

