/*
 * Decompiled with CFR 0.152.
 */
package gregtech.integration.crafttweaker.recipe;

import crafttweaker.annotations.ZenRegister;
import crafttweaker.api.item.IItemStack;
import crafttweaker.api.liquid.ILiquidStack;
import crafttweaker.api.minecraft.CraftTweakerMC;
import gregtech.api.recipes.GTRecipeHandler;
import gregtech.api.recipes.Recipe;
import gregtech.api.recipes.RecipeMap;
import gregtech.api.util.GTLog;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.gregtech.recipe.helpers")
@ZenRegister
public class CTRecipeUtils {
    @ZenMethod(value="removeRecipeByOutput")
    public static void removeRecipeByOutput(RecipeMap<?> recipeMap, IItemStack[] outputs, ILiquidStack[] fluidOutputs, boolean useAmounts) {
        ArrayList<Recipe> recipesToRemove = new ArrayList<Recipe>();
        List mcItemOutputs = outputs == null ? Collections.emptyList() : Arrays.stream(outputs).map(CraftTweakerMC::getItemStack).collect(Collectors.toList());
        List mcFluidOutputs = fluidOutputs == null ? Collections.emptyList() : Arrays.stream(fluidOutputs).map(CraftTweakerMC::getLiquidStack).collect(Collectors.toList());
        for (Recipe recipe : recipeMap.getRecipeList()) {
            if (!(recipe instanceof Recipe)) continue;
            if (!mcItemOutputs.isEmpty()) {
                for (ItemStack output : recipe.getOutputs()) {
                    for (ItemStack itemStack : mcItemOutputs) {
                        if (!output.func_77969_a(itemStack) || output.func_77960_j() != itemStack.func_77960_j()) continue;
                        if (useAmounts) {
                            if (output.func_190916_E() != itemStack.func_190916_E()) continue;
                            recipesToRemove.add(recipe);
                            GTLog.logger.info(output.func_82833_r());
                            continue;
                        }
                        recipesToRemove.add(recipe);
                        GTLog.logger.info(output.func_82833_r());
                    }
                }
            }
            if (mcFluidOutputs.isEmpty()) continue;
            for (FluidStack fluidOutput : recipe.getFluidOutputs()) {
                for (FluidStack fluidStack : mcFluidOutputs) {
                    if (!fluidOutput.isFluidEqual(fluidStack)) continue;
                    if (useAmounts) {
                        if (fluidOutput.amount != fluidStack.amount) continue;
                        recipesToRemove.add(recipe);
                        continue;
                    }
                    recipesToRemove.add(recipe);
                }
            }
        }
        for (Recipe recipe : recipesToRemove) {
            recipeMap.removeRecipe(recipe);
        }
    }

    @ZenMethod(value="clear")
    public static void removeAll(RecipeMap<?> recipeMap) {
        GTRecipeHandler.removeAllRecipes(recipeMap);
    }
}

