/*
 * Decompiled with CFR 0.152.
 */
package gregtech.integration.crafttweaker.recipe;

import crafttweaker.annotations.ZenRegister;
import crafttweaker.api.data.DataMap;
import crafttweaker.api.data.IData;
import crafttweaker.api.item.IIngredient;
import crafttweaker.api.item.IItemStack;
import crafttweaker.api.liquid.ILiquidStack;
import crafttweaker.api.minecraft.CraftTweakerMC;
import crafttweaker.api.oredict.IOreDictEntry;
import gregtech.api.recipes.RecipeBuilder;
import gregtech.api.recipes.ingredients.GTRecipeFluidInput;
import gregtech.api.recipes.ingredients.GTRecipeInput;
import gregtech.api.recipes.ingredients.GTRecipeItemInput;
import gregtech.api.recipes.ingredients.GTRecipeOreInput;
import gregtech.api.recipes.ingredients.nbtmatch.NBTCondition;
import gregtech.api.recipes.ingredients.nbtmatch.NBTMatcher;
import gregtech.api.util.ItemStackHashStrategy;
import gregtech.integration.crafttweaker.recipe.CTNBTMatcher;
import gregtech.integration.crafttweaker.recipe.CTNBTMultiItemMatcher;
import it.unimi.dsi.fastutil.Hash;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenCustomHashMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.gregtech.recipe.RecipeBuilder")
@ZenRegister
public class CTRecipeBuilder {
    public final RecipeBuilder<?> backingBuilder;

    public CTRecipeBuilder(RecipeBuilder<?> backingBuilder) {
        this.backingBuilder = backingBuilder;
    }

    @ZenMethod
    public CTRecipeBuilder duration(int duration) {
        this.backingBuilder.duration(duration);
        return this;
    }

    @ZenMethod
    public CTRecipeBuilder EUt(int EUt) {
        this.backingBuilder.EUt(EUt);
        return this;
    }

    @ZenMethod
    public CTRecipeBuilder hidden() {
        this.backingBuilder.hidden();
        return this;
    }

    private static String extractOreDictEntry(IIngredient ingredient) {
        if (ingredient instanceof IOreDictEntry) {
            return ((IOreDictEntry)ingredient).getName();
        }
        if (ingredient.getInternal() instanceof IOreDictEntry) {
            return ((IOreDictEntry)ingredient.getInternal()).getName();
        }
        return null;
    }

    @ZenMethod
    public CTRecipeBuilder inputs(IIngredient ... ingredients) {
        for (IIngredient ingredient : ingredients) {
            this.backingBuilder.input(CTRecipeBuilder.getInputFromCTIngredient(ingredient));
        }
        return this;
    }

    @ZenMethod
    public CTRecipeBuilder notConsumable(IIngredient ... ingredients) {
        for (IIngredient ingredient : ingredients) {
            this.backingBuilder.notConsumable(CTRecipeBuilder.getInputFromCTIngredient(ingredient));
        }
        return this;
    }

    @NotNull
    private static GTRecipeInput getInputFromCTIngredient(@Nullable IIngredient ingredient) {
        if (ingredient == null) {
            throw new IllegalArgumentException("Invalid ingredient: is null");
        }
        List items = ingredient.getItems();
        String oreDict = CTRecipeBuilder.extractOreDictEntry(ingredient);
        if (oreDict != null) {
            if (items.isEmpty()) {
                throw new IllegalArgumentException("Invalid Ore Dictionary [" + oreDict + "]: contains no items");
            }
            return new GTRecipeOreInput(oreDict, ingredient.getAmount());
        }
        if (items.isEmpty()) {
            throw new IllegalArgumentException("Invalid Item [" + ingredient + "]: item not found");
        }
        if (items.size() == 1) {
            ItemStack stack = CraftTweakerMC.getItemStack((IItemStack)((IItemStack)items.get(0)));
            IData data = ((IItemStack)items.get(0)).getTag();
            NBTTagCompound tagCompound = data == DataMap.EMPTY ? null : CraftTweakerMC.getNBTCompound((IData)data);
            return CTRecipeBuilder.tryConstructNBTInput((GTRecipeInput)new GTRecipeItemInput(stack, ingredient.getAmount()), tagCompound);
        }
        Object2ObjectOpenCustomHashMap map = new Object2ObjectOpenCustomHashMap((Hash.Strategy)ItemStackHashStrategy.comparingItemDamageCount());
        ItemStack[] stacks = new ItemStack[items.size()];
        for (int i = 0; i < stacks.length; ++i) {
            IItemStack item = (IItemStack)items.get(i);
            ItemStack stack = CraftTweakerMC.getItemStack((IItemStack)item);
            if (stack.func_190926_b()) {
                throw new IllegalArgumentException("Invalid Item [" + ingredient + "]: contains empty ItemStack.");
            }
            stacks[i] = stack;
            NBTTagCompound compound = CraftTweakerMC.getNBTCompound((IData)item.getTag());
            if (compound == null) continue;
            if (map.containsKey(stack)) {
                ((List)map.get(stack)).add(compound);
                continue;
            }
            ArrayList<NBTTagCompound> list = new ArrayList<NBTTagCompound>(1);
            list.add(compound);
            map.put(stack, list);
        }
        return CTRecipeBuilder.tryConstructNBTInput((GTRecipeInput)new GTRecipeItemInput(stacks), (Map<ItemStack, List<NBTTagCompound>>)map);
    }

    @NotNull
    private static GTRecipeInput tryConstructNBTInput(@NotNull GTRecipeInput input, @Nullable NBTTagCompound compound) {
        if (compound == null) {
            return input;
        }
        if (compound.func_82582_d()) {
            return input.setNBTMatchingCondition(NBTMatcher.ANY, NBTCondition.ANY);
        }
        return input.setNBTMatchingCondition(new CTNBTMatcher(compound), null);
    }

    @NotNull
    private static GTRecipeInput tryConstructNBTInput(@NotNull GTRecipeInput input, @NotNull Map<ItemStack, List<NBTTagCompound>> map) {
        if (map.isEmpty()) {
            return input;
        }
        return input.setNBTMatchingCondition(new CTNBTMultiItemMatcher(map), null);
    }

    @ZenMethod
    public CTRecipeBuilder notConsumable(ILiquidStack ingredient) {
        this.backingBuilder.notConsumable(CraftTweakerMC.getLiquidStack((ILiquidStack)ingredient));
        return this;
    }

    @ZenMethod
    public CTRecipeBuilder circuit(int num) {
        this.backingBuilder.circuitMeta(num);
        return this;
    }

    @ZenMethod
    public CTRecipeBuilder fluidInputs(ILiquidStack ... ingredients) {
        this.backingBuilder.fluidInputs(Arrays.stream(ingredients).map(CraftTweakerMC::getLiquidStack).map(GTRecipeFluidInput::new).collect(Collectors.toList()));
        return this;
    }

    @ZenMethod
    public CTRecipeBuilder outputs(IItemStack ... ingredients) {
        this.backingBuilder.outputs(Arrays.stream(ingredients).map(CraftTweakerMC::getItemStack).collect(Collectors.toList()));
        return this;
    }

    @ZenMethod
    public CTRecipeBuilder chancedOutput(IItemStack outputStack, int chanceValue, int tierChanceBoost) {
        this.backingBuilder.chancedOutput(CraftTweakerMC.getItemStack((IItemStack)outputStack), chanceValue, tierChanceBoost);
        return this;
    }

    @ZenMethod
    public CTRecipeBuilder fluidOutputs(ILiquidStack ... ingredients) {
        this.backingBuilder.fluidOutputs(Arrays.stream(ingredients).map(CraftTweakerMC::getLiquidStack).collect(Collectors.toList()));
        return this;
    }

    @ZenMethod
    public CTRecipeBuilder property(String key, int value) {
        boolean applied = this.backingBuilder.applyProperty(key, (Object)value);
        if (!applied) {
            throw new IllegalArgumentException("Property " + key + " cannot be applied to recipe type " + this.backingBuilder.getClass().getSimpleName());
        }
        return this;
    }

    @ZenMethod
    public CTRecipeBuilder property(String key, String value) {
        boolean applied = this.backingBuilder.applyProperty(key, (Object)value);
        if (!applied) {
            throw new IllegalArgumentException("Property " + key + " cannot be applied to recipe type " + this.backingBuilder.getClass().getSimpleName());
        }
        return this;
    }

    @ZenMethod
    public CTRecipeBuilder property(String key, boolean value) {
        boolean applied = this.backingBuilder.applyProperty(key, (Object)value);
        if (!applied) {
            throw new IllegalArgumentException("Property " + key + " cannot be applied to recipe type " + this.backingBuilder.getClass().getSimpleName());
        }
        return this;
    }

    @ZenMethod
    public CTRecipeBuilder property(String key, long value) {
        boolean applied = this.backingBuilder.applyProperty(key, (Object)value);
        if (!applied) {
            throw new IllegalArgumentException("Property " + key + " cannot be applied to recipe type " + this.backingBuilder.getClass().getSimpleName());
        }
        return this;
    }

    @ZenMethod
    public CTRecipeBuilder property(String key, float value) {
        boolean applied = this.backingBuilder.applyProperty(key, (Object)Float.valueOf(value));
        if (!applied) {
            throw new IllegalArgumentException("Property " + key + " cannot be applied to recipe type " + this.backingBuilder.getClass().getSimpleName());
        }
        return this;
    }

    @ZenMethod
    public CTRecipeBuilder property(String key, IItemStack item) {
        boolean applied = this.backingBuilder.applyProperty(key, (Object)CraftTweakerMC.getItemStack((IItemStack)item));
        if (!applied) {
            throw new IllegalArgumentException("Property " + key + " cannot be applied to recipe type " + this.backingBuilder.getClass().getSimpleName() + " for Item " + CraftTweakerMC.getItemStack((IItemStack)item).func_82833_r());
        }
        return this;
    }

    @ZenMethod
    public void buildAndRegister() {
        ((RecipeBuilder)this.backingBuilder.isCTRecipe()).buildAndRegister();
    }

    @ZenMethod
    public String toString() {
        return this.backingBuilder.toString();
    }
}

