/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.terminal.app.guide.widget;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import gregtech.api.gui.IRenderContext;
import gregtech.api.gui.Widget;
import gregtech.api.gui.widgets.WidgetGroup;
import gregtech.api.terminal.gui.widgets.DraggableScrollableWidgetGroup;
import gregtech.api.util.Position;
import gregtech.api.util.Size;
import gregtech.common.terminal.app.guide.widget.GuidePageWidget;
import gregtech.common.terminal.app.guide.widget.IGuideWidget;
import gregtech.common.terminal.app.guideeditor.widget.configurator.ColorConfigurator;
import gregtech.common.terminal.app.guideeditor.widget.configurator.NumberConfigurator;
import gregtech.common.terminal.app.guideeditor.widget.configurator.StringConfigurator;
import gregtech.common.terminal.app.guideeditor.widget.configurator.TextListConfigurator;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.item.ItemStack;

public abstract class GuideWidgetGroup
extends WidgetGroup
implements IGuideWidget {
    public String ref;
    public int fill;
    public int stroke;
    public int stroke_width = 1;
    public String link;
    public List<String> hover_text;
    private transient boolean isFixed;
    protected transient GuidePageWidget page;
    protected transient JsonObject config;

    public GuideWidgetGroup(int x, int y, int width, int height) {
        super(x, y, width, height);
    }

    public GuideWidgetGroup() {
        super(Position.ORIGIN, Size.ZERO);
    }

    @Override
    public JsonObject getConfig() {
        return this.config;
    }

    @Override
    public boolean isFixed() {
        return this.isFixed;
    }

    @Override
    public void setStroke(int color) {
        this.stroke = color;
    }

    @Override
    public void setSize(Size size) {
        Size oldSize = this.getSize();
        super.setSize(size);
        if (this.page != null) {
            this.page.onSizeUpdate(this, oldSize);
        }
    }

    @Override
    protected void recomputePosition() {
        Position oldPosition = this.getPosition();
        super.recomputePosition();
        if (this.page != null) {
            this.page.onPositionUpdate(this, oldPosition);
        }
    }

    @Override
    public JsonObject getTemplate(boolean isFixed) {
        JsonObject template = new JsonObject();
        template.addProperty("type", this.getRegistryName());
        if (isFixed) {
            template.addProperty("x", (Number)0);
            template.addProperty("y", (Number)0);
            template.addProperty("width", (Number)100);
            template.addProperty("height", (Number)100);
        }
        template.addProperty("ref", (String)null);
        template.addProperty("stroke", (String)null);
        template.addProperty("stroke_width", (String)null);
        template.addProperty("fill", (String)null);
        template.addProperty("link", (String)null);
        template.add("hover_text", new Gson().toJsonTree(this.hover_text));
        return template;
    }

    @Override
    public void loadConfigurator(DraggableScrollableWidgetGroup group, JsonObject config, boolean isFixed, Consumer<String> needUpdate) {
        group.addWidget(new ColorConfigurator(group, config, "fill", 0).setOnUpdated(needUpdate));
        group.addWidget(new ColorConfigurator(group, config, "stroke", 0).setOnUpdated(needUpdate));
        group.addWidget(new NumberConfigurator(group, config, "stroke_width", 1).setOnUpdated(needUpdate));
        group.addWidget(new StringConfigurator(group, config, "ref", "").setOnUpdated(needUpdate));
        group.addWidget(new StringConfigurator(group, config, "link", "").setOnUpdated(needUpdate));
        group.addWidget(new TextListConfigurator(group, 40, config, "hover_text", "").setOnUpdated(needUpdate));
    }

    @Override
    public String getRef() {
        return this.ref;
    }

    protected Widget initStream() {
        return this.initFixed();
    }

    protected abstract Widget initFixed();

    @Override
    public Widget updateOrCreateStreamWidget(int x, int y, int pageWidth, JsonObject config) {
        if (config == null) {
            return this.initStream();
        }
        GuideWidgetGroup widget = (GuideWidgetGroup)new Gson().fromJson((JsonElement)config, this.getClass());
        widget.isFixed = false;
        widget.setSelfPosition(new Position(x, y));
        widget.setSize(new Size(pageWidth, 0));
        widget.config = config;
        return widget.initStream();
    }

    @Override
    public Widget updateOrCreateFixedWidget(int x, int y, int width, int height, JsonObject config) {
        if (config == null) {
            return this.initFixed();
        }
        GuideWidgetGroup widget = (GuideWidgetGroup)new Gson().fromJson((JsonElement)config, this.getClass());
        widget.isFixed = true;
        widget.setSelfPosition(new Position(x, y));
        widget.setSize(new Size(width, height));
        widget.config = config;
        return widget.initFixed();
    }

    @Override
    public void setPage(GuidePageWidget page) {
        this.page = page;
    }

    @Override
    public void addWidget(Widget widget) {
        super.addWidget(widget);
        if (widget instanceof IGuideWidget) {
            ((IGuideWidget)((Object)widget)).setPage(this.page);
        }
    }

    @Override
    public void drawInForeground(int mouseX, int mouseY) {
        if (this.link != null && this.isMouseOverElement(mouseX, mouseY)) {
            Position position = this.getPosition();
            Size size = this.getSize();
            GuideWidgetGroup.drawBorder(position.x, position.y, size.width, size.height, -16776961, this.stroke_width);
        }
        if ((this.hover_text != null || this.link != null) && this.isMouseOverElement(mouseX, mouseY)) {
            ArrayList<String> tooltip;
            ArrayList<String> arrayList = tooltip = this.hover_text == null ? new ArrayList<String>() : new ArrayList<String>(this.hover_text);
            if (this.link != null) {
                tooltip.add("\u00a79Ctrl+Click\u00a7r \u00a7e(" + this.link + ")\u00a7r");
            }
            this.drawHoveringText(ItemStack.field_190927_a, tooltip, 100, mouseX, mouseY);
        }
        super.drawInForeground(mouseX, mouseY);
    }

    @Override
    public void drawInBackground(int mouseX, int mouseY, float partialTicks, IRenderContext context) {
        Position position = this.getPosition();
        Size size = this.getSize();
        if (this.stroke != 0) {
            GuideWidgetGroup.drawBorder(position.x, position.y, size.width, size.height, this.stroke, this.stroke_width);
        }
        if (this.fill != 0) {
            GuideWidgetGroup.drawSolidRect(position.x, position.y, size.width, size.height, this.fill);
        }
        super.drawInBackground(mouseX, mouseY, partialTicks, context);
    }

    @Override
    public boolean mouseClicked(int mouseX, int mouseY, int button) {
        if (this.link != null && this.isMouseOverElement(mouseX, mouseY) && GuideWidgetGroup.isCtrlDown()) {
            this.page.jumpToRef(this.link);
            return true;
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }
}

