/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.terminal.app.game.pong;

import java.awt.Rectangle;
import java.util.List;
import net.minecraft.util.math.MathHelper;
import org.lwjgl.util.vector.Vector2f;

public class TwoDimensionalRayTracer {
    public static TwoDimensionalRayTraceResult intersectBoxSegment(Vector2f pos, Vector2f delta, Vector2f boxCenter, Vector2f boxSize) {
        float scaleX = (float)(1.0 / (double)delta.x);
        float scaleY = (float)(1.0 / (double)delta.y);
        float signX = Math.signum(scaleX);
        float signY = Math.signum(scaleY);
        float nearTimeX = (boxCenter.x - signX * boxSize.x - pos.x) * scaleX;
        float nearTimeY = (boxCenter.y - signY * boxSize.y - pos.y) * scaleY;
        float farTimeX = (boxCenter.x + signX * boxSize.x - pos.x) * scaleX;
        float farTimeY = (boxCenter.y + signY * boxSize.y - pos.y) * scaleY;
        if (nearTimeX > farTimeY || nearTimeY > farTimeX) {
            return null;
        }
        double nearTime = Math.max(nearTimeX, nearTimeY);
        double farTime = Math.min(farTimeX, farTimeY);
        if (nearTime >= 1.0 || farTime <= 0.0) {
            return null;
        }
        TwoDimensionalRayTraceResult result = new TwoDimensionalRayTraceResult();
        result.time = (float)MathHelper.func_151237_a((double)nearTime, (double)0.0, (double)1.0);
        if (nearTimeX > nearTimeY) {
            result.normal.x = -signX;
            result.normal.y = 0.0f;
        } else {
            result.normal.x = 0.0f;
            result.normal.y = -signY;
        }
        result.delta.x = (float)((1.0 - (double)result.time) * (double)(-delta.x));
        result.delta.y = (float)((1.0 - (double)result.time) * (double)(-delta.y));
        result.pos.x = pos.x + delta.x * result.time;
        result.pos.y = pos.y + delta.y * result.time;
        return result;
    }

    public static TwoDimensionalRayTraceResult nearestBoxSegmentCollision(Vector2f pos, Vector2f delta, List<Rectangle> boxes, Vector2f padding) {
        TwoDimensionalRayTraceResult result = new TwoDimensionalRayTraceResult();
        result.time = 1.0f;
        result.pos.x = pos.x + delta.x;
        result.pos.y = pos.y + delta.y;
        for (Rectangle box : boxes) {
            TwoDimensionalRayTraceResult sweep = TwoDimensionalRayTracer.intersectBoxSegment(pos, delta, new Vector2f((float)box.getCenterX(), (float)box.getCenterY()), new Vector2f((float)box.getWidth() / 2.0f + padding.x, (float)box.getHeight() / 2.0f + padding.y));
            if (sweep == null || !(sweep.time < result.time)) continue;
            result = sweep;
            result.collidedWith = box;
        }
        return result;
    }

    public static class TwoDimensionalRayTraceResult {
        public Vector2f pos = new Vector2f();
        public Vector2f delta = new Vector2f();
        public Vector2f normal = new Vector2f();
        public float time = -1.0f;
        public Rectangle collidedWith = new Rectangle();
    }
}

