/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.pipelike.optical.tile;

import gregtech.api.capability.GregtechDataCodes;
import gregtech.api.capability.GregtechTileCapabilities;
import gregtech.api.capability.IDataAccessHatch;
import gregtech.api.capability.IOpticalComputationProvider;
import gregtech.api.pipenet.tile.IPipeTile;
import gregtech.api.pipenet.tile.TileEntityPipeBase;
import gregtech.api.recipes.Recipe;
import gregtech.api.util.TaskScheduler;
import gregtech.common.pipelike.optical.OpticalPipeProperties;
import gregtech.common.pipelike.optical.OpticalPipeType;
import gregtech.common.pipelike.optical.net.OpticalNetHandler;
import gregtech.common.pipelike.optical.net.OpticalPipeNet;
import gregtech.common.pipelike.optical.net.WorldOpticalPipeNet;
import java.lang.ref.WeakReference;
import java.util.Collection;
import java.util.EnumMap;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TileEntityOpticalPipe
extends TileEntityPipeBase<OpticalPipeType, OpticalPipeProperties> {
    private final EnumMap<EnumFacing, OpticalNetHandler> handlers = new EnumMap(EnumFacing.class);
    private final IDataAccessHatch clientDataHandler = new DefaultDataHandler();
    private final IOpticalComputationProvider clientComputationHandler = new DefaultComputationHandler();
    private WeakReference<OpticalPipeNet> currentPipeNet = new WeakReference<Object>(null);
    private OpticalNetHandler defaultHandler;
    private int ticksActive = 0;
    private boolean isActive;

    @Override
    public Class<OpticalPipeType> getPipeTypeClass() {
        return OpticalPipeType.class;
    }

    @Override
    public boolean supportsTicking() {
        return false;
    }

    @Override
    public boolean canHaveBlockedFaces() {
        return false;
    }

    private void initHandlers() {
        OpticalPipeNet net = this.getOpticalPipeNet();
        if (net == null) {
            return;
        }
        for (EnumFacing facing : EnumFacing.field_82609_l) {
            this.handlers.put(facing, new OpticalNetHandler(net, this, facing));
        }
        this.defaultHandler = new OpticalNetHandler(net, this, null);
    }

    @Override
    @Nullable
    public <T> T getCapabilityInternal(Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == GregtechTileCapabilities.CAPABILITY_DATA_ACCESS) {
            if (this.field_145850_b.field_72995_K) {
                return (T)GregtechTileCapabilities.CAPABILITY_DATA_ACCESS.cast((Object)this.clientDataHandler);
            }
            if (this.handlers.isEmpty()) {
                this.initHandlers();
            }
            this.checkNetwork();
            return (T)GregtechTileCapabilities.CAPABILITY_DATA_ACCESS.cast((Object)this.handlers.getOrDefault(facing, this.defaultHandler));
        }
        if (capability == GregtechTileCapabilities.CABABILITY_COMPUTATION_PROVIDER) {
            if (this.field_145850_b.field_72995_K) {
                return (T)GregtechTileCapabilities.CABABILITY_COMPUTATION_PROVIDER.cast((Object)this.clientComputationHandler);
            }
            if (this.handlers.isEmpty()) {
                this.initHandlers();
            }
            this.checkNetwork();
            return (T)GregtechTileCapabilities.CABABILITY_COMPUTATION_PROVIDER.cast((Object)this.handlers.getOrDefault(facing, this.defaultHandler));
        }
        return super.getCapabilityInternal(capability, facing);
    }

    public void checkNetwork() {
        if (this.defaultHandler != null) {
            OpticalPipeNet current = this.getOpticalPipeNet();
            if (this.defaultHandler.getNet() != current) {
                this.defaultHandler.updateNetwork(current);
                for (OpticalNetHandler handler : this.handlers.values()) {
                    handler.updateNetwork(current);
                }
            }
        }
    }

    public OpticalPipeNet getOpticalPipeNet() {
        if (this.field_145850_b == null || this.field_145850_b.field_72995_K) {
            return null;
        }
        OpticalPipeNet currentPipeNet = (OpticalPipeNet)this.currentPipeNet.get();
        if (currentPipeNet != null && currentPipeNet.isValid() && currentPipeNet.containsNode(this.getPipePos())) {
            return currentPipeNet;
        }
        WorldOpticalPipeNet worldNet = (WorldOpticalPipeNet)((Object)this.getPipeBlock().getWorldPipeNet(this.getPipeWorld()));
        currentPipeNet = (OpticalPipeNet)worldNet.getNetFromPos(this.getPipePos());
        if (currentPipeNet != null) {
            this.currentPipeNet = new WeakReference<OpticalPipeNet>(currentPipeNet);
        }
        return currentPipeNet;
    }

    @Override
    public void transferDataFrom(IPipeTile<OpticalPipeType, OpticalPipeProperties> tileEntity) {
        super.transferDataFrom(tileEntity);
        if (this.getOpticalPipeNet() == null) {
            return;
        }
        TileEntityOpticalPipe pipe = (TileEntityOpticalPipe)tileEntity;
        if (!pipe.handlers.isEmpty() && pipe.defaultHandler != null) {
            this.handlers.clear();
            this.handlers.putAll(pipe.handlers);
            this.defaultHandler = pipe.defaultHandler;
            this.checkNetwork();
        } else {
            this.initHandlers();
        }
    }

    @Override
    public void setConnection(EnumFacing side, boolean connected, boolean fromNeighbor) {
        if (!this.func_145831_w().field_72995_K && connected && !fromNeighbor) {
            IPipeTile pipeTile;
            if (this.getNumConnections() >= 2) {
                return;
            }
            TileEntity tile = this.func_145831_w().func_175625_s(this.func_174877_v().func_177972_a(side));
            if (tile instanceof IPipeTile && (pipeTile = (IPipeTile)tile).getPipeType().getClass() == ((OpticalPipeType)this.getPipeType()).getClass() && pipeTile.getNumConnections() >= 2) {
                return;
            }
        }
        super.setConnection(side, connected, fromNeighbor);
    }

    public boolean isActive() {
        return this.isActive;
    }

    public void setActive(boolean active, int duration) {
        boolean stateChanged = false;
        if (this.isActive && !active) {
            this.isActive = false;
            stateChanged = true;
        } else if (!this.isActive && active) {
            this.isActive = true;
            stateChanged = true;
            TaskScheduler.scheduleTask(this.func_145831_w(), () -> {
                if (++this.ticksActive % duration == 0) {
                    this.ticksActive = 0;
                    this.setActive(false, -1);
                    return false;
                }
                return true;
            });
        }
        if (stateChanged) {
            this.writeCustomData(GregtechDataCodes.PIPE_OPTICAL_ACTIVE, buf -> buf.writeBoolean(this.isActive));
            this.notifyBlockUpdate();
            this.func_70296_d();
        }
    }

    @Override
    public void receiveCustomData(int discriminator, PacketBuffer buf) {
        super.receiveCustomData(discriminator, buf);
        if (discriminator == GregtechDataCodes.PIPE_OPTICAL_ACTIVE) {
            this.isActive = buf.readBoolean();
            this.scheduleChunkForRenderUpdate();
        }
    }

    @Override
    public void onChunkUnload() {
        super.onChunkUnload();
        this.handlers.clear();
    }

    private static class DefaultDataHandler
    implements IDataAccessHatch {
        private DefaultDataHandler() {
        }

        @Override
        public boolean isRecipeAvailable(@NotNull Recipe recipe, @NotNull Collection<IDataAccessHatch> seen) {
            return false;
        }

        @Override
        public boolean isCreative() {
            return false;
        }
    }

    private static class DefaultComputationHandler
    implements IOpticalComputationProvider {
        private DefaultComputationHandler() {
        }

        @Override
        public int requestCWUt(int cwut, boolean simulate, @NotNull Collection<IOpticalComputationProvider> seen) {
            return 0;
        }

        @Override
        public int getMaxCWUt(@NotNull Collection<IOpticalComputationProvider> seen) {
            return 0;
        }

        @Override
        public boolean canBridge(@NotNull Collection<IOpticalComputationProvider> seen) {
            return false;
        }
    }
}

