/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.pipelike.laser.net;

import gregtech.api.capability.ILaserContainer;
import gregtech.common.pipelike.laser.net.LaserPipeNet;
import gregtech.common.pipelike.laser.net.LaserRoutePath;
import gregtech.common.pipelike.laser.tile.TileEntityLaserPipe;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LaserNetHandler
implements ILaserContainer {
    private LaserPipeNet net;
    private final TileEntityLaserPipe pipe;
    private final EnumFacing facing;

    public LaserNetHandler(LaserPipeNet net, @NotNull TileEntityLaserPipe pipe, @Nullable EnumFacing facing) {
        this.net = net;
        this.pipe = pipe;
        this.facing = facing;
    }

    public void updateNetwork(LaserPipeNet net) {
        this.net = net;
    }

    private void setPipesActive() {
        for (BlockPos pos : this.net.getAllNodes().keySet()) {
            TileEntity tileEntity = this.pipe.func_145831_w().func_175625_s(pos);
            if (!(tileEntity instanceof TileEntityLaserPipe)) continue;
            TileEntityLaserPipe laserPipe = (TileEntityLaserPipe)tileEntity;
            laserPipe.setActive(true, 100);
        }
    }

    @Nullable
    private ILaserContainer getInnerContainer() {
        if (this.net == null || this.pipe == null || this.pipe.func_145837_r() || this.facing == null) {
            return null;
        }
        LaserRoutePath data = this.net.getNetData(this.pipe.getPipePos(), this.facing);
        if (data == null) {
            return null;
        }
        return data.getHandler();
    }

    @Override
    public long acceptEnergyFromNetwork(EnumFacing side, long voltage, long amperage) {
        ILaserContainer handler = this.getInnerContainer();
        if (handler == null) {
            return 0L;
        }
        this.setPipesActive();
        return handler.acceptEnergyFromNetwork(side, voltage, amperage);
    }

    @Override
    public boolean inputsEnergy(EnumFacing side) {
        ILaserContainer handler = this.getInnerContainer();
        if (handler == null) {
            return false;
        }
        return handler.inputsEnergy(side);
    }

    @Override
    public boolean outputsEnergy(EnumFacing side) {
        ILaserContainer handler = this.getInnerContainer();
        if (handler == null) {
            return false;
        }
        return handler.outputsEnergy(side);
    }

    @Override
    public long changeEnergy(long amount) {
        ILaserContainer handler = this.getInnerContainer();
        if (handler == null) {
            return 0L;
        }
        this.setPipesActive();
        return handler.changeEnergy(amount);
    }

    @Override
    public long getEnergyStored() {
        ILaserContainer handler = this.getInnerContainer();
        if (handler == null) {
            return 0L;
        }
        return handler.getEnergyStored();
    }

    @Override
    public long getEnergyCapacity() {
        ILaserContainer handler = this.getInnerContainer();
        if (handler == null) {
            return 0L;
        }
        return handler.getEnergyCapacity();
    }

    @Override
    public long getInputAmperage() {
        return 0L;
    }

    @Override
    public long getInputVoltage() {
        return 0L;
    }

    public LaserPipeNet getNet() {
        return this.net;
    }

    @Override
    public boolean isOneProbeHidden() {
        return true;
    }
}

