/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.pipelike.itempipe.tile;

import gregtech.api.pipenet.block.material.TileEntityMaterialPipeBase;
import gregtech.api.pipenet.tile.IPipeTile;
import gregtech.api.unification.material.properties.ItemPipeProperties;
import gregtech.api.util.FacingPos;
import gregtech.common.pipelike.itempipe.ItemPipeType;
import gregtech.common.pipelike.itempipe.net.ItemNetHandler;
import gregtech.common.pipelike.itempipe.net.ItemPipeNet;
import gregtech.common.pipelike.itempipe.net.WorldItemPipeNet;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.lang.ref.WeakReference;
import java.util.EnumMap;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import org.jetbrains.annotations.Nullable;

public class TileEntityItemPipe
extends TileEntityMaterialPipeBase<ItemPipeType, ItemPipeProperties> {
    private final EnumMap<EnumFacing, ItemNetHandler> handlers = new EnumMap(EnumFacing.class);
    private final Object2IntMap<FacingPos> transferred = new Object2IntOpenHashMap();
    private ItemNetHandler defaultHandler;
    private final IItemHandler clientCapability = new ItemStackHandler(0);
    private WeakReference<ItemPipeNet> currentPipeNet = new WeakReference<Object>(null);
    private int transferredItems = 0;
    private long timer = 0L;

    public long getWorldTime() {
        return this.func_145830_o() ? this.func_145831_w().func_82737_E() : 0L;
    }

    @Override
    public Class<ItemPipeType> getPipeTypeClass() {
        return ItemPipeType.class;
    }

    @Override
    public boolean supportsTicking() {
        return false;
    }

    private void initHandlers() {
        ItemPipeNet net = this.getItemPipeNet();
        if (net == null) {
            return;
        }
        for (EnumFacing facing : EnumFacing.values()) {
            this.handlers.put(facing, new ItemNetHandler(net, this, facing));
        }
        this.defaultHandler = new ItemNetHandler(net, this, null);
    }

    @Override
    @Nullable
    public <T> T getCapabilityInternal(Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            if (this.field_145850_b.field_72995_K) {
                return (T)CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.cast((Object)this.clientCapability);
            }
            if (this.handlers.size() == 0) {
                this.initHandlers();
            }
            this.checkNetwork();
            return (T)CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.cast((Object)this.handlers.getOrDefault(facing, this.defaultHandler));
        }
        return super.getCapabilityInternal(capability, facing);
    }

    public void checkNetwork() {
        if (this.defaultHandler != null) {
            ItemPipeNet current = this.getItemPipeNet();
            if (this.defaultHandler.getNet() != current) {
                this.defaultHandler.updateNetwork(current);
                for (ItemNetHandler handler : this.handlers.values()) {
                    handler.updateNetwork(current);
                }
            }
        }
    }

    public ItemPipeNet getItemPipeNet() {
        if (this.field_145850_b == null || this.field_145850_b.field_72995_K) {
            return null;
        }
        ItemPipeNet currentPipeNet = (ItemPipeNet)this.currentPipeNet.get();
        if (currentPipeNet != null && currentPipeNet.isValid() && currentPipeNet.containsNode(this.getPipePos())) {
            return currentPipeNet;
        }
        WorldItemPipeNet worldFluidPipeNet = (WorldItemPipeNet)((Object)this.getPipeBlock().getWorldPipeNet(this.getPipeWorld()));
        currentPipeNet = (ItemPipeNet)worldFluidPipeNet.getNetFromPos(this.getPipePos());
        if (currentPipeNet != null) {
            this.currentPipeNet = new WeakReference<ItemPipeNet>(currentPipeNet);
        }
        return currentPipeNet;
    }

    public void resetTransferred() {
        this.transferred.clear();
    }

    public Object2IntMap<FacingPos> getTransferred() {
        return this.transferred;
    }

    @Override
    public void transferDataFrom(IPipeTile<ItemPipeType, ItemPipeProperties> tileEntity) {
        super.transferDataFrom(tileEntity);
        TileEntityItemPipe itemPipe = (TileEntityItemPipe)tileEntity;
        if (!itemPipe.handlers.isEmpty()) {
            this.handlers.clear();
            for (ItemNetHandler handler : itemPipe.handlers.values()) {
                handler.updatePipe(this);
                this.handlers.put(handler.getFacing(), handler);
            }
        }
        if (itemPipe.defaultHandler != null) {
            itemPipe.defaultHandler.updatePipe(this);
            this.defaultHandler = itemPipe.defaultHandler;
        }
    }

    private void updateTransferredState() {
        long currentTime = this.getWorldTime();
        long dif = currentTime - this.timer;
        if (dif >= 20L || dif < 0L) {
            this.transferredItems = 0;
            this.timer = currentTime;
        }
    }

    public void addTransferredItems(int amount) {
        this.updateTransferredState();
        this.transferredItems += amount;
    }

    public int getTransferredItems() {
        this.updateTransferredState();
        return this.transferredItems;
    }

    @Override
    public void onChunkUnload() {
        super.onChunkUnload();
        this.handlers.clear();
    }
}

